/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.parser.parsing.statements;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.jetbrains.php.PhpBundle;
import fleet.com.jetbrains.php.lang.lexer.PhpTokenTypes;
import fleet.com.jetbrains.php.lang.parser.ListParsingHelper;
import fleet.com.jetbrains.php.lang.parser.ParserPart;
import fleet.com.jetbrains.php.lang.parser.PhpElementTypes;
import fleet.com.jetbrains.php.lang.parser.PhpParserErrors;
import fleet.com.jetbrains.php.lang.parser.PhpPsiBuilder;
import fleet.com.jetbrains.php.lang.parser.PhpStubElementTypes;
import fleet.com.jetbrains.php.lang.parser.parsing.StatementList;
import fleet.com.jetbrains.php.lang.parser.parsing.classes.ClassReference;

public final class TryStatement {
    public static final ParserPart PARSER_PART = new ParserPart(){

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            IElementType result = ClassReference.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.expected(PhpBundle.message("exception.class", new Object[0])));
            }
            return result;
        }
    };

    public static IElementType parse(PhpPsiBuilder builder) {
        if (!builder.compare(PhpTokenTypes.kwTRY)) {
            return PhpElementTypes.EMPTY_INPUT;
        }
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (builder.compare(PhpTokenTypes.chLBRACE)) {
            StatementList.parseFast(builder);
        } else {
            builder.match(PhpTokenTypes.chLBRACE);
        }
        int catchCount = TryStatement.parseCatchClauses(builder);
        PsiBuilder.Marker _finally = builder.mark();
        if (builder.compareAndEat(PhpTokenTypes.kwFINALLY)) {
            if (builder.compare(PhpTokenTypes.chLBRACE)) {
                StatementList.parseFast(builder);
            } else {
                builder.error(PhpParserErrors.expected("{"));
            }
            _finally.done(PhpElementTypes.FINALLY);
        } else {
            _finally.drop();
            if (catchCount == 0) {
                builder.error(PhpParserErrors.expected(TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwCATCH, PhpTokenTypes.kwFINALLY})));
            }
        }
        statement.done(PhpElementTypes.TRY);
        return PhpElementTypes.TRY;
    }

    private static int parseCatchClauses(PhpPsiBuilder builder) {
        int i = 0;
        while (TryStatement.parseCatchClause(builder) != PhpElementTypes.EMPTY_INPUT) {
            ++i;
        }
        return i;
    }

    private static IElementType parseCatchClause(PhpPsiBuilder builder) {
        if (!builder.compare(PhpTokenTypes.kwCATCH)) {
            return PhpElementTypes.EMPTY_INPUT;
        }
        PsiBuilder.Marker catchClause = builder.mark();
        builder.advanceLexer();
        builder.match(PhpTokenTypes.chLPAREN);
        if (ListParsingHelper.parseDelimitedExpressionWithLeadExpr(builder, PARSER_PART.parse(builder), PARSER_PART, PhpTokenTypes.opBIT_OR, true, false) < 0) {
            builder.error(PhpParserErrors.expected(PhpBundle.message("exception.class", new Object[0])));
        }
        if (builder.compare(PhpTokenTypes.VARIABLE)) {
            PsiBuilder.Marker variable = builder.mark();
            builder.advanceLexer();
            variable.done(PhpStubElementTypes.VARIABLE);
        }
        builder.match(PhpTokenTypes.chRPAREN);
        if (builder.compare(PhpTokenTypes.chLBRACE)) {
            StatementList.parseFast(builder);
        } else {
            builder.error(PhpParserErrors.expected("{"));
        }
        catchClause.done(PhpElementTypes.CATCH);
        return PhpElementTypes.CATCH;
    }
}

