/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.parser.parsing.statements;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.jetbrains.php.PhpBundle;
import fleet.com.jetbrains.php.lang.lexer.PhpTokenTypes;
import fleet.com.jetbrains.php.lang.parser.ListParsingHelper;
import fleet.com.jetbrains.php.lang.parser.ParserPart;
import fleet.com.jetbrains.php.lang.parser.PhpElementTypes;
import fleet.com.jetbrains.php.lang.parser.PhpParserErrors;
import fleet.com.jetbrains.php.lang.parser.PhpPsiBuilder;
import fleet.com.jetbrains.php.lang.parser.parsing.Statement;
import fleet.com.jetbrains.php.lang.parser.parsing.StatementList;
import fleet.com.jetbrains.php.lang.parser.parsing.calls.Variable;
import fleet.com.jetbrains.php.lang.parser.parsing.expressions.AssignmentExpression;
import fleet.com.jetbrains.php.lang.parser.parsing.expressions.Expression;
import fleet.com.jetbrains.php.lang.parser.parsing.functions.IsReference;

public final class ForeachStatement {
    private static final TokenSet ENDFOREACH = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwENDFOREACH});
    private static final ParserPart FOREACH_VARIABLE_PART = builder -> {
        if (builder.compareAndEat(PhpTokenTypes.chLBRACKET)) {
            ForeachStatement.parseForeachVariable(builder);
            builder.compareAndEat(PhpTokenTypes.chRBRACKET);
            return PhpTokenTypes.VARIABLE;
        }
        return AssignmentExpression.ASSIGNMENT_PART.parse(builder);
    };

    public static IElementType parse(PhpPsiBuilder builder) {
        if (!builder.compare(PhpTokenTypes.kwFOREACH)) {
            return PhpElementTypes.EMPTY_INPUT;
        }
        PsiBuilder.Marker foreach = builder.mark();
        builder.advanceLexer();
        builder.match(PhpTokenTypes.chLPAREN);
        Expression.parse(builder);
        builder.match(PhpTokenTypes.kwAS);
        if (AssignmentExpression.parseArrayLiteral(builder, false) == PhpElementTypes.EMPTY_INPUT) {
            ForeachStatement.parseByRefVariable(builder);
            if (builder.compareAndEat(PhpTokenTypes.opHASH_ARRAY) && AssignmentExpression.parseArrayLiteral(builder, false) == PhpElementTypes.EMPTY_INPUT) {
                ForeachStatement.parseByRefVariable(builder);
            }
        }
        builder.match(PhpTokenTypes.chRPAREN);
        ForeachStatement.parseForeachStatement(builder);
        foreach.done(PhpElementTypes.FOREACH);
        return PhpElementTypes.FOREACH;
    }

    private static void parseForeachVariable(PhpPsiBuilder builder) {
        ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, FOREACH_VARIABLE_PART.parse(builder), FOREACH_VARIABLE_PART, false);
    }

    private static void parseForeachStatement(PhpPsiBuilder builder) {
        if (builder.compareAndEat(PhpTokenTypes.opCOLON)) {
            StatementList.parseAccurate(builder, ENDFOREACH);
            builder.match(PhpTokenTypes.kwENDFOREACH);
            if (!builder.compare(PhpTokenTypes.PHP_CLOSING_TAG)) {
                builder.match(PhpTokenTypes.opSEMICOLON);
            }
        } else {
            Statement.parse(builder);
        }
    }

    private static void parseByRefVariable(PhpPsiBuilder builder) {
        IsReference.parse(builder);
        PsiBuilder.Marker variable = builder.mark();
        IElementType result = Variable.parse(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            builder.error(PhpParserErrors.expected(PhpBundle.message("variable1", new Object[0])));
        }
        variable.done(result);
    }
}

