/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.parser.parsing.expressions;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.jetbrains.php.lang.lexer.PhpTokenTypes;
import fleet.com.jetbrains.php.lang.parser.ListParsingHelper;
import fleet.com.jetbrains.php.lang.parser.PhpElementTypes;
import fleet.com.jetbrains.php.lang.parser.PhpParserErrors;
import fleet.com.jetbrains.php.lang.parser.PhpPsiBuilder;
import fleet.com.jetbrains.php.lang.parser.parsing.expressions.Expression;

public final class MatchExpression {
    public static IElementType parse(PhpPsiBuilder builder) {
        if (builder.getTokenType() != PhpTokenTypes.kwMATCH) {
            if (builder.getTokenType() != PhpTokenTypes.IDENTIFIER || !"match".equalsIgnoreCase(builder.getTokenText())) {
                return PhpElementTypes.EMPTY_INPUT;
            }
            builder.remapToMatchKeyword();
        }
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        if (builder.compare(PhpTokenTypes.SCOPE_RESOLUTION) || builder.compare(PhpTokenTypes.chLBRACKET)) {
            mark.rollbackTo();
            builder.remapToIdentifier();
            return PhpElementTypes.EMPTY_INPUT;
        }
        builder.match(PhpTokenTypes.chLPAREN);
        IElementType expr = Expression.parse(builder);
        if (expr == PhpElementTypes.EMPTY_INPUT) {
            builder.error(PhpParserErrors.getExpressionExpectedMessage());
        }
        builder.match(PhpTokenTypes.chRPAREN);
        builder.match(PhpTokenTypes.chLBRACE);
        int numberOfArms = ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, MatchExpression::parseMatchArm, true);
        if (numberOfArms == 0) {
            if (!builder.matchExpressionSupported()) {
                mark.rollbackTo();
                builder.remapToIdentifier();
                return PhpElementTypes.EMPTY_INPUT;
            }
            builder.error(PhpParserErrors.getExpressionExpectedMessage());
        }
        builder.match(PhpTokenTypes.chRBRACE);
        mark.done(PhpElementTypes.MATCH_EXPRESSION);
        return PhpElementTypes.MATCH_EXPRESSION;
    }

    private static IElementType parseMatchArm(PhpPsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        IElementType result = MatchExpression.parseMatchArmConditions(builder);
        if (builder.compare(PhpTokenTypes.opHASH_ARRAY) || builder.compare(PhpTokenTypes.opCOLON)) {
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            }
            builder.advanceLexer();
            IElementType body = Expression.parse(builder);
            if (body == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            }
            IElementType matchArmType = result != PhpElementTypes.EMPTY_INPUT ? result : PhpElementTypes.MATCH_ARM;
            mark.done(matchArmType);
            return matchArmType;
        }
        if (result != PhpElementTypes.EMPTY_INPUT) {
            builder.error(PhpParserErrors.expected("=>"));
            if (builder.matchExpressionSupported()) {
                mark.done(result);
                return result;
            }
        }
        mark.drop();
        return PhpElementTypes.EMPTY_INPUT;
    }

    private static IElementType parseMatchArmConditions(PhpPsiBuilder builder) {
        IElementType[] resultType = new IElementType[]{PhpElementTypes.MATCH_ARM};
        int numberOfConditions = ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, b -> {
            if (b.compareAndEat(PhpTokenTypes.kwDEFAULT)) {
                resultType[0] = PhpElementTypes.DEFAULT_MATCH_ARM;
                return PhpTokenTypes.kwDEFAULT;
            }
            return Expression.parse(b);
        }, true);
        return numberOfConditions == 0 ? PhpElementTypes.EMPTY_INPUT : resultType[0];
    }
}

