/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.parser.parsing.classes;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.jetbrains.php.PhpBundle;
import fleet.com.jetbrains.php.lang.lexer.PhpTokenTypes;
import fleet.com.jetbrains.php.lang.parser.ListParsingHelper;
import fleet.com.jetbrains.php.lang.parser.PhpElementTypes;
import fleet.com.jetbrains.php.lang.parser.PhpParserErrors;
import fleet.com.jetbrains.php.lang.parser.PhpPsiBuilder;
import fleet.com.jetbrains.php.lang.parser.PhpStubElementTypes;
import fleet.com.jetbrains.php.lang.parser.parsing.Attributes;
import fleet.com.jetbrains.php.lang.parser.parsing.Namespace;
import fleet.com.jetbrains.php.lang.parser.parsing.classes.ClassConstant;
import fleet.com.jetbrains.php.lang.parser.parsing.classes.ClassDeclaration;
import fleet.com.jetbrains.php.lang.parser.parsing.classes.ClassField;
import fleet.com.jetbrains.php.lang.parser.parsing.classes.ClassMemberModifiers;
import fleet.com.jetbrains.php.lang.parser.parsing.classes.ClassMethod;
import fleet.com.jetbrains.php.lang.parser.parsing.classes.ClassReference;
import fleet.com.jetbrains.php.lang.parser.parsing.expressions.Expression;

public final class ClassStatementList {
    private static final TokenSet EXPECTED_AFTER_AS = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpTokenTypes.tsVISIBILITY_MODIFIERS, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.IDENTIFIER, PhpTokenTypes.kwFINAL})});
    private static final TokenSet EXPECTED_IN_USE_TRAIT_RULE = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwAS, PhpTokenTypes.kwINSTEADOF});
    public static final TokenSet MODIFIERS = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpTokenTypes.tsVISIBILITY_MODIFIERS, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwFINAL})});

    public static void parse(PhpPsiBuilder builder) {
        while (!builder.eof() && !builder.compare(PhpTokenTypes.chRBRACE)) {
            IElementType result = ClassStatementList.parseStatement(builder);
            if (result != PhpElementTypes.EMPTY_INPUT || ClassStatementList.permissivelyParseClassMemberModifiers(builder)) continue;
            builder.error(PhpParserErrors.unexpected(builder.getTokenType()));
            builder.advanceLexer();
        }
    }

    private static boolean permissivelyParseClassMemberModifiers(PhpPsiBuilder builder) {
        if (builder.compare(PhpTokenTypes.kwVAR) || ClassMemberModifiers.mayBeReadonlyKeyword(builder)) {
            ClassMemberModifiers.parseVariableModifiers(builder);
            builder.error(PhpParserErrors.expected(PhpBundle.message("expected.property", new Object[0])));
            return true;
        }
        if (builder.compare(PhpTokenTypes.tsMODIFIERS)) {
            ClassMemberModifiers.parseVariableModifiers(builder);
            builder.error(PhpParserErrors.expected(PhpBundle.message("property.or.function", new Object[0])));
            return true;
        }
        return false;
    }

    private static IElementType parseStatement(PhpPsiBuilder builder) {
        IElementType result = ClassStatementList.parseUse(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            result = ClassStatementList.parseEnumCase(builder);
            if (result != PhpElementTypes.EMPTY_INPUT) {
                return result;
            }
            result = ClassConstant.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT && (result = ClassField.parse(builder)) == PhpElementTypes.EMPTY_INPUT) {
                result = ClassMethod.parse(builder);
            }
        }
        return result;
    }

    private static IElementType parseEnumCase(PhpPsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        Attributes.parseAttributesList(builder);
        if (!builder.compareAndEat(PhpTokenTypes.kwCASE)) {
            mark.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        int identifiersCount = ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, b -> {
            IElementType result = PhpElementTypes.EMPTY_INPUT;
            if (ClassConstant.parseConstantName(builder, true)) {
                result = PhpTokenTypes.IDENTIFIER;
            }
            if (builder.compare(PhpTokenTypes.opASGN)) {
                if (result == PhpElementTypes.EMPTY_INPUT) {
                    builder.error(PhpParserErrors.expected(PhpBundle.message("identifier", new Object[0])));
                }
                result = PhpTokenTypes.IDENTIFIER;
                builder.advanceLexer();
                IElementType expression = Expression.parse(builder);
                if (expression == PhpElementTypes.EMPTY_INPUT) {
                    builder.error(PhpParserErrors.expected(PhpBundle.message("initializer", new Object[0])));
                }
            }
            return result;
        }, false);
        if (identifiersCount <= 0) {
            builder.error(PhpParserErrors.expected(PhpBundle.message("identifier", new Object[0])));
        }
        builder.match(PhpTokenTypes.opSEMICOLON);
        mark.done(PhpStubElementTypes.ENUM_CASE);
        return PhpStubElementTypes.ENUM_CASE;
    }

    public static IElementType parseUse(PhpPsiBuilder builder) {
        if (!builder.compare(PhpTokenTypes.kwUSE)) {
            return PhpElementTypes.EMPTY_INPUT;
        }
        PsiBuilder.Marker useList = builder.mark();
        builder.advanceLexer();
        do {
            PsiBuilder.Marker use = builder.mark();
            IElementType result = ClassReference.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.expected(PhpBundle.message("class.reference", new Object[0])));
            }
            use.done(PhpStubElementTypes.USE);
        } while (builder.compareAndEat(PhpTokenTypes.opCOMMA));
        if (builder.compareAndEat(PhpTokenTypes.chLBRACE)) {
            while (!builder.compareAndEat(PhpTokenTypes.chRBRACE) && !builder.eof()) {
                PsiBuilder.Marker rule = builder.mark();
                PsiBuilder.Marker method = builder.mark();
                PsiBuilder.Marker classR = builder.mark();
                Namespace.parseReference(builder);
                builder.match(PhpTokenTypes.IDENTIFIER);
                if (builder.compare(PhpTokenTypes.SCOPE_RESOLUTION)) {
                    classR.done(PhpElementTypes.CLASS_REFERENCE);
                    builder.advanceLexer();
                    builder.match(PhpTokenTypes.IDENTIFIER);
                } else {
                    classR.drop();
                }
                method.done(PhpElementTypes.METHOD_REFERENCE);
                if (builder.compareAndEat(PhpTokenTypes.kwAS)) {
                    boolean vis = builder.compareAndEat(MODIFIERS);
                    boolean name = builder.compareAndEat(PhpTokenTypes.IDENTIFIER);
                    if (!vis && !name) {
                        builder.error(PhpParserErrors.expected(EXPECTED_AFTER_AS));
                    }
                } else if (builder.compareAndEat(PhpTokenTypes.kwINSTEADOF)) {
                    ClassDeclaration.parseClassNamesList(builder);
                } else {
                    builder.error(PhpParserErrors.expected(EXPECTED_IN_USE_TRAIT_RULE));
                }
                while (!(builder.compare(PhpTokenTypes.opSEMICOLON) || builder.compare(PhpTokenTypes.chRBRACE) || builder.eof())) {
                    builder.advanceLexer();
                }
                builder.match(PhpTokenTypes.opSEMICOLON);
                rule.done(PhpStubElementTypes.TRAIT_USE_RULE);
            }
        } else {
            builder.match(PhpTokenTypes.opSEMICOLON);
        }
        useList.done(PhpElementTypes.USE_LIST);
        return PhpElementTypes.USE_LIST;
    }
}

