/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.parser.parsing.calls;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.jetbrains.php.PhpBundle;
import fleet.com.jetbrains.php.lang.lexer.PhpTokenTypes;
import fleet.com.jetbrains.php.lang.parser.PhpElementTypes;
import fleet.com.jetbrains.php.lang.parser.PhpParserErrors;
import fleet.com.jetbrains.php.lang.parser.PhpPsiBuilder;
import fleet.com.jetbrains.php.lang.parser.PhpStubElementTypes;
import fleet.com.jetbrains.php.lang.parser.parsing.calls.Function;
import fleet.com.jetbrains.php.lang.parser.parsing.classes.ClassReference;
import fleet.com.jetbrains.php.lang.parser.parsing.classes.StaticClassConstant;
import fleet.com.jetbrains.php.lang.parser.parsing.expressions.Expression;
import fleet.com.jetbrains.php.lang.parser.parsing.expressions.PrimaryExpression;
import fleet.com.jetbrains.php.lang.parser.parsing.expressions.StaticScalar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Variable {
    public static final TokenSet chLBRACE___chLBRACKET = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.chLBRACE, PhpTokenTypes.chLBRACKET});
    private static final TokenSet chRBRACE___chRBRACKET = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.chRBRACKET, PhpTokenTypes.chRBRACE});
    public static final TokenSet START_TOKENS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.VARIABLE_NAME, PhpTokenTypes.VARIABLE, PhpTokenTypes.DOLLAR, PhpTokenTypes.IDENTIFIER, PhpTokenTypes.kwSTATIC});

    public static IElementType parse(PhpPsiBuilder builder) {
        PsiBuilder.Marker reference = builder.mark();
        IElementType result = Variable.parseBaseVariableOrFunctionCall(builder);
        if (result != PhpElementTypes.EMPTY_INPUT) {
            while (builder.compareArrowOrNullsafeArrow() || builder.compare(PhpTokenTypes.SCOPE_RESOLUTION) || builder.compare(PhpTokenTypes.chLBRACKET) || builder.compare(PhpTokenTypes.chLBRACE)) {
                reference.done(result);
                reference = reference.precede();
                result = Variable.parseArrayDeref(builder);
                result = Variable.parseMethodCall(builder, result);
            }
        }
        while (builder.compare(PhpTokenTypes.chLPAREN)) {
            reference.done(result);
            reference = reference.precede();
            result = Function.parseFunctionCallParamListOrCallable(builder, true);
            while (builder.compare(chLBRACE___chLBRACKET) || builder.compareArrowOrNullsafeArrow()) {
                reference.done(result);
                reference = reference.precede();
                if (builder.compare(chLBRACE___chLBRACKET)) {
                    result = Variable.parseArrayDeref(builder);
                    continue;
                }
                result = Variable.parseMethodCall(builder, PhpElementTypes.EMPTY_INPUT);
            }
        }
        reference.drop();
        return result;
    }

    private static boolean isDereference(PhpPsiBuilder builder) {
        return builder.compareArrowOrNullsafeArrow() || builder.compare(PhpTokenTypes.SCOPE_RESOLUTION) || builder.compare(PhpTokenTypes.chLBRACKET) || builder.compare(PhpTokenTypes.chLBRACE);
    }

    public static IElementType parseMethodCall(PhpPsiBuilder builder, IElementType result) {
        IElementType method;
        if (result == PhpElementTypes.EMPTY_INPUT) {
            boolean isStatic = builder.compare(PhpTokenTypes.SCOPE_RESOLUTION);
            builder.compareAndEat(PhpPsiBuilder.QUESTION_MARKS);
            builder.advanceLexer();
            result = Variable.parseObjectProperty(builder, isStatic);
        }
        if ((method = Variable.parseMethodOrNot(builder)) != PhpElementTypes.EMPTY_INPUT) {
            result = method;
        }
        return result;
    }

    public static IElementType parseArrayDeref(PhpPsiBuilder builder) {
        if (builder.compareAndEat(chLBRACE___chLBRACKET)) {
            PsiBuilder.Marker mark = builder.mark();
            Expression.parse(builder);
            mark.done(PhpElementTypes.ARRAY_INDEX);
            builder.match(chRBRACE___chRBRACKET);
            return PhpElementTypes.ARRAY_ACCESS_EXPRESSION;
        }
        return PhpElementTypes.EMPTY_INPUT;
    }

    public static IElementType parseAssignable(PhpPsiBuilder builder) {
        PsiBuilder.Marker reference = builder.mark();
        IElementType result = Variable.parseBaseVariable(builder);
        while (builder.compareArrowOrNullsafeArrow() || builder.compare(chLBRACE___chLBRACKET)) {
            reference.done(result);
            reference = reference.precede();
            if (builder.compare(chLBRACE___chLBRACKET)) {
                result = Variable.parseArrayDeref(builder);
                continue;
            }
            result = Variable.parseMethodCall(builder, PhpElementTypes.EMPTY_INPUT);
        }
        reference.drop();
        return result;
    }

    private static IElementType parseMethodOrNot(PhpPsiBuilder builder) {
        if (builder.compare(PhpTokenTypes.chLPAREN)) {
            return Function.parseFunctionCallParamListOrCallable(builder, false);
        }
        return PhpElementTypes.EMPTY_INPUT;
    }

    public static IElementType parseObjectProperty(PhpPsiBuilder builder, boolean isStatic) {
        IElementType result;
        if (isStatic && builder.getTokenType() != PhpTokenTypes.DOLLAR) {
            PsiBuilder.Marker mark = builder.mark();
            result = Variable.parseCompoundVariable(builder);
            if (result == PhpStubElementTypes.VARIABLE && !builder.compare(PhpTokenTypes.chLPAREN) && !builder.compare(PhpTokenTypes.chLBRACKET)) {
                if (builder.compare(PhpTokenTypes.SCOPE_RESOLUTION)) {
                    mark.done(result);
                } else {
                    mark.drop();
                }
                return PhpElementTypes.FIELD_REFERENCE;
            }
            mark.rollbackTo();
        }
        PsiBuilder.Marker objectProperty = builder.mark();
        result = Variable.parseVariableWithoutObjects(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            objectProperty.drop();
            result = Variable.parseVariableName(builder);
        } else {
            objectProperty.done(result);
        }
        if (result == PhpElementTypes.EMPTY_INPUT && !builder.compareAndEat(PhpTokenTypes.kwCLASS)) {
            builder.error(PhpParserErrors.expected(PhpBundle.message("field.name", new Object[0])));
        }
        return PhpElementTypes.FIELD_REFERENCE;
    }

    private static IElementType parseVariableName(PhpPsiBuilder builder) {
        if (builder.compareAndEat(PhpTokenTypes.IDENTIFIER) || builder.compareAndEat(PhpTokenTypes.tsKEYWORDS)) {
            return PhpElementTypes.FIELD_REFERENCE;
        }
        if (builder.compareAndEat(PhpTokenTypes.chLBRACE)) {
            Expression.parse(builder);
            builder.match(PhpTokenTypes.chRBRACE);
            return PhpElementTypes.FIELD_REFERENCE;
        }
        return PhpElementTypes.EMPTY_INPUT;
    }

    private static IElementType parseBaseVariableOrFunctionCall(PhpPsiBuilder builder) {
        PsiBuilder.Marker rollback = builder.mark();
        IElementType result = Variable.parseBaseVariable(builder);
        if (result == PhpElementTypes.EMPTY_INPUT && (result = Variable.tryParseConstantReferenceInDynamicContext(builder)) == PhpElementTypes.EMPTY_INPUT) {
            result = Variable.tryParseClassConstantReference(builder);
        }
        if (result == PhpElementTypes.CLASS_CONSTANT_REFERENCE && !Variable.isDereference(builder)) {
            rollback.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        if (result == PhpElementTypes.EMPTY_INPUT) {
            rollback.drop();
            result = Function.parse(builder);
        } else if (builder.compare(PhpTokenTypes.chLPAREN)) {
            rollback.rollbackTo();
            result = Function.parse(builder);
        } else {
            rollback.drop();
        }
        return result;
    }

    private static IElementType tryParseClassConstantReference(PhpPsiBuilder builder) {
        PsiBuilder.Marker constantMark = builder.mark();
        IElementType classConstant = StaticClassConstant.doParseClassConstantReference(builder);
        if (classConstant != PhpElementTypes.EMPTY_INPUT) {
            constantMark.drop();
            return classConstant;
        }
        constantMark.rollbackTo();
        return PhpElementTypes.EMPTY_INPUT;
    }

    private static IElementType tryParseConstantReferenceInDynamicContext(PhpPsiBuilder builder) {
        PsiBuilder.Marker constantMark = builder.mark();
        if (StaticScalar.parseConstantReference(builder) && (builder.compareArrowOrNullsafeArrow() || builder.compare(PhpTokenTypes.chLBRACKET))) {
            constantMark.drop();
            return PhpElementTypes.CONSTANT_REF;
        }
        constantMark.rollbackTo();
        return PhpElementTypes.EMPTY_INPUT;
    }

    public static IElementType parseBaseVariable(PhpPsiBuilder builder) {
        IElementType result = PhpElementTypes.EMPTY_INPUT;
        if (builder.compare(PhpTokenTypes.chLPAREN)) {
            result = PrimaryExpression.parseParens(builder);
        }
        if (result != PhpElementTypes.PARENTHESIZED_EXPRESSION) {
            result = Variable.parseVariableWithoutObjects(builder);
        }
        if (result == PhpElementTypes.EMPTY_INPUT) {
            result = Variable.parseStaticMember(builder);
        }
        return result;
    }

    private static IElementType parseStaticMember(PhpPsiBuilder builder) {
        PsiBuilder.Marker rollback = builder.mark();
        PsiBuilder.Marker var = builder.mark();
        if (ClassReference.parse(builder) != PhpElementTypes.EMPTY_INPUT && builder.compareAndEat(PhpTokenTypes.SCOPE_RESOLUTION)) {
            PsiBuilder.Marker variable = builder.mark();
            boolean variableVariable = builder.compare(PhpTokenTypes.DOLLAR);
            IElementType result = Variable.parseVariableWithoutObjects(builder, var, PhpElementTypes.FIELD_REFERENCE);
            if (result != PhpElementTypes.EMPTY_INPUT) {
                rollback.drop();
                if (result == PhpStubElementTypes.VARIABLE) {
                    if (variableVariable) {
                        variable.done(PhpStubElementTypes.VARIABLE);
                    } else {
                        variable.drop();
                    }
                    return PhpElementTypes.FIELD_REFERENCE;
                }
                variable.drop();
                return result;
            }
            variable.drop();
        }
        rollback.rollbackTo();
        return PhpElementTypes.EMPTY_INPUT;
    }

    public static IElementType parseVariableWithoutObjects(PhpPsiBuilder builder) {
        return Variable.parseVariableWithoutObjects(builder, null, null);
    }

    public static IElementType parseVariableWithoutObjects(PhpPsiBuilder builder, @Nullable PsiBuilder.Marker variableMarker, @Nullable IElementType outerElement) {
        return Variable.parseReferenceVariable(builder, variableMarker, outerElement);
    }

    private static IElementType parseReferenceVariable(PhpPsiBuilder builder, @Nullable PsiBuilder.Marker preceder, @Nullable IElementType outerElement) {
        if (preceder == null) {
            preceder = builder.mark();
        }
        boolean varVar = builder.compare(PhpTokenTypes.DOLLAR);
        PsiBuilder.Marker varVarInsideFieldReferenceMark = builder.mark();
        IElementType result = Variable.parseCompoundVariable(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            preceder.drop();
            varVarInsideFieldReferenceMark.drop();
            return result;
        }
        if (varVar && outerElement != null && builder.compare(chLBRACE___chLBRACKET)) {
            varVarInsideFieldReferenceMark.done(PhpStubElementTypes.VARIABLE);
        } else {
            varVarInsideFieldReferenceMark.drop();
        }
        while (builder.compare(chLBRACE___chLBRACKET)) {
            preceder.done(outerElement == null ? result : outerElement);
            if (outerElement != null) {
                outerElement = null;
            }
            preceder = preceder.precede();
            if (builder.compare(chLBRACE___chLBRACKET)) {
                result = Variable.parseArrayAccessWithOptionalIndex(builder);
                continue;
            }
            builder.error(PhpParserErrors.unexpected(builder.getTokenType()));
        }
        preceder.drop();
        return result;
    }

    @NotNull
    public static IElementType parseArrayAccessWithOptionalIndex(PhpPsiBuilder builder) {
        boolean bracket = builder.compare(PhpTokenTypes.chLBRACKET);
        builder.advanceLexer();
        PsiBuilder.Marker arrayIndex = builder.mark();
        Variable.parseDimOffset(builder);
        arrayIndex.done(PhpElementTypes.ARRAY_INDEX);
        builder.match(bracket ? PhpTokenTypes.chRBRACKET : PhpTokenTypes.chRBRACE);
        return PhpElementTypes.ARRAY_ACCESS_EXPRESSION;
    }

    private static IElementType parseCompoundVariable(PhpPsiBuilder builder) {
        if (builder.compareAndEat(PhpTokenTypes.VARIABLE)) {
            return PhpStubElementTypes.VARIABLE;
        }
        if (builder.compareAndEat(PhpTokenTypes.DOLLAR)) {
            if (builder.compareAndEat(PhpTokenTypes.chLBRACE)) {
                Expression.parse(builder);
                builder.match(PhpTokenTypes.chRBRACE);
            } else {
                PsiBuilder.Marker mark = builder.mark();
                IElementType type = Variable.parseCompoundVariable(builder);
                if (type != PhpElementTypes.EMPTY_INPUT) {
                    mark.done(type);
                } else {
                    mark.drop();
                    builder.error(PhpParserErrors.expected(PhpTokenTypes.IDENTIFIER));
                }
            }
            return PhpStubElementTypes.VARIABLE;
        }
        return PhpElementTypes.EMPTY_INPUT;
    }

    private static void parseDimOffset(PhpPsiBuilder builder) {
        Expression.parse(builder);
    }
}

