/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.parser;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.openapi.project.Project;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.jetbrains.php.lang.parser.PhpElementCodeFragmentParser;
import fleet.com.jetbrains.php.lang.parser.PhpElementTypes;
import fleet.com.jetbrains.php.lang.parser.PhpParserErrors;
import fleet.com.jetbrains.php.lang.parser.PhpPsiBuilder;
import fleet.com.jetbrains.php.lang.parser.parsing.functions.Function;
import org.jetbrains.annotations.NotNull;

public class PhpTypeCodeFragmentParser
extends PhpElementCodeFragmentParser {
    public PhpTypeCodeFragmentParser(@NotNull Project project) {
        super(project);
    }

    @Override
    public boolean parseFragment(@NotNull PsiBuilder psiBuilder, @NotNull PhpPsiBuilder phpPsiBuilder, boolean expressionParsed) {
        if (expressionParsed) {
            psiBuilder.error(PhpParserErrors.getClassReferenceExpectedMessage());
        } else {
            PsiBuilder.Marker classReferenceMarker = phpPsiBuilder.mark();
            IElementType result = Function.parseReturnTypeElement(phpPsiBuilder);
            if (result != PhpElementTypes.EMPTY_INPUT) {
                classReferenceMarker.done(result);
                expressionParsed = true;
            } else {
                classReferenceMarker.drop();
                psiBuilder.error(PhpParserErrors.unexpected(psiBuilder.getTokenType()));
            }
        }
        psiBuilder.advanceLexer();
        return expressionParsed;
    }
}

