/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.lexer.managers;

import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.jetbrains.php.lang.lexer.PhpTokenTypes;
import fleet.com.jetbrains.php.lang.lexer._PhpLexer;
import fleet.com.jetbrains.php.lang.lexer.managers.ReadingManager;
import java.io.IOException;

public class NowDocManager
extends ReadingManager {
    private String heredocID;

    public static IElementType tryHeredocStart(_PhpLexer lexer) throws IOException {
        String text = lexer.yytext().toString();
        int labelEnd = text.length() - 1;
        char semicolon = text.charAt(text.length() - 2);
        if (semicolon == ';') {
            --labelEnd;
            lexer.yypushback(2);
        } else {
            lexer.yypushback(1);
        }
        String label = text.substring(0, labelEnd);
        if (label.equals(lexer.getNdManager().getHeredocID())) {
            lexer.sManager.toPreviousState();
            return PhpTokenTypes.HEREDOC_END;
        }
        lexer.yypushback(lexer.yylength());
        lexer.yybegin(14);
        return lexer.advance();
    }

    public static IElementType tryHeredocBody(_PhpLexer lexer) {
        int eatResult = lexer.getNdManager().eat();
        if (eatResult == 0) {
            lexer.sManager.toPreviousState();
            lexer.zzMarkedPos += lexer.getNdManager().getHeredocEndLength();
            return PhpTokenTypes.HEREDOC_END;
        }
        if (eatResult < 0) {
            throw new RuntimeException(lexer.zzBuffer + "@@@" + lexer.zzCurrentPos);
        }
        lexer.zzMarkedPos += eatResult - 1;
        return PhpTokenTypes.HEREDOC_CONTENTS;
    }

    public NowDocManager(_PhpLexer lexer) {
        super(lexer);
    }

    public void start() {
        this.heredocID = this.lexer.yytext().toString();
        this.heredocID = this.heredocID.substring(this.heredocID.charAt(0) == '<' ? 3 : 4).trim();
        this.heredocID = this.heredocID.substring(1, this.heredocID.length() - 1);
        this.lexer.sManager.toState(18);
    }

    @Override
    protected String getHeredocID() {
        return this.heredocID;
    }

    private int getHeredocEndLength() {
        return this.heredocIndentLength + this.heredocID.length();
    }

    public int eat() {
        int pos = 0;
        while (this.canReadAt(pos) && !this.checkForEndDelimiter(pos)) {
            ++pos;
        }
        return pos > 0 ? pos : 0;
    }

    @Override
    public void reset() {
        super.reset();
    }
}

