/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.documentation.phpdoc.parser.tags;

import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.util.containers.ContainerUtil;
import fleet.com.jetbrains.php.lang.documentation.phpdoc.parser.tags.PhpDocMixinTagParser;
import fleet.com.jetbrains.php.lang.documentation.phpdoc.parser.tags.PhpDocParamTagParser;
import fleet.com.jetbrains.php.lang.documentation.phpdoc.parser.tags.PhpDocPropertyTagParser;
import fleet.com.jetbrains.php.lang.documentation.phpdoc.parser.tags.PhpDocReturnTagParser;
import fleet.com.jetbrains.php.lang.documentation.phpdoc.parser.tags.PhpDocSeeTagParser;
import fleet.com.jetbrains.php.lang.documentation.phpdoc.parser.tags.PhpDocTagParser;
import fleet.com.jetbrains.php.lang.documentation.phpdoc.parser.tags.PhpDocThrowsTagParser;
import fleet.com.jetbrains.php.lang.documentation.phpdoc.parser.tags.PhpDocVarTagParser;
import fleet.com.jetbrains.php.lang.documentation.phpdoc.parser.tags.PhpExpectedExceptionCodeTagParser;
import fleet.com.jetbrains.php.lang.documentation.phpdoc.parser.tags.PhpUnitCoversTagParser;
import fleet.com.jetbrains.php.lang.documentation.phpdoc.parser.tags.PhpUnitDocTypeTagParser;
import fleet.com.jetbrains.php.lang.parser.PhpPsiBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDocTagParserRegistry {
    private static final PhpDocTagParser DEFAULT_PARSER = new PhpDocTagParser();
    private static final Map<String, PhpDocTagParser> parsers = new HashMap<String, PhpDocTagParser>();

    private PhpDocTagParserRegistry() {
    }

    @Deprecated
    public static synchronized void register(@Nullable String name, PhpDocTagParser parser) {
        if (name != null) {
            parsers.put(name, parser);
        }
    }

    public static void parse(PhpPsiBuilder builder, boolean inlineTag) {
        String tokenText = builder.getTokenText();
        String tagName = StringUtil.notNullize((String)tokenText);
        PhpDocTagParser tagParser = parsers.containsKey(tokenText) ? parsers.get(tokenText) : PhpDocTagParserRegistry.parsers().filter(e -> ContainerUtil.find(e.getTagNames(), n -> PhpDocTagParserRegistry.sameTagName(n, tagName)) != null).findFirst().orElse(DEFAULT_PARSER);
        tagParser.parse(builder, false, inlineTag);
    }

    private static Stream<PhpDocTagParser> parsers() {
        return Stream.of(new PhpDocMixinTagParser(), new PhpDocParamTagParser(), new PhpDocPropertyTagParser(), new PhpDocReturnTagParser(), new PhpDocSeeTagParser(), new PhpDocThrowsTagParser(), new PhpDocVarTagParser(), new PhpExpectedExceptionCodeTagParser(), new PhpUnitCoversTagParser(), new PhpUnitDocTypeTagParser());
    }

    private static boolean sameTagName(String f, String s) {
        return PhpDocTagParserRegistry.trimStart(f, "@").equalsIgnoreCase(PhpDocTagParserRegistry.trimStart(s, "@"));
    }

    @Contract(pure=true)
    @NotNull
    public static String trimStart(@NotNull String s, @NotNull String prefix) {
        if (s.startsWith(prefix)) {
            return s.substring(prefix.length());
        }
        return s;
    }
}

