/*
 * Decompiled with CFR 0.152.
 */
package fleet.workspace.auth;

import fleet.workspace.auth.JWK;
import fleet.workspace.auth.JWKS;
import fleet.workspace.auth.JWT;
import fleet.workspace.auth.OAuthAuthorizerKt;
import io.ktor.client.HttpClient;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import io.ktor.client.statement.HttpStatement;
import io.ktor.http.HttpMethod;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0002\u001a\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0082@\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"decodeJWT", "Lfleet/workspace/auth/JWT;", "jwt", "", "jwk", "Lfleet/workspace/auth/JWK;", "verifyRsaSignature", "", "exponent", "", "modulus", "content", "signature", "retrieveJWKS", "Lfleet/workspace/auth/JWKS;", "httpClient", "Lio/ktor/client/HttpClient;", "spaceInstance", "(Lio/ktor/client/HttpClient;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fleet.workspace"})
@SourceDebugExtension(value={"SMAP\nOAuthAuthorizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuthAuthorizer.kt\nfleet/workspace/auth/OAuthAuthorizerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 builders.kt\nio/ktor/client/request/BuildersKt\n*L\n1#1,158:1\n1#2:159\n332#3:160\n225#3:161\n99#3,2:162\n22#3:164\n*S KotlinDebug\n*F\n+ 1 OAuthAuthorizer.kt\nfleet/workspace/auth/OAuthAuthorizerKt\n*L\n148#1:160\n148#1:161\n148#1:162,2\n148#1:164\n*E\n"})
public final class OAuthAuthorizerKt {
    private static final JWT decodeJWT(String jwt, JWK jwk) {
        Base64.Decoder base64 = Base64.getUrlDecoder();
        char[] cArray = new char[]{'.'};
        List components = StringsKt.split$default((CharSequence)jwt, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (!(components.size() == 3)) {
            boolean $i$a$-check-OAuthAuthorizerKt$decodeJWT$42 = false;
            String $i$a$-check-OAuthAuthorizerKt$decodeJWT$42 = "Wrong number of components in JWT string";
            throw new IllegalStateException($i$a$-check-OAuthAuthorizerKt$decodeJWT$42.toString());
        }
        String header = (String)components.get(0);
        String payload = (String)components.get(1);
        String signature = (String)components.get(2);
        JsonObject headerJson = OAuthAuthorizerKt.decodeJWT$decodeJson(base64, header);
        JsonObject payloadJson = OAuthAuthorizerKt.decodeJWT$decodeJson(base64, payload);
        JsonElement it = (JsonElement)headerJson.get((Object)"alg");
        boolean bl = false;
        Object object = it instanceof JsonPrimitive ? (JsonPrimitive)it : null;
        if (object == null || (object = object.getContent()) == null) {
            throw new IllegalStateException(("Invalid \"alg\" value " + it).toString());
        }
        Object jwtAlg = object;
        if (!Intrinsics.areEqual((Object)jwtAlg, (Object)jwk.getAlg())) {
            boolean $i$a$-check-OAuthAuthorizerKt$decodeJWT$52 = false;
            String $i$a$-check-OAuthAuthorizerKt$decodeJWT$52 = "JWT algorithm does not match JWK algorithm: " + (String)jwtAlg + " vs " + jwk.getAlg();
            throw new IllegalStateException($i$a$-check-OAuthAuthorizerKt$decodeJWT$52.toString());
        }
        if (!Intrinsics.areEqual((Object)jwtAlg, (Object)"RS512")) {
            boolean bl2 = false;
            String string = "Only RS512 algorithm is supported";
            throw new IllegalStateException(string.toString());
        }
        byte[] byArray = base64.decode(jwk.getExponent());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] byArray2 = base64.decode(jwk.getModulus());
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decode(...)");
        byte[] byArray3 = (header + "." + payload).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
        byte[] byArray4 = base64.decode(signature);
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"decode(...)");
        boolean valid = OAuthAuthorizerKt.verifyRsaSignature(byArray, byArray2, byArray3, byArray4);
        if (!valid) {
            return JWT.InvalidSignature.INSTANCE;
        }
        return new JWT.Valid(payloadJson);
    }

    private static final boolean verifyRsaSignature(byte[] exponent, byte[] modulus, byte[] content2, byte[] signature) {
        Signature signature2;
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(new BigInteger(1, modulus), new BigInteger(1, exponent));
        PublicKey key = KeyFactory.getInstance("RSA").generatePublic(keySpec);
        Signature $this$verifyRsaSignature_u24lambda_u244 = signature2 = Signature.getInstance("SHA512withRSA");
        boolean bl = false;
        $this$verifyRsaSignature_u24lambda_u244.initVerify(key);
        $this$verifyRsaSignature_u24lambda_u244.update(content2);
        return signature2.verify(signature);
    }

    /*
     * Unable to fully structure code
     */
    private static final Object retrieveJWKS(HttpClient var0, String var1_1, Continuation<? super JWKS> $completion) {
        if (!($completion instanceof retrieveJWKS.1)) ** GOTO lbl-1000
        var17_3 = $completion;
        if ((var17_3.label & -2147483648) != 0) {
            var17_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return OAuthAuthorizerKt.access$retrieveJWKS(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var18_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_6 = httpClient;
                urlString$iv = (String)spaceInstance + "/oauth/jwks.json";
                $i$f$get = false;
                $this$get$iv$iv = $this$get$iv;
                $i$f$get = false;
                var8_13 = $this$get$iv$iv;
                $this$get_u24lambda_u244$iv = var9_14 = new HttpRequestBuilder();
                $i$a$-get-BuildersKt$get$5$iv = false;
                HttpRequestKt.url((HttpRequestBuilder)$this$get_u24lambda_u244$iv, (String)urlString$iv);
                $i$a$-get-OAuthAuthorizerKt$retrieveJWKS$2 = false;
                builder$iv$iv$iv = var9_14;
                $i$f$get = false;
                builder$iv$iv$iv.setMethod(HttpMethod.Companion.getGet());
                $this$request$iv$iv$iv$iv = $this$get$iv$iv$iv;
                $i$f$request = false;
                $continuation.label = 1;
                v0 = new HttpStatement(builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv$iv).execute((Continuation)$continuation);
                if (v0 == var18_5) {
                    return var18_5;
                }
                ** GOTO lbl45
            }
            case 1: {
                $i$f$get = false;
                $i$f$get = false;
                $i$f$get = false;
                $i$f$request = false;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl45:
                // 2 sources

                response = (HttpResponse)v0;
                $i$a$-let-OAuthAuthorizerKt$retrieveJWKS$3 = false;
                $continuation.label = 2;
                v1 = HttpResponseKt.bodyAsText$default((HttpResponse)response, null, (Continuation)$continuation, (int)1, null);
                if (v1 == var18_5) {
                    return var18_5;
                }
                ** GOTO lbl56
            }
            case 2: {
                $i$a$-let-OAuthAuthorizerKt$retrieveJWKS$3 = false;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl56:
                // 2 sources

                responseString = (String)v1;
                json = JsonKt.Json$default(null, (Function1)retrieveJWKS.3.json.1.INSTANCE, (int)1, null);
                try {
                    var8_13 = (JWKS)json.decodeFromString((DeserializationStrategy)JWKS.Companion.serializer(), responseString);
                }
                catch (SerializationException ex) {
                    throw new RuntimeException("Failed to deserialize JWKS from " + responseString, ex);
                }
                return var8_13;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final JsonObject decodeJWT$decodeJson(Base64.Decoder base64, String base64string) {
        DeserializationStrategy deserializationStrategy = (DeserializationStrategy)JsonObject.Companion.serializer();
        byte[] byArray = base64.decode(base64string);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.UTF_8;
        return (JsonObject)Json.Default.decodeFromString(deserializationStrategy, new String(byArray2, charset));
    }

    public static final /* synthetic */ Object access$retrieveJWKS(HttpClient httpClient, String spaceInstance, Continuation $completion) {
        return OAuthAuthorizerKt.retrieveJWKS(httpClient, spaceInstance, (Continuation<? super JWKS>)$completion);
    }

    public static final /* synthetic */ JWT access$decodeJWT(String jwt, JWK jwk) {
        return OAuthAuthorizerKt.decodeJWT(jwt, jwk);
    }
}

