/*
 * Decompiled with CFR 0.152.
 */
package fleet.ssh.frontend;

import com.jetbrains.rhizomedb.ChangeScope;
import fleet.common.download.DownloadingException;
import fleet.frontend.notifications.NotificationCategory;
import fleet.frontend.notifications.NotificationCategoryId;
import fleet.frontend.notifications.NotificationEntity;
import fleet.frontend.notifications.NotificationIcon;
import fleet.frontend.notifications.NotificationsKt;
import fleet.kernel.KernelKt;
import fleet.ssh.frontend.ConnectionTimeoutException;
import fleet.ssh.frontend.SshErrorInfo;
import fleet.ssh.frontend.SshHostParams;
import fleet.ssh.frontend.SshReports;
import fleet.ssh.frontend.UnexpectedProcessResultException;
import fleet.ssh.frontend.UnsupportedRemotePlatformException;
import java.io.EOFException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.UnresolvedAddressException;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.exception.SshChannelClosedException;
import org.apache.sshd.common.channel.exception.SshChannelException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0080@\u00a2\u0006\u0002\u0010\u000b\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0011"}, d2={"SshCategory", "Lfleet/frontend/notifications/NotificationCategory;", "getSshCategory", "()Lfleet/frontend/notifications/NotificationCategory;", "createSshNotification", "Lfleet/frontend/notifications/NotificationEntity;", "title", "", "description", "isWarning", "", "(Ljava/lang/String;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parse", "Lfleet/ssh/frontend/SshErrorInfo;", "", "hostParams", "Lfleet/ssh/frontend/SshHostParams;", "fleet.plugins.ssh.frontend"})
public final class SshErrorsKt {
    @NotNull
    private static final NotificationCategory SshCategory = new NotificationCategory(NotificationCategoryId.constructor-impl((String)"ssh"), "SSH", null, 4, null);

    @NotNull
    public static final NotificationCategory getSshCategory() {
        return SshCategory;
    }

    @Nullable
    public static final Object createSshNotification(@NotNull String title, @NotNull String description, boolean isWarning, @NotNull Continuation<? super NotificationEntity> $completion) {
        return KernelKt.change((Function1)((Function1)new Function1<ChangeScope, NotificationEntity>(title, isWarning, description){
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $isWarning;
            final /* synthetic */ String $description;
            {
                this.$title = $title;
                this.$isWarning = $isWarning;
                this.$description = $description;
                super(1);
            }

            @NotNull
            public final NotificationEntity invoke(@NotNull ChangeScope $this$change) {
                Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
                return NotificationsKt.showNotification$default((ChangeScope)$this$change, (NotificationCategory)SshErrorsKt.getSshCategory(), (String)this.$title, (NotificationIcon)(this.$isWarning ? NotificationIcon.Companion.getWarning() : NotificationIcon.Companion.getError()), (String)this.$description, (boolean)false, null, null, null, (int)240, null);
            }
        }), $completion);
    }

    @NotNull
    public static final SshErrorInfo parse(@NotNull Throwable $this$parse, @NotNull SshHostParams hostParams) {
        SshErrorInfo sshErrorInfo;
        Intrinsics.checkNotNullParameter((Object)$this$parse, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hostParams, (String)"hostParams");
        Throwable throwable = $this$parse;
        if (throwable instanceof DownloadingException) {
            sshErrorInfo = new SshErrorInfo(((DownloadingException)$this$parse).getUiVisibleError(), null, SshReports.SshStatus.DOWNLOADING_ERROR, null, 10, null);
        } else if (throwable instanceof UnresolvedAddressException) {
            sshErrorInfo = new SshErrorInfo("Failed to resolve host `" + hostParams.getHostname() + "`", null, SshReports.SshStatus.CONNECT_ERROR, null, 10, null);
        } else if (throwable instanceof SocketException) {
            sshErrorInfo = new SshErrorInfo("Failed to create network socket: " + $this$parse.getMessage(), null, SshReports.SshStatus.CONNECT_ERROR, null, 10, null);
        } else if (throwable instanceof SocketTimeoutException ? true : throwable instanceof ConnectionTimeoutException) {
            sshErrorInfo = new SshErrorInfo("Timeout while trying to connect to a remote host: " + $this$parse.getMessage(), null, SshReports.SshStatus.CONNECT_ERROR, null, 10, null);
        } else if (throwable instanceof EOFException ? true : throwable instanceof SshChannelClosedException) {
            sshErrorInfo = new SshErrorInfo("Connection closed", $this$parse.getMessage(), SshReports.SshStatus.CONNECT_ERROR, null, 8, null);
        } else if (throwable instanceof SshChannelException) {
            sshErrorInfo = new SshErrorInfo("Ssh channel " + ((SshChannelException)$this$parse).getChannelId() + " failed", $this$parse.getMessage(), SshReports.SshStatus.CONNECT_ERROR, null, 8, null);
        } else if (throwable instanceof SshException) {
            Object object = $this$parse.getMessage();
            if (object == null) {
                object = "Connection failed with code " + ((SshException)$this$parse).getDisconnectCode();
            }
            sshErrorInfo = new SshErrorInfo((String)object, null, SshReports.SshStatus.SSH_ERROR, "Ssh connection failed with disconnect code " + ((SshException)$this$parse).getDisconnectCode(), 2, null);
        } else if (throwable instanceof UnexpectedProcessResultException) {
            String string = $this$parse.getMessage();
            Intrinsics.checkNotNull((Object)string);
            sshErrorInfo = new SshErrorInfo(string, ((UnexpectedProcessResultException)$this$parse).getOutputLog(), SshReports.SshStatus.REMOTE_PROCESS_ERROR, null, 8, null);
        } else {
            sshErrorInfo = throwable instanceof UnsupportedRemotePlatformException ? new SshErrorInfo("The platform of the remote machine (`" + ((UnsupportedRemotePlatformException)$this$parse).getOs() + "` on `" + ((UnsupportedRemotePlatformException)$this$parse).getArch() + "`) is not supported", null, SshReports.SshStatus.UNSUPPORTED_REMOTE, null, 10, null) : new SshErrorInfo("An unknown error has occurred", $this$parse.getMessage(), SshReports.SshStatus.UNKNOWN_ERROR, null, 8, null);
        }
        return sshErrorInfo;
    }
}

