/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.os;

import java.util.Locale;

public final class Os {
    public static final Os INSTANCE = new Os();

    private Os() {
    }

    public String getName() {
        return System.getProperty("os.name");
    }

    public String getVersion() {
        return System.getProperty("os.version");
    }

    public String getArch() {
        return System.getProperty("os.arch");
    }

    public Type getType() {
        String normalizedName = this.getName().toLowerCase(Locale.ROOT);
        if (normalizedName.startsWith("mac")) {
            return Type.MacOS;
        }
        if (normalizedName.startsWith("win")) {
            return Type.Windows;
        }
        if (normalizedName.contains("nix") || normalizedName.contains("nux")) {
            return Type.Linux;
        }
        return Type.Unknown;
    }

    public boolean isAarch64() {
        String arch = this.getArch();
        return "aarch64".equals(arch) || "arm64".equals(arch);
    }

    public boolean isMac() {
        return this.getType() == Type.MacOS;
    }

    public boolean isWindows() {
        return this.getType() == Type.Windows;
    }

    public boolean isLinux() {
        return this.getType() == Type.Linux;
    }

    public boolean isUnix() {
        Type type = this.getType();
        return type == Type.Linux || type == Type.MacOS;
    }

    public static enum Type {
        Windows,
        Linux,
        MacOS,
        Unknown;

    }
}

