/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceRange;
import org.clang.lex.PPCallbacks;
import org.clang.lex.PragmaHandler;
import org.clang.lex.PragmaIntroducerKind;
import org.clang.lex.Preprocessor;
import org.clang.lex.Token;
import org.clang.lex.llvm.ArrayRefToken;
import org.clang.lex.llvm.MutableArrayRefToken;
import org.clank.java.built_in;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.support.CrashRecoveryContext;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class PragmaDebugHandler
extends PragmaHandler
implements Destructors.ClassWithDestructor {
    public PragmaDebugHandler() {
        super("__debug");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void HandlePragma(Preprocessor PP, PragmaIntroducerKind Introducer, Token DepToken) {
        Token Tok = new Token();
        PP.LexUnexpandedToken(Tok);
        if (Tok.isNot('\u0005')) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)PP.Diag(Tok, 988))));
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        IdentifierInfo II = Tok.getIdentifierInfo();
        if (II.isStr("assert")) {
            throw new llvm_unreachable("This is an assertion!");
        }
        if (II.isStr("crash")) {
            built_in.__builtin_trap();
        } else if (II.isStr("parser_crash")) {
            Token Crasher = new Token();
            Crasher.startToken();
            Crasher.setKind('\u014d');
            Crasher.setAnnotationRange(new SourceRange(Tok.getLocation()));
            PP.EnterToken(Crasher);
        } else if (II.isStr("dump")) {
            Token Identifier = new Token();
            PP.LexUnexpandedToken(Identifier);
            IdentifierInfo DumpII = Identifier.getIdentifierInfo();
            if (DumpII != null) {
                Token DumpAnnot = new Token();
                DumpAnnot.startToken();
                DumpAnnot.setKind('\u014f');
                DumpAnnot.setAnnotationRange(new SourceRange(Tok.getLocation(), Identifier.getLocation()));
                DumpAnnot.setAnnotationValue(DumpII);
                PP.DiscardUntilEndOfDirective();
                PP.EnterToken(DumpAnnot);
            } else {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)PP.Diag(Identifier, 985))), (StringRef)II.getName()));
                }
                finally {
                    $c$.$destroy();
                }
            }
        } else if (II.isStr("llvm_fatal_error")) {
            llvm.report_fatal_error((char.ptr)NativePointer.$((String)"#pragma clang __debug llvm_fatal_error"));
        } else {
            if (II.isStr("llvm_unreachable")) {
                throw new llvm_unreachable("#pragma clang __debug llvm_unreachable");
            }
            if (II.isStr("macro")) {
                Token MacroName = new Token();
                PP.LexUnexpandedToken(MacroName);
                IdentifierInfo MacroII = MacroName.getIdentifierInfo();
                if (MacroII != null) {
                    PP.dumpMacroInfo(MacroII);
                } else {
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)PP.Diag(MacroName, 985))), (StringRef)II.getName()));
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
            } else if (II.isStr("overflow_stack")) {
                PragmaDebugHandler.DebugOverflowStack();
            } else if (II.isStr("handle_crash")) {
                CrashRecoveryContext CRC = CrashRecoveryContext.GetCurrent();
                if (CRC != null) {
                    CRC.HandleCrash();
                }
            } else if (II.isStr("captured")) {
                this.HandleCaptured(PP);
            } else {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)PP.Diag(Tok, 986))), (StringRef)II.getName()));
                }
                finally {
                    $c$.$destroy();
                }
            }
        }
        PPCallbacks Callbacks = PP.getPPCallbacks();
        if (Callbacks != null) {
            Callbacks.PragmaDebug(Tok.getLocation(), II.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void HandleCaptured(Preprocessor PP) {
        if (PP.isPreprocessedOutput()) {
            return;
        }
        Token Tok = new Token();
        PP.LexUnexpandedToken(Tok);
        if (Tok.isNot('\u0002')) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)PP.Diag(Tok, 886))), (String)"pragma clang __debug captured"));
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        SourceLocation NameLoc = Tok.getLocation();
        MutableArrayRefToken Toks = new MutableArrayRefToken(new Token());
        ((Token)Toks.$at(0)).startToken();
        ((Token)Toks.$at(0)).setKind('\u014e');
        ((Token)Toks.$at(0)).setLocation(NameLoc);
        PP.EnterTokenStream(new ArrayRefToken(Toks), true);
    }

    public static void DebugOverflowStack() {
        NativeCallback.Void2Void Self = () -> PragmaDebugHandler.DebugOverflowStack();
        Self.$call();
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    public String toString() {
        return "" + super.toString();
    }
}

