/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.Module;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceRange;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.tok;
import org.clang.lex.CommentHandler;
import org.clang.lex.DirectoryLookup;
import org.clang.lex.LexClangGlobals;
import org.clang.lex.Lexer;
import org.clang.lex.MacroDefinition;
import org.clang.lex.MacroDirective;
import org.clang.lex.MacroInfo;
import org.clang.lex.ModuleMacro;
import org.clang.lex.NumericLiteralParser;
import org.clang.lex.PPCallbacks;
import org.clang.lex.PTHLexer;
import org.clang.lex.PTHManager;
import org.clang.lex.PragmaNamespace;
import org.clang.lex.PreprocessingRecord;
import org.clang.lex.Preprocessor;
import org.clang.lex.Preprocessor_NestedClasses;
import org.clang.lex.Preprocessor_NestedEnums;
import org.clang.lex.Preprocessor_Pragma;
import org.clang.lex.ScratchBuffer;
import org.clang.lex.StringLiteralParser;
import org.clang.lex.Token;
import org.clang.lex.TokenLexer;
import org.clang.lex.TokenValue;
import org.clang.lex.impl.PreprocessorStatics;
import org.clang.lex.java.PTHManagerDriver;
import org.clang.lex.java.impl.EvaluateValueHelper;
import org.clang.lex.llvm.ArrayRefToken;
import org.clang.lex.llvm.ModuleIdPath;
import org.clang.lex.llvm.SmallVectorToken;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.ulong;
import org.llvm.adt.APInt;
import org.llvm.adt.SmallString;
import org.llvm.adt.StatisticsADTSupport;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.adt.aliases.DenseMapIteratorTypeUInt;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class Preprocessor_Preprocessor
extends Preprocessor_Pragma {
    private final Preprocessor $this() {
        return (Preprocessor)this;
    }

    public void Initialize(TargetInfo Target) {
        this.$this().Initialize(Target, null);
    }

    public void Initialize(TargetInfo Target, TargetInfo AuxTarget) {
        assert (this.$this().Target == null || this.$this().Target == Native.$AddrOf((Object)Target)) : "Invalid override of target information";
        this.$this().Target = (TargetInfo)Native.$AddrOf((Object)Target);
        assert (this.$this().AuxTarget == null || this.$this().AuxTarget == AuxTarget) : "Invalid override of aux target information.";
        this.$this().AuxTarget = AuxTarget;
        this.$this().$EvaluateValueHelper = EvaluateValueHelper.$create(Target.getIntMaxTWidth());
        this.$this().BuiltinInfo.InitializeTarget(Target, AuxTarget);
        this.$this().HeaderInfo.setTarget(Target);
    }

    public void InitializeForModelFile() {
        this.$this().NumEnteredSourceFiles = 0;
        this.$this().PragmaHandlersBackup.$assignMove((std_ptr.unique_ptr)std.move(this.$this().PragmaHandlers));
        this.$this().PragmaHandlers.reset((Object)new PragmaNamespace(StringRef.R$STRING_REF_NO_ARGS));
        this.$this().RegisterBuiltinPragmas();
        this.$this().PredefinesFileID.$assignMove(new FileID());
    }

    public void FinalizeForModelFile() {
        this.$this().NumEnteredSourceFiles = 1;
        this.$this().PragmaHandlers.$assignMove((std_ptr.unique_ptr)std.move(this.$this().PragmaHandlersBackup));
    }

    public void setPTHManager(PTHManager pm) {
        this.$this().PTH.reset((Object)pm);
        this.$this().FileMgr.addStatCache(((PTHManager)((Object)this.$this().PTH.$arrow())).createStatCache());
    }

    public DenseMapIterator<IdentifierInfo, Preprocessor_NestedClasses.MacroState> macro_begin() {
        return this.$this().macro_begin(true);
    }

    public DenseMapIterator<IdentifierInfo, Preprocessor_NestedClasses.MacroState> macro_begin(boolean IncludeExternalMacros) {
        if (IncludeExternalMacros && this.$this().ExternalSource != null && !this.$this().ReadMacrosFromExternalSource) {
            this.$this().ReadMacrosFromExternalSource = true;
            this.$this().ExternalSource.ReadDefinedMacros();
        }
        for (ModuleMacro Macro : this.$this().ModuleMacros) {
            this.$this().CurSubmoduleState.Macros.insert((std_pair.pair)std.make_pair_Ptr_T((Object)Macro.II, (Object)new Preprocessor_NestedClasses.MacroState()));
        }
        return this.$this().CurSubmoduleState.Macros.begin();
    }

    public DenseMapIterator<IdentifierInfo, Preprocessor_NestedClasses.MacroState> macro_end() {
        return this.$this().macro_end(true);
    }

    public DenseMapIterator<IdentifierInfo, Preprocessor_NestedClasses.MacroState> macro_end(boolean IncludeExternalMacros) {
        if (IncludeExternalMacros && this.$this().ExternalSource != null && !this.$this().ReadMacrosFromExternalSource) {
            this.$this().ReadMacrosFromExternalSource = true;
            this.$this().ExternalSource.ReadDefinedMacros();
        }
        return this.$this().CurSubmoduleState.Macros.end();
    }

    public StringRef getLastMacroWithSpelling(SourceLocation Loc, ArrayRef<TokenValue> Tokens) {
        int BestLocation = SourceLocation.getInvalid();
        StringRef BestSpelling = new StringRef();
        DenseMapIterator<IdentifierInfo, Preprocessor_NestedClasses.MacroState> I = this.$this().macro_begin();
        DenseMapIterator<IdentifierInfo, Preprocessor_NestedClasses.MacroState> E = this.$this().macro_end();
        while (I.$noteq(E)) {
            MacroDirective.DefInfo Def = ((Preprocessor_NestedClasses.MacroState)I.$arrow().second).findDirectiveAtLoc(Loc, this.$this().SourceMgr);
            if (Def.$bool() && Def.getMacroInfo() != null && Def.getMacroInfo().isObjectLike() && PreprocessorStatics.MacroDefinitionEquals(Def.getMacroInfo(), Tokens)) {
                int Location2 = Def.getLocation();
                if (SourceLocation.isInvalid((int)BestLocation) || SourceLocation.isValid((int)Location2) && this.$this().SourceMgr.isBeforeInTranslationUnit(BestLocation, Location2)) {
                    BestLocation = Location2;
                    BestSpelling.$assignMove(((IdentifierInfo)I.$arrow().first).getName());
                }
            }
            I.$preInc();
        }
        return BestSpelling;
    }

    public void addCommentHandler(CommentHandler Handler) {
        assert (Handler != null) : "NULL comment handler";
        assert (!this.$this().CommentHandlers.contains((Object)Handler)) : "Comment handler already registered";
        this.$this().CommentHandlers.push_back((Object)Handler);
    }

    public void removeCommentHandler(CommentHandler Handler) {
        assert (this.$this().CommentHandlers.contains((Object)Handler)) : "Comment handler not registered";
        this.$this().CommentHandlers.erase((Object)Handler);
    }

    public void CodeCompleteNaturalLanguage() {
        if (this.$this().CodeComplete != null) {
            this.$this().CodeComplete.CodeCompleteNaturalLanguage();
        }
        this.$this().setCodeCompletionReached();
    }

    public void createPreprocessingRecord() {
        if (this.$this().Record != null) {
            return;
        }
        this.$this().Record = new PreprocessingRecord(this.$this().getSourceManager());
        this.$this().addPPCallbacks((std_ptr.unique_ptr<PPCallbacks>)new std_ptr.unique_ptr((Object)this.$this().Record));
    }

    public void EnterMainSourceFile() {
        if (NativeTrace.USE_PTH_DRIVER_IN_TEST && !this.$this().PTH.$bool() && this.$this().ExternalSource == null) {
            PTHManagerDriver.PreparePTHForPreprocessor(this.$this());
        }
        assert (this.$this().NumEnteredSourceFiles == 0) : "Cannot reenter the main file!";
        FileID MainFileID = this.$this().SourceMgr.getMainFileID();
        if (!this.$this().SourceMgr.isLoadedFileID(MainFileID)) {
            FileEntry FE;
            this.$this().EnterSourceFile(MainFileID.$ID(), (type.ptr<DirectoryLookup>)((type.ptr)null), SourceLocation.getInvalid());
            if (this.$this().SkipMainFilePreamble.first > 0) {
                ((Lexer)this.$this().CurLexer.$arrow()).SkipBytes(this.$this().SkipMainFilePreamble.first, this.$this().SkipMainFilePreamble.second);
            }
            if ((FE = this.$this().SourceMgr.getFileEntryForID(MainFileID)) != null) {
                this.$this().HeaderInfo.IncrementIncludeCount(FE);
            }
        }
        std_ptr.unique_ptr SB = MemoryBuffer.getMemBufferCopy((StringRef)new StringRef(this.$this().Predefines), (Twine)Twine.T$built_in_marker);
        assert (SB.$bool()) : "Cannot create predefined source buffer";
        int FID = this.$this().SourceMgr.createFileID(SB);
        assert (FileID.isValid((int)FID)) : "Could not create FileID for predefines?";
        this.$this().setPredefinesFileID(FID);
        this.$this().EnterSourceFile(FID, (type.ptr<DirectoryLookup>)((type.ptr)null), SourceLocation.getInvalid());
    }

    public void EndSourceFile() {
        if (this.$this().Callbacks$boolean) {
            this.$this().Callbacks$arrow.EndOfMainFile();
        }
    }

    public void Lex(Token Result) {
        boolean ReturnedToken = false;
        do {
            switch (this.$this().CurLexerKind) {
                case CLK_Lexer: {
                    ReturnedToken = ((Lexer)this.$this().CurLexer.$arrow()).Lex(Result);
                    break;
                }
                case CLK_PTHLexer: {
                    ReturnedToken = ((PTHLexer)this.$this().CurPTHLexer.$arrow()).Lex(Result);
                    break;
                }
                case CLK_TokenLexer: {
                    ReturnedToken = ((TokenLexer)this.$this().CurTokenLexer.$arrow()).Lex(Result);
                    break;
                }
                case CLK_CachingLexer: {
                    this.$this().CachingLex(Result);
                    ReturnedToken = true;
                    break;
                }
                case CLK_LexAfterModuleImport: {
                    this.$this().LexAfterModuleImport(Result);
                    ReturnedToken = true;
                }
            }
        } while (!ReturnedToken);
        this.$this().LastTokenWasAt = Result.is('G');
    }

    public void LexAfterModuleImport(Token Result) {
        this.$this().recomputeCurLexerKind();
        this.$this().Lex(Result);
        if (this.$this().ModuleImportExpectsIdentifier && Result.getKind() == '\u0005') {
            this.$this().ModuleImportPath.push_back((Object)std.make_pair_Ptr_T((Object)Result.getIdentifierInfo(), (Object)Result.getLocation()));
            this.$this().ModuleImportExpectsIdentifier = false;
            Preprocessor_NestedEnums.CurLexerKindEnum cfr_ignored_0 = this.$this().CurLexerKind;
            this.$this().CurLexerKind = Preprocessor_NestedEnums.CurLexerKindEnum.CLK_LexAfterModuleImport;
            return;
        }
        if (!this.$this().ModuleImportExpectsIdentifier && Result.getKind() == '\u0019') {
            this.$this().ModuleImportExpectsIdentifier = true;
            Preprocessor_NestedEnums.CurLexerKindEnum cfr_ignored_1 = this.$this().CurLexerKind;
            this.$this().CurLexerKind = Preprocessor_NestedEnums.CurLexerKindEnum.CLK_LexAfterModuleImport;
            return;
        }
        if (!this.$this().ModuleImportPath.empty()) {
            Module.B Imported = null;
            if (this.$this().getLangOpts().Modules && (Imported = this.$this().TheModuleLoader.loadModule(this.$this().ModuleImportLoc, new ModuleIdPath((SmallVectorImpl<std_pair.pair<IdentifierInfo, SourceLocation>>)this.$this().ModuleImportPath), Module.B.NameVisibilityKind.Hidden, false).$ModulePtr()) != null) {
                this.$this().makeModuleVisible(Imported, this.$this().ModuleImportLoc);
            }
            if (this.$this().Callbacks$boolean && (this.$this().getLangOpts().Modules || this.$this().getLangOpts().DebuggerSupport)) {
                this.$this().Callbacks$arrow.moduleImport(this.$this().ModuleImportLoc, new ModuleIdPath((SmallVectorImpl<std_pair.pair<IdentifierInfo, SourceLocation>>)this.$this().ModuleImportPath), Imported);
            }
        }
    }

    public void makeModuleVisible(Module.B M, SourceLocation Loc) {
        this.$this().makeModuleVisible(M, Loc.getRawEncoding());
    }

    public void makeModuleVisible(Module.B M, int Loc) {
        this.$this().CurSubmoduleState.VisibleModules.setVisible(M, Loc, Mod -> {}, (Path, Conflict2, Message) -> {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.$this().Diag(this.$this().ModuleImportLoc, 971))), (StringRef)new StringRef(((Module.B)Path.$at(0)).getFullModuleName())), (StringRef)new StringRef(Conflict2.getFullModuleName())), (StringRef)Message));
            }
            finally {
                $c$.$destroy();
            }
        });
        if (!this.$this().BuildingSubmoduleStack.empty() && M != ((Preprocessor_NestedClasses.BuildingSubmoduleInfo)this.$this().BuildingSubmoduleStack.back()).M) {
            ((Preprocessor_NestedClasses.BuildingSubmoduleInfo)this.$this().BuildingSubmoduleStack.back()).M.Imports.insert((Object)M);
        }
    }

    public boolean FinishLexStringLiteral(Token Result, std.string String2, String DiagnosticTag, boolean AllowMacroExpansion) {
        if (Result.isNot('\r')) {
            BasicClangGlobals.$out_DiagnosticBuilder$C_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_int((DiagnosticBuilder)this.$this().Diag(Result, 12), (int)0), (String)DiagnosticTag).$destroy();
            return false;
        }
        SmallVectorToken StrToks = new SmallVectorToken(4, null);
        do {
            StrToks.push_back(Result);
            if (Result.hasUDSuffix()) {
                this.$this().Diag(Result, 18).$destroy();
            }
            if (AllowMacroExpansion) {
                this.Lex(Result);
                continue;
            }
            this.$this().LexUnexpandedToken(Result);
        } while (Result.is('\r'));
        StringLiteralParser Literal = new StringLiteralParser(new ArrayRefToken(StrToks), (Preprocessor)((Object)Native.$Deref((Object)((Object)this.$this()))));
        if (Literal.hadError()) {
            return false;
        }
        assert (Literal.isAscii()) : "Didn't allow wide strings in";
        if (Literal.Pascal) {
            BasicClangGlobals.$out_DiagnosticBuilder$C_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_int((DiagnosticBuilder)this.$this().Diag(StrToks.$at(0).$getLocation(), 12), (int)0), (String)DiagnosticTag).$destroy();
            return false;
        }
        String2.$assignMove(Literal.GetString().$string());
        return true;
    }

    public boolean parseSimpleIntegerLiteral(Token Tok, ulong.ref Value) {
        assert (Tok.is('\u0007'));
        SmallString IntegerBuffer = new SmallString(8);
        bool.ptr NumberInvalid = NativePointer.create_bool$ptr((boolean)false);
        StringRef Spelling = this.$this().getSpelling(Tok, IntegerBuffer, (bool.ptr)Native.$AddrOf((Object)NumberInvalid));
        if (NumberInvalid.$star()) {
            return false;
        }
        NumericLiteralParser Literal = new NumericLiteralParser(Spelling, Tok.$getLocation(), (Preprocessor)((Object)Native.$Deref((Object)((Object)this.$this()))));
        if (Literal.hadError || !Literal.isIntegerLiteral() || Literal.hasUDSuffix()) {
            return false;
        }
        APInt APVal = new APInt(JavaDifferentiators.JD$UInt_ULong.INSTANCE, 64, 0L);
        if (Literal.GetIntegerValue(APVal)) {
            return false;
        }
        this.$this().Lex(Tok);
        Value.$set(APVal.getLimitedValue());
        return true;
    }

    public void recomputeCurLexerKind() {
        this.$this().CurLexerKind = this.$this().CurLexer.$bool() ? Preprocessor_NestedEnums.CurLexerKindEnum.CLK_Lexer : (this.$this().CurPTHLexer.$bool() ? Preprocessor_NestedEnums.CurLexerKindEnum.CLK_PTHLexer : (this.$this().CurTokenLexer.$bool() ? Preprocessor_NestedEnums.CurLexerKindEnum.CLK_TokenLexer : Preprocessor_NestedEnums.CurLexerKindEnum.CLK_CachingLexer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean SetCodeCompletionPoint(FileEntry File2, int CompleteLine, int CompleteColumn) {
        std_ptr.unique_ptr NewBuffer = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            assert (File2 != null);
            assert (CompleteLine != 0 && CompleteColumn != 0) : "Starts from 1:1";
            assert (this.$this().CodeCompletionFile == null) : "Already set";
            bool.ptr Invalid = null;
            MemoryBuffer Buffer = this.$this().SourceMgr.getMemoryBufferForFile(File2, Invalid);
            if (Buffer.isInvalid()) {
                boolean bl = true;
                return bl;
            }
            char.ptr Position = Native.$tryClone((char.ptr)Buffer.getBufferStart());
            int Line = 1;
            while (Unsigned.$less_uint((int)Line, (int)CompleteLine)) {
                while (Position.$star() != 0) {
                    if (Position.$star() == 13 || Position.$star() == 10) {
                        if ((Position.$at(1) == 13 || Position.$at(1) == 10) && Position.$at(0) != Position.$at(1)) {
                            Position.$preInc();
                        }
                        Position.$preInc();
                        break;
                    }
                    Position.$preInc();
                }
                ++Line;
            }
            Position.$inc(CompleteColumn - 1);
            if (this.$this().SkipMainFilePreamble.first != 0 && this.$this().SourceMgr.getFileEntryForID(this.$this().SourceMgr.getMainFileID()) == File2 && Position.$sub((abstract_iterator)Buffer.getBufferStart()) < this.$this().SkipMainFilePreamble.first) {
                Position = Native.$tryClone((char.ptr)((char.ptr)Buffer.getBufferStart().$add(this.$this().SkipMainFilePreamble.first)));
            }
            if (Position.$greater((Object)Buffer.getBufferEnd())) {
                Position = Native.$tryClone((char.ptr)Buffer.getBufferEnd());
            }
            this.$this().CodeCompletionFile = File2;
            this.$this().CodeCompletionOffset = Position.$sub((abstract_iterator)Buffer.getBufferStart());
            NewBuffer = MemoryBuffer.getNewUninitMemBuffer((int)(Buffer.getBufferSize() + 1), (Twine)new Twine(Buffer.getBufferIdentifier()));
            char.ptr NewBuf = Native.$tryClone((char.ptr)((MemoryBuffer)NewBuffer.$arrow()).getBufferStart());
            char.ptr NewPos = Native.$tryClone((char.ptr)((char.ptr)std.copy((char.iterator)Buffer.getBufferStart(), (char.iterator)Position, (char.iterator)NewBuf)));
            NewPos.$set((byte)0);
            std.copy((char.iterator)Position, (char.iterator)Buffer.getBufferEnd(), (char.iterator)((char.ptr)NewPos.$add(1)));
            this.$this().SourceMgr.overrideFileContents(File2, $c$.track(new std_ptr.unique_ptr(JavaDifferentiators.JD$Move.INSTANCE, (std_ptr.unique_ptr)std.move((Object)NewBuffer))));
            $c$.clean();
            boolean bl = false;
            return bl;
        }
        finally {
            if (NewBuffer != null) {
                NewBuffer.$destroy();
            }
            $c$.$destroy();
        }
    }

    public StringRef getSpelling(Token Tok, SmallString Buffer) {
        return this.$this().getSpelling(Tok, Buffer, (bool.ptr)null);
    }

    public StringRef getSpelling(Token Tok, SmallString Buffer, bool.ptr Invalid) {
        IdentifierInfo II;
        if (Tok.isNot('\u0006') && !Tok.hasUCN() && (II = Tok.getIdentifierInfo()) != null) {
            return II.getName();
        }
        if (Tok.needsCleaning()) {
            Buffer.resize(Tok.getLength());
        }
        char.ptr Ptr = Buffer.data();
        int Len = this.$this().getSpelling(Tok, Ptr, Invalid);
        return new StringRef(Ptr, Len);
    }

    public void CreateString(StringRef Str, Token Tok) {
        this.$this().CreateString(Str, Tok, SourceLocation.getInvalid(), SourceLocation.getInvalid());
    }

    public void CreateString(StringRef Str, Token Tok, int ExpansionLocStart) {
        this.$this().CreateString(Str, Tok, ExpansionLocStart, SourceLocation.getInvalid());
    }

    public void CreateString(StringRef Str, Token Tok, int ExpansionLocStart, int ExpansionLocEnd) {
        this.$this().CreateString(Str.data(), Str.size(), Tok, ExpansionLocStart, ExpansionLocEnd);
    }

    public void CreateString(char.ptr Str, int StrLen, Token Tok) {
        this.$this().CreateString(Str, StrLen, Tok, SourceLocation.getInvalid(), SourceLocation.getInvalid());
    }

    public void CreateString(char.ptr Str, int StrLen, Token Tok, int ExpansionLocStart) {
        this.$this().CreateString(Str, StrLen, Tok, ExpansionLocStart, SourceLocation.getInvalid());
    }

    public void CreateString(char.ptr Str, int StrLen, Token Tok, int ExpansionLocStart, int ExpansionLocEnd) {
        Tok.setLength(StrLen);
        char.ptr.array DestPtr = this.$this().$getCreateStringDestPtr();
        int Loc = ((ScratchBuffer)this.$this().ScratchBuf.$arrow()).getToken(Str, StrLen, (char.ptr)DestPtr);
        this.$this().putCreatedStringIntoToken(ExpansionLocStart, Loc, ExpansionLocEnd, StrLen, Tok, (char.ptr)DestPtr);
        this.$this().$releaseCreateStringDestPtr(DestPtr);
    }

    public void CreateString(byte[] Str, int StrIdx, int StrLen, Token Tok, int ExpansionLocStart, int ExpansionLocEnd) {
        Tok.setLength(StrLen);
        char.ptr.array DestPtr = this.$this().$getCreateStringDestPtr();
        assert (DestPtr != null);
        int Loc = ((ScratchBuffer)this.$this().ScratchBuf.$arrow()).getToken(Str, StrIdx, StrLen, (char.ptr)DestPtr);
        this.$this().putCreatedStringIntoToken(ExpansionLocStart, Loc, ExpansionLocEnd, StrLen, Tok, (char.ptr)DestPtr);
        this.$this().$releaseCreateStringDestPtr(DestPtr);
    }

    public void DumpToken(Token Tok) {
        this.$this().DumpToken(Tok, false);
    }

    public void DumpToken(Token Tok, raw_ostream OS) {
        this.$this().DumpToken(Tok, false, OS);
    }

    public void DumpToken(Token Tok, boolean DumpFlags) {
        this.$this().DumpToken(Tok, DumpFlags, llvm.errs());
    }

    public void DumpToken(Token Tok, boolean DumpFlags, raw_ostream llvm$errs) {
        llvm$errs.$out(tok.getTokenName((char)Tok.getKind())).$out(" '").$out(this.$this().getSpelling(Tok)).$out(NativePointer.$SGL_QUOTE);
        if (!DumpFlags) {
            return;
        }
        llvm$errs.$out(NativePointer.$TAB);
        if (Tok.isAtStartOfLine()) {
            llvm$errs.$out(" [StartOfLine]");
        }
        if (Tok.hasLeadingSpace()) {
            llvm$errs.$out(" [LeadingSpace]");
        }
        if (Tok.isExpandDisabled()) {
            llvm$errs.$out(" [ExpandDisabled]");
        }
        if (Tok.needsCleaning()) {
            char.ptr.array $CharacterDataPtr = this.$this().SourceMgr.$CharacterDataPtr();
            char.ptr Start = this.$this().SourceMgr.getCharacterData_ValidOnly(Tok.$getLocation(), (char.ptr)$CharacterDataPtr);
            llvm$errs.$out(" [UnClean='").$out(new StringRef(Start, Tok.getLength())).$out("']");
            this.$this().SourceMgr.$releaseCharacterDataPtr($CharacterDataPtr);
        }
        llvm$errs.$out("\tLoc=<");
        this.$this().DumpLocation(Tok.getLocation(), llvm$errs);
        llvm$errs.$out(NativePointer.$GT);
    }

    public void DumpLocation(SourceLocation Loc) {
        this.$this().DumpLocation(Loc, llvm.errs());
    }

    public void DumpLocation(SourceLocation Loc, raw_ostream OS) {
        Loc.dump(this.$this().SourceMgr, OS);
    }

    public void DumpMacro(MacroInfo MI) {
        this.$this().DumpMacro(MI, llvm.errs());
    }

    public void DumpMacro(MacroInfo MI, raw_ostream llvm$errs) {
        llvm$errs.$out("MACRO: ");
        int e = MI.getNumTokens();
        for (int i = 0; i != e; ++i) {
            this.$this().DumpToken(MI.getReplacementToken(i), llvm$errs);
            llvm$errs.$out("  ");
        }
        llvm$errs.$out(NativePointer.$LF);
    }

    public void PrintStats() {
        this.$this().PrintStats(llvm.errs());
    }

    public long PrintStats(raw_ostream llvm$errs) {
        llvm$errs.$out("\n*** Preprocessor Stats:\n");
        llvm$errs.$out_uint$formatted(this.$this().NumDirectives).$out(" directives found:\n");
        llvm$errs.$out("  ").$out_uint$formatted(this.$this().NumDefined).$out(" #define.\n");
        llvm$errs.$out("  ").$out_uint$formatted(this.$this().NumUndefined).$out(" #undef.\n");
        llvm$errs.$out("  #include/#include_next/#import:\n");
        llvm$errs.$out("    ").$out_uint$formatted(this.$this().NumEnteredSourceFiles).$out(" source files entered.\n");
        llvm$errs.$out("    ").$out_uint$formatted(this.$this().MaxIncludeStackDepth).$out(" max include stack depth\n");
        llvm$errs.$out("  ").$out_uint$formatted(this.$this().NumIf).$out(" #if/#ifndef/#ifdef.\n");
        llvm$errs.$out("  ").$out_uint$formatted(this.$this().NumElse).$out(" #else/#elif.\n");
        llvm$errs.$out("  ").$out_uint$formatted(this.$this().NumEndif).$out(" #endif.\n");
        llvm$errs.$out("  ").$out_uint$formatted(this.$this().NumPragma).$out(" #pragma.\n");
        llvm$errs.$out_uint$formatted(this.$this().NumSkipped).$out(" #if/#ifndef#ifdef regions skipped\n");
        long Value = this.$this().NumDirectives + this.$this().NumDefined + this.$this().NumUndefined;
        Value += (long)(this.$this().NumEnteredSourceFiles + this.$this().MaxIncludeStackDepth);
        Value += (long)(this.$this().NumIf + this.$this().NumElse + this.$this().NumEndif + this.$this().NumPragma + this.$this().NumSkipped);
        llvm$errs.$out_uint$formatted(this.$this().NumMacroExpanded).$out(NativePointer.$SLASH).$out_uint$formatted(this.$this().NumFnMacroExpanded).$out(NativePointer.$SLASH).$out_uint$formatted(this.$this().NumBuiltinMacroExpanded).$out(" obj/fn/builtin macros expanded, ").$out_uint$formatted(this.$this().NumFastMacroExpanded).$out(" on the fast path.\n");
        Value += (long)(this.$this().NumMacroExpanded + this.$this().NumFnMacroExpanded + this.$this().NumBuiltinMacroExpanded);
        llvm$errs.$out_uint$formatted(this.$this().NumFastTokenPaste + this.$this().NumTokenPaste).$out(" token paste (##) operations performed, ").$out_uint$formatted(this.$this().NumFastTokenPaste).$out(" on the fast path.\n");
        Value += (long)this.$this().NumTokenPaste;
        llvm$errs.$out("\nPreprocessor Memory: ").$out(NativeTrace.formatNumber((long)this.$this().getTotalMemory())).$out("B total");
        long totalMemory = ((ScratchBuffer)this.$this().ScratchBuf.$arrow()).Allocator.getTotalMemory();
        llvm$errs.$out("\n  Scratch Buffers: ").$out(NativeTrace.formatNumber((long)totalMemory));
        Value += totalMemory;
        ((ScratchBuffer)this.$this().ScratchBuf.$arrow()).Allocator.PrintStats("PPScratchBufAllocatedBytes", llvm$errs);
        totalMemory = this.$this().BP.getTotalMemory();
        llvm$errs.$out("\n  BumpPtr: ").$out(NativeTrace.formatNumber((long)totalMemory));
        Value += totalMemory;
        this.$this().BP.PrintStats("PPInternalAllocatedBytes", llvm$errs);
        int capacity_in_bytes = llvm.capacity_in_bytes((NativeType.SizeofCapable)this.$this().MacroExpandedTokens);
        llvm$errs.$out("\n  Macro Expanded Tokens: ").$out_uint$formatted(capacity_in_bytes);
        Value += (long)capacity_in_bytes;
        capacity_in_bytes = this.$this().Predefines.capacity();
        llvm$errs.$out("\n  Predefines Buffer: ").$out_uint$formatted(capacity_in_bytes);
        Value += (long)capacity_in_bytes;
        capacity_in_bytes = llvm.capacity_in_bytes(this.$this().CurSubmoduleState.Macros);
        llvm$errs.$out("\n  Macros: ").$out_uint$formatted(capacity_in_bytes);
        Value += (long)capacity_in_bytes;
        capacity_in_bytes = llvm.capacity_in_bytes(this.$this().PragmaPushMacroInfo);
        llvm$errs.$out("\n  #pragma push_macro Info: ").$out_uint$formatted(capacity_in_bytes);
        Value += (long)capacity_in_bytes;
        capacity_in_bytes = llvm.capacity_in_bytes(this.$this().PoisonReasons);
        llvm$errs.$out("\n  Poison Reasons: ").$out_uint$formatted(capacity_in_bytes);
        Value += (long)capacity_in_bytes;
        capacity_in_bytes = llvm.capacity_in_bytes(this.$this().CommentHandlers);
        llvm$errs.$out("\n  Comment Handlers: ").$out_uint$formatted(capacity_in_bytes).$out(NativePointer.$LF);
        StatisticsADTSupport.dumpStatisticValue((raw_ostream)llvm$errs, (String)"TotalPreprocessorValue", (long)(Value += (long)capacity_in_bytes));
        return Value;
    }

    public long getTotalMemory() {
        return this.$this().BP.getTotalMemory() + (long)llvm.capacity_in_bytes((NativeType.SizeofCapable)this.$this().MacroExpandedTokens) + (long)this.$this().Predefines.capacity() + (long)llvm.capacity_in_bytes(this.$this().CurSubmoduleState.Macros) + (long)llvm.capacity_in_bytes(this.$this().PragmaPushMacroInfo) + (long)llvm.capacity_in_bytes(this.$this().PoisonReasons) + (long)llvm.capacity_in_bytes(this.$this().CommentHandlers);
    }

    public IdentifierInfo LookUpIdentifierInfo(Token Identifier) {
        IdentifierInfo II;
        assert (Identifier.hasRawIdentiferData()) : "No raw identifier data!";
        assert (Identifier.getLength() > 0) : "No raw identifier data!";
        if (!Identifier.needsCleaning() && !Identifier.hasUCN()) {
            byte[] $CharPtrData = Identifier.$CharPtrData();
            II = $CharPtrData != null ? this.$this().getIdentifierInfo($CharPtrData, Identifier.$CharPtrDataIndex(), Identifier.getLength()) : this.$this().getIdentifierInfo(Identifier.getRawIdentifier());
        } else {
            SmallString IdentifierBuffer = new SmallString(64);
            StringRef CleanedStr = this.$this().getSpelling(Identifier, IdentifierBuffer);
            if (Identifier.hasUCN()) {
                SmallString UCNIdentifierBuffer = new SmallString(64);
                LexClangGlobals.expandUCNs(UCNIdentifierBuffer, CleanedStr);
                II = this.$this().getIdentifierInfo(UCNIdentifierBuffer.$array(), 0, UCNIdentifierBuffer.size());
            } else {
                char.ptr data = CleanedStr.data();
                assert (Native.$is_array_based((char.ptr)data)) : data;
                II = this.$this().getIdentifierInfo(data.$array(), data.$index(), CleanedStr.size());
            }
        }
        Identifier.setIdentifierInfo(II);
        Identifier.setKind(II.getTokenID());
        return II;
    }

    public void SetPoisonReason(IdentifierInfo II, int DiagID) {
        this.$this().PoisonReasons.$set((Object)II, DiagID);
    }

    public void HandlePoisonedIdentifier(Token Identifier) {
        assert (Identifier.getIdentifierInfo() != null) : "Can't handle identifiers without identifier info!";
        DenseMapIteratorTypeUInt it = this.$this().PoisonReasons.find((Object)Identifier.getIdentifierInfo());
        if (it.$eq(this.$this().PoisonReasons.end())) {
            this.$this().Diag(Identifier, 838).$destroy();
        } else {
            BasicClangGlobals.$out_DiagnosticBuilder$C_IdentifierInfo$C$P((DiagnosticBuilder)this.$this().Diag(Identifier, it.$star().second), (IdentifierInfo)Identifier.getIdentifierInfo()).$destroy();
        }
    }

    public void PoisonSEHIdentifiers() {
        this.$this().PoisonSEHIdentifiers(true);
    }

    public void PoisonSEHIdentifiers(boolean Poison) {
        assert (this.$this().Ident__exception_code != null && this.$this().Ident__exception_info != null);
        assert (this.$this().Ident___exception_code != null && this.$this().Ident___exception_info != null);
        this.$this().Ident__exception_code.setIsPoisoned(Poison);
        this.$this().Ident___exception_code.setIsPoisoned(Poison);
        this.$this().Ident_GetExceptionCode.setIsPoisoned(Poison);
        this.$this().Ident__exception_info.setIsPoisoned(Poison);
        this.$this().Ident___exception_info.setIsPoisoned(Poison);
        this.$this().Ident_GetExceptionInfo.setIsPoisoned(Poison);
        this.$this().Ident__abnormal_termination.setIsPoisoned(Poison);
        this.$this().Ident___abnormal_termination.setIsPoisoned(Poison);
        this.$this().Ident_AbnormalTermination.setIsPoisoned(Poison);
    }

    public boolean HandleIdentifier(Token Identifier) {
        MacroDefinition MD;
        assert (Identifier.getIdentifierInfo() != null) : "Can't handle identifiers without identifier info!";
        IdentifierInfo II = (IdentifierInfo)Native.$Deref((Object)Identifier.getIdentifierInfo());
        if (II.isOutOfDate()) {
            boolean CurrentIsPoisoned = false;
            if (Native.$AddrOf((Object)II) == this.$this().Ident__VA_ARGS__) {
                CurrentIsPoisoned = this.$this().Ident__VA_ARGS__.isPoisoned();
            }
            this.$this().ExternalSource.updateOutOfDateIdentifier(II);
            Identifier.setKind(II.getTokenID());
            if (Native.$AddrOf((Object)II) == this.$this().Ident__VA_ARGS__) {
                II.setIsPoisoned(CurrentIsPoisoned);
            }
        }
        if (II.isPoisoned() && this.$this().CurPPLexer != null) {
            this.$this().HandlePoisonedIdentifier(Identifier);
        }
        if ((MD = this.$this().getMacroDefinition((IdentifierInfo)Native.$AddrOf((Object)II))).$bool()) {
            MacroInfo MI = MD.getMacroInfo();
            assert (MI != null) : "macro definition with no macro info?";
            if (!this.$this().DisableMacroExpansion) {
                if (!Identifier.isExpandDisabled() && MI.isEnabled()) {
                    if (!MI.isFunctionLike() || this.$this().isNextPPTokenLParen()) {
                        return this.$this().HandleMacroExpandedIdentifier(Identifier, MD);
                    }
                } else {
                    Identifier.setFlag('\u0004');
                    if (MI.isObjectLike() || this.$this().isNextPPTokenLParen()) {
                        this.$this().Diag(Identifier, 920).$destroy();
                    }
                }
            }
        }
        if (II.isFutureCompatKeyword() && !this.$this().DisableMacroExpansion) {
            BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)this.$this().Diag(Identifier, PreprocessorStatics.getFutureCompatDiagKind(II, this.$this().getLangOpts())), (StringRef)II.getName()).$destroy();
            II.setIsFutureCompatKeyword(false);
        }
        if (II.isCPlusPlusOperatorKeyword()) {
            Identifier.setIdentifierInfo(null);
        }
        if (II.isExtensionToken() && !this.$this().DisableMacroExpansion) {
            this.$this().Diag(Identifier, 902).$destroy();
        }
        if (this.$this().LastTokenWasAt && II.isModulesImport() && !this.$this().InMacroArgs && !this.$this().DisableMacroExpansion && (this.$this().getLangOpts().Modules || this.$this().getLangOpts().DebuggerSupport)) {
            Preprocessor_NestedEnums.CurLexerKindEnum cfr_ignored_0 = this.$this().CurLexerKind;
            if (this.$this().CurLexerKind != Preprocessor_NestedEnums.CurLexerKindEnum.CLK_CachingLexer) {
                this.$this().ModuleImportLoc.$assignMove(Identifier.$getLocation());
                this.$this().ModuleImportPath.clear();
                this.$this().ModuleImportExpectsIdentifier = true;
                this.$this().CurLexerKind = Preprocessor_NestedEnums.CurLexerKindEnum.CLK_LexAfterModuleImport;
            }
        }
        return true;
    }

    public Module.B getCurrentModule() {
        if (!this.$this().getLangOpts().CompilingModule) {
            return null;
        }
        return this.$this().getHeaderSearchInfo().lookupModule(new StringRef(this.$this().getLangOpts().CurrentModule));
    }

    public boolean HandleComment(Token result, SourceRange Comment) {
        boolean AnyPendingTokens = false;
        Preprocessor $PP = (Preprocessor)((Object)Native.$Deref((Object)((Object)this.$this())));
        std.vector<CommentHandler> $CommentHandlers = $PP.CommentHandlers;
        int size = $CommentHandlers.size();
        for (int i = 0; i < size; ++i) {
            CommentHandler $Handler = (CommentHandler)$CommentHandlers.$at(i);
            if (!$Handler.HandleComment($PP, Comment)) continue;
            AnyPendingTokens = true;
        }
        if (!AnyPendingTokens || $PP.getCommentRetentionState()) {
            return false;
        }
        $PP.Lex(result);
        return true;
    }
}

