/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.CharSourceRange;
import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.Module;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SourceRange;
import org.clang.lex.ExternalPreprocessingRecordSource;
import org.clang.lex.InclusionDirective;
import org.clang.lex.MacroArgs;
import org.clang.lex.MacroDefinition;
import org.clang.lex.MacroDefinitionRecord;
import org.clang.lex.MacroDirective;
import org.clang.lex.MacroExpansion;
import org.clang.lex.MacroInfo;
import org.clang.lex.PPCallbacks;
import org.clang.lex.PreprocessedEntity;
import org.clang.lex.Token;
import org.clang.lex.impl.PPEntityComp;
import org.clang.lex.impl.PreprocessingRecordStatics;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapInfo;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.adt.iterator_adaptor;
import org.llvm.adt.iterator_range;
import org.llvm.support.BumpPtrAllocator;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class PreprocessingRecord
extends PPCallbacks
implements Destructors.ClassWithDestructor {
    private SourceManager SourceMgr;
    private BumpPtrAllocator BumpAlloc;
    private std.vector<PreprocessedEntity> PreprocessedEntities;
    private std.vector<PreprocessedEntity> LoadedPreprocessedEntities;
    private std.vector<SourceRange> SkippedRanges;
    private DenseMap<MacroInfo, MacroDefinitionRecord> MacroDefinitions;
    private ExternalPreprocessingRecordSource ExternalSource;
    private Unnamed_struct3 CachedRangeQuery;

    public static PPEntityID getPPEntityID(int Index, boolean isLoaded) {
        return isLoaded ? new PPEntityID(-Index - 1) : new PPEntityID(Index + 1);
    }

    public PreprocessedEntity getPreprocessedEntity(PPEntityID PPID) {
        if (PPID.ID < 0) {
            int Index = -PPID.ID - 1;
            assert (Unsigned.$less_uint((int)Index, (int)this.LoadedPreprocessedEntities.size())) : "Out-of bounds loaded preprocessed entity";
            return this.getLoadedPreprocessedEntity(Index);
        }
        if (PPID.ID == 0) {
            return null;
        }
        int Index = PPID.ID - 1;
        assert (Unsigned.$less_uint((int)Index, (int)this.PreprocessedEntities.size())) : "Out-of bounds local preprocessed entity";
        return (PreprocessedEntity)this.PreprocessedEntities.$at(Index);
    }

    public PreprocessedEntity getLoadedPreprocessedEntity(int Index) {
        assert (Unsigned.$less_uint((int)Index, (int)this.LoadedPreprocessedEntities.size())) : "Out-of bounds loaded preprocessed entity";
        assert (this.ExternalSource != null) : "No external source to load from";
        PreprocessedEntity Entity = (PreprocessedEntity)this.LoadedPreprocessedEntities.$at(Index);
        if (Entity == null) {
            Entity = this.ExternalSource.ReadPreprocessedEntity(Index);
            if (Entity == null) {
                Entity = new PreprocessedEntity(PreprocessedEntity.EntityKind.InvalidKind, new SourceRange());
            }
            this.LoadedPreprocessedEntities.$set(Index, (Object)Entity);
        }
        return Entity;
    }

    public int getNumLoadedPreprocessedEntities() {
        return this.LoadedPreprocessedEntities.size();
    }

    private std_pair.pairUIntUInt findLocalPreprocessedEntitiesInRange(SourceRange Range) {
        if (Range.isInvalid()) {
            return std.make_pair_uint_uint((int)0, (int)0);
        }
        assert (!this.SourceMgr.isBeforeInTranslationUnit(Range.getEnd(), Range.getBegin()));
        int Begin = this.findBeginLocalPreprocessedEntity(Range.getBegin());
        int End = this.findEndLocalPreprocessedEntity(Range.getEnd());
        return std.make_pair_uint_uint((int)Begin, (int)End);
    }

    private int findBeginLocalPreprocessedEntity(SourceLocation Loc) {
        if (this.SourceMgr.isLoadedSourceLocation(Loc)) {
            return 0;
        }
        int Count = this.PreprocessedEntities.size();
        StdVector.iterator First = this.PreprocessedEntities.begin();
        StdVector.iterator I = new StdVector.iterator(this.PreprocessedEntities, 0, false);
        while (Unsigned.$greater_uint((int)Count, (int)0)) {
            int Half = Count / 2;
            I.$assign(First);
            std.advance((abstract_iterator)I, (int)Half);
            if (this.SourceMgr.isBeforeInTranslationUnit(((PreprocessedEntity)I.$star()).getSourceRange().getEnd(), Loc)) {
                First.$assign(I);
                First.$preInc();
                Count = Count - Half - 1;
                continue;
            }
            Count = Half;
        }
        return std.$sub___normal_iterator$C((StdVector.iterator)First, (StdVector.iterator)this.PreprocessedEntities.begin());
    }

    private int findEndLocalPreprocessedEntity(SourceLocation Loc) {
        if (this.SourceMgr.isLoadedSourceLocation(Loc)) {
            return 0;
        }
        StdVector.iterator I = (StdVector.iterator)std.upper_bound((type.iterator)this.PreprocessedEntities.begin(), (type.iterator)this.PreprocessedEntities.end(), (Object)Loc, (Native.ComparatorLower)new PPEntityComp(this.SourceMgr, obj -> obj.getBegin()));
        return std.$sub___normal_iterator$C((StdVector.iterator)I, (StdVector.iterator)this.PreprocessedEntities.begin());
    }

    public int allocateLoadedEntities(int NumEntities) {
        int Result = this.LoadedPreprocessedEntities.size();
        this.LoadedPreprocessedEntities.resize(this.LoadedPreprocessedEntities.size() + NumEntities);
        return Result;
    }

    public void RegisterMacroDefinition(MacroInfo Macro, MacroDefinitionRecord Def) {
        this.MacroDefinitions.$set((Object)Macro, (Object)Def);
    }

    public PreprocessingRecord(SourceManager SM) {
        this.SourceMgr = SM;
        this.BumpAlloc = new BumpPtrAllocator();
        this.PreprocessedEntities = new std.vector((Object)null);
        this.LoadedPreprocessedEntities = new std.vector((Object)null);
        this.SkippedRanges = new std.vector((Object)SourceRange.EMPTY);
        this.MacroDefinitions = new DenseMap((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), (Object)null);
        this.ExternalSource = null;
        this.CachedRangeQuery = new Unnamed_struct3();
    }

    public char.ptr Allocate(int Size) {
        return this.Allocate(Size, 8);
    }

    public char.ptr Allocate(int Size, int Align) {
        return this.BumpAlloc.Allocate(Size, Align);
    }

    public void Deallocate(Object Ptr) {
    }

    public long getTotalMemory() {
        return this.BumpAlloc.getTotalMemory() + (long)llvm.capacity_in_bytes(this.MacroDefinitions) + (long)llvm.capacity_in_bytes(this.PreprocessedEntities) + (long)llvm.capacity_in_bytes(this.LoadedPreprocessedEntities);
    }

    public SourceManager getSourceManager() {
        return this.SourceMgr;
    }

    public iterator begin() {
        return new iterator(this, -this.LoadedPreprocessedEntities.size());
    }

    public iterator end() {
        return new iterator(this, this.PreprocessedEntities.size());
    }

    public iterator local_begin() {
        return new iterator(this, 0);
    }

    public iterator local_end() {
        return new iterator(this, this.PreprocessedEntities.size());
    }

    public iterator_range<PreprocessedEntity> getIteratorsForLoadedRange(int start, int count) {
        int end = start + count;
        assert (Unsigned.$lesseq_uint((int)end, (int)this.LoadedPreprocessedEntities.size()));
        return llvm.make_range((type.iterator)new iterator(this, start - this.LoadedPreprocessedEntities.size()), (type.iterator)new iterator(this, end - this.LoadedPreprocessedEntities.size()));
    }

    public iterator_range<PreprocessedEntity> getPreprocessedEntitiesInRange(SourceRange Range) {
        if (Range.isInvalid()) {
            return llvm.make_range((type.iterator)new iterator(), (type.iterator)new iterator());
        }
        if (this.CachedRangeQuery.Range.$eq(Range)) {
            return llvm.make_range((type.iterator)new iterator(this, this.CachedRangeQuery.Result.first), (type.iterator)new iterator(this, this.CachedRangeQuery.Result.second));
        }
        std_pair.pairIntInt Res = this.getPreprocessedEntitiesInRangeSlow(Range);
        this.CachedRangeQuery.Range.$assign(Range);
        this.CachedRangeQuery.Result.$assign(Res);
        return llvm.make_range((type.iterator)new iterator(this, Res.first), (type.iterator)new iterator(this, Res.second));
    }

    public boolean isEntityInFileID(iterator PPEI, FileID FID) {
        if (FID.isInvalid()) {
            return false;
        }
        int Pos = std.distance((abstract_iterator)new iterator(this, 0), (abstract_iterator)new iterator(PPEI));
        if (Pos < 0) {
            if (Unsigned.$greatereq_uint((int)(-Pos - 1), (int)this.LoadedPreprocessedEntities.size())) {
                assert (false) : "Out-of bounds loaded preprocessed entity";
                return false;
            }
            assert (this.ExternalSource != null) : "No external source to load from";
            int LoadedIndex = this.LoadedPreprocessedEntities.size() + Pos;
            PreprocessedEntity PPE = (PreprocessedEntity)this.LoadedPreprocessedEntities.$at(LoadedIndex);
            if (PPE != null) {
                return PreprocessingRecordStatics.isPreprocessedEntityIfInFileID(PPE, FID, this.SourceMgr);
            }
            ADTAliases.OptionalBool IsInFile = this.ExternalSource.isPreprocessedEntityInFileID(LoadedIndex, FID);
            if (IsInFile.hasValue()) {
                return IsInFile.getValue();
            }
            return PreprocessingRecordStatics.isPreprocessedEntityIfInFileID(this.getLoadedPreprocessedEntity(LoadedIndex), FID, this.SourceMgr);
        }
        if (Unsigned.$greatereq_uint((int)Pos, (int)this.PreprocessedEntities.size())) {
            assert (false) : "Out-of bounds local preprocessed entity";
            return false;
        }
        return PreprocessingRecordStatics.isPreprocessedEntityIfInFileID((PreprocessedEntity)this.PreprocessedEntities.$at(Pos), FID, this.SourceMgr);
    }

    public PPEntityID addPreprocessedEntity(PreprocessedEntity Entity) {
        assert (Entity != null);
        SourceLocation BeginLoc = Entity.getSourceRange().getBegin();
        if (llvm.isa(MacroDefinitionRecord.class, (Object)Entity)) {
            assert (this.PreprocessedEntities.empty() || !this.SourceMgr.isBeforeInTranslationUnit(BeginLoc, ((PreprocessedEntity)this.PreprocessedEntities.back()).getSourceRange().getBegin())) : "a macro definition was encountered out-of-order";
            this.PreprocessedEntities.push_back((Object)Entity);
            return PreprocessingRecord.getPPEntityID(this.PreprocessedEntities.size() - 1, false);
        }
        if (this.PreprocessedEntities.empty() || !this.SourceMgr.isBeforeInTranslationUnit(BeginLoc, ((PreprocessedEntity)this.PreprocessedEntities.back()).getSourceRange().getBegin())) {
            this.PreprocessedEntities.push_back((Object)Entity);
            return PreprocessingRecord.getPPEntityID(this.PreprocessedEntities.size() - 1, false);
        }
        int count = 0;
        StdVector.iterator RI = this.PreprocessedEntities.end();
        StdVector.iterator Begin = this.PreprocessedEntities.begin();
        while (std.$noteq___normal_iterator$C((abstract_iterator)RI, (abstract_iterator)Begin) && Unsigned.$less_uint((int)count, (int)4)) {
            StdVector.iterator I = new StdVector.iterator(RI);
            I.$preDec();
            if (!this.SourceMgr.isBeforeInTranslationUnit(BeginLoc, ((PreprocessedEntity)I.$star()).getSourceRange().getBegin())) {
                StdVector.iterator insertI = this.PreprocessedEntities.insert(RI, (Object)Entity);
                return PreprocessingRecord.getPPEntityID(std.$sub___normal_iterator$C((StdVector.iterator)insertI, (StdVector.iterator)this.PreprocessedEntities.begin()), false);
            }
            RI.$preDec();
            ++count;
        }
        StdVector.iterator I = (StdVector.iterator)std.upper_bound((type.iterator)this.PreprocessedEntities.begin(), (type.iterator)this.PreprocessedEntities.end(), (Object)BeginLoc, (Native.ComparatorLower)new PPEntityComp(this.SourceMgr, obj -> obj.getBegin()));
        StdVector.iterator insertI = this.PreprocessedEntities.insert(I, (Object)Entity);
        return PreprocessingRecord.getPPEntityID(std.$sub___normal_iterator((StdVector.iterator)insertI, (StdVector.iterator)this.PreprocessedEntities.begin()), false);
    }

    public void SetExternalSource(ExternalPreprocessingRecordSource Source) {
        assert (this.ExternalSource == null) : "Preprocessing record already has an external source";
        this.ExternalSource = (ExternalPreprocessingRecordSource)Native.$AddrOf((Object)Source);
    }

    public ExternalPreprocessingRecordSource getExternalSource() {
        return this.ExternalSource;
    }

    public MacroDefinitionRecord findMacroDefinition(MacroInfo MI) {
        DenseMapIterator Pos = this.MacroDefinitions.find((Object)MI);
        if (Pos.$eq(this.MacroDefinitions.end())) {
            return null;
        }
        return (MacroDefinitionRecord)Pos.$arrow().second;
    }

    public std.vector<SourceRange> getSkippedRanges() {
        return this.SkippedRanges;
    }

    @Override
    public void MacroExpands(Token Id, MacroDefinition MD, SourceRange Range, MacroArgs Args) {
        this.addMacroExpansion(Id, MD.getMacroInfo(), Range);
    }

    @Override
    public void MacroDefined(SourceLocation HashLoc, SourceLocation EodLoc, Token Id, MacroDirective MD) {
        MacroInfo MI = MD.getMacroInfo();
        SourceRange R = new SourceRange(MI.$getDefinitionLoc(), MI.$getDefinitionEndLoc());
        MacroDefinitionRecord Def = new MacroDefinitionRecord(Id.getIdentifierInfo(), R);
        this.addPreprocessedEntity(Def);
        this.MacroDefinitions.$set((Object)MI, (Object)Def);
    }

    @Override
    public void MacroUndefined(SourceLocation HashLoc, SourceLocation EodLoc, Token Id, MacroDefinition MD) {
        MD.forAllDefinitions(MI -> this.MacroDefinitions.erase((Object)MI));
    }

    @Override
    public void InclusionDirective(SourceLocation HashLoc, SourceLocation EodLoc, Token IncludeTok, StringRef FileName, boolean IsAngled, CharSourceRange FilenameRange, FileEntry File2, StringRef SearchPath, StringRef RelativePath, Module.B Imported) {
        InclusionDirective.InclusionKind Kind2 = InclusionDirective.InclusionKind.Include;
        switch (IncludeTok.getIdentifierInfo().getPPKeywordID()) {
            case '\b': {
                Kind2 = InclusionDirective.InclusionKind.Include;
                break;
            }
            case '\u000f': {
                Kind2 = InclusionDirective.InclusionKind.Import;
                break;
            }
            case '\u0010': {
                Kind2 = InclusionDirective.InclusionKind.IncludeNext;
                break;
            }
            case '\t': {
                Kind2 = InclusionDirective.InclusionKind.IncludeMacros;
                break;
            }
            default: {
                throw new llvm_unreachable("Unknown include directive kind");
            }
        }
        SourceLocation EndLoc = new SourceLocation();
        if (!IsAngled) {
            EndLoc.$assignMove(FilenameRange.getBegin());
        } else {
            EndLoc.$assignMove(FilenameRange.getEnd());
            if (FilenameRange.isCharRange()) {
                EndLoc.$assignMove(EndLoc.getLocWithOffset(-1));
            }
        }
        InclusionDirective ID = new InclusionDirective(this, Kind2, FileName, !IsAngled, Imported != null, File2, new SourceRange(HashLoc, EndLoc));
        this.addPreprocessedEntity(ID);
    }

    @Override
    public void Ifdef(SourceLocation HashLoc, SourceLocation EodLoc, SourceLocation Loc, Token MacroNameTok, MacroDefinition MD) {
        if (MD.$bool()) {
            this.addMacroExpansion(MacroNameTok, MD.getMacroInfo(), new SourceRange(MacroNameTok.$getLocation()));
        }
    }

    @Override
    public void Ifndef(SourceLocation HashLoc, SourceLocation EodLoc, SourceLocation Loc, Token MacroNameTok, MacroDefinition MD) {
        if (MD.$bool()) {
            this.addMacroExpansion(MacroNameTok, MD.getMacroInfo(), new SourceRange(MacroNameTok.$getLocation()));
        }
    }

    @Override
    public void Defined(Token MacroNameTok, MacroDefinition MD, SourceRange Range) {
        if (MD.$bool()) {
            this.addMacroExpansion(MacroNameTok, MD.getMacroInfo(), new SourceRange(MacroNameTok.$getLocation()));
        }
    }

    @Override
    public void SourceRangeSkipped(SourceRange Range) {
        this.SkippedRanges.push_back((Object)Range);
    }

    private void addMacroExpansion(Token Id, MacroInfo MI, SourceRange Range) {
        if (SourceLocation.isMacroID((int)Id.$getLocation())) {
            return;
        }
        if (MI.isBuiltinMacro()) {
            this.addPreprocessedEntity(new MacroExpansion(Id.getIdentifierInfo(), Range));
        } else {
            MacroDefinitionRecord Def = this.findMacroDefinition(MI);
            if (Def != null) {
                this.addPreprocessedEntity(new MacroExpansion(Def, Range));
            }
        }
    }

    private std_pair.pairIntInt getPreprocessedEntitiesInRangeSlow(SourceRange Range) {
        assert (Range.isValid());
        assert (!this.SourceMgr.isBeforeInTranslationUnit(Range.getEnd(), Range.getBegin()));
        std_pair.pairUIntUInt Local = this.findLocalPreprocessedEntitiesInRange(Range);
        if (this.ExternalSource == null || this.SourceMgr.isLocalSourceLocation(Range.getBegin())) {
            return std.make_pair_int_int((int)Local.first, (int)Local.second);
        }
        std_pair.pairUIntUInt Loaded = this.ExternalSource.findPreprocessedEntitiesInRange(Range);
        if (Loaded.first == Loaded.second) {
            return std.make_pair_int_int((int)Local.first, (int)Local.second);
        }
        int TotalLoaded = this.LoadedPreprocessedEntities.size();
        if (Local.first == Local.second) {
            return std.make_pair_int_int((int)(Loaded.first - TotalLoaded), (int)(Loaded.second - TotalLoaded));
        }
        return std.make_pair_int_int((int)(Loaded.first - TotalLoaded), (int)Local.second);
    }

    @Override
    public void $destroy() {
        this.MacroDefinitions.$destroy();
        this.SkippedRanges.$destroy();
        this.LoadedPreprocessedEntities.$destroy();
        this.PreprocessedEntities.$destroy();
        this.BumpAlloc.$destroy();
        super.$destroy();
    }

    @Override
    public String toString() {
        return ", BumpAlloc=" + this.BumpAlloc + ", PreprocessedEntities=" + this.PreprocessedEntities + ", LoadedPreprocessedEntities=" + this.LoadedPreprocessedEntities + ", SkippedRanges=" + this.SkippedRanges + ", MacroDefinitions=" + this.MacroDefinitions + ", ExternalSource=" + this.ExternalSource + ", CachedRangeQuery=" + this.CachedRangeQuery + super.toString();
    }

    private static class Unnamed_struct3 {
        public SourceRange Range = new SourceRange();
        public std_pair.pairIntInt Result = new std_pair.pairIntInt();

        public String toString() {
            return "Range=" + this.Range + ", Result=" + this.Result;
        }
    }

    public static class iterator
    extends iterator_adaptor.Int_base<iterator, std.random_access_iterator_tag, PreprocessedEntity> {
        private PreprocessingRecord Self;

        private iterator(PreprocessingRecord Self, int Position) {
            super(JavaDifferentiators.JD$NotBaseOfRemoveCVRef.INSTANCE, Position);
            this.Self = Self;
        }

        public iterator() {
            this((PreprocessingRecord)null, 0);
        }

        public PreprocessedEntity $star() {
            boolean isLoaded = this.I.$deref() < 0;
            int Index = isLoaded ? this.Self.LoadedPreprocessedEntities.size() + this.I.$deref() : this.I.$deref();
            PPEntityID ID = PreprocessingRecord.getPPEntityID(Index, isLoaded);
            return this.Self.getPreprocessedEntity(ID);
        }

        public PreprocessedEntity $arrow() {
            return this.$star();
        }

        public iterator(iterator $Prm0) {
            super((iterator_adaptor.Int_base)$Prm0);
            this.Self = $Prm0.Self;
        }

        public iterator(JavaDifferentiators.JD$Move _dparam, iterator $Prm0) {
            super(JavaDifferentiators.JD$Move.INSTANCE, (iterator_adaptor.Int_base)$Prm0);
            this.Self = $Prm0.Self;
        }

        public iterator clone() {
            return new iterator(this);
        }

        public String toString() {
            return "Self=" + this.Self + super.toString();
        }
    }

    public static class PPEntityID {
        private int ID;

        private PPEntityID(int ID) {
            this.ID = ID;
        }

        public PPEntityID() {
            this.ID = 0;
        }

        public PPEntityID(PPEntityID $Prm0) {
            this.ID = $Prm0.ID;
        }

        public PPEntityID(JavaDifferentiators.JD$Move _dparam, PPEntityID $Prm0) {
            this.ID = $Prm0.ID;
        }

        public String toString() {
            return "ID=" + this.ID;
        }
    }
}

