/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.DirectoryEntry;
import org.clang.basic.FileEntry;
import org.clang.basic.FileManager;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.LangOptions;
import org.clang.basic.Module;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SrcMgr;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.vfs.FileSystem;
import org.clang.basic.vfs.directory_iterator;
import org.clang.lex.DirectoryLookup;
import org.clang.lex.ExternalHeaderFileInfoSource;
import org.clang.lex.ExternalPreprocessorSource;
import org.clang.lex.HeaderFileInfo;
import org.clang.lex.HeaderMap;
import org.clang.lex.HeaderSearchOptions;
import org.clang.lex.ModuleMap;
import org.clang.lex.Preprocessor;
import org.clang.lex.impl.HeaderSearchStatics;
import org.clang.lex.llvm.HeaderFileInfoVector;
import org.clang.lex.llvm.SmallVectorPtrPairFileEntryDirectoryEntry;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.APInt;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.HashingGlobals;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSet;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.DenseMapInfo;
import org.llvm.adt.aliases.DenseMapIteratorTypeBool;
import org.llvm.adt.aliases.DenseMapTypeBool;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapConstIterator;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.adt.aliases.StringMapIterator;
import org.llvm.adt.aliases.StringMapIteratorChar;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;

public class HeaderSearch
implements Destructors.ClassWithDestructor {
    private IntrusiveRefCntPtr<HeaderSearchOptions> HSOpts;
    private DiagnosticsEngine Diags;
    private FileManager FileMgr;
    private std.vector<DirectoryLookup> SearchDirs;
    private int AngledDirIdx;
    private int SystemDirIdx;
    private boolean NoCurDirSearch;
    private std.vector<std_pair.pairTypeBool<std.string>> SystemHeaderPrefixes;
    private std.string ModuleCachePath;
    private HeaderFileInfoVector FileInfo;
    public static final String REUSE_HEADER_FILE_INFOS_PROP = "clang.header.file.infos.reuse";
    public static final boolean REUSE_HEADER_FILE_INFOS = Boolean.valueOf(System.getProperty("clang.header.file.infos.reuse", "true"));
    private StringMap<LookupFileCacheInfo> LookupFileCache;
    private StringMap<FrameworkCacheEntry> FrameworkMap;
    private std_ptr.unique_ptr<StringMap<std.string>> IncludeAliases;
    private std.vector<std_pair.pair<FileEntry, HeaderMap>> HeaderMaps;
    private ModuleMap ModMap;
    private DenseMapTypeBool<DirectoryEntry> DirectoryHasModuleMap;
    private DenseMapTypeBool<FileEntry> LoadedModuleMaps;
    private StringSet FrameworkNames;
    private ExternalPreprocessorSource ExternalLookup;
    private ExternalHeaderFileInfoSource ExternalSource;
    private int NumIncluded;
    private int NumMultiIncludeFileOptzn;
    private int NumFrameworkLookups;
    private int NumSubFrameworkLookups;
    private final SmallString $LookupFileTmpDir = new SmallString(1024);
    private boolean $LookupFileTmpDirInUse = false;
    private final SmallString $LookupFileMappedName = new SmallString(64);
    private boolean $LookupFileMappedNameInUse = false;
    private final bool.ref $InUserSpecifiedSystemFramework = NativePointer.create_bool$ref((boolean)false);
    private boolean $InUserSpecifiedSystemFrameworkInUse = false;
    private final bool.ref $HasBeenMapped = NativePointer.create_bool$ref((boolean)false);
    private boolean $HasBeenMappedInUse = false;

    private HeaderSearch(HeaderSearch $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private void $assign(HeaderSearch $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    public HeaderSearch(IntrusiveRefCntPtr<HeaderSearchOptions> HSOpts, SourceManager SourceMgr, DiagnosticsEngine Diags, LangOptions LangOpts, TargetInfo Target) {
        this.HSOpts = new IntrusiveRefCntPtr(JavaDifferentiators.JD$Move.INSTANCE, (IntrusiveRefCntPtr)std.move(HSOpts));
        this.Diags = Diags;
        this.FileMgr = SourceMgr.getFileManager();
        this.SearchDirs = new std.vector((Object)DirectoryLookup.DEFAULT);
        this.SystemHeaderPrefixes = new std.vector((Object)new std_pair.pairTypeBool((Object)new std.string(), false));
        this.ModuleCachePath = new std.string();
        this.FileInfo = HeaderFileInfoVector.$create();
        this.LookupFileCache = new StringMap((Object)new LookupFileCacheInfo());
        this.FrameworkMap = new StringMap(64, (Object)new FrameworkCacheEntry());
        this.IncludeAliases = new std_ptr.unique_ptr();
        this.HeaderMaps = new std.vector((Object)null);
        this.ModMap = new ModuleMap(SourceMgr, Diags, LangOpts, Target, this);
        this.DirectoryHasModuleMap = new DenseMapTypeBool((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), false);
        this.LoadedModuleMaps = new DenseMapTypeBool(FileEntry.DMI$FileEntryPtr, false);
        this.FrameworkNames = new StringSet();
        this.AngledDirIdx = 0;
        this.SystemDirIdx = 0;
        this.NoCurDirSearch = false;
        this.ExternalLookup = null;
        this.ExternalSource = null;
        this.NumIncluded = 0;
        this.NumMultiIncludeFileOptzn = 0;
        this.NumSubFrameworkLookups = 0;
        this.NumFrameworkLookups = 0;
    }

    public void $destroy() {
        int e = this.HeaderMaps.size();
        for (int i = 0; i != e; ++i) {
            if (((std_pair.pair)this.HeaderMaps.$at((int)i)).second == null) continue;
            ((HeaderMap)((std_pair.pair)this.HeaderMaps.$at((int)i)).second).$destroy();
        }
        this.FrameworkNames.$destroy();
        this.LoadedModuleMaps.$destroy();
        this.DirectoryHasModuleMap.$destroy();
        this.ModMap.$destroy();
        this.HeaderMaps.$destroy();
        this.IncludeAliases.$destroy();
        this.FrameworkMap.$destroy();
        this.LookupFileCache.$destroy();
        HeaderFileInfoVector.$release(this.FileInfo);
        this.FileInfo = null;
        this.ModuleCachePath.$destroy();
        this.SystemHeaderPrefixes.$destroy();
        this.SearchDirs.$destroy();
        this.HSOpts.$destroy();
    }

    public HeaderSearchOptions getHeaderSearchOpts() {
        return (HeaderSearchOptions)((Object)this.HSOpts.$star());
    }

    public FileManager getFileMgr() {
        return this.FileMgr;
    }

    public void SetSearchPaths(std.vector<DirectoryLookup> dirs, int angledDirIdx, int systemDirIdx, boolean noCurDirSearch) {
        assert (Unsigned.$lesseq_uint((int)angledDirIdx, (int)systemDirIdx) && Unsigned.$lesseq_uint((int)systemDirIdx, (int)dirs.size())) : "Directory indicies are unordered";
        this.SearchDirs.$assign(dirs);
        this.AngledDirIdx = angledDirIdx;
        this.SystemDirIdx = systemDirIdx;
        this.NoCurDirSearch = noCurDirSearch;
    }

    public void AddSearchPath(DirectoryLookup dir, boolean isAngled) {
        int idx = isAngled ? this.SystemDirIdx : this.AngledDirIdx;
        this.SearchDirs.insert(this.SearchDirs.begin().$add(idx), (Object)dir);
        if (!isAngled) {
            ++this.AngledDirIdx;
        }
        ++this.SystemDirIdx;
    }

    public void SetSystemHeaderPrefixes(ArrayRef<std_pair.pairTypeBool<std.string>> P) {
        this.SystemHeaderPrefixes.assign$T((type.iterator)P.begin(), (type.iterator)P.end());
    }

    public boolean HasIncludeAliasMap() {
        return this.IncludeAliases.$bool();
    }

    public void AddIncludeAlias(StringRef Source, StringRef Dest) {
        if (!this.IncludeAliases.$bool()) {
            this.IncludeAliases.reset((Object)new StringMap((Object)std.string.EMPTY));
        }
        ((std.string)((StringMap)this.IncludeAliases.$star()).$at(Source)).$assignMove(Dest.$string());
    }

    public StringRef MapHeaderToIncludeAlias(StringRef Source) {
        assert (this.IncludeAliases.$bool()) : "Trying to map headers when there's no map";
        StringMapIterator Iter = ((StringMap)this.IncludeAliases.$arrow()).find(Source);
        if (Iter.$noteq((StringMapConstIterator)((StringMap)this.IncludeAliases.$arrow()).end())) {
            return new StringRef((std.string)Iter.$arrow().second);
        }
        return new StringRef();
    }

    public void setModuleCachePath(StringRef CachePath) {
        this.ModuleCachePath.$assignMove(CachePath.$string());
    }

    public StringRef getModuleCachePath() {
        return new StringRef(this.ModuleCachePath);
    }

    public void setDirectoryHasModuleMap(DirectoryEntry Dir) {
        this.DirectoryHasModuleMap.$set((Object)Dir, true);
    }

    public void ClearFileInfo() {
        this.FileInfo.clear();
    }

    public void SetExternalLookup(ExternalPreprocessorSource EPS) {
        this.ExternalLookup = EPS;
    }

    public ExternalPreprocessorSource getExternalLookup() {
        return this.ExternalLookup;
    }

    public void SetExternalSource(ExternalHeaderFileInfoSource ES) {
        this.ExternalSource = ES;
    }

    public void setTarget(TargetInfo Target) {
        this.ModMap.setTarget(Target);
    }

    public FileEntry LookupFile(StringRef Filename, SourceLocation IncludeLoc, boolean isAngled, type.ptr<DirectoryLookup> FromDir, type.ref<type.ptr<DirectoryLookup>> CurDir, SmallVectorPtrPairFileEntryDirectoryEntry Includers, SmallString SearchPath, SmallString RelativePath, Module.B RequestingModule, ModuleMap.KnownHeader SuggestedModule) {
        return this.LookupFile(Filename, IncludeLoc, isAngled, FromDir, CurDir, Includers, SearchPath, RelativePath, RequestingModule, SuggestedModule, false, false);
    }

    public FileEntry LookupFile(StringRef Filename, SourceLocation IncludeLoc, boolean isAngled, type.ptr<DirectoryLookup> FromDir, type.ref<type.ptr<DirectoryLookup>> CurDir, SmallVectorPtrPairFileEntryDirectoryEntry Includers, SmallString SearchPath, SmallString RelativePath, Module.B RequestingModule, ModuleMap.KnownHeader SuggestedModule, boolean SkipCache) {
        return this.LookupFile(Filename, IncludeLoc, isAngled, FromDir, CurDir, Includers, SearchPath, RelativePath, RequestingModule, SuggestedModule, SkipCache, false);
    }

    /*
     * Exception decompiling
     */
    public FileEntry LookupFile(StringRef Filename, SourceLocation IncludeLoc, boolean isAngled, type.ptr<DirectoryLookup> FromDir, type.ref<type.ptr<DirectoryLookup>> CurDir, SmallVectorPtrPairFileEntryDirectoryEntry Includers, SmallString SearchPath, SmallString RelativePath, Module.B RequestingModule, ModuleMap.KnownHeader SuggestedModule, boolean SkipCache, boolean BuildSystemModule) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 3[TRYBLOCK]], but top level block is 18[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FileEntry LookupSubframeworkHeader(StringRef Filename, FileEntry ContextFileEnt, SmallString SearchPath, SmallString RelativePath, Module.B RequestingModule, ModuleMap.KnownHeader SuggestedModule) {
        byte DirInfo;
        assert (ContextFileEnt != null) : "No context file?";
        int SlashPos = Filename.find((byte)47);
        if (SlashPos == StringRef.npos) {
            return null;
        }
        char.ptr ContextName = Native.$tryClone((char.ptr)ContextFileEnt.getName());
        int DotFrameworkLen = 10;
        char.ptr FrameworkPos = Native.$tryClone((char.ptr)std.strstr((char.ptr)ContextName, (char.ptr)NativePointer.$((String)".framework")));
        if (Native.$eq_ptr((void.ptr)FrameworkPos, null) || FrameworkPos.$at(DotFrameworkLen) != 47 && FrameworkPos.$at(DotFrameworkLen) != 92) {
            return null;
        }
        SmallString FrameworkName = new SmallString((char.iterator)ContextName, (char.iterator)((char.ptr)((char.ptr)FrameworkPos.$add(DotFrameworkLen)).$add(1)), 1024);
        FrameworkName.$addassign("Frameworks/");
        FrameworkName.append(Filename, 0, SlashPos);
        FrameworkName.$addassign(".framework/");
        StringMapEntry CacheLookup = this.FrameworkMap.GetOrCreateValue(Filename.substr(0, SlashPos), (Object)new FrameworkCacheEntry());
        if (((FrameworkCacheEntry)CacheLookup.second).Directory != null && CacheLookup.getKeyLength() == FrameworkName.size() && std.memcmp((char.ptr)CacheLookup.getKeyStr(), (char.ptr)((char.ptr)Native.$AddrOf((Object)FrameworkName.data())), (int)CacheLookup.getKeyLength()) != 0) {
            return null;
        }
        if (((FrameworkCacheEntry)CacheLookup.second).Directory == null) {
            ++this.NumSubFrameworkLookups;
            DirectoryEntry Dir = this.FileMgr.getDirectory(FrameworkName.$StringRef());
            if (Dir == null) {
                return null;
            }
            ((FrameworkCacheEntry)CacheLookup.second).Directory = Dir;
        }
        FileEntry FE = null;
        if (RelativePath != null) {
            RelativePath.clear();
            RelativePath.append(Filename, SlashPos + 1, Filename.size());
        }
        SmallString HeadersFilename = new SmallString(FrameworkName);
        HeadersFilename.$addassign("Headers/");
        if (SearchPath != null) {
            SearchPath.clear();
            SearchPath.append((SmallVectorImplChar)HeadersFilename, 0, HeadersFilename.size() - 1);
        }
        HeadersFilename.append(Filename, SlashPos + 1, Filename.size());
        FE = this.FileMgr.getFile(HeadersFilename.$StringRef(), true);
        if (FE == null) {
            HeadersFilename.$assign((SmallVectorImplChar)FrameworkName);
            HeadersFilename.$addassign("PrivateHeaders/");
            if (SearchPath != null) {
                SearchPath.clear();
                SearchPath.append((SmallVectorImplChar)HeadersFilename, 0, HeadersFilename.size() - 1);
            }
            HeadersFilename.append(Filename, SlashPos + 1, Filename.size());
            FE = this.FileMgr.getFile(HeadersFilename.$StringRef(), true);
            if (FE == null) {
                return null;
            }
        }
        this.getFileInfo((FileEntry)FE).DirInfo = DirInfo = this.getFileInfo((FileEntry)ContextFileEnt).DirInfo;
        FrameworkName.pop_back();
        if (!this.findUsableModuleForFrameworkHeader(FE, FrameworkName.$StringRef(), RequestingModule, SuggestedModule, false)) {
            return null;
        }
        return FE;
    }

    public FrameworkCacheEntry LookupFrameworkCache(StringRef FWName) {
        return (FrameworkCacheEntry)this.FrameworkMap.$at(FWName);
    }

    public boolean ShouldEnterIncludeFile(Preprocessor PP, FileEntry File, boolean isImport, Module.B M) {
        IdentifierInfo ControllingMacro;
        ++this.NumIncluded;
        HeaderFileInfo FileInfo = this.getFileInfo(File);
        if (isImport) {
            FileInfo.isImport = true;
            if (FileInfo.NumIncludes != '\u0000') {
                return false;
            }
        } else if (FileInfo.isImport) {
            return false;
        }
        if ((ControllingMacro = FileInfo.getControllingMacro(this.ExternalLookup)) != null && (M != null ? PP.isMacroDefinedInLocalModule(ControllingMacro, M) : PP.isMacroDefined(ControllingMacro))) {
            ++this.NumMultiIncludeFileOptzn;
            return false;
        }
        FileInfo.NumIncludes = (char)(FileInfo.NumIncludes + '\u0001');
        return true;
    }

    public SrcMgr.CharacteristicKind getFileDirFlavor(FileEntry File) {
        return SrcMgr.CharacteristicKind.valueOf((int)this.getFileInfo((FileEntry)File).DirInfo);
    }

    public byte $getFileDirFlavor(FileEntry File) {
        return this.getFileInfo((FileEntry)File).DirInfo;
    }

    public void MarkFileIncludeOnce(FileEntry File) {
        HeaderFileInfo FI = this.getFileInfo(File);
        FI.isImport = true;
        FI.isPragmaOnce = true;
    }

    public void MarkFileSystemHeader(FileEntry File) {
        this.getFileInfo((FileEntry)File).DirInfo = 1;
    }

    public void MarkFileModuleHeader(FileEntry FE, int Role, boolean isCompilingModuleHeader) {
        HeaderFileInfo HFI;
        boolean isModularHeader;
        boolean bl = isModularHeader = (Role & 2) == 0;
        if (!isCompilingModuleHeader) {
            if (!isModularHeader) {
                return;
            }
            HFI = this.getExistingFileInfo(FE);
            if (HFI != null && HFI.isModuleHeader) {
                return;
            }
        }
        HFI = this.getFileInfo(FE);
        HFI.isModuleHeader |= isModularHeader;
        HFI.isCompilingModuleHeader |= isCompilingModuleHeader;
    }

    public void IncrementIncludeCount(FileEntry File) {
        this.getFileInfo((FileEntry)File).NumIncludes = (char)(this.getFileInfo((FileEntry)File).NumIncludes + '\u0001');
    }

    public void SetFileControllingMacro(FileEntry File, IdentifierInfo ControllingMacro) {
        this.getFileInfo((FileEntry)File).ControllingMacro = ControllingMacro;
    }

    public boolean FirstTimeLexingFile(FileEntry File) {
        return Unsigned.$ushort2int((char)this.getFileInfo((FileEntry)File).NumIncludes) == 1;
    }

    public boolean isFileMultipleIncludeGuarded(FileEntry File) {
        HeaderFileInfo HFI = this.getExistingFileInfo(File);
        if (HFI != null) {
            return HFI.isPragmaOnce || HFI.isImport || HFI.ControllingMacro != null || HFI.ControllingMacroID != 0;
        }
        return false;
    }

    public HeaderMap CreateHeaderMap(FileEntry FE) {
        HeaderMap HM;
        if (!this.HeaderMaps.empty()) {
            int e = this.HeaderMaps.size();
            for (int i = 0; i != e; ++i) {
                if (((std_pair.pair)this.HeaderMaps.$at((int)i)).first != FE) continue;
                return (HeaderMap)((std_pair.pair)this.HeaderMaps.$at((int)i)).second;
            }
        }
        if ((HM = HeaderMap.Create(FE, this.FileMgr)) != null) {
            this.HeaderMaps.push_back((Object)std.make_pair_Ptr_Ptr((Object)FE, (Object)HM));
            return HM;
        }
        return null;
    }

    public std.string getModuleFileName(Module.B Module2) {
        FileEntry ModuleMap2 = this.getModuleMap().getModuleMapFileForUniquing(Module2);
        return this.getModuleFileName(new StringRef(Module2.Name), new StringRef(ModuleMap2.getName()));
    }

    public std.string getModuleFileName(StringRef ModuleName, StringRef ModuleMapPath) {
        if (this.getModuleCachePath().empty()) {
            return new std.string();
        }
        SmallString Result = new SmallString(this.getModuleCachePath(), 256);
        fs.make_absolute((SmallString)Result);
        if (((HeaderSearchOptions)((Object)this.HSOpts.$arrow())).DisableModuleHash) {
            path.append((SmallString)Result, (Twine)llvm.$add_StringRef_char$ptr$C((StringRef)ModuleName, (String)".pcm"));
        } else {
            DirectoryEntry Dir = this.FileMgr.getDirectory(path.parent_path((StringRef)ModuleMapPath));
            if (Dir == null) {
                return new std.string();
            }
            StringRef DirName = this.FileMgr.getCanonicalName(Dir);
            StringRef FileName = path.filename((StringRef)ModuleMapPath);
            HashingGlobals.hash_code Hash = HashingGlobals.hash_combine((std.string)DirName.lower(), (std.string)FileName.lower());
            SmallString HashStr = new SmallString(128);
            new APInt(JavaDifferentiators.JD$UInt_ULong.INSTANCE, 64, Unsigned.$uint2ulong((int)Hash.$uint())).toStringUnsigned(HashStr, 36);
            path.append((SmallString)Result, (Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_StringRef_char$ptr$C((StringRef)ModuleName, (char.ptr)NativePointer.$MINUS), (Twine)new Twine(HashStr)), (Twine)new Twine(".pcm")));
        }
        return Result.str().str();
    }

    public Module.B lookupModule(StringRef ModuleName) {
        return this.lookupModule(ModuleName, true);
    }

    public Module.B lookupModule(StringRef ModuleName, boolean AllowSearch) {
        Module.B Module2 = this.ModMap.findModule(ModuleName);
        if (Module2 != null || !AllowSearch || !((HeaderSearchOptions)((Object)this.HSOpts.$arrow())).ImplicitModuleMaps) {
            return Module2;
        }
        int N = this.SearchDirs.size();
        for (int Idx = 0; Idx != N; ++Idx) {
            if (((DirectoryLookup)this.SearchDirs.$at(Idx)).isFramework()) {
                boolean IsSystem;
                SmallString FrameworkDirName = new SmallString(128);
                FrameworkDirName.$addassign(((DirectoryLookup)this.SearchDirs.$at(Idx)).getFrameworkDir().getName());
                path.append((SmallString)FrameworkDirName, (Twine)llvm.$add_StringRef_char$ptr$C((StringRef)ModuleName, (String)".framework"));
                DirectoryEntry FrameworkDir = this.FileMgr.getDirectory(FrameworkDirName.$StringRef());
                if (FrameworkDir != null && (Module2 = this.loadFrameworkModule(ModuleName, FrameworkDir, IsSystem = ((DirectoryLookup)this.SearchDirs.$at(Idx)).getDirCharacteristic() != SrcMgr.CharacteristicKind.C_User)) != null) break;
            }
            if (!((DirectoryLookup)this.SearchDirs.$at(Idx)).isNormalDir()) continue;
            boolean IsSystem = ((DirectoryLookup)this.SearchDirs.$at(Idx)).isSystemHeaderDirectory();
            DirectoryEntry dir = ((DirectoryLookup)this.SearchDirs.$at(Idx)).getDir();
            if (this.loadModuleMapFile(dir, IsSystem, false) == LoadModuleMapResult.LMM_NewlyLoaded && (Module2 = this.ModMap.findModule(ModuleName)) != null) break;
            SmallString NestedModuleMapDirName = new SmallString(128);
            NestedModuleMapDirName.$assign(dir.getName(), dir.getNameLen());
            path.append((SmallString)NestedModuleMapDirName, (StringRef)ModuleName);
            if (this.loadModuleMapFile(NestedModuleMapDirName.$StringRef(), IsSystem, false) == LoadModuleMapResult.LMM_NewlyLoaded && (Module2 = this.ModMap.findModule(ModuleName)) != null) break;
            if (((DirectoryLookup)this.SearchDirs.$at(Idx)).haveSearchedAllModuleMaps()) continue;
            this.loadSubdirectoryModuleMaps((DirectoryLookup)this.SearchDirs.$at(Idx));
            Module2 = this.ModMap.findModule(ModuleName);
            if (Module2 != null) break;
        }
        return Module2;
    }

    public FileEntry lookupModuleMapFile(DirectoryEntry Dir, boolean IsFramework) {
        if (!((HeaderSearchOptions)((Object)this.HSOpts.$arrow())).ImplicitModuleMaps) {
            return null;
        }
        SmallString ModuleMapFileName = new SmallString(new StringRef(Dir.getName(), Dir.getNameLen()), 128);
        if (IsFramework) {
            path.append((SmallString)ModuleMapFileName, (Twine)new Twine("Modules"));
        }
        path.append((SmallString)ModuleMapFileName, (Twine)new Twine("module.modulemap"));
        FileEntry F = this.FileMgr.getFile(ModuleMapFileName.$StringRef());
        if (F != null) {
            return F;
        }
        ModuleMapFileName.$assign(Dir.getName(), Dir.getNameLen());
        path.append((SmallString)ModuleMapFileName, (Twine)new Twine("module.map"));
        return this.FileMgr.getFile(ModuleMapFileName.$StringRef());
    }

    public void IncrementFrameworkLookupCount() {
        ++this.NumFrameworkLookups;
    }

    public boolean hasModuleMap(StringRef FileName, DirectoryEntry Root, boolean IsSystem) {
        if (!((HeaderSearchOptions)((Object)this.HSOpts.$arrow())).ImplicitModuleMaps) {
            return false;
        }
        SmallVector FixUpDirectories = new SmallVector(2, (Object)null);
        StringRef DirName = new StringRef(FileName);
        while (true) {
            DirName.$assignMove(path.parent_path((StringRef)DirName));
            if (DirName.empty()) {
                return false;
            }
            DirectoryEntry Dir = this.FileMgr.getDirectory(DirName);
            if (Dir == null) {
                return false;
            }
            switch (this.loadModuleMapFile(Dir, IsSystem, llvm.$eq_StringRef((StringRef)path.extension((StringRef)new StringRef(Dir.getName(), Dir.getNameLen())), (String)".framework"))) {
                case LMM_NewlyLoaded: 
                case LMM_AlreadyLoaded: {
                    int N = FixUpDirectories.size();
                    for (int I = 0; I != N; ++I) {
                        this.DirectoryHasModuleMap.$set((Object)((DirectoryEntry)FixUpDirectories.$at(I)), true);
                    }
                    return true;
                }
            }
            if (Dir == Root) {
                return false;
            }
            FixUpDirectories.push_back((Object)Dir);
        }
    }

    public ModuleMap.KnownHeader findModuleForHeader(FileEntry File) {
        if (this.ExternalSource != null) {
            this.getExistingFileInfo(File);
        }
        return this.ModMap.findModuleForHeader(File);
    }

    public boolean loadModuleMapFile(FileEntry File, boolean IsSystem) {
        DirectoryEntry Dir = null;
        if (this.getHeaderSearchOpts().ModuleMapFileHomeIsCwd) {
            Dir = this.FileMgr.getDirectory(StringRef.R$DOT);
        } else {
            Dir = File.getDir();
            StringRef DirName = new StringRef(Dir.getName(), Dir.getNameLen());
            if (llvm.$eq_StringRef((StringRef)path.filename((StringRef)DirName), (String)"Modules")) {
                DirName.$assignMove(path.parent_path((StringRef)DirName));
                if (DirName.endswith(".framework")) {
                    Dir = this.FileMgr.getDirectory(DirName);
                }
                assert (Dir != null) : "parent must exist";
            }
        }
        switch (this.loadModuleMapFileImpl(File, IsSystem, Dir)) {
            case LMM_NewlyLoaded: 
            case LMM_AlreadyLoaded: {
                return false;
            }
            case LMM_NoDirectory: 
            case LMM_InvalidModuleMap: {
                return true;
            }
        }
        throw new llvm_unreachable("Unknown load module map result");
    }

    public void collectAllModules(SmallVectorImpl<Module.B> Modules) {
        Modules.clear();
        if (((HeaderSearchOptions)((Object)this.HSOpts.$arrow())).ImplicitModuleMaps) {
            int N = this.SearchDirs.size();
            for (int Idx = 0; Idx != N; ++Idx) {
                boolean IsSystem = ((DirectoryLookup)this.SearchDirs.$at(Idx)).isSystemHeaderDirectory();
                if (((DirectoryLookup)this.SearchDirs.$at(Idx)).isFramework()) {
                    std_errors.error_code EC = new std_errors.error_code();
                    SmallString DirNative = new SmallString(128);
                    path.__native((Twine)new Twine(((DirectoryLookup)this.SearchDirs.$at(Idx)).getFrameworkDir().getName()), (SmallString)DirNative);
                    FileSystem FS = this.FileMgr.$getVirtualFileSystem();
                    directory_iterator Dir = FS.dir_begin(new Twine(DirNative), EC);
                    directory_iterator DirEnd = new directory_iterator();
                    while (Dir.$noteq(DirEnd) && !EC.$bool()) {
                        DirectoryEntry FrameworkDir;
                        if (!llvm.$noteq_StringRef((StringRef)path.extension((StringRef)Dir.$arrow().getName()), (String)".framework") && (FrameworkDir = this.FileMgr.getDirectory(Dir.$arrow().getName())) != null) {
                            this.loadFrameworkModule(path.stem((StringRef)Dir.$arrow().getName()), FrameworkDir, IsSystem);
                        }
                        Dir.increment(EC);
                    }
                    continue;
                }
                if (((DirectoryLookup)this.SearchDirs.$at(Idx)).isHeaderMap()) continue;
                this.loadModuleMapFile(((DirectoryLookup)this.SearchDirs.$at(Idx)).getDir(), IsSystem, false);
                this.loadSubdirectoryModuleMaps((DirectoryLookup)this.SearchDirs.$at(Idx));
            }
        }
        StringMapIterator<Module.B> M = this.ModMap.module_begin();
        StringMapIterator<Module.B> MEnd = this.ModMap.module_end();
        while (M.$noteq(MEnd)) {
            Modules.push_back((Object)((Module.B)M.$arrow().getValue()));
            M.$preInc();
        }
    }

    public void loadTopLevelSystemModules() {
        if (!((HeaderSearchOptions)((Object)this.HSOpts.$arrow())).ImplicitModuleMaps) {
            return;
        }
        int N = this.SearchDirs.size();
        for (int Idx = 0; Idx != N; ++Idx) {
            if (!((DirectoryLookup)this.SearchDirs.$at(Idx)).isNormalDir()) continue;
            this.loadModuleMapFile(((DirectoryLookup)this.SearchDirs.$at(Idx)).getDir(), ((DirectoryLookup)this.SearchDirs.$at(Idx)).isSystemHeaderDirectory(), ((DirectoryLookup)this.SearchDirs.$at(Idx)).isFramework());
        }
    }

    Module.B loadFrameworkModule(StringRef Name, DirectoryEntry Dir, boolean IsSystem) {
        Module.B Module2 = this.ModMap.findModule(Name);
        if (Module2 != null) {
            return Module2;
        }
        switch (this.loadModuleMapFile(Dir, IsSystem, true)) {
            case LMM_InvalidModuleMap: {
                if (!((HeaderSearchOptions)((Object)this.HSOpts.$arrow())).ImplicitModuleMaps) break;
                this.ModMap.inferFrameworkModule(Dir, IsSystem, (Module.B)null);
                break;
            }
            case LMM_AlreadyLoaded: 
            case LMM_NoDirectory: {
                return null;
            }
        }
        return this.ModMap.findModule(Name);
    }

    private void loadSubdirectoryModuleMaps(DirectoryLookup SearchDir) {
        assert (((HeaderSearchOptions)((Object)this.HSOpts.$arrow())).ImplicitModuleMaps) : "Should not be loading subdirectory module maps";
        if (SearchDir.haveSearchedAllModuleMaps()) {
            return;
        }
        std_errors.error_code EC = new std_errors.error_code();
        SmallString DirNative = new SmallString(128);
        path.__native((Twine)new Twine(SearchDir.getDir().getName()), (SmallString)DirNative);
        FileSystem FS = this.FileMgr.$getVirtualFileSystem();
        directory_iterator Dir = FS.dir_begin(new Twine(DirNative), EC);
        directory_iterator DirEnd = new directory_iterator();
        while (Dir.$noteq(DirEnd) && !EC.$bool()) {
            boolean IsFramework = llvm.$eq_StringRef((StringRef)path.extension((StringRef)Dir.$arrow().getName()), (String)".framework");
            if (IsFramework == SearchDir.isFramework()) {
                this.loadModuleMapFile(Dir.$arrow().getName(), SearchDir.isSystemHeaderDirectory(), SearchDir.isFramework());
            }
            Dir.increment(EC);
        }
        SearchDir.setSearchedAllModuleMaps(true);
    }

    boolean findUsableModuleForHeader(FileEntry File, DirectoryEntry Root, Module.B RequestingModule, ModuleMap.KnownHeader SuggestedModule, boolean IsSystemHeaderDir) {
        if (File != null && SuggestedModule != null) {
            this.hasModuleMap(new StringRef(File.getName()), Root, IsSystemHeaderDir);
            SuggestedModule.$assignMove(this.findModuleForHeader(File));
        }
        return true;
    }

    boolean findUsableModuleForFrameworkHeader(FileEntry File, StringRef FrameworkName, Module.B RequestingModule, ModuleMap.KnownHeader SuggestedModule, boolean IsSystemFramework) {
        if (SuggestedModule != null) {
            SmallVector SubmodulePath = new SmallVector(4, (Object)new std.string());
            DirectoryEntry TopFrameworkDir = HeaderSearchStatics.getTopFrameworkDir(this.FileMgr, new StringRef(FrameworkName), (SmallVectorImpl<std.string>)SubmodulePath);
            StringRef ModuleName = path.stem((StringRef)new StringRef(TopFrameworkDir.getName()));
            this.loadFrameworkModule(ModuleName, TopFrameworkDir, IsSystemFramework);
            SuggestedModule.$assignMove(this.findModuleForHeader(File));
        }
        return true;
    }

    FileEntry getFileAndSuggestModule(StringRef FileName, SourceLocation IncludeLoc, DirectoryEntry Dir, boolean IsSystemHeaderDir, Module.B RequestingModule, ModuleMap.KnownHeader SuggestedModule) {
        FileEntry File = this.getFileMgr().getFile(new StringRef(FileName), true);
        if (File == null) {
            return null;
        }
        if (!this.findUsableModuleForHeader(File, Dir != null ? Dir : File.getDir(), RequestingModule, SuggestedModule, IsSystemHeaderDir)) {
            return null;
        }
        return File;
    }

    public ModuleMap getModuleMap() {
        return this.ModMap;
    }

    public ModuleMap getModuleMap$Const() {
        return this.ModMap;
    }

    public int header_file_size() {
        return this.FileInfo.size();
    }

    public HeaderFileInfo getFileInfo(FileEntry FE) {
        if (Unsigned.$greatereq_uint((int)FE.getUID(), (int)this.FileInfo.size())) {
            this.FileInfo.resize(FE.getUID() + 1);
        }
        HeaderFileInfo HFI = (HeaderFileInfo)Native.$AddrOf((Object)this.FileInfo.$at(FE.getUID()));
        if (this.ExternalSource != null && !HFI.Resolved) {
            HFI.Resolved = true;
            HeaderFileInfo ExternalHFI = this.ExternalSource.GetHeaderFileInfo(FE);
            HFI = (HeaderFileInfo)Native.$AddrOf((Object)this.FileInfo.$at(FE.getUID()));
            if (ExternalHFI.External) {
                HeaderSearchStatics.mergeHeaderFileInfo((HeaderFileInfo)Native.$Deref((Object)HFI), ExternalHFI);
            }
        }
        HFI.IsValid = true;
        HFI.External = false;
        return (HeaderFileInfo)Native.$Deref((Object)HFI);
    }

    public HeaderFileInfo getExistingFileInfo(FileEntry FE) {
        return this.getExistingFileInfo(FE, true);
    }

    public HeaderFileInfo getExistingFileInfo(FileEntry FE, boolean WantExternal) {
        HeaderFileInfo HFI;
        if (this.ExternalSource != null) {
            if (Unsigned.$greatereq_uint((int)FE.getUID(), (int)this.FileInfo.size())) {
                if (!WantExternal) {
                    return null;
                }
                this.FileInfo.resize(FE.getUID() + 1);
            }
            HFI = (HeaderFileInfo)Native.$AddrOf((Object)this.FileInfo.$at(FE.getUID()));
            if (!(WantExternal || HFI.IsValid && !HFI.External)) {
                return null;
            }
            if (!HFI.Resolved) {
                HFI.Resolved = true;
                HeaderFileInfo ExternalHFI = this.ExternalSource.GetHeaderFileInfo(FE);
                HFI = (HeaderFileInfo)Native.$AddrOf((Object)this.FileInfo.$at(FE.getUID()));
                if (ExternalHFI.External) {
                    HeaderSearchStatics.mergeHeaderFileInfo((HeaderFileInfo)Native.$Deref((Object)HFI), ExternalHFI);
                }
            }
        } else {
            if (Unsigned.$greatereq_uint((int)FE.getUID(), (int)this.FileInfo.size())) {
                return null;
            }
            HFI = (HeaderFileInfo)Native.$AddrOf((Object)this.FileInfo.$at(FE.getUID()));
        }
        if (!HFI.IsValid || HFI.External && !WantExternal) {
            return null;
        }
        return HFI;
    }

    public StdVector.iterator<DirectoryLookup> search_dir_begin() {
        return this.SearchDirs.begin();
    }

    public StdVector.iterator<DirectoryLookup> search_dir_end() {
        return this.SearchDirs.end();
    }

    std.vector<DirectoryLookup> $SearchDirs() {
        return this.SearchDirs;
    }

    public int search_dir_size() {
        return this.SearchDirs.size();
    }

    public StdVector.iterator<DirectoryLookup> quoted_dir_begin() {
        return this.SearchDirs.begin();
    }

    public StdVector.iterator<DirectoryLookup> quoted_dir_end() {
        return this.SearchDirs.begin().$add(this.AngledDirIdx);
    }

    public StdVector.iterator<DirectoryLookup> angled_dir_begin() {
        return this.SearchDirs.begin().$add(this.AngledDirIdx);
    }

    public StdVector.iterator<DirectoryLookup> angled_dir_end() {
        return this.SearchDirs.begin().$add(this.SystemDirIdx);
    }

    public StdVector.iterator<DirectoryLookup> system_dir_begin() {
        return this.SearchDirs.begin().$add(this.SystemDirIdx);
    }

    public StdVector.iterator<DirectoryLookup> system_dir_end() {
        return this.SearchDirs.end();
    }

    public StringRef getUniqueFrameworkName(StringRef Framework) {
        return ((StringMapIteratorChar)this.FrameworkNames.insert((StringRef)Framework).first).$arrow().first();
    }

    public std.string suggestPathToFileForDiagnostics(FileEntry File) {
        return this.suggestPathToFileForDiagnostics(File, null);
    }

    public std.string suggestPathToFileForDiagnostics(FileEntry File, bool.ptr IsSystem) {
        char.ptr Name = Native.$tryClone((char.ptr)File.getName());
        int BestPrefixLength = 0;
        int BestSearchDir = 0;
        block0: for (int I = 0; I != this.SearchDirs.size(); ++I) {
            if (!((DirectoryLookup)this.SearchDirs.$at(I)).isNormalDir()) continue;
            char.ptr Dir = Native.$tryClone((char.ptr)((DirectoryLookup)this.SearchDirs.$at(I)).getDir().getName());
            path.const_iterator NI = path.begin((StringRef)new StringRef(Name));
            path.const_iterator NE = path.end((StringRef)new StringRef(Name));
            path.const_iterator DI = path.begin((StringRef)new StringRef(Dir));
            path.const_iterator DE = path.end((StringRef)new StringRef(Dir));
            while (true) {
                if (NI.$noteq((Object)NE) && llvm.$eq_StringRef((StringRef)NI.$star(), (String)".")) {
                    NI.$preInc();
                    continue;
                }
                if (NI.$eq((Object)NE)) continue block0;
                while (DI.$noteq((Object)DE) && llvm.$eq_StringRef((StringRef)DI.$star(), (String)".")) {
                    DI.$preInc();
                }
                if (DI.$eq((Object)DE)) {
                    int PrefixLength = NI.$sub(path.begin((StringRef)new StringRef(Name)));
                    if (!Unsigned.$greater_uint((int)PrefixLength, (int)BestPrefixLength)) continue block0;
                    BestPrefixLength = PrefixLength;
                    BestSearchDir = I;
                    continue block0;
                }
                if (llvm.$noteq_StringRef((StringRef)NI.$star(), (StringRef)DI.$star())) continue block0;
                NI.$preInc();
                DI.$preInc();
            }
        }
        if (IsSystem != null) {
            IsSystem.$set(BestPrefixLength != 0 ? Unsigned.$greatereq_uint((int)BestSearchDir, (int)this.SystemDirIdx) : false);
        }
        return new std.string((char.ptr)Name.$add(BestPrefixLength));
    }

    public void PrintStats() {
        this.PrintStats(llvm.errs());
    }

    public void PrintStats(raw_ostream OS) {
        OS.$out(String.format("\n*** HeaderSearch Stats:\n", new Object[0]));
        OS.$out(String.format("%d files tracked.\n", this.FileInfo.size()));
        int NumOnceOnlyFiles = 0;
        int MaxNumIncludes = 0;
        int NumSingleIncludedFiles = 0;
        int e = this.FileInfo.size();
        for (int i = 0; i != e; ++i) {
            NumOnceOnlyFiles += this.FileInfo.$at((int)i).isImport ? 1 : 0;
            if (Unsigned.$less_uint_ushort((int)MaxNumIncludes, (char)this.FileInfo.$at((int)i).NumIncludes)) {
                MaxNumIncludes = Unsigned.$ushort2uint((char)this.FileInfo.$at((int)i).NumIncludes);
            }
            NumSingleIncludedFiles += Unsigned.$ushort2int((char)this.FileInfo.$at((int)i).NumIncludes) == 1 ? 1 : 0;
        }
        OS.$out(String.format("  %d #import/#pragma once files.\n", NumOnceOnlyFiles));
        OS.$out(String.format("  %d included exactly once.\n", NumSingleIncludedFiles));
        OS.$out(String.format("  %d max times a file is included.\n", MaxNumIncludes));
        OS.$out(String.format("  %d #include/#include_next/#import.\n", this.NumIncluded));
        OS.$out(String.format("    %d #includes skipped due to the multi-include optimization.\n", this.NumMultiIncludeFileOptzn));
        OS.$out(String.format("%d framework lookups.\n", this.NumFrameworkLookups));
        OS.$out(String.format("%d subframework lookups.\n", this.NumSubFrameworkLookups));
    }

    public int getTotalMemory() {
        return this.SearchDirs.capacity() + llvm.capacity_in_bytes((NativeType.SizeofCapable)this.FileInfo) + llvm.capacity_in_bytes(this.HeaderMaps) + Unsigned.$ulong2uint((long)this.LookupFileCache.getAllocator().getTotalMemory()) + Unsigned.$ulong2uint((long)this.FrameworkMap.getAllocator().getTotalMemory());
    }

    private LoadModuleMapResult loadModuleMapFileImpl(FileEntry File, boolean IsSystem, DirectoryEntry Dir) {
        assert (File != null) : "expected FileEntry";
        std_pair.pairTypeBool AddResult = this.LoadedModuleMaps.insert((std_pair.pairTypeBool)std.make_pair_Ptr_bool((Object)File, (boolean)true));
        if (!AddResult.second) {
            return ((DenseMapIteratorTypeBool)AddResult.first).$arrow().second ? LoadModuleMapResult.LMM_AlreadyLoaded : LoadModuleMapResult.LMM_InvalidModuleMap;
        }
        if (this.ModMap.parseModuleMapFile(File, IsSystem, Dir)) {
            this.LoadedModuleMaps.$set((Object)File, false);
            return LoadModuleMapResult.LMM_InvalidModuleMap;
        }
        FileEntry PMMFile = HeaderSearchStatics.getPrivateModuleMap(File, this.FileMgr);
        if (PMMFile != null && this.ModMap.parseModuleMapFile(PMMFile, IsSystem, Dir)) {
            this.LoadedModuleMaps.$set((Object)File, false);
            return LoadModuleMapResult.LMM_InvalidModuleMap;
        }
        return LoadModuleMapResult.LMM_NewlyLoaded;
    }

    private LoadModuleMapResult loadModuleMapFile(StringRef DirName, boolean IsSystem, boolean IsFramework) {
        DirectoryEntry Dir = this.FileMgr.getDirectory(DirName);
        if (Dir != null) {
            return this.loadModuleMapFile(Dir, IsSystem, IsFramework);
        }
        return LoadModuleMapResult.LMM_NoDirectory;
    }

    private LoadModuleMapResult loadModuleMapFile(DirectoryEntry Dir, boolean IsSystem, boolean IsFramework) {
        DenseMapIteratorTypeBool KnownDir = this.DirectoryHasModuleMap.find((Object)Dir);
        if (KnownDir.$noteq(this.DirectoryHasModuleMap.end())) {
            return KnownDir.$arrow().second ? LoadModuleMapResult.LMM_AlreadyLoaded : LoadModuleMapResult.LMM_InvalidModuleMap;
        }
        FileEntry ModuleMapFile = this.lookupModuleMapFile(Dir, IsFramework);
        if (ModuleMapFile != null) {
            LoadModuleMapResult Result = this.loadModuleMapFileImpl(ModuleMapFile, IsSystem, Dir);
            if (Result == LoadModuleMapResult.LMM_NewlyLoaded) {
                this.DirectoryHasModuleMap.$set((Object)Dir, true);
            } else if (Result == LoadModuleMapResult.LMM_InvalidModuleMap) {
                this.DirectoryHasModuleMap.$set((Object)Dir, false);
            }
            return Result;
        }
        return LoadModuleMapResult.LMM_InvalidModuleMap;
    }

    public String toString() {
        return "HSOpts=" + this.HSOpts + ", SearchDirs=" + this.SearchDirs + ", AngledDirIdx=" + this.AngledDirIdx + ", SystemDirIdx=" + this.SystemDirIdx + ", NoCurDirSearch=" + this.NoCurDirSearch + ", SystemHeaderPrefixes=" + this.SystemHeaderPrefixes + ", ModuleCachePath=" + this.ModuleCachePath + ", FileInfo=" + this.FileInfo + ", LookupFileCache=" + this.LookupFileCache + ", FrameworkMap=" + this.FrameworkMap + ", IncludeAliases=" + this.IncludeAliases + ", HeaderMaps=" + this.HeaderMaps + ", ModMap=" + this.ModMap + ", DirectoryHasModuleMap=" + this.DirectoryHasModuleMap + ", LoadedModuleMaps=" + this.LoadedModuleMaps + ", FrameworkNames=" + this.FrameworkNames + ", ExternalLookup=" + this.ExternalLookup + ", ExternalSource=" + this.ExternalSource + ", NumIncluded=" + this.NumIncluded + ", NumMultiIncludeFileOptzn=" + this.NumMultiIncludeFileOptzn + ", NumFrameworkLookups=" + this.NumFrameworkLookups + ", NumSubFrameworkLookups=" + this.NumSubFrameworkLookups;
    }

    private SmallString $getLookupFileTmpDir() {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.$LookupFileTmpDirInUse) break block3;
                this.$LookupFileTmpDirInUse = true;
                if (true) break block2;
            }
            throw new AssertionError();
        }
        return this.$LookupFileTmpDir;
    }

    private void $releaseLookupFileTmpDir(SmallString buf) {
        assert (this.$LookupFileTmpDirInUse);
        if (!$assertionsDisabled) {
            this.$LookupFileTmpDirInUse = false;
            if (!false) {
                // empty if block
            }
        }
        assert (buf == this.$LookupFileTmpDir);
        this.$LookupFileTmpDir.clear();
    }

    private SmallString $getLookupFileMappedName() {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.$LookupFileMappedNameInUse) break block3;
                this.$LookupFileMappedNameInUse = true;
                if (true) break block2;
            }
            throw new AssertionError();
        }
        return this.$LookupFileMappedName;
    }

    private void $releaseLookupFileMappedName(SmallString buf) {
        assert (this.$LookupFileMappedNameInUse);
        if (!$assertionsDisabled) {
            this.$LookupFileMappedNameInUse = false;
            if (!false) {
                // empty if block
            }
        }
        assert (buf == this.$LookupFileMappedName);
        this.$LookupFileMappedName.clear();
    }

    private bool.ref $getInUserSpecifiedSystemFramework(boolean val) {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.$InUserSpecifiedSystemFrameworkInUse) break block3;
                this.$InUserSpecifiedSystemFrameworkInUse = true;
                if (true) break block2;
            }
            throw new AssertionError();
        }
        this.$InUserSpecifiedSystemFramework.$set(val);
        return this.$InUserSpecifiedSystemFramework;
    }

    private boolean $releaseInUserSpecifiedSystemFramework(bool.ref buf) {
        assert (this.$InUserSpecifiedSystemFrameworkInUse);
        if (!$assertionsDisabled) {
            this.$InUserSpecifiedSystemFrameworkInUse = false;
            if (!false) {
                // empty if block
            }
        }
        assert (buf == this.$InUserSpecifiedSystemFramework);
        return this.$InUserSpecifiedSystemFramework.$deref();
    }

    private bool.ref $getHasBeenMapped(boolean val) {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.$HasBeenMappedInUse) break block3;
                this.$HasBeenMappedInUse = true;
                if (true) break block2;
            }
            throw new AssertionError();
        }
        this.$HasBeenMapped.$set(val);
        return this.$HasBeenMapped;
    }

    private boolean $releaseHasBeenMapped(bool.ref buf) {
        assert (this.$HasBeenMappedInUse);
        if (!$assertionsDisabled) {
            this.$HasBeenMappedInUse = false;
            if (!false) {
                // empty if block
            }
        }
        assert (buf == this.$HasBeenMapped);
        return this.$HasBeenMapped.$deref();
    }

    private static final class LoadModuleMapResult
    extends Enum<LoadModuleMapResult>
    implements Native.ComparableLower {
        public static final /* enum */ LoadModuleMapResult LMM_AlreadyLoaded = new LoadModuleMapResult(0);
        public static final /* enum */ LoadModuleMapResult LMM_NewlyLoaded = new LoadModuleMapResult(LMM_AlreadyLoaded.getValue() + 1);
        public static final /* enum */ LoadModuleMapResult LMM_NoDirectory = new LoadModuleMapResult(LMM_NewlyLoaded.getValue() + 1);
        public static final /* enum */ LoadModuleMapResult LMM_InvalidModuleMap = new LoadModuleMapResult(LMM_NoDirectory.getValue() + 1);
        private final int value;
        private static final /* synthetic */ LoadModuleMapResult[] $VALUES;

        public static LoadModuleMapResult[] values() {
            return (LoadModuleMapResult[])$VALUES.clone();
        }

        public static LoadModuleMapResult valueOf(String name) {
            return Enum.valueOf(LoadModuleMapResult.class, name);
        }

        public static LoadModuleMapResult valueOf(int val) {
            LoadModuleMapResult out;
            LoadModuleMapResult loadModuleMapResult = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private LoadModuleMapResult(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((LoadModuleMapResult)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((LoadModuleMapResult)((Object)obj)).value);
        }

        static {
            $VALUES = new LoadModuleMapResult[]{LMM_AlreadyLoaded, LMM_NewlyLoaded, LMM_NoDirectory, LMM_InvalidModuleMap};
        }

        private static final class Values {
            private static final LoadModuleMapResult[] VALUES;
            private static final LoadModuleMapResult[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (LoadModuleMapResult kind : LoadModuleMapResult.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new LoadModuleMapResult[min < 0 ? 1 - min : 0];
                VALUES = new LoadModuleMapResult[max >= 0 ? 1 + max : 0];
                for (LoadModuleMapResult kind : LoadModuleMapResult.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((LoadModuleMapResult)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((LoadModuleMapResult)kind).value] = kind;
                }
            }
        }
    }

    private static class LookupFileCacheInfo
    implements NativeCloneable<LookupFileCacheInfo> {
        public int StartIdx;
        public int HitIdx;
        public char.ptr MappedName;

        public LookupFileCacheInfo() {
            this.StartIdx = 0;
            this.HitIdx = 0;
            this.MappedName = null;
        }

        public void reset(int StartIdx) {
            this.StartIdx = StartIdx;
            this.MappedName = null;
        }

        public LookupFileCacheInfo(LookupFileCacheInfo $Prm0) {
            this.StartIdx = $Prm0.StartIdx;
            this.HitIdx = $Prm0.HitIdx;
            this.MappedName = Native.$tryClone((char.ptr)$Prm0.MappedName);
        }

        public LookupFileCacheInfo(JavaDifferentiators.JD$Move _dparam, LookupFileCacheInfo $Prm0) {
            this.StartIdx = $Prm0.StartIdx;
            this.HitIdx = $Prm0.HitIdx;
            this.MappedName = Native.$tryClone((char.ptr)$Prm0.MappedName);
        }

        public LookupFileCacheInfo clone() {
            return new LookupFileCacheInfo(this);
        }

        public String toString() {
            return "StartIdx=" + this.StartIdx + ", HitIdx=" + this.HitIdx + ", MappedName=" + this.MappedName;
        }
    }

    static class FrameworkCacheEntry
    implements NativeCloneable<FrameworkCacheEntry> {
        public DirectoryEntry Directory;
        public boolean IsUserSpecifiedSystemFramework;

        public FrameworkCacheEntry() {
            this.Directory = null;
            this.IsUserSpecifiedSystemFramework = false;
        }

        public FrameworkCacheEntry(FrameworkCacheEntry $Prm0) {
            this.Directory = $Prm0.Directory;
            this.IsUserSpecifiedSystemFramework = $Prm0.IsUserSpecifiedSystemFramework;
        }

        public FrameworkCacheEntry(JavaDifferentiators.JD$Move _dparam, FrameworkCacheEntry $Prm0) {
            this.Directory = $Prm0.Directory;
            this.IsUserSpecifiedSystemFramework = $Prm0.IsUserSpecifiedSystemFramework;
        }

        public FrameworkCacheEntry $assign(FrameworkCacheEntry $Prm0) {
            this.Directory = $Prm0.Directory;
            this.IsUserSpecifiedSystemFramework = $Prm0.IsUserSpecifiedSystemFramework;
            return this;
        }

        public FrameworkCacheEntry clone() {
            return new FrameworkCacheEntry(this);
        }

        public String toString() {
            return "Directory=" + this.Directory + ", IsUserSpecifiedSystemFramework=" + this.IsUserSpecifiedSystemFramework;
        }
    }
}

