/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.jediterm.core.compatibility.Point;
import com.jediterm.core.util.CellPosition;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.ChangeWidthOperation;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.LinesBuffer;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalHistoryBufferListener;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalModelListener;
import com.jediterm.terminal.model.TerminalResizeResult;
import com.jediterm.terminal.model.TerminalSelection;
import com.jediterm.terminal.model.hyperlinks.TextProcessing;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalTextBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(TerminalTextBuffer.class);
    private static final Boolean USE_CONPTY_COMPATIBLE_RESIZE = true;
    @NotNull
    private final StyleState myStyleState;
    private LinesBuffer myHistoryBuffer;
    private LinesBuffer myScreenBuffer;
    private int myWidth;
    private int myHeight;
    private final int myHistoryLinesCount;
    private final Lock myLock = new ReentrantLock();
    private LinesBuffer myHistoryBufferBackup;
    private LinesBuffer myScreenBufferBackup;
    private boolean myAlternateBuffer = false;
    private boolean myUsingAlternateBuffer = false;
    private final List<TerminalModelListener> myListeners = new CopyOnWriteArrayList<TerminalModelListener>();
    private final List<TerminalModelListener> myTypeAheadListeners = new CopyOnWriteArrayList<TerminalModelListener>();
    private final List<TerminalHistoryBufferListener> myHistoryBufferListeners = new CopyOnWriteArrayList<TerminalHistoryBufferListener>();
    @Nullable
    private final TextProcessing myTextProcessing;

    public TerminalTextBuffer(int width, int height, @NotNull StyleState styleState) {
        this(width, height, styleState, null);
    }

    public TerminalTextBuffer(int width, int height, @NotNull StyleState styleState, @Nullable TextProcessing textProcessing) {
        this(width, height, styleState, 5000, textProcessing);
    }

    public TerminalTextBuffer(int width, int height, @NotNull StyleState styleState, int historyLinesCount, @Nullable TextProcessing textProcessing) {
        this.myStyleState = styleState;
        this.myWidth = width;
        this.myHeight = height;
        this.myHistoryLinesCount = historyLinesCount;
        this.myTextProcessing = textProcessing;
        this.myScreenBuffer = this.createScreenBuffer();
        this.myHistoryBuffer = this.createHistoryBuffer();
    }

    @NotNull
    private LinesBuffer createScreenBuffer() {
        return new LinesBuffer(-1, this.myTextProcessing);
    }

    @NotNull
    private LinesBuffer createHistoryBuffer() {
        return new LinesBuffer(this.myHistoryLinesCount, this.myTextProcessing);
    }

    @NotNull
    TerminalResizeResult resize(@NotNull TermSize newTermSize, @NotNull CellPosition oldCursor, @Nullable TerminalSelection selection) {
        int oldHeight;
        int newWidth = newTermSize.getColumns();
        int newHeight = newTermSize.getRows();
        int newCursorX = oldCursor.getX();
        int newCursorY = oldCursor.getY();
        int oldCursorY = oldCursor.getY();
        if (this.myWidth != newWidth) {
            ChangeWidthOperation changeWidthOperation = new ChangeWidthOperation(this, newWidth, newHeight);
            Point cursorPoint = new Point(oldCursor.getX() - 1, oldCursor.getY() - 1);
            changeWidthOperation.addPointToTrack(cursorPoint, true);
            if (selection != null) {
                changeWidthOperation.addPointToTrack(selection.getStart(), false);
                changeWidthOperation.addPointToTrack(selection.getEnd(), false);
            }
            changeWidthOperation.run();
            this.myWidth = newWidth;
            this.myHeight = newHeight;
            Point newCursor = changeWidthOperation.getTrackedPoint(cursorPoint);
            newCursorX = newCursor.x + 1;
            newCursorY = newCursor.y + 1;
            if (selection != null) {
                selection.getStart().setLocation(changeWidthOperation.getTrackedPoint(selection.getStart()));
                selection.getEnd().setLocation(changeWidthOperation.getTrackedPoint(selection.getEnd()));
            }
        }
        if (newHeight < (oldHeight = this.myHeight)) {
            if (!this.myAlternateBuffer) {
                int lineDiffCount = oldHeight - newHeight;
                int maxBottomLinesToRemove = Math.min(lineDiffCount, Math.max(0, oldHeight - oldCursorY));
                int emptyLinesDeleted = this.myScreenBuffer.removeBottomEmptyLines(oldHeight - 1, maxBottomLinesToRemove);
                int screenLinesToMove = lineDiffCount - emptyLinesDeleted;
                this.myScreenBuffer.moveTopLinesTo(screenLinesToMove, this.myHistoryBuffer);
                newCursorY = oldCursorY - screenLinesToMove;
                if (selection != null) {
                    selection.shiftY(-screenLinesToMove);
                }
            } else {
                newCursorY = oldCursorY;
            }
        } else if (newHeight > oldHeight) {
            if (USE_CONPTY_COMPATIBLE_RESIZE.booleanValue()) {
                newCursorY = oldCursorY;
            } else if (!this.myAlternateBuffer) {
                int historyLinesCount = Math.min(newHeight - oldHeight, this.myHistoryBuffer.getLineCount());
                this.myHistoryBuffer.moveBottomLinesTo(historyLinesCount, this.myScreenBuffer);
                newCursorY = oldCursorY + historyLinesCount;
                if (selection != null) {
                    selection.shiftY(historyLinesCount);
                }
            } else {
                newCursorY = oldCursorY;
            }
        }
        this.myWidth = newWidth;
        this.myHeight = newHeight;
        this.fireModelChangeEvent();
        return new TerminalResizeResult(new CellPosition(newCursorX, newCursorY));
    }

    public void addModelListener(TerminalModelListener listener) {
        this.myListeners.add(listener);
    }

    public void removeModelListener(TerminalModelListener listener) {
        this.myListeners.remove(listener);
    }

    public void addHistoryBufferListener(@NotNull TerminalHistoryBufferListener listener) {
        this.myHistoryBufferListeners.add(listener);
    }

    public void removeHistoryBufferListener(@NotNull TerminalHistoryBufferListener listener) {
        this.myHistoryBufferListeners.remove(listener);
    }

    public void addTypeAheadModelListener(TerminalModelListener listener) {
        this.myTypeAheadListeners.add(listener);
    }

    public void removeTypeAheadModelListener(TerminalModelListener listener) {
        this.myTypeAheadListeners.remove(listener);
    }

    void fireModelChangeEvent() {
        for (TerminalModelListener modelListener : this.myListeners) {
            modelListener.modelChanged();
        }
    }

    void fireTypeAheadModelChangeEvent() {
        for (TerminalModelListener modelListener : this.myTypeAheadListeners) {
            modelListener.modelChanged();
        }
    }

    private TextStyle createEmptyStyleWithCurrentColor() {
        return this.myStyleState.getCurrent().createEmptyWithColors();
    }

    private TerminalLine.TextEntry createFillerEntry() {
        return new TerminalLine.TextEntry(this.createEmptyStyleWithCurrentColor(), new CharBuffer('\u0000', this.myWidth));
    }

    public void deleteCharacters(int x, int y, int count) {
        if (y > this.myHeight - 1 || y < 0) {
            LOG.error("attempt to delete in line " + y + "\nargs were x:" + x + " count:" + count);
        } else if (count < 0) {
            LOG.error("Attempt to delete negative chars number: count:" + count);
        } else if (count > 0) {
            this.myScreenBuffer.deleteCharacters(x, y, count, this.createEmptyStyleWithCurrentColor());
            this.fireModelChangeEvent();
        }
    }

    public void insertBlankCharacters(int x, int y, int count) {
        if (y > this.myHeight - 1 || y < 0) {
            LOG.error("attempt to insert blank chars in line " + y + "\nargs were x:" + x + " count:" + count);
        } else if (count < 0) {
            LOG.error("Attempt to insert negative blank chars number: count:" + count);
        } else if (count > 0) {
            this.myScreenBuffer.insertBlankCharacters(x, y, count, this.myWidth, this.createEmptyStyleWithCurrentColor());
            this.fireModelChangeEvent();
        }
    }

    public void writeString(int x, int y, @NotNull CharBuffer str) {
        this.writeString(x, y, str, this.myStyleState.getCurrent());
    }

    public void addLine(@NotNull TerminalLine line) {
        this.myScreenBuffer.addLines(List.of(line));
        this.fireModelChangeEvent();
    }

    private void writeString(int x, int y, @NotNull CharBuffer str, @NotNull TextStyle style) {
        this.myScreenBuffer.writeString(x, y - 1, str, style);
        this.fireModelChangeEvent();
    }

    public void scrollArea(int scrollRegionTop, int dy, int scrollRegionBottom) {
        if (dy == 0) {
            return;
        }
        if (dy > 0) {
            this.insertLines(scrollRegionTop - 1, dy, scrollRegionBottom);
        } else {
            LinesBuffer removed = this.deleteLines(scrollRegionTop - 1, -dy, scrollRegionBottom);
            if (scrollRegionTop == 1) {
                removed.moveTopLinesTo(removed.getLineCount(), this.myHistoryBuffer);
            }
            this.fireModelChangeEvent();
        }
    }

    @NotNull
    public TerminalLine getLine(int index) {
        if (index >= 0) {
            if (index >= this.getHeight()) {
                LOG.error("Attempt to get line out of bounds: " + index + " >= " + this.getHeight());
                return TerminalLine.createEmpty();
            }
            return this.myScreenBuffer.getLine(index);
        }
        if (index < -this.getHistoryLinesCount()) {
            LOG.error("Attempt to get line out of bounds: " + index + " < " + -this.getHistoryLinesCount());
            return TerminalLine.createEmpty();
        }
        return this.myHistoryBuffer.getLine(this.getHistoryLinesCount() + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScreenLines() {
        this.myLock.lock();
        try {
            StringBuilder sb = new StringBuilder();
            for (int row = 0; row < this.myHeight; ++row) {
                StringBuilder line = new StringBuilder(this.myScreenBuffer.getLine(row).getText());
                for (int i = line.length(); i < this.myWidth; ++i) {
                    line.append(' ');
                }
                if (line.length() > this.myWidth) {
                    line.setLength(this.myWidth);
                }
                sb.append((CharSequence)line);
                sb.append('\n');
            }
            String string = sb.toString();
            return string;
        }
        finally {
            this.myLock.unlock();
        }
    }

    public void processScreenLines(int yStart, int yCount, @NotNull StyledTextConsumer consumer) {
        this.myScreenBuffer.processLines(yStart, yCount, consumer);
    }

    public void lock() {
        this.myLock.lock();
    }

    public void unlock() {
        this.myLock.unlock();
    }

    public void modify(@NotNull Runnable runnable) {
        this.myLock.lock();
        try {
            runnable.run();
        }
        finally {
            this.myLock.unlock();
        }
    }

    public boolean tryLock() {
        return this.myLock.tryLock();
    }

    public int getWidth() {
        return this.myWidth;
    }

    public int getHeight() {
        return this.myHeight;
    }

    public int getHistoryLinesCount() {
        return this.myHistoryBuffer.getLineCount();
    }

    public int getScreenLinesCount() {
        return this.myScreenBuffer.getLineCount();
    }

    public char getBuffersCharAt(int x, int y) {
        return this.getLine(y).charAt(x);
    }

    public TextStyle getStyleAt(int x, int y) {
        return this.getLine(y).getStyleAt(x);
    }

    @NotNull
    public Pair<Character, TextStyle> getStyledCharAt(int x, int y) {
        TerminalLine line = this.getLine(y);
        return new Pair((Object)Character.valueOf(line.charAt(x)), (Object)line.getStyleAt(x));
    }

    public char getCharAt(int x, int y) {
        return this.getLine(y).charAt(x);
    }

    public boolean isUsingAlternateBuffer() {
        return this.myUsingAlternateBuffer;
    }

    public void useAlternateBuffer(boolean enabled) {
        this.myAlternateBuffer = enabled;
        if (enabled) {
            if (!this.myUsingAlternateBuffer) {
                this.myScreenBufferBackup = this.myScreenBuffer;
                this.myHistoryBufferBackup = this.myHistoryBuffer;
                this.myScreenBuffer = this.createScreenBuffer();
                this.myHistoryBuffer = this.createHistoryBuffer();
                this.myUsingAlternateBuffer = true;
            }
        } else if (this.myUsingAlternateBuffer) {
            this.myScreenBuffer = this.myScreenBufferBackup;
            this.myHistoryBuffer = this.myHistoryBufferBackup;
            this.myScreenBufferBackup = this.createScreenBuffer();
            this.myHistoryBufferBackup = this.createHistoryBuffer();
            this.myUsingAlternateBuffer = false;
        }
        this.fireModelChangeEvent();
    }

    public LinesBuffer getHistoryBuffer() {
        return this.myHistoryBuffer;
    }

    @NotNull
    public LinesBuffer getScreenBuffer() {
        return this.myScreenBuffer;
    }

    public void insertLines(int y, int count, int scrollRegionBottom) {
        this.myScreenBuffer.insertLines(y, count, scrollRegionBottom - 1, this.createFillerEntry());
        this.fireModelChangeEvent();
    }

    public LinesBuffer deleteLines(int y, int count, int scrollRegionBottom) {
        LinesBuffer linesBuffer = this.myScreenBuffer.deleteLines(y, count, scrollRegionBottom - 1, this.createFillerEntry());
        this.fireModelChangeEvent();
        return linesBuffer;
    }

    public void clearLines(int startRow, int endRow) {
        this.myScreenBuffer.clearLines(startRow, endRow, this.createFillerEntry());
        this.fireModelChangeEvent();
    }

    public void eraseCharacters(int leftX, int rightX, int y) {
        TextStyle style = this.createEmptyStyleWithCurrentColor();
        if (y >= 0) {
            this.myScreenBuffer.clearArea(leftX, y, rightX, y + 1, style);
            this.fireModelChangeEvent();
            if (this.myTextProcessing != null && y < this.getHeight()) {
                this.myTextProcessing.processHyperlinks(this.myScreenBuffer, this.getLine(y));
            }
        } else {
            LOG.error("Attempt to erase characters in line: " + y);
        }
    }

    public void clearScreenAndHistoryBuffers() {
        this.myScreenBuffer.clearAll();
        this.myHistoryBuffer.clearAll();
        this.fireModelChangeEvent();
    }

    public void clearScreenBuffer() {
        this.myScreenBuffer.clearAll();
        this.fireModelChangeEvent();
    }

    @Deprecated
    public void clearAll() {
        this.myScreenBuffer.clearAll();
        this.fireModelChangeEvent();
    }

    public void processHistoryAndScreenLines(int scrollOrigin, int maximalLinesToProcess, StyledTextConsumer consumer) {
        if (maximalLinesToProcess < 0) {
            maximalLinesToProcess = this.myHistoryBuffer.getLineCount() + this.myScreenBuffer.getLineCount();
        }
        int linesFromHistory = Math.min(-scrollOrigin, maximalLinesToProcess);
        int y = this.myHistoryBuffer.getLineCount() + scrollOrigin;
        if (y < 0) {
            y = 0;
        }
        this.myHistoryBuffer.processLines(y, linesFromHistory, consumer, y);
        if (linesFromHistory < maximalLinesToProcess) {
            this.myScreenBuffer.processLines(0, maximalLinesToProcess - linesFromHistory, consumer, -linesFromHistory);
        }
    }

    public void clearHistory() {
        this.modify(() -> {
            int lineCount = this.myHistoryBuffer.getLineCount();
            this.myHistoryBuffer.clearAll();
            if (lineCount > 0) {
                this.fireHistoryBufferLineCountChanged();
            }
        });
        this.fireModelChangeEvent();
    }

    void moveScreenLinesToHistory() {
        this.myLock.lock();
        try {
            this.myScreenBuffer.removeBottomEmptyLines(this.myScreenBuffer.getLineCount() - 1, this.myScreenBuffer.getLineCount());
            int movedToHistoryLineCount = this.myScreenBuffer.moveTopLinesTo(this.myScreenBuffer.getLineCount(), this.myHistoryBuffer);
            if (this.myHistoryBuffer.getLineCount() > 0) {
                this.myHistoryBuffer.getLine(this.myHistoryBuffer.getLineCount() - 1).setWrapped(false);
            }
            if (movedToHistoryLineCount > 0) {
                this.fireHistoryBufferLineCountChanged();
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    private void fireHistoryBufferLineCountChanged() {
        for (TerminalHistoryBufferListener historyBufferListener : this.myHistoryBufferListeners) {
            historyBufferListener.historyBufferLineCountChanged();
        }
    }

    @NotNull
    LinesBuffer getHistoryBufferOrBackup() {
        return this.myUsingAlternateBuffer ? this.myHistoryBufferBackup : this.myHistoryBuffer;
    }

    @NotNull
    LinesBuffer getScreenBufferOrBackup() {
        return this.myUsingAlternateBuffer ? this.myScreenBufferBackup : this.myScreenBuffer;
    }

    public int findScreenLineIndex(@NotNull TerminalLine line) {
        return this.myScreenBuffer.findLineIndex(line);
    }

    public void clearTypeAheadPredictions() {
        this.myScreenBuffer.clearTypeAheadPredictions();
        this.myHistoryBuffer.clearTypeAheadPredictions();
        this.fireModelChangeEvent();
    }

    @Nullable
    TextProcessing getTextProcessing() {
        return this.myTextProcessing;
    }
}

