/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.hyperlinks.TextProcessing;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinesBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(LinesBuffer.class);
    public static final int DEFAULT_MAX_LINES_COUNT = 5000;
    private int myBufferMaxLinesCount = 5000;
    private ArrayList<TerminalLine> myLines = new ArrayList();
    @Nullable
    private final TextProcessing myTextProcessing;

    public LinesBuffer(@Nullable TextProcessing textProcessing) {
        this.myTextProcessing = textProcessing;
    }

    public LinesBuffer(int bufferMaxLinesCount, @Nullable TextProcessing textProcessing) {
        this.myBufferMaxLinesCount = bufferMaxLinesCount;
        this.myTextProcessing = textProcessing;
    }

    public String getLines() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (TerminalLine line : this.myLines) {
            if (!first) {
                sb.append("\n");
            }
            sb.append(line.getText());
            first = false;
        }
        return sb.toString();
    }

    @NotNull
    public List<String> getLineTexts() {
        return this.getLineTexts(0, this.getLineCount());
    }

    @NotNull
    List<String> getLineTexts(int from, int to) {
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = from; i < Math.min(to, this.getLineCount()); ++i) {
            lines.add(this.myLines.get(i).getText());
        }
        return lines;
    }

    public void addNewLine(@NotNull TextStyle style, @NotNull CharBuffer characters) {
        this.addNewLine(new TerminalLine.TextEntry(style, characters));
    }

    private void addNewLine(@NotNull TerminalLine.TextEntry entry) {
        this.addLine(new TerminalLine(entry));
    }

    private void addLine(@NotNull TerminalLine line) {
        if (this.myBufferMaxLinesCount > 0 && this.myLines.size() >= this.myBufferMaxLinesCount) {
            this.removeTopLines(1);
        }
        this.myLines.add(line);
    }

    public int getLineCount() {
        return this.myLines.size();
    }

    public void removeTopLines(int count) {
        this.myLines = count >= this.myLines.size() ? new ArrayList() : new ArrayList<TerminalLine>(this.myLines.subList(count, this.myLines.size()));
    }

    public String getLineText(int row) {
        TerminalLine line = this.getLine(row);
        return line.getText();
    }

    public void insertLines(int y, int count, int lastLine, @NotNull TerminalLine.TextEntry filler) {
        LinesBuffer tail = new LinesBuffer(this.myTextProcessing);
        if (lastLine < this.getLineCount() - 1) {
            this.moveBottomLinesTo(this.getLineCount() - lastLine - 1, tail);
        }
        LinesBuffer head = new LinesBuffer(this.myTextProcessing);
        if (y > 0) {
            this.moveTopLinesTo(y, head);
        }
        for (int i = 0; i < count; ++i) {
            head.addNewLine(filler);
        }
        head.moveBottomLinesTo(head.getLineCount(), this);
        this.removeBottomLines(count);
        tail.moveTopLinesTo(tail.getLineCount(), this);
    }

    public LinesBuffer deleteLines(int y, int count, int lastLine, @NotNull TerminalLine.TextEntry filler) {
        LinesBuffer tail = new LinesBuffer(this.myTextProcessing);
        if (lastLine < this.getLineCount() - 1) {
            this.moveBottomLinesTo(this.getLineCount() - lastLine - 1, tail);
        }
        LinesBuffer head = new LinesBuffer(this.myTextProcessing);
        if (y > 0) {
            this.moveTopLinesTo(y, head);
        }
        int toRemove = Math.min(count, this.getLineCount());
        LinesBuffer removed = new LinesBuffer(this.myTextProcessing);
        this.moveTopLinesTo(toRemove, removed);
        head.moveBottomLinesTo(head.getLineCount(), this);
        for (int i = 0; i < toRemove; ++i) {
            this.addNewLine(filler);
        }
        tail.moveTopLinesTo(tail.getLineCount(), this);
        return removed;
    }

    public void writeString(int x, int y, CharBuffer str, @NotNull TextStyle style) {
        TerminalLine line = this.getLine(y);
        line.writeString(x, str, style);
        if (this.myTextProcessing != null) {
            this.myTextProcessing.processHyperlinks(this, line);
        }
    }

    public void clearLines(int startRow, int endRow, @NotNull TerminalLine.TextEntry filler) {
        for (int i = startRow; i <= endRow; ++i) {
            this.getLine(i).clear(filler);
        }
    }

    public void clearAll() {
        this.myLines.clear();
    }

    public void deleteCharacters(int x, int y, int count, @NotNull TextStyle style) {
        TerminalLine line = this.getLine(y);
        line.deleteCharacters(x, count, style);
    }

    public void insertBlankCharacters(int x, int y, int count, int maxLen, @NotNull TextStyle style) {
        TerminalLine line = this.getLine(y);
        line.insertBlankCharacters(x, count, maxLen, style);
    }

    public void clearArea(int leftX, int topY, int rightX, int bottomY, @NotNull TextStyle style) {
        for (int y = topY; y < bottomY; ++y) {
            TerminalLine line = this.getLine(y);
            line.clearArea(leftX, rightX, style);
        }
    }

    public void processLines(int yStart, int yCount, @NotNull StyledTextConsumer consumer) {
        this.processLines(yStart, yCount, consumer, -this.getLineCount());
    }

    public void processLines(int firstLine, int count, @NotNull StyledTextConsumer consumer, int startRow) {
        if (firstLine < 0) {
            throw new IllegalArgumentException("firstLine=" + firstLine + ", should be >0");
        }
        for (int y = firstLine; y < Math.min(firstLine + count, this.myLines.size()); ++y) {
            this.myLines.get(y).process(y, consumer, startRow);
        }
    }

    int moveTopLinesTo(int count, @NotNull LinesBuffer buffer) {
        if (count < 0) {
            throw new AssertionError((Object)("Moving negative line count: " + count));
        }
        count = Math.min(count, this.getLineCount());
        buffer.addLines(this.myLines.subList(0, count));
        this.removeTopLines(count);
        return count;
    }

    public void addLines(@NotNull List<TerminalLine> lines) {
        if (this.myBufferMaxLinesCount > 0) {
            if (lines.size() >= this.myBufferMaxLinesCount) {
                int index = lines.size() - this.myBufferMaxLinesCount;
                this.myLines = new ArrayList<TerminalLine>(lines.subList(index, lines.size()));
                return;
            }
            int count = this.myLines.size() + lines.size();
            if (count >= this.myBufferMaxLinesCount) {
                this.removeTopLines(count - this.myBufferMaxLinesCount);
            }
        }
        this.myLines.addAll(lines);
    }

    @NotNull
    public TerminalLine getLine(int row) {
        if (row < 0) {
            LOG.error("Negative line number: " + row);
            return TerminalLine.createEmpty();
        }
        for (int i = this.getLineCount(); i <= row; ++i) {
            this.addLine(TerminalLine.createEmpty());
        }
        return this.myLines.get(row);
    }

    public void moveBottomLinesTo(int count, @NotNull LinesBuffer buffer) {
        count = Math.min(count, this.getLineCount());
        buffer.addLinesFirst(this.myLines.subList(this.getLineCount() - count, this.getLineCount()));
        this.removeBottomLines(count);
    }

    private void addLinesFirst(@NotNull List<TerminalLine> lines) {
        ArrayList<TerminalLine> list = new ArrayList<TerminalLine>(lines);
        list.addAll(this.myLines);
        this.myLines = new ArrayList<TerminalLine>(list);
    }

    private void removeBottomLines(int count) {
        this.myLines = new ArrayList<TerminalLine>(this.myLines.subList(0, this.getLineCount() - count));
    }

    public int removeBottomEmptyLines(int bottomMostLineInd, int maxCount) {
        int removedCount = 0;
        for (int ind = bottomMostLineInd; removedCount < maxCount && ind >= 0 && (ind >= this.myLines.size() || this.myLines.get(ind).isNulOrEmpty()); --ind, ++removedCount) {
            if (ind >= this.myLines.size()) continue;
            this.myLines.remove(ind);
        }
        return removedCount;
    }

    int findLineIndex(@NotNull TerminalLine line) {
        return this.myLines.indexOf(line);
    }

    public void clearTypeAheadPredictions() {
        for (TerminalLine line : this.myLines) {
            line.myTypeAheadLine = null;
        }
    }
}

