/*
 * Decompiled with CFR 0.152.
 */
package boringFormatter.breaker;

import boringFormatter.FormatterUtilsKt;
import boringFormatter.TextContent;
import boringFormatter.breaker.CustomFormatterArguments;
import boringFormatter.breaker.CustomReplacerRule;
import boringFormatter.breaker.CustomReplacerRulesSet;
import boringFormatter.breaker.LineBreakRule;
import boringFormatter.breaker.LineBreakRulesSet;
import boringFormatter.breaker.ReplaceOp;
import boringFormatter.breaker.ReplacerLogger;
import boringFormatter.breaker.ReplacerRuleArguments;
import boringFormatter.breaker.SpacerRule;
import boringFormatter.breaker.SpacerRulesSet;
import boringFormatter.breaker.SpacerType;
import fleet.ast.NodeAspectProvider;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u00013B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\tH\u0002J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001cJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0002J*\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\tH\u0002J2\u0010'\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\u0006\u0010%\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u0014H\u0002J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*H\u0002J\u0018\u0010-\u001a\u00020.2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*H\u0002J\u0011\u0010/\u001a\u00020\u0014*\u00020\tH\u0000\u00a2\u0006\u0002\b0J\u000e\u00101\u001a\u0004\u0018\u00010\t*\u00020\tH\u0002J\u000e\u00102\u001a\u0004\u0018\u00010\t*\u00020\tH\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"LboringFormatter/breaker/ReplacerSession;", "", "lineBreakRules", "LboringFormatter/breaker/LineBreakRulesSet;", "spacerRules", "LboringFormatter/breaker/SpacerRulesSet;", "replacerRules", "LboringFormatter/breaker/CustomReplacerRulesSet;", "root", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "text", "LboringFormatter/TextContent;", "range", "Lkotlin/ranges/LongRange;", "aspects", "Lfleet/ast/NodeAspectProvider;", "logger", "LboringFormatter/breaker/ReplacerLogger;", "isNotWhiteSpace", "Lkotlin/Function1;", "", "(LboringFormatter/breaker/LineBreakRulesSet;LboringFormatter/breaker/SpacerRulesSet;LboringFormatter/breaker/CustomReplacerRulesSet;Lfleet/com/jetbrains/lang/syntax/SyntaxNode;LboringFormatter/TextContent;Lkotlin/ranges/LongRange;Lfleet/ast/NodeAspectProvider;LboringFormatter/breaker/ReplacerLogger;Lkotlin/jvm/functions/Function1;)V", "result", "", "LboringFormatter/breaker/ReplaceOp;", "applyCustomRules", "currentNode", "calculate", "", "calculateNewLineCount", "LboringFormatter/breaker/ReplacerSession$newLines;", "prevNodeThatDoesNotEndWithWs", "currentNodeThatDoesNotStartWithWs", "calculateReplacement", "", "prevNode", "lNode", "rNode", "nextNonWsStartNode", "calculateSpaceText", "hasRemoveNLOp", "lineBreaksCount", "", "start", "end", "spaceCountInOriginText", "", "doesNodeStartsWithWs", "doesNodeStartsWithWs$fleet_boringFormatter", "nextNonWsStartedNode", "prevNonWsSiblingNode", "newLines", "fleet.boringFormatter"})
@SourceDebugExtension(value={"SMAP\nReplacerSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplacerSession.kt\nboringFormatter/breaker/ReplacerSession\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,232:1\n288#2,2:233\n766#2:235\n857#2,2:236\n1#3:238\n1099#4,3:239\n1099#4,3:242\n*S KotlinDebug\n*F\n+ 1 ReplacerSession.kt\nboringFormatter/breaker/ReplacerSession\n*L\n104#1:233,2\n206#1:235\n206#1:236,2\n209#1:239,3\n225#1:242,3\n*E\n"})
public final class ReplacerSession {
    @NotNull
    private final LineBreakRulesSet lineBreakRules;
    @NotNull
    private final SpacerRulesSet spacerRules;
    @NotNull
    private final CustomReplacerRulesSet replacerRules;
    @NotNull
    private final SyntaxNode root;
    @NotNull
    private final TextContent text;
    @NotNull
    private final LongRange range;
    @NotNull
    private final NodeAspectProvider aspects;
    @NotNull
    private final ReplacerLogger logger;
    @NotNull
    private final Function1<Object, Boolean> isNotWhiteSpace;
    @NotNull
    private final List<ReplaceOp> result;

    public ReplacerSession(@NotNull LineBreakRulesSet lineBreakRules, @NotNull SpacerRulesSet spacerRules, @NotNull CustomReplacerRulesSet replacerRules, @NotNull SyntaxNode root, @NotNull TextContent text, @NotNull LongRange range, @NotNull NodeAspectProvider aspects, @NotNull ReplacerLogger logger, @NotNull Function1<Object, Boolean> isNotWhiteSpace) {
        Intrinsics.checkNotNullParameter((Object)lineBreakRules, (String)"lineBreakRules");
        Intrinsics.checkNotNullParameter((Object)spacerRules, (String)"spacerRules");
        Intrinsics.checkNotNullParameter((Object)replacerRules, (String)"replacerRules");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)aspects, (String)"aspects");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(isNotWhiteSpace, (String)"isNotWhiteSpace");
        this.lineBreakRules = lineBreakRules;
        this.spacerRules = spacerRules;
        this.replacerRules = replacerRules;
        this.root = root;
        this.text = text;
        this.range = range;
        this.aspects = aspects;
        this.logger = logger;
        this.isNotWhiteSpace = isNotWhiteSpace;
        this.result = new ArrayList();
    }

    public /* synthetic */ ReplacerSession(LineBreakRulesSet lineBreakRulesSet, SpacerRulesSet spacerRulesSet, CustomReplacerRulesSet customReplacerRulesSet, SyntaxNode syntaxNode, TextContent textContent, LongRange longRange, NodeAspectProvider nodeAspectProvider, ReplacerLogger replacerLogger, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            nodeAspectProvider = NodeAspectProvider.Companion.getEmpty();
        }
        if ((n & 0x80) != 0) {
            replacerLogger = ReplacerLogger.Companion.getNoLog();
        }
        this(lineBreakRulesSet, spacerRulesSet, customReplacerRulesSet, syntaxNode, textContent, longRange, nodeAspectProvider, replacerLogger, (Function1<Object, Boolean>)function1);
    }

    @NotNull
    public final List<ReplaceOp> calculate() {
        SyntaxNode syntaxNode = SyntaxNodeExtKt.leafByOffset((SyntaxNode)this.root, (long)Math.max(this.range.getStart(), 0L));
        if (syntaxNode == null) {
            return CollectionsKt.emptyList();
        }
        SyntaxNode current = syntaxNode;
        while (current.getStartOffset() < this.range.getEndInclusive()) {
            SyntaxNode syntaxNode2 = this.applyCustomRules(current);
            if (syntaxNode2 == null || (current = syntaxNode2).getStartOffset() >= this.range.getEndInclusive()) break;
            if (!this.doesNodeStartsWithWs$fleet_boringFormatter(current)) {
                SyntaxNode rNode;
                if (FormatterUtilsKt.next(current, this.isNotWhiteSpace) == null || this.nextNonWsStartedNode(current) == null) break;
                if (rNode.getStartOffset() < this.range.getEndInclusive()) {
                    SyntaxNode lNode = FormatterUtilsKt.prevSibling(rNode, this.isNotWhiteSpace);
                    SyntaxNode prevNode = this.prevNonWsSiblingNode(rNode);
                    if (lNode != null && prevNode != null) {
                        SyntaxNode rSkipWsNode;
                        this.logger.newReplacerInterval(prevNode, lNode, rNode, rSkipWsNode);
                        String replacement = this.calculateReplacement(prevNode, lNode, rNode, rSkipWsNode);
                        if (replacement != null) {
                            this.result.add(new ReplaceOp(prevNode.getEndOffset(), rSkipWsNode.getStartOffset(), replacement));
                        }
                    }
                }
            }
            SyntaxNode syntaxNode3 = FormatterUtilsKt.next(current, this.isNotWhiteSpace);
            if (syntaxNode3 == null) break;
            current = syntaxNode3;
        }
        return this.result;
    }

    private final String calculateReplacement(SyntaxNode prevNode, SyntaxNode lNode, SyntaxNode rNode, SyntaxNode nextNonWsStartNode) {
        String newLineReplacement;
        newLines it = this.calculateNewLineCount(prevNode, nextNonWsStartNode);
        boolean bl = false;
        newLines newLineReplacements = this.lineBreakRules.getMaxContinuousLineBreaks() == null ? it : newLines.copy$default(it, 0, Math.min(this.lineBreakRules.getMaxContinuousLineBreaks(), it.getCountAfter()), 1, null);
        String string = newLineReplacement = newLineReplacements.getCountBefore() != newLineReplacements.getCountAfter() ? StringsKt.repeat((CharSequence)"\n", (int)newLineReplacements.getCountAfter()) : null;
        if (newLineReplacements.getCountAfter() > 0) {
            return newLineReplacement;
        }
        String spaces = this.calculateSpaceText(prevNode, lNode, nextNonWsStartNode, rNode, newLineReplacements.getCountBefore() > 0);
        String string2 = spaces;
        if (string2 == null) {
            string2 = newLineReplacement;
        }
        return string2;
    }

    private final SyntaxNode applyCustomRules(SyntaxNode currentNode) {
        Object v0;
        block5: {
            if (this.replacerRules.isEmpty()) {
                return currentNode;
            }
            this.logger.nextCurrentNode(currentNode);
            Iterable $this$firstOrNull$iv = this.replacerRules.getRules();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CustomReplacerRule it = (CustomReplacerRule)element$iv;
                boolean bl = false;
                if (!((Boolean)it.getRegionStart().invoke((Object)new ReplacerRuleArguments(this.text, this.aspects, currentNode))).booleanValue()) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        CustomReplacerRule rule = v0;
        if (rule == null) {
            return currentNode;
        }
        this.logger.customRuleApplied(rule);
        SyntaxNode syntaxNode = (SyntaxNode)rule.getEndLocator().invoke((Object)currentNode);
        if (syntaxNode == null) {
            throw new Exception("Rule " + rule.getName() + " return null as end node");
        }
        SyntaxNode endNodeInclusive = syntaxNode;
        CustomFormatterArguments args = new CustomFormatterArguments(this.text, currentNode, endNodeInclusive, this.lineBreakRules, this.spacerRules, this.replacerRules, this.aspects);
        List ops = (List)rule.getCalculate().invoke((Object)args);
        CollectionsKt.addAll((Collection)this.result, (Iterable)ops);
        if (((Boolean)this.isNotWhiteSpace.invoke((Object)endNodeInclusive)).booleanValue()) {
            return endNodeInclusive;
        }
        return this.nextNonWsStartedNode(endNodeInclusive);
    }

    public final boolean doesNodeStartsWithWs$fleet_boringFormatter(@NotNull SyntaxNode $this$doesNodeStartsWithWs) {
        Intrinsics.checkNotNullParameter((Object)$this$doesNodeStartsWithWs, (String)"<this>");
        if (FormatterUtilsKt.isToken($this$doesNodeStartsWithWs) && ((Boolean)this.isNotWhiteSpace.invoke((Object)$this$doesNodeStartsWithWs)).booleanValue()) {
            return false;
        }
        SyntaxNode syntaxNode = SyntaxNodeExtKt.firstLeaf((SyntaxNode)$this$doesNodeStartsWithWs);
        if (syntaxNode == null) {
            return false;
        }
        SyntaxNode firstLeaf = syntaxNode;
        return (Boolean)this.isNotWhiteSpace.invoke((Object)firstLeaf) == false;
    }

    private final SyntaxNode nextNonWsStartedNode(SyntaxNode $this$nextNonWsStartedNode) {
        SyntaxNode pointer = $this$nextNonWsStartedNode;
        while (FormatterUtilsKt.next(pointer, this.isNotWhiteSpace) != null) {
            SyntaxNode next;
            SyntaxNode child = next.firstChild();
            while (true) {
                if (child == null) {
                    return next;
                }
                if (!((Boolean)this.isNotWhiteSpace.invoke(child.getType())).booleanValue()) break;
                child = child.firstChild();
            }
            pointer = child;
        }
        return null;
    }

    private final SyntaxNode prevNonWsSiblingNode(SyntaxNode $this$prevNonWsSiblingNode) {
        SyntaxNode pointer = $this$prevNonWsSiblingNode;
        while (FormatterUtilsKt.prevSibling(pointer, this.isNotWhiteSpace) != null) {
            SyntaxNode prev;
            SyntaxNode child = prev.lastChild();
            while (true) {
                if (child == null) {
                    return prev;
                }
                if (!((Boolean)this.isNotWhiteSpace.invoke(child.getType())).booleanValue()) break;
                child = child.lastChild();
            }
            pointer = child;
        }
        return null;
    }

    private final newLines calculateNewLineCount(SyntaxNode prevNodeThatDoesNotEndWithWs, SyntaxNode currentNodeThatDoesNotStartWithWs) {
        int lineBreaksAfter;
        int lineBreakCountBefore = (int)this.lineBreaksCount(prevNodeThatDoesNotEndWithWs.getEndOffset(), currentNodeThatDoesNotStartWithWs.getStartOffset());
        LineBreakRule lineBreakRule = this.lineBreakRules.getRuleOrNull$fleet_boringFormatter(prevNodeThatDoesNotEndWithWs, currentNodeThatDoesNotStartWithWs);
        if (lineBreakRule == null) {
            return new newLines(lineBreakCountBefore, lineBreakCountBefore);
        }
        LineBreakRule rule = lineBreakRule;
        int n = lineBreakCountBefore < rule.getType().getFrom() ? rule.getType().getFrom() : (lineBreaksAfter = rule.getType().getTo() != null && lineBreakCountBefore > rule.getType().getTo() ? rule.getType().getTo() : lineBreakCountBefore);
        if (lineBreaksAfter != lineBreakCountBefore) {
            this.logger.nlRule(rule, lineBreakCountBefore, lineBreaksAfter);
        }
        return new newLines(lineBreakCountBefore, lineBreaksAfter);
    }

    /*
     * WARNING - void declaration
     */
    private final String calculateSpaceText(SyntaxNode prevNodeThatDoesNotEndWithWs, SyntaxNode lNode, SyntaxNode currentNodeThatDoesNotStartWithWs, SyntaxNode rNode, boolean hasRemoveNLOp) {
        String result;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        SpacerRule spacerRule = this.spacerRules.getRuleOrNull$fleet_boringFormatter(lNode, rNode);
        if (spacerRule == null) {
            return null;
        }
        SpacerRule spacerRule2 = spacerRule;
        int spaceCountBefore = this.spaceCountInOriginText(prevNodeThatDoesNotEndWithWs.getEndOffset(), currentNodeThatDoesNotStartWithWs.getStartOffset());
        Iterable iterable = this.result;
        int $i$f$filter = 0;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ReplaceOp it = (ReplaceOp)element$iv$iv;
            boolean bl = false;
            if (!(it.getStart() == prevNodeThatDoesNotEndWithWs.getEndOffset() && it.getEnd() == currentNodeThatDoesNotStartWithWs.getStartOffset())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = 0;
        for (Object t : $this$filter$iv) {
            void it;
            ReplaceOp $i$f$filterTo2 = (ReplaceOp)t;
            int n = $i$f$filter;
            boolean bl = false;
            CharSequence $this$count$iv = it.getText();
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char it2 = element$iv = $this$count$iv.charAt(i);
                boolean bl2 = false;
                if (!(it2 == ' ')) continue;
                ++count$iv;
            }
            int n2 = count$iv;
            $i$f$filter = n + n2;
        }
        int spaceCountCalculated = $i$f$filter;
        int spaces = hasRemoveNLOp ? 0 : spaceCountBefore + spaceCountCalculated;
        String string = spacerRule2.getType() == SpacerType.One && spaces != 1 ? " " : (spacerRule2.getType() == SpacerType.Zero && spaces != 0 ? "" : (result = spacerRule2.getType() == SpacerType.ZeroOrOne && spaces > 1 ? " " : null));
        if (result != null) {
            this.logger.spaceRule(spacerRule2, spaces, result.length());
        }
        return result;
    }

    private final int spaceCountInOriginText(long start, long end) {
        int n;
        if (start == end) {
            n = 0;
        } else {
            CharSequence $this$count$iv = this.text.charSequence(start, end);
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(i);
                boolean bl = false;
                if (!(it == ' ')) continue;
                ++count$iv;
            }
            n = count$iv;
        }
        return n;
    }

    private final long lineBreaksCount(long start, long end) {
        return start == end ? 0L : this.text.lineNumber(end) - this.text.lineNumber(start);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"LboringFormatter/breaker/ReplacerSession$newLines;", "", "countBefore", "", "countAfter", "(II)V", "getCountAfter", "()I", "getCountBefore", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "fleet.boringFormatter"})
    public static final class newLines {
        private final int countBefore;
        private final int countAfter;

        public newLines(int countBefore, int countAfter) {
            this.countBefore = countBefore;
            this.countAfter = countAfter;
        }

        public final int getCountBefore() {
            return this.countBefore;
        }

        public final int getCountAfter() {
            return this.countAfter;
        }

        public final int component1() {
            return this.countBefore;
        }

        public final int component2() {
            return this.countAfter;
        }

        @NotNull
        public final newLines copy(int countBefore, int countAfter) {
            return new newLines(countBefore, countAfter);
        }

        public static /* synthetic */ newLines copy$default(newLines newLines2, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = newLines2.countBefore;
            }
            if ((n3 & 2) != 0) {
                n2 = newLines2.countAfter;
            }
            return newLines2.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "newLines(countBefore=" + this.countBefore + ", countAfter=" + this.countAfter + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.countBefore);
            result = result * 31 + Integer.hashCode(this.countAfter);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof newLines)) {
                return false;
            }
            newLines newLines2 = (newLines)other;
            if (this.countBefore != newLines2.countBefore) {
                return false;
            }
            return this.countAfter == newLines2.countAfter;
        }
    }
}

