/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ec4j.core.model.Adaptable;
import org.ec4j.core.model.Section;
import org.ec4j.core.model.Version;

public class EditorConfig
extends Adaptable {
    private final Boolean root;
    private final List<Section> sections;
    private final Version version;

    public static Builder builder() {
        return new Builder();
    }

    EditorConfig(List<Object> adapters, Boolean root, Version version, List<Section> sections) {
        super(adapters);
        this.root = root;
        this.version = version;
        this.sections = sections;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EditorConfig other = (EditorConfig)obj;
        if (this.root == null ? other.root != null : !this.root.equals(other.root)) {
            return false;
        }
        if (this.sections == null ? other.sections != null : !this.sections.equals(other.sections)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public List<Section> getSections() {
        return this.sections;
    }

    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        result = 31 * result + (this.sections == null ? 0 : this.sections.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean hasRootProperty() {
        return this.root != null;
    }

    public boolean isRoot() {
        return Boolean.TRUE.equals(this.root);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.root != null) {
            s.append("root = ");
            s.append(this.root);
            s.append("\n\n");
        }
        int i = 0;
        for (Section section : this.sections) {
            if (i > 0) {
                s.append("\n\n");
            }
            section.appendTo(s);
            ++i;
        }
        return s.toString();
    }

    public static class Builder
    extends Adaptable.Builder<Builder> {
        boolean parentAware;
        Boolean root;
        List<Section.Builder> sections;
        Version version = Version.CURRENT;

        public Builder() {
            this.sections = new ArrayList<Section.Builder>();
        }

        public EditorConfig build() {
            ArrayList<Section> useSections = new ArrayList<Section>(this.sections.size());
            ArrayList<List> propAdapters = new ArrayList<List>();
            for (Section.Builder sectionBuilder : this.sections) {
                if (this.parentAware) {
                    propAdapters.add(sectionBuilder.adapters);
                }
                Section section = sectionBuilder.build();
                useSections.add(section);
            }
            this.sections = null;
            EditorConfig result = new EditorConfig(this.sealAdapters(), this.root, this.version, Collections.unmodifiableList(useSections));
            for (List adapters : propAdapters) {
                adapters.add(result);
            }
            return result;
        }

        public Section.Builder openSection() {
            return new Section.Builder(this).parentAware(this.parentAware);
        }

        public Builder parentAware(boolean parentAware) {
            this.parentAware = parentAware;
            return this;
        }

        public Builder root(Boolean root) {
            this.root = root;
            return this;
        }

        public Builder section(Section.Builder section) {
            this.sections.add(section);
            return this;
        }

        public Builder sections(Collection<Section.Builder> sections) {
            this.sections.addAll(sections);
            return this;
        }

        public Builder sections(Section.Builder ... sections) {
            for (Section.Builder section : sections) {
                this.sections.add(section);
            }
            return this;
        }

        public Builder version(Version version) {
            this.version = version;
            return this;
        }
    }
}

