/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.zlib;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.support.impl.CompressionStatics;
import org.llvm.support.zlib.CompressionLevel;
import org.llvm.support.zlib.Status;

public final class ZlibGlobals {
    public static boolean isAvailable() {
        return true;
    }

    public static Status compress(StringRef InputBuffer, SmallString CompressedBuffer) {
        return ZlibGlobals.compress(InputBuffer, CompressedBuffer, CompressionLevel.DefaultCompression);
    }

    public static Status compress(StringRef InputBuffer, SmallString CompressedBuffer, CompressionLevel aLevel) {
        Deflater compresser = new Deflater(CompressionStatics.encodeZlibCompressionLevel(aLevel));
        char.ptr data = InputBuffer.data();
        compresser.setInput(data.$array(), data.$index(), InputBuffer.size());
        compresser.finish();
        byte[] buffer = new byte[1024];
        while (!compresser.finished()) {
            int count = compresser.deflate(buffer);
            CompressedBuffer.append(buffer, 0, count);
        }
        compresser.end();
        return Status.StatusOK;
    }

    public static Status uncompress(StringRef InputBuffer, SmallString UncompressedBuffer, int UncompressedSize) {
        UncompressedBuffer.resize(UncompressedSize);
        Inflater decompresser = new Inflater();
        char.ptr data = InputBuffer.data();
        decompresser.setInput(data.$array(), data.$index(), InputBuffer.size());
        byte[] buffer = UncompressedBuffer.$array();
        int off = 0;
        int len = UncompressedSize;
        while (!decompresser.finished()) {
            try {
                int count = decompresser.inflate(buffer, off, len);
                off += count;
                len -= count;
            }
            catch (DataFormatException ex) {
                Logger.getLogger(ZlibGlobals.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        decompresser.end();
        return Status.StatusOK;
    }

    public static int crc32(StringRef Buffer) {
        CRC32 crc = new CRC32();
        crc.update(Buffer.data().$array());
        return (int)crc.getValue();
    }
}

