/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.yaml;

import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.support.MemoryBufferRef;
import org.llvm.support.SMLoc;
import org.llvm.support.SMRange;
import org.llvm.support.SourceMgr;
import org.llvm.support.llvm;
import org.llvm.support.yaml.Document;
import org.llvm.support.yaml.Node;
import org.llvm.support.yaml.document_iterator;
import org.llvm.support.yaml.impl.Scanner;
import org.llvm.support.yaml.impl.Token;

public class Stream
implements Destructors.ClassWithDestructor {
    public std_ptr.unique_ptr<Scanner> scanner;
    public std_ptr.unique_ptr<Document> CurrentDoc;

    public Stream(StringRef Input2, SourceMgr SM) {
        this(Input2, SM, true);
    }

    public Stream(StringRef Input2, SourceMgr SM, boolean ShowColors) {
        this.scanner = new std_ptr.unique_ptr((Object)new Scanner(new StringRef(Input2), SM, ShowColors));
        this.CurrentDoc = new std_ptr.unique_ptr();
    }

    public Stream(MemoryBufferRef InputBuffer, SourceMgr SM) {
        this(InputBuffer, SM, true);
    }

    public Stream(MemoryBufferRef InputBuffer, SourceMgr SM, boolean ShowColors) {
        this.scanner = new std_ptr.unique_ptr((Object)new Scanner(new MemoryBufferRef(InputBuffer), SM, ShowColors));
        this.CurrentDoc = new std_ptr.unique_ptr();
    }

    public void $destroy() {
        this.CurrentDoc.$destroy();
        this.scanner.$destroy();
    }

    public document_iterator begin() {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            if (this.CurrentDoc.$bool()) {
                llvm.report_fatal_error(NativePointer.$((String)"Can only iterate over the stream once"));
            }
            $c$.clean((Object)((Token)$c$.track((Object)((Scanner)this.scanner.$arrow()).getNext())));
            this.CurrentDoc.reset((Object)new Document(this));
            document_iterator document_iterator2 = new document_iterator(this.CurrentDoc);
            return document_iterator2;
        }
        finally {
            $c$.$destroy();
        }
    }

    public document_iterator end() {
        return new document_iterator();
    }

    public void skip() {
        document_iterator i = this.begin();
        document_iterator e = this.end();
        while (i.$noteq(e)) {
            ((Document)i.$arrow().$arrow()).skip();
            i.$preInc();
        }
    }

    public boolean failed() {
        return ((Scanner)this.scanner.$arrow()).failed();
    }

    public boolean validate() {
        this.skip();
        return !this.failed();
    }

    public void printError(Node N, Twine Msg) {
        ((Scanner)this.scanner.$arrow()).printError(new SMLoc(JavaDifferentiators.JD.Move.INSTANCE, N.getSourceRange().Start), SourceMgr.DiagKind.DK_Error, Msg, new ArrayRef<SMRange>(N.getSourceRange(), false));
    }

    public String toString() {
        return ", CurrentDoc=" + this.CurrentDoc;
    }
}

