/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.yaml;

import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.line_iterator;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;
import org.llvm.support.yaml.IO;

public class Output
extends IO
implements Destructors.ClassWithDestructor {
    private final raw_ostream Out;
    private int WrapColumn;
    private SmallVector<InState> StateStack;
    private int Column;
    private int ColumnAtFlowStart;
    private int ColumnAtMapFlowStart;
    private boolean NeedBitValueComma;
    private boolean NeedFlowSequenceComma;
    private boolean EnumerationMatchFound;
    private boolean NeedsNewLine;

    public Output(raw_ostream yout) {
        this(yout, null, 70);
    }

    public Output(raw_ostream yout, Object context) {
        this(yout, context, 70);
    }

    public Output(raw_ostream yout, Object context, int WrapColumn) {
        super(context);
        this.Out = yout;
        this.WrapColumn = WrapColumn;
        this.StateStack = new SmallVector<InState>(8, InState.inSeq);
        this.Column = 0;
        this.ColumnAtFlowStart = 0;
        this.ColumnAtMapFlowStart = 0;
        this.NeedBitValueComma = false;
        this.NeedFlowSequenceComma = false;
        this.EnumerationMatchFound = false;
        this.NeedsNewLine = false;
    }

    @Override
    public void $destroy() {
        this.StateStack.$destroy();
        super.$destroy();
    }

    @Override
    public boolean outputting() {
        return true;
    }

    @Override
    public boolean mapTag(StringRef Tag2, boolean Use) {
        if (Use) {
            boolean SequenceElement;
            boolean bl = SequenceElement = Unsigned.$greater_uint((int)this.StateStack.size(), (int)1) && (this.StateStack.$at(this.StateStack.size() - 2) == InState.inSeq || this.StateStack.$at(this.StateStack.size() - 2) == InState.inFlowSeq);
            if (SequenceElement && this.StateStack.back() == InState.inMapFirstKey) {
                this.newLineCheck();
            } else {
                this.output(new StringRef(NativePointer.$SPACE));
            }
            this.output(new StringRef(Tag2));
            if (SequenceElement) {
                if (this.StateStack.back() == InState.inMapFirstKey) {
                    this.StateStack.pop_back();
                    this.StateStack.push_back(InState.inMapOtherKey);
                }
                this.NeedsNewLine = true;
            }
        }
        return Use;
    }

    @Override
    public void beginMapping() {
        this.StateStack.push_back(InState.inMapFirstKey);
        this.NeedsNewLine = true;
    }

    @Override
    public void endMapping() {
        this.StateStack.pop_back();
    }

    @Override
    public boolean preflightKey(char.ptr Key, boolean Required, boolean SameAsDefault, bool.ref UseDefault, type.ref<Object> $Prm4) {
        UseDefault.$set(false);
        if (Required || !SameAsDefault) {
            InState State2 = (InState)((Object)this.StateStack.back());
            if (State2 == InState.inFlowMapFirstKey || State2 == InState.inFlowMapOtherKey) {
                this.flowKey(new StringRef(Key));
            } else {
                this.newLineCheck();
                this.paddedKey(new StringRef(Key));
            }
            return true;
        }
        return false;
    }

    @Override
    public void postflightKey(Object $Prm0) {
        if (this.StateStack.back() == InState.inMapFirstKey) {
            this.StateStack.pop_back();
            this.StateStack.push_back(InState.inMapOtherKey);
        } else if (this.StateStack.back() == InState.inFlowMapFirstKey) {
            this.StateStack.pop_back();
            this.StateStack.push_back(InState.inFlowMapOtherKey);
        }
    }

    @Override
    public void beginFlowMapping() {
        this.StateStack.push_back(InState.inFlowMapFirstKey);
        this.newLineCheck();
        this.ColumnAtMapFlowStart = this.Column;
        this.output(new StringRef("{ "));
    }

    @Override
    public void endFlowMapping() {
        this.StateStack.pop_back();
        this.outputUpToEndOfLine(new StringRef(" }"));
    }

    @Override
    public int beginSequence() {
        this.StateStack.push_back(InState.inSeq);
        this.NeedsNewLine = true;
        return 0;
    }

    @Override
    public void endSequence() {
        this.StateStack.pop_back();
    }

    @Override
    public boolean preflightElement(int $Prm0, type.ref<Object> $Prm1) {
        return true;
    }

    @Override
    public void postflightElement(Object $Prm0) {
    }

    @Override
    public int beginFlowSequence() {
        this.StateStack.push_back(InState.inFlowSeq);
        this.newLineCheck();
        this.ColumnAtFlowStart = this.Column;
        this.output(new StringRef("[ "));
        this.NeedFlowSequenceComma = false;
        return 0;
    }

    @Override
    public boolean preflightFlowElement(int $Prm0, type.ref<Object> $Prm1) {
        if (this.NeedFlowSequenceComma) {
            this.output(new StringRef(NativePointer.$COMMA_SPACE));
        }
        if (this.WrapColumn != 0 && this.Column > this.WrapColumn) {
            this.output(new StringRef(NativePointer.$LF));
            for (int i = 0; i < this.ColumnAtFlowStart; ++i) {
                this.output(new StringRef(NativePointer.$SPACE));
            }
            this.Column = this.ColumnAtFlowStart;
            this.output(new StringRef("  "));
        }
        return true;
    }

    @Override
    public void postflightFlowElement(Object $Prm0) {
        this.NeedFlowSequenceComma = true;
    }

    @Override
    public void endFlowSequence() {
        this.StateStack.pop_back();
        this.outputUpToEndOfLine(new StringRef(" ]"));
    }

    @Override
    public void beginEnumScalar() {
        this.EnumerationMatchFound = false;
    }

    @Override
    public boolean matchEnumScalar(char.ptr Str, boolean Match) {
        if (Match && !this.EnumerationMatchFound) {
            this.newLineCheck();
            this.outputUpToEndOfLine(new StringRef(Str));
            this.EnumerationMatchFound = true;
        }
        return false;
    }

    @Override
    public boolean matchEnumFallback() {
        if (this.EnumerationMatchFound) {
            return false;
        }
        this.EnumerationMatchFound = true;
        return true;
    }

    @Override
    public void endEnumScalar() {
        if (!this.EnumerationMatchFound) {
            throw new llvm_unreachable("bad runtime enum value");
        }
    }

    @Override
    public boolean beginBitSetScalar(bool.ref DoClear) {
        this.newLineCheck();
        this.output(new StringRef("[ "));
        this.NeedBitValueComma = false;
        DoClear.$set(false);
        return true;
    }

    @Override
    public boolean bitSetMatch(char.ptr Str, boolean Matches) {
        if (Matches) {
            if (this.NeedBitValueComma) {
                this.output(new StringRef(NativePointer.$COMMA_SPACE));
            }
            this.output(new StringRef(Str));
            this.NeedBitValueComma = true;
        }
        return false;
    }

    @Override
    public void endBitSetScalar() {
        this.outputUpToEndOfLine(new StringRef(" ]"));
    }

    @Override
    public void scalarString(StringRef S2, boolean MustQuote) {
        this.newLineCheck();
        if (S2.empty()) {
            this.outputUpToEndOfLine(new StringRef("''"));
            return;
        }
        if (!MustQuote) {
            this.outputUpToEndOfLine(new StringRef(S2));
            return;
        }
        int i = 0;
        int j = 0;
        int End2 = S2.size();
        this.output(new StringRef(NativePointer.$SGL_QUOTE));
        char.ptr Base = Native.$tryClone((char.ptr)S2.data());
        while (Unsigned.$less_uint((int)j, (int)End2)) {
            if (S2.$at(j) == 39) {
                this.output(new StringRef((char.ptr)Base.$add(i), j - i + 1));
                this.output(new StringRef(NativePointer.$SGL_QUOTE));
                i = j + 1;
            }
            ++j;
        }
        this.output(new StringRef((char.ptr)Base.$add(i), j - i));
        this.outputUpToEndOfLine(new StringRef(NativePointer.$SGL_QUOTE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockScalarString(StringRef S2) {
        std_ptr.unique_ptr<MemoryBuffer> Buffer = null;
        try {
            if (!this.StateStack.empty()) {
                this.newLineCheck();
            }
            this.output(new StringRef(" |"));
            this.outputNewLine();
            int Indent = this.StateStack.empty() ? 1 : this.StateStack.size();
            Buffer = MemoryBuffer.getMemBuffer(new StringRef(S2), new StringRef(NativePointer.$EMPTY), false);
            line_iterator Lines = new line_iterator((MemoryBuffer)Buffer.$star(), false);
            while (!Lines.is_at_end()) {
                int I = 0;
                while (Unsigned.$less_uint((int)I, (int)Indent)) {
                    this.output(new StringRef("  "));
                    ++I;
                }
                this.output(Lines.$star());
                this.outputNewLine();
                Lines.$preInc();
            }
        }
        finally {
            if (Buffer != null) {
                Buffer.$destroy();
            }
        }
    }

    @Override
    public void setError(Twine message) {
    }

    @Override
    public boolean canElideEmptySequence() {
        if (Unsigned.$less_uint((int)this.StateStack.size(), (int)2)) {
            return true;
        }
        if (this.StateStack.back() != InState.inMapFirstKey) {
            return true;
        }
        return this.StateStack.$at(this.StateStack.size() - 2) != InState.inSeq;
    }

    public void beginDocuments() {
        this.outputUpToEndOfLine(new StringRef("---"));
    }

    public boolean preflightDocument(int index) {
        if (Unsigned.$greater_uint((int)index, (int)0)) {
            this.outputUpToEndOfLine(new StringRef("\n---"));
        }
        return true;
    }

    public void postflightDocument() {
    }

    public void endDocuments() {
        this.output(new StringRef("\n...\n"));
    }

    private void output(StringRef s) {
        this.Column += s.size();
        this.Out.$out(s);
    }

    private void outputUpToEndOfLine(StringRef s) {
        this.output(new StringRef(s));
        if (this.StateStack.empty() || this.StateStack.back() != InState.inFlowSeq && this.StateStack.back() != InState.inFlowMapFirstKey && this.StateStack.back() != InState.inFlowMapOtherKey) {
            this.NeedsNewLine = true;
        }
    }

    private void newLineCheck() {
        if (!this.NeedsNewLine) {
            return;
        }
        this.NeedsNewLine = false;
        this.outputNewLine();
        assert (Unsigned.$greater_uint((int)this.StateStack.size(), (int)0));
        int Indent = this.StateStack.size() - 1;
        boolean OutputDash = false;
        if (this.StateStack.back() == InState.inSeq) {
            OutputDash = true;
        } else if (Unsigned.$greater_uint((int)this.StateStack.size(), (int)1) && (this.StateStack.back() == InState.inMapFirstKey || this.StateStack.back() == InState.inFlowSeq || this.StateStack.back() == InState.inFlowMapFirstKey) && this.StateStack.$at(this.StateStack.size() - 2) == InState.inSeq) {
            --Indent;
            OutputDash = true;
        }
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)Indent)) {
            this.output(new StringRef("  "));
            ++i;
        }
        if (OutputDash) {
            this.output(new StringRef("- "));
        }
    }

    private void outputNewLine() {
        this.Out.$out(NativePointer.$LF);
        this.Column = 0;
    }

    private void paddedKey(StringRef key) {
        this.output(new StringRef(key));
        this.output(new StringRef(NativePointer.$COLON));
        char.ptr spaces = NativePointer.$((String)"                ");
        if (Unsigned.$less_uint((int)key.size(), (int)std.strlen((char.ptr)spaces))) {
            this.output(new StringRef((char.ptr)spaces.$add(key.size())));
        } else {
            this.output(new StringRef(NativePointer.$SPACE));
        }
    }

    private void flowKey(StringRef Key) {
        if (this.StateStack.back() == InState.inFlowMapOtherKey) {
            this.output(new StringRef(NativePointer.$COMMA_SPACE));
        }
        if (this.WrapColumn != 0 && this.Column > this.WrapColumn) {
            this.output(new StringRef(NativePointer.$LF));
            for (int I = 0; I < this.ColumnAtMapFlowStart; ++I) {
                this.output(new StringRef(NativePointer.$SPACE));
            }
            this.Column = this.ColumnAtMapFlowStart;
            this.output(new StringRef("  "));
        }
        this.output(new StringRef(Key));
        this.output(new StringRef(": "));
    }

    @Override
    public String toString() {
        return "Out=" + this.Out + ", WrapColumn=" + this.WrapColumn + ", StateStack=" + this.StateStack + ", Column=" + this.Column + ", ColumnAtFlowStart=" + this.ColumnAtFlowStart + ", ColumnAtMapFlowStart=" + this.ColumnAtMapFlowStart + ", NeedBitValueComma=" + this.NeedBitValueComma + ", NeedFlowSequenceComma=" + this.NeedFlowSequenceComma + ", EnumerationMatchFound=" + this.EnumerationMatchFound + ", NeedsNewLine=" + this.NeedsNewLine + super.toString();
    }

    private static final class InState
    extends Enum<InState>
    implements Native.NativeUIntEnum {
        public static final /* enum */ InState inSeq = new InState(0);
        public static final /* enum */ InState inFlowSeq = new InState(inSeq.getValue() + 1);
        public static final /* enum */ InState inMapFirstKey = new InState(inFlowSeq.getValue() + 1);
        public static final /* enum */ InState inMapOtherKey = new InState(inMapFirstKey.getValue() + 1);
        public static final /* enum */ InState inFlowMapFirstKey = new InState(inMapOtherKey.getValue() + 1);
        public static final /* enum */ InState inFlowMapOtherKey = new InState(inFlowMapFirstKey.getValue() + 1);
        private final int value;
        private static final /* synthetic */ InState[] $VALUES;

        public static InState[] values() {
            return (InState[])$VALUES.clone();
        }

        public static InState valueOf(String name) {
            return Enum.valueOf(InState.class, name);
        }

        public static InState valueOf(int val) {
            InState out;
            InState inState = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private InState(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new InState[]{inSeq, inFlowSeq, inMapFirstKey, inMapOtherKey, inFlowMapFirstKey, inFlowMapOtherKey};
        }

        private static final class Values {
            private static final InState[] VALUES;
            private static final InState[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (InState kind : InState.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new InState[min < 0 ? 1 - min : 0];
                VALUES = new InState[max >= 0 ? 1 + max : 0];
                for (InState kind : InState.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((InState)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((InState)kind).value] = kind;
                }
            }
        }
    }
}

