/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.target;

import org.clank.java.std;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitchUInt;
import org.llvm.support.ARMBuildAttrs;
import org.llvm.support.llvm;
import org.llvm.support.target.ARM;
import org.llvm.support.target.impl.TargetParserStatics;

public final class AArch64 {
    public static StringRef getCanonicalArchName(StringRef Arch) {
        return ARM.getCanonicalArchName(Arch);
    }

    public static StringRef getFPUName(int FPUKind2) {
        return ARM.getFPUName(FPUKind2);
    }

    public static int getFPUVersion(int FPUKind2) {
        return ARM.getFPUVersion(FPUKind2);
    }

    public static int getFPUNeonSupportLevel(int FPUKind2) {
        return ARM.getFPUNeonSupportLevel(FPUKind2);
    }

    public static int getFPURestriction(int FPUKind2) {
        return ARM.getFPURestriction(FPUKind2);
    }

    public static boolean getFPUFeatures(int FPUKind2, std.vectorCharPtr Features) {
        return ARM.getFPUFeatures(FPUKind2, Features);
    }

    public static boolean getExtensionFeatures(int Extensions, std.vectorCharPtr Features) {
        if (Extensions == 0) {
            return false;
        }
        if ((Extensions & 8) != 0) {
            Features.push_back_T$RR(NativePointer.$((String)"+fp-armv8"));
        }
        if ((Extensions & 0x10) != 0) {
            Features.push_back_T$RR(NativePointer.$((String)"+neon"));
        }
        if ((Extensions & 2) != 0) {
            Features.push_back_T$RR(NativePointer.$((String)"+crc"));
        }
        if ((Extensions & 4) != 0) {
            Features.push_back_T$RR(NativePointer.$((String)"+crypto"));
        }
        if ((Extensions & 0x20) != 0) {
            Features.push_back_T$RR(NativePointer.$((String)"+fullfp16"));
        }
        if ((Extensions & 0x40) != 0) {
            Features.push_back_T$RR(NativePointer.$((String)"+spe"));
        }
        if ((Extensions & 0x80) != 0) {
            Features.push_back_T$RR(NativePointer.$((String)"+ras"));
        }
        return true;
    }

    public static boolean getArchFeatures(int ArchKind2, std.vectorCharPtr Features) {
        if (ArchKind2 == ARM.ArchKind.AK_INVALID.getValue() || Unsigned.$greatereq_uint((int)ArchKind2, (int)ARM.ArchKind.AK_LAST.getValue())) {
            return false;
        }
        if (ArchKind2 == ARM.ArchKind.AK_ARMV8_1A.getValue()) {
            Features.push_back_T$RR(NativePointer.$((String)"+v8.1a"));
        }
        if (ArchKind2 == ARM.ArchKind.AK_ARMV8_2A.getValue()) {
            Features.push_back_T$RR(NativePointer.$((String)"+v8.2a"));
        }
        return true;
    }

    public static StringRef getArchName(int ArchKind2) {
        for (TargetParserStatics.Unnamed_struct1 AI : TargetParserStatics.AArch64ARCHNames) {
            if (AI.ID.getValue() != ArchKind2) continue;
            return AI.getName();
        }
        return new StringRef();
    }

    public static int getArchAttr(int ArchKind2) {
        for (TargetParserStatics.Unnamed_struct1 AI : TargetParserStatics.AArch64ARCHNames) {
            if (AI.ID.getValue() != ArchKind2) continue;
            return AI.ArchAttr.getValue();
        }
        return ARMBuildAttrs.CPUArch.v8_A.getValue();
    }

    public static StringRef getCPUAttr(int ArchKind2) {
        for (TargetParserStatics.Unnamed_struct1 AI : TargetParserStatics.AArch64ARCHNames) {
            if (AI.ID.getValue() != ArchKind2) continue;
            return AI.getCPUAttr();
        }
        return new StringRef();
    }

    public static StringRef getSubArch(int ArchKind2) {
        for (TargetParserStatics.Unnamed_struct1 AI : TargetParserStatics.AArch64ARCHNames) {
            if (AI.ID.getValue() != ArchKind2) continue;
            return AI.getSubArch();
        }
        return new StringRef();
    }

    public static StringRef getArchExtName(int AArchExtKind) {
        for (TargetParserStatics.Unnamed_struct2 AE : TargetParserStatics.AArch64ARCHExtNames) {
            if (AArchExtKind != AE.ID) continue;
            return AE.getName();
        }
        return new StringRef();
    }

    public static char.ptr getArchExtFeature(StringRef ArchExt) {
        if (ArchExt.startswith("no")) {
            StringRef ArchExtBase = ArchExt.substr(2);
            TargetParserStatics.Unnamed_struct2[] unnamed_struct2Array = TargetParserStatics.AArch64ARCHExtNames;
            int n = unnamed_struct2Array.length;
            for (int i = 0; i < n; ++i) {
                TargetParserStatics.Unnamed_struct2 AE = unnamed_struct2Array[i];
                if (AE.NegFeature == null || !llvm.$eq_StringRef(ArchExtBase, AE.getName())) continue;
                return AE.NegFeature;
            }
        }
        for (TargetParserStatics.Unnamed_struct2 AE : TargetParserStatics.AArch64ARCHExtNames) {
            if (AE.Feature == null || !llvm.$eq_StringRef(ArchExt, AE.getName())) continue;
            return AE.Feature;
        }
        return null;
    }

    public static int checkArchVersion(StringRef Arch) {
        if (Arch.$at(0) == 118 && std.isdigit((byte)Arch.$at(1)) != 0) {
            return Arch.$at(1) - 48;
        }
        return 0;
    }

    public static int getDefaultFPU(StringRef CPU, int ArchKind2) {
        if (llvm.$eq_StringRef(CPU, "generic")) {
            return TargetParserStatics.AArch64ARCHNames[ArchKind2].DefaultFPU;
        }
        return new StringSwitchUInt(CPU).Case("cortex-a35", ARM.FPUKind.FK_CRYPTO_NEON_FP_ARMV8.getValue()).Case("cortex-a53", ARM.FPUKind.FK_CRYPTO_NEON_FP_ARMV8.getValue()).Case("cortex-a57", ARM.FPUKind.FK_CRYPTO_NEON_FP_ARMV8.getValue()).Case("cortex-a72", ARM.FPUKind.FK_CRYPTO_NEON_FP_ARMV8.getValue()).Case("cortex-a73", ARM.FPUKind.FK_CRYPTO_NEON_FP_ARMV8.getValue()).Case("cyclone", ARM.FPUKind.FK_CRYPTO_NEON_FP_ARMV8.getValue()).Case("exynos-m1", ARM.FPUKind.FK_CRYPTO_NEON_FP_ARMV8.getValue()).Case("kryo", ARM.FPUKind.FK_CRYPTO_NEON_FP_ARMV8.getValue()).Case("vulcan", ARM.FPUKind.FK_CRYPTO_NEON_FP_ARMV8.getValue()).Case("invalid", ARM.FPUKind.FK_INVALID.getValue()).Default(ARM.FPUKind.FK_INVALID.getValue());
    }

    public static int getDefaultExtensions(StringRef CPU, int _ArchKind) {
        if (llvm.$eq_StringRef(CPU, "generic")) {
            return TargetParserStatics.AArch64ARCHNames[_ArchKind].ArchBaseExtensions;
        }
        return new StringSwitchUInt(CPU).Case("cortex-a35", TargetParserStatics.AArch64ARCHNames[ARM.ArchKind.AK_ARMV8A.getValue()].ArchBaseExtensions | 0x16).Case("cortex-a53", TargetParserStatics.AArch64ARCHNames[ARM.ArchKind.AK_ARMV8A.getValue()].ArchBaseExtensions | 0x16).Case("cortex-a57", TargetParserStatics.AArch64ARCHNames[ARM.ArchKind.AK_ARMV8A.getValue()].ArchBaseExtensions | 0x16).Case("cortex-a72", TargetParserStatics.AArch64ARCHNames[ARM.ArchKind.AK_ARMV8A.getValue()].ArchBaseExtensions | 0x16).Case("cortex-a73", TargetParserStatics.AArch64ARCHNames[ARM.ArchKind.AK_ARMV8A.getValue()].ArchBaseExtensions | 0x16).Case("cyclone", TargetParserStatics.AArch64ARCHNames[ARM.ArchKind.AK_ARMV8A.getValue()].ArchBaseExtensions | 0x14).Case("exynos-m1", TargetParserStatics.AArch64ARCHNames[ARM.ArchKind.AK_ARMV8A.getValue()].ArchBaseExtensions | 0x16).Case("kryo", TargetParserStatics.AArch64ARCHNames[ARM.ArchKind.AK_ARMV8A.getValue()].ArchBaseExtensions | 0x16).Case("vulcan", TargetParserStatics.AArch64ARCHNames[ARM.ArchKind.AK_ARMV8_1A.getValue()].ArchBaseExtensions | 0x16).Case("invalid", TargetParserStatics.AArch64ARCHNames[ARM.ArchKind.AK_INVALID.getValue()].ArchBaseExtensions | 0).Default(0);
    }

    public static StringRef getDefaultCPU(StringRef Arch) {
        int AK = AArch64.parseArch(new StringRef(Arch));
        if (AK == ARM.ArchKind.AK_INVALID.getValue()) {
            return new StringRef();
        }
        for (TargetParserStatics.Unnamed_struct4 CPU : TargetParserStatics.AArch64CPUNames) {
            if (CPU.ArchID.getValue() != AK || !CPU.Default) continue;
            return CPU.getName();
        }
        return new StringRef(NativePointer.$generic);
    }

    public static int parseFPU(StringRef FPU) {
        return ARM.parseFPU(FPU);
    }

    public static int parseArch(StringRef Arch) {
        Arch.$assignMove(AArch64.getCanonicalArchName(new StringRef(Arch)));
        if (Unsigned.$less_uint((int)AArch64.checkArchVersion(new StringRef(Arch)), (int)8)) {
            return ARM.ArchKind.AK_INVALID.getValue();
        }
        StringRef Syn = TargetParserStatics.getArchSynonym(new StringRef(Arch));
        for (TargetParserStatics.Unnamed_struct1 A : TargetParserStatics.AArch64ARCHNames) {
            if (!A.getName().endswith(Syn)) continue;
            return A.ID.getValue();
        }
        return ARM.ArchKind.AK_INVALID.getValue();
    }

    public static int parseArchExt(StringRef ArchExt) {
        for (TargetParserStatics.Unnamed_struct2 A : TargetParserStatics.AArch64ARCHExtNames) {
            if (!llvm.$eq_StringRef(ArchExt, A.getName())) continue;
            return A.ID;
        }
        return 0;
    }

    public static int parseCPUArch(StringRef CPU) {
        for (TargetParserStatics.Unnamed_struct4 C2 : TargetParserStatics.AArch64CPUNames) {
            if (!llvm.$eq_StringRef(CPU, C2.getName())) continue;
            return C2.ArchID.getValue();
        }
        return ARM.ArchKind.AK_INVALID.getValue();
    }

    public static int parseArchISA(StringRef Arch) {
        return ARM.parseArchISA(Arch);
    }

    public static int parseArchEndian(StringRef Arch) {
        return ARM.parseArchEndian(Arch);
    }

    public static int parseArchProfile(StringRef Arch) {
        return ARM.parseArchProfile(Arch);
    }

    public static int parseArchVersion(StringRef Arch) {
        return ARM.parseArchVersion(Arch);
    }

    public static final class ArchExtKind {
        public static final int AEK_INVALID = 0;
        public static final int AEK_NONE = 1;
        public static final int AEK_CRC = 2;
        public static final int AEK_CRYPTO = 4;
        public static final int AEK_FP = 8;
        public static final int AEK_SIMD = 16;
        public static final int AEK_FP16 = 32;
        public static final int AEK_PROFILE = 64;
        public static final int AEK_RAS = 128;
    }
}

