/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.sys;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.clank.java.built_in;
import org.clank.java.io;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.stdimpl.aliases.StdVectorString;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.StringMapBool;
import org.llvm.support.ErrorOr;
import org.llvm.support.ManagedStaticInfo;
import org.llvm.support.sys.ManagedStaticInfoImpl;
import org.llvm.support.sys.SmartMutex;
import org.llvm.support.sys.SmartScopedLock;
import org.llvm.support.sys.TimeValue;
import org.llvm.support.sys.UnicodeCharRange;
import org.llvm.support.sys.WindowsEncodingMethod;
import org.llvm.support.sys.impl.HostSysGlobals;
import org.llvm.support.sys.impl.ProgramSysGlobals;
import org.llvm.support.sys.impl.SwapByteOrderSysGlobals;
import org.llvm.support.unix.impl.HostStatics;
import org.llvm.support.unix.impl.SignalsStatics;

public final class sys {
    public static final byte EnvPathSeparator = NativePointer.$((char)File.pathSeparatorChar);
    public static boolean IsBigEndianHost = false;
    public static boolean IsLittleEndianHost = !IsBigEndianHost;
    public static final ManagedStaticInfo<SmartMutex> StaticSmartMutexTrue = new ManagedStaticInfoImpl<SmartMutex>(){

        @Override
        protected SmartMutex create() {
            return new SmartMutex(true);
        }
    };
    public static final ManagedStaticInfo<std.string> StaticStdString = new ManagedStaticInfoImpl<std.string>(){

        @Override
        protected std.string create() {
            return new std.string();
        }
    };
    public static final ManagedStaticInfo<std.vectorCharPtr> StaticStdVectorCharPtr = new ManagedStaticInfoImpl<std.vectorCharPtr>(){

        @Override
        protected std.vectorCharPtr create() {
            return new std.vectorCharPtr();
        }
    };

    public static int AtomicIncrement(AtomicInteger Value) {
        return Value.incrementAndGet();
    }

    public static int AtomicDecrement(AtomicInteger Value) {
        return Value.decrementAndGet();
    }

    public static int AtomicAdd(AtomicInteger Value, int add) {
        return Value.addAndGet(add);
    }

    public static int AtomicMul(AtomicInteger Value, int V) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void AtomicDiv(AtomicInteger Value, int V) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void RunInterruptHandlers() {
        SmartScopedLock Guard = null;
        try {
            Guard = new SmartScopedLock(true, SignalsStatics.SignalsMutex);
            SignalsStatics.RemoveFilesToRemove();
        }
        finally {
            if (Guard != null) {
                Guard.$destroy();
            }
        }
    }

    public static boolean RemoveFileOnSignal(StringRef Filename) {
        return sys.RemoveFileOnSignal(Filename, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean RemoveFileOnSignal(StringRef Filename, std.string ErrMsg) {
        SmartScopedLock Guard = null;
        try {
            Guard = new SmartScopedLock(true, SignalsStatics.SignalsMutex);
            std.vectorString FilesToRemoveRef = SignalsStatics.FilesToRemove;
            std.string OldPtr = FilesToRemoveRef.empty() ? null : (std.string)Native.$AddrOf((Object)FilesToRemoveRef.$at(0));
            FilesToRemoveRef.push_back(Filename.$string());
            if (OldPtr == Native.$AddrOf((Object)FilesToRemoveRef.$at(0))) {
                FilesToRemoveRef.back().c_str();
            } else {
                int e = FilesToRemoveRef.size();
                for (int i = 0; i != e; ++i) {
                    FilesToRemoveRef.$at(i).c_str();
                }
            }
        }
        finally {
            if (Guard != null) {
                Guard.$destroy();
            }
        }
        SignalsStatics.RegisterHandlers();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DontRemoveFileOnSignal(StringRef Filename) {
        SmartScopedLock Guard = null;
        try {
            Guard = new SmartScopedLock(true, SignalsStatics.SignalsMutex);
            std.reverse_iterator RI = (std.reverse_iterator)std.find((type.iterator)SignalsStatics.FilesToRemove.rbegin(), (type.iterator)SignalsStatics.FilesToRemove.rend(), (Object)Filename);
            StdVectorString.iterator I = SignalsStatics.FilesToRemove.end();
            if (ADTAliases.$noteq_reverse_iterator$C((abstract_iterator)RI, (abstract_iterator)SignalsStatics.FilesToRemove.rend())) {
                StdVectorString.iterator base = (StdVectorString.iterator)RI.base();
                I.$assignMove(SignalsStatics.FilesToRemove.erase(base.$sub(1)));
            }
        }
        finally {
            if (Guard != null) {
                Guard.$destroy();
            }
        }
    }

    public static void PrintStackTraceOnErrorSignal() {
        sys.AddSignalHandler(SignalsStatics::PrintStackTraceSignalHandler, null);
    }

    public static void PrintStackTraceOnErrorSignal(StringRef obj) {
        sys.AddSignalHandler(SignalsStatics::PrintStackTraceSignalHandler, obj);
    }

    public static void PrintStackTrace(io.FILE FD) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static void AddSignalHandler(NativeCallback.VoidPtr2Void FnPtr, Object Cookie) {
        SignalsStatics.CallBacksToRun.push_back((Object)std.make_pair_Ptr_Ptr((Object)FnPtr, (Object)Cookie));
        SignalsStatics.RegisterHandlers();
    }

    public static void SetInterruptFunction(NativeCallback.Void2Void IF) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static std.string StrError() {
        return sys.StrError(std.errno());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.string StrError(int errnum) {
        std.string str = null;
        try {
            if (errnum == 0) {
                std.string string2 = std.string.EMPTY;
                return string2;
            }
            int MaxErrStrLen = 2000;
            char.ptr buffer = NativePointer.create_char$ptr((byte[])NativePointer.new$char((int)2000, (byte[])new byte[0]));
            buffer.$set(0, NativePointer.$((char)'\u0000'));
            str = new std.string();
            std.strerror_r((int)errnum, (char.ptr)buffer, (int)(MaxErrStrLen - 1));
            str.$assign(buffer);
            std.string string3 = str;
            return string3;
        }
        finally {
            if (str != null) {
                str.$destroy();
            }
        }
    }

    public static ErrorOr<std.string> findProgramByName(StringRef Name2) {
        return sys.findProgramByName(Name2, new ArrayRef<StringRef>());
    }

    public static ErrorOr<std.string> findProgramByName(StringRef Name2, ArrayRef<StringRef> Paths) {
        return ProgramSysGlobals.findProgramByName(Name2, Paths);
    }

    private static int getPageSize() {
        return std.getpagesize();
    }

    public static std_errors.error_code ChangeStdinToBinary() {
        return std_errors.error_code.success();
    }

    public static std_errors.error_code ChangeStdoutToBinary() {
        return std_errors.error_code.success();
    }

    public static std_errors.error_code ChangeStderrToBinary() {
        return std_errors.error_code.success();
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args) {
        return sys.ExecuteAndWait(Program, args, (type.ptr<char.ptr>)((type.ptr)null), (type.ptr<StringRef>)((type.ptr)null), 0, 0, null, null);
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp) {
        return sys.ExecuteAndWait(Program, args, envp, (type.ptr<StringRef>)((type.ptr)null), 0, 0, null, null);
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp, type.ptr<StringRef> redirects) {
        return sys.ExecuteAndWait(Program, args, envp, redirects, 0, 0, null, null);
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp, type.ptr<StringRef> redirects, int secondsToWait) {
        return sys.ExecuteAndWait(Program, args, envp, redirects, secondsToWait, 0, null, null);
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp, type.ptr<StringRef> redirects, int secondsToWait, int memoryLimit) {
        return sys.ExecuteAndWait(Program, args, envp, redirects, secondsToWait, memoryLimit, null, null);
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp, type.ptr<StringRef> redirects, int secondsToWait, int memoryLimit, std.string ErrMsg) {
        return sys.ExecuteAndWait(Program, args, envp, redirects, secondsToWait, memoryLimit, ErrMsg, null);
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp, type.ptr<StringRef> redirects, int secondsToWait, int memoryLimit, std.string ErrMsg, bool.ptr ExecutionFailed) {
        return ProgramSysGlobals.ExecuteAndWait(Program, args, envp, redirects, secondsToWait, memoryLimit, ErrMsg, ExecutionFailed);
    }

    public static boolean argumentsFitWithinSystemLimits(ArrayRef<char.ptr> Args) {
        return ProgramSysGlobals.argumentsFitWithinSystemLimits(Args);
    }

    public static std_errors.error_code writeFileWithEncoding(StringRef FileName, StringRef Contents2) {
        return ProgramSysGlobals.writeFileWithEncoding(FileName, Contents2);
    }

    public static std_errors.error_code writeFileWithEncoding(StringRef FileName, StringRef Contents2, WindowsEncodingMethod Encoding) {
        return ProgramSysGlobals.writeFileWithEncoding(FileName, Contents2, Encoding);
    }

    public static boolean commandLineFitsWithinSystemLimits(StringRef Program, ArrayRef<char.ptr> Args) {
        return true;
    }

    public static char SwapByteOrder_16(char value) {
        return SwapByteOrderSysGlobals.SwapByteOrder_16(value);
    }

    public static int SwapByteOrder_32(int value) {
        return SwapByteOrderSysGlobals.SwapByteOrder_32(value);
    }

    public static long SwapByteOrder_64(long value) {
        return SwapByteOrderSysGlobals.SwapByteOrder_64(value);
    }

    public static byte getSwappedBytes_uchar(byte C2) {
        return SwapByteOrderSysGlobals.getSwappedBytes_uchar(C2);
    }

    public static byte getSwappedBytes_schar(byte C2) {
        return SwapByteOrderSysGlobals.getSwappedBytes_schar(C2);
    }

    public static byte getSwappedBytes_char(byte C2) {
        return SwapByteOrderSysGlobals.getSwappedBytes_char(C2);
    }

    public static char getSwappedBytes_ushort(char C2) {
        return SwapByteOrderSysGlobals.getSwappedBytes_ushort(C2);
    }

    public static short getSwappedBytes_short(short C2) {
        return SwapByteOrderSysGlobals.getSwappedBytes_short(C2);
    }

    public static int getSwappedBytes_uint(int C2) {
        return SwapByteOrderSysGlobals.getSwappedBytes_uint(C2);
    }

    public static int getSwappedBytes_int(int C2) {
        return SwapByteOrderSysGlobals.getSwappedBytes_int(C2);
    }

    public static long getSwappedBytes_ulong(long C2) {
        return SwapByteOrderSysGlobals.getSwappedBytes_ulong(C2);
    }

    public static long getSwappedBytes_long(long C2) {
        return SwapByteOrderSysGlobals.getSwappedBytes_long(C2);
    }

    public static long getSwappedBytes_ullong(long C2) {
        return SwapByteOrderSysGlobals.getSwappedBytes_ullong(C2);
    }

    public static long getSwappedBytes_llong(long C2) {
        return SwapByteOrderSysGlobals.getSwappedBytes_llong(C2);
    }

    public static <T> T swapByteOrder(T Value) {
        return SwapByteOrderSysGlobals.swapByteOrder(Value);
    }

    public static TimeValue $add_TimeValue(TimeValue tv1, TimeValue tv2) {
        TimeValue sum = new TimeValue(tv1.seconds_ + tv2.seconds_, tv1.nanos_ + tv2.nanos_);
        sum.normalize();
        return sum;
    }

    public static TimeValue $sub_TimeValue(TimeValue tv1, TimeValue tv2) {
        TimeValue difference = new TimeValue(tv1.seconds_ - tv2.seconds_, tv1.nanos_ - tv2.nanos_);
        difference.normalize();
        return difference;
    }

    public static std.string getDefaultTargetTriple() {
        return HostStatics.getDefaultTargetTriple();
    }

    public static std.string getProcessTriple() {
        return HostSysGlobals.getProcessTriple();
    }

    public static StringRef getHostCPUName() {
        return HostSysGlobals.getHostCPUName();
    }

    public static boolean getHostCPUFeatures(StringMapBool Features) {
        return HostSysGlobals.getHostCPUFeatures(Features);
    }

    public static void RunningOnValgrind() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static boolean $less_uint32_t_UnicodeCharRange(int Value, UnicodeCharRange Range) {
        return Value < Range.Lower;
    }

    public static boolean $less_UnicodeCharRange_uint32_t(UnicodeCharRange Range, int Value) {
        return Range.Upper < Value;
    }

    public static void MemoryFence() {
        built_in.__sync_synchronize();
    }

    public static class Watchdog
    implements Destructors.ClassWithDestructor {
        public Watchdog(int seconds) {
            std.alarm((int)seconds);
        }

        public void $destroy() {
            std.alarm((int)0);
        }

        private Watchdog(Watchdog other) {
            throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
        }

        private Watchdog $assign(Watchdog other) {
            throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
        }
    }

    public static class ThreadLocal<T>
    extends ThreadLocalImpl
    implements Destructors.ClassWithDestructor {
        public T get() {
            return (T)this.getInstance();
        }

        public void set(T d) {
            this.setInstance(d);
        }

        public void erase() {
            this.removeInstance();
        }
    }

    public static class ThreadLocalImpl
    implements Destructors.ClassWithDestructor {
        private Unnamed_union1 Unnamed_field = new Unnamed_union1();
        private final java.lang.ThreadLocal<Object> data = new java.lang.ThreadLocal();

        public ThreadLocalImpl() {
            this.Unnamed_field.data = new byte[8];
        }

        public void $destroy() {
            this.data.remove();
        }

        public void setInstance(Object d) {
            this.data.set(d);
        }

        public Object getInstance() {
            return this.data.get();
        }

        public void removeInstance() {
            this.setInstance(null);
        }

        private static class Unnamed_union1 {
            public byte[] data = new byte[8];
            public long align_data;

            private Unnamed_union1() {
            }
        }
    }

    public final class ScopedLock
    extends SmartScopedLock {
        public ScopedLock(SmartMutex m) {
            super(false, m);
            assert (!m.mt_only());
        }
    }

    public static final class Mutex
    extends SmartMutex {
        public Mutex() {
            this(true);
        }

        public Mutex(boolean rec) {
            super(false, rec);
        }
    }
}

