/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.sys;

import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.support.llvm;
import org.llvm.support.sys.impl.PathAppendHelper;
import org.llvm.support.sys.impl.PathStatics;

public final class path {
    public static final byte[] preferred_separator_string = NativePointer.new$char((int)2, (byte[])new byte[]{47, 0});
    private static final char.ptr[] EnvironmentVariables = new char.ptr[]{NativePointer.$((String)"TMPDIR"), NativePointer.$((String)"TMP"), NativePointer.$((String)"TEMP"), NativePointer.$((String)"TEMPDIR")};
    private static final String RFS_PREFIX = "rfs:";

    public static const_iterator begin(StringRef path2) {
        const_iterator i = new const_iterator(path2, org.llvm.support.impl.PathStatics.find_first_component(path2), 0);
        return i;
    }

    public static const_iterator end(StringRef path2) {
        const_iterator i = new const_iterator(path2, StringRef.R$EMPTY, path2.size());
        return i;
    }

    public static reverse_iterator rbegin(StringRef Path2) {
        reverse_iterator I = new reverse_iterator(Path2, StringRef.R$EMPTY, Path2.size());
        return I.$preInc();
    }

    public static reverse_iterator rend(StringRef Path2) {
        reverse_iterator I = new reverse_iterator(Path2, Path2.substr(0, 0), 0);
        return I;
    }

    public static void remove_filename(SmallString path2) {
        int end_pos = org.llvm.support.impl.PathStatics.parent_path_end(path2.$StringRef());
        if (end_pos != StringRef.npos) {
            path2.set_size(end_pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replace_extension(SmallString path2, Twine extension) {
        SmallVectorImplChar ext_storage = null;
        try {
            StringRef p = new StringRef(path2.$array(), path2.size());
            ext_storage = new SmallString(32);
            StringRef ext = extension.toStringRef((SmallString)ext_storage);
            int pos = p.find_last_of(NativePointer.$((char)'.'));
            if (pos != StringRef.npos && pos >= org.llvm.support.impl.PathStatics.filename_pos(new StringRef(p))) {
                path2.set_size(pos);
            }
            if (ext.size() > 0 && ext.$at(0) != NativePointer.$((char)'.')) {
                path2.push_back(NativePointer.$((char)'.'));
            }
            path2.append(ext);
        }
        finally {
            if (ext_storage != null) {
                ext_storage.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, Twine a) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            if (!a.isTriviallyEmpty()) {
                SmallString a_storage = helper.$a_storage();
                components.push_back(a.toStringRef(a_storage));
            }
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, StringRef a) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            components.push_back(a);
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, char.ptr a) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            components.push_back(helper.$a_StringRef().$assign(a));
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, std.string a) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            components.push_back(helper.$a_StringRef().$assign(a.data(), a.length()));
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, SmallVectorImplChar a) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            components.push_back(helper.$a_StringRef().$assign(a.data(), a.size()));
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, Twine a, Twine b) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            if (!a.isTriviallyEmpty()) {
                SmallString a_storage = helper.$a_storage();
                components.push_back(a.toStringRef(a_storage));
            }
            if (!b.isTriviallyEmpty()) {
                SmallString b_storage = helper.$b_storage();
                components.push_back(b.toStringRef(b_storage));
            }
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, StringRef a, StringRef b) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            components.push_back(a);
            components.push_back(b);
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, Twine a, Twine b, Twine c) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            if (!a.isTriviallyEmpty()) {
                SmallString a_storage = helper.$a_storage();
                components.push_back(a.toStringRef(a_storage));
            }
            if (!b.isTriviallyEmpty()) {
                SmallString b_storage = helper.$b_storage();
                components.push_back(b.toStringRef(b_storage));
            }
            if (!c.isTriviallyEmpty()) {
                SmallString c_storage = helper.$c_storage();
                components.push_back(c.toStringRef(c_storage));
            }
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, StringRef a, StringRef b, StringRef c) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            components.push_back(a);
            components.push_back(b);
            components.push_back(c);
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, char.ptr a, char.ptr b, char.ptr c) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            components.push_back(helper.$a_StringRef().$assign(a));
            components.push_back(helper.$b_StringRef().$assign(b));
            components.push_back(helper.$c_StringRef().$assign(c));
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, Twine a, Twine b, Twine c, Twine d) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            if (!a.isTriviallyEmpty()) {
                SmallString a_storage = helper.$a_storage();
                components.push_back(a.toStringRef(a_storage));
            }
            if (!b.isTriviallyEmpty()) {
                SmallString b_storage = helper.$b_storage();
                components.push_back(b.toStringRef(b_storage));
            }
            if (!c.isTriviallyEmpty()) {
                SmallString c_storage = helper.$c_storage();
                components.push_back(c.toStringRef(c_storage));
            }
            if (!d.isTriviallyEmpty()) {
                SmallString d_storage = helper.$d_storage();
                components.push_back(d.toStringRef(d_storage));
            }
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, StringRef a, StringRef b, StringRef c, StringRef d) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            components.push_back(a);
            components.push_back(b);
            components.push_back(c);
            components.push_back(d);
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    private static void appendImpl(SmallVector<StringRef> components, SmallString path2) {
        T[] $array = components.$array();
        int e = components.size();
        for (int i = 0; i != e; ++i) {
            StringRef i$star = (StringRef)$array[i];
            boolean path_has_sep = !path2.empty() && path.is_separator(path2.$at(path2.size() - 1));
            boolean component_has_sep = !i$star.empty() && path.is_separator(i$star.$at(0));
            boolean is_root_name = path.has_root_name(i$star);
            if (path_has_sep) {
                int loc = i$star.find_first_not_of(org.llvm.support.impl.PathStatics.separators);
                StringRef c_ = i$star.substr(loc);
                path2.append(c_, 0, c_.size());
                continue;
            }
            if (!(component_has_sep || path2.empty() || is_root_name)) {
                path2.push_back((byte)47);
            }
            path2.append(i$star, 0, i$star.size());
        }
    }

    public static void append(SmallString path2, const_iterator begin, const_iterator end) {
        begin = (const_iterator)Native.$tryClone((NativeCloneable)begin);
        while (begin.$noteq(end)) {
            path.append(path2, begin.$star());
            begin.$preInc();
        }
    }

    public static void __native(Twine path2, SmallString result) {
        assert (!path2.isSingleStringRef() || path2.getSingleStringRef().data() != result.data()) : "path and result are not allowed to overlap!";
        result.clear();
        path2.toVector(result);
        path.__native(result);
    }

    public static void __native(SmallString Path2) {
        if (llvm.LLVM_ON_WIN32) {
            std.replace((char.iterator)Path2.begin(), (char.iterator)Path2.end(), (byte)47, (byte)92);
        } else {
            int PE = Path2.size();
            for (int PI = 0; PI < PE; ++PI) {
                if (Path2.$at(PI) != 92) continue;
                int PN = PI + 1;
                if (PN < PE && Path2.$at(PN) == 92) {
                    ++PI;
                    continue;
                }
                Path2.$set(PI, (byte)47);
            }
        }
    }

    public static StringRef root_name(StringRef path2) {
        StringRef First2 = org.llvm.support.impl.PathStatics.find_first_component(path2);
        int size = First2.size();
        if (size > 0) {
            int pathOffsetInURL = path.get_path_offset_in_url(path2);
            assert (pathOffsetInURL <= size) : "[" + First2 + "] of [" + path2 + "] has offset at " + pathOffsetInURL + " vs length=" + size;
            if (pathOffsetInURL == size) {
                return StringRef.R$EMPTY;
            }
            byte first_at_zero = First2.$at(pathOffsetInURL);
            boolean has_net = pathOffsetInURL == 0 && size > 2 && path.is_separator(first_at_zero) && First2.$at(1) == first_at_zero;
            boolean has_drive = false;
            if (!llvm.LLVM_ON_WIN32) {
                // empty if block
            }
            has_drive = First2.endswith(":");
            if (has_net || has_drive) {
                return First2;
            }
        }
        return StringRef.R$EMPTY;
    }

    public static StringRef root_directory(StringRef path2) {
        StringRef First2 = org.llvm.support.impl.PathStatics.find_first_component(path2);
        int size = First2.size();
        if (size > 0) {
            int pathOffsetInURL = path.get_path_offset_in_url(path2);
            assert (pathOffsetInURL <= size) : "[" + First2 + "] of [" + path2 + "] has offset at " + pathOffsetInURL + " vs length=" + size;
            if (pathOffsetInURL == size) {
                return First2;
            }
            byte first_at_zero = First2.$at(pathOffsetInURL);
            boolean first_at_zero_is_separator = path.is_separator(first_at_zero);
            boolean has_net = pathOffsetInURL == 0 && size > 2 && first_at_zero_is_separator && First2.$at(1) == first_at_zero;
            boolean has_drive = false;
            has_drive = First2.endswith(":");
            if (has_net || has_drive) {
                const_iterator pos = new const_iterator(path2, First2, 0);
                int EndPosition = path2.size();
                pos.$preInc();
                if (pos.Position != EndPosition && path.is_separator(pos.$star().$at(0))) {
                    return pos.$star();
                }
            }
            if (!has_net && first_at_zero_is_separator) {
                return First2;
            }
        }
        return StringRef.R$EMPTY;
    }

    public static StringRef root_path(StringRef path2) {
        StringRef First2 = org.llvm.support.impl.PathStatics.find_first_component(path2);
        int size = First2.size();
        if (size > 0) {
            int pathOffsetInURL = path.get_path_offset_in_url(path2);
            assert (pathOffsetInURL <= size) : "[" + First2 + "] of [" + path2 + "] has offset at " + pathOffsetInURL + " vs length=" + size;
            if (pathOffsetInURL == size) {
                return First2;
            }
            byte first_at_zero = First2.$at(pathOffsetInURL);
            boolean first_at_zero_is_separator = path.is_separator(first_at_zero);
            boolean has_net = pathOffsetInURL == 0 && size > 2 && first_at_zero_is_separator && First2.$at(1) == first_at_zero;
            boolean has_drive = false;
            if (llvm.LLVM_ON_WIN32 || NativeTrace.UNIT_TEST_MODE) {
                has_drive = First2.endswith(":");
            }
            if (has_net || has_drive) {
                const_iterator pos = new const_iterator(path2, First2, 0);
                int EndPosition = path2.size();
                pos.$preInc();
                if (pos.Position != EndPosition && path.is_separator(pos.$star().$at(0))) {
                    return path2.substr(0, First2.size() + pos.$arrow().size());
                }
                return First2;
            }
            if (first_at_zero_is_separator) {
                return First2;
            }
        }
        return StringRef.R$EMPTY;
    }

    public static StringRef relative_path(StringRef _path) {
        StringRef root = path.root_path(_path);
        return _path.substr(root.size());
    }

    public static StringRef parent_path(StringRef path2) {
        int end_pos = org.llvm.support.impl.PathStatics.parent_path_end(path2);
        if (end_pos == StringRef.npos) {
            return StringRef.R$EMPTY;
        }
        return path2.substr(0, end_pos);
    }

    public static StringRef filename(StringRef path2) {
        return path.rbegin(path2).$star();
    }

    public static StringRef stem(StringRef path2) {
        StringRef fname = path.filename(path2);
        int pos = fname.find_last_of(NativePointer.$((char)'.'));
        if (pos == StringRef.npos) {
            return fname;
        }
        if (fname.size() == 1 && llvm.$eq_StringRef(fname, ".") || fname.size() == 2 && llvm.$eq_StringRef(fname, "..")) {
            return fname;
        }
        return fname.substr(0, pos);
    }

    public static StringRef extension(StringRef path2) {
        StringRef fname = path.filename(path2);
        int pos = fname.find_last_of(NativePointer.$((char)'.'));
        if (pos == StringRef.npos) {
            return StringRef.R$EMPTY;
        }
        if (fname.size() == 1 && llvm.$eq_StringRef(fname, ".") || fname.size() == 2 && llvm.$eq_StringRef(fname, "..")) {
            return StringRef.R$EMPTY;
        }
        return fname.substr(pos);
    }

    public static boolean is_separator(byte value) {
        switch (value) {
            case 47: 
            case 92: {
                return true;
            }
        }
        return false;
    }

    public static StringRef get_separator() {
        return new StringRef(PathStatics.preferred_separator_string);
    }

    public static void system_temp_directory(boolean ErasedOnReboot, SmallString Result) {
        char.ptr RequestedDir;
        Result.clear();
        if (ErasedOnReboot && (RequestedDir = path.getEnvTempDir()) != null) {
            Result.append(RequestedDir, std.strlen((char.ptr)RequestedDir));
            return;
        }
        RequestedDir = path.getDefaultTempDir(ErasedOnReboot);
        Result.append(RequestedDir, std.strlen((char.ptr)RequestedDir));
    }

    public static boolean home_directory(SmallString result) {
        char.ptr RequestedDir = Native.$tryClone((char.ptr)std.getenv((String)"HOME"));
        if (RequestedDir != null) {
            result.clear();
            result.append(RequestedDir, std.strlen((char.ptr)RequestedDir));
            return true;
        }
        return false;
    }

    public static boolean user_cache_directory(SmallString Result, Twine Path1) {
        return path.user_cache_directory(Result, Path1, Twine.T$EMPTY, Twine.T$EMPTY);
    }

    public static boolean user_cache_directory(SmallString Result, Twine Path1, Twine Path2) {
        return path.user_cache_directory(Result, Path1, Path2, Twine.T$EMPTY);
    }

    public static boolean user_cache_directory(SmallString Result, Twine Path1, Twine Path2, Twine Path3) {
        if (PathStatics.getUserCacheDir(Result)) {
            path.append(Result, Path1, Path2, Path3);
            return true;
        }
        return false;
    }

    public static boolean has_root_name(Twine path2) {
        SmallString path_storage = new SmallString(128);
        StringRef p = path2.toStringRef(path_storage);
        return path.has_root_name(p);
    }

    public static boolean has_root_name(StringRef p) {
        return !path.root_name(p).empty();
    }

    public static boolean has_root_directory(Twine path2) {
        SmallString path_storage = new SmallString(128);
        StringRef p = path2.toStringRef(path_storage);
        return path.has_root_directory(p);
    }

    public static boolean has_root_directory(StringRef p) {
        return !path.root_directory(p).empty();
    }

    public static boolean has_root_path(Twine path2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean has_relative_path(Twine path2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean has_parent_path(Twine path2) {
        SmallString path_storage = null;
        try {
            path_storage = new SmallString(128);
            StringRef p = path2.toStringRef(path_storage);
            boolean bl = !path.parent_path(new StringRef(p)).empty();
            return bl;
        }
        finally {
            if (path_storage != null) {
                path_storage.$destroy();
            }
        }
    }

    public static boolean has_filename(Twine path2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean has_stem(Twine path2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean has_extension(Twine _path) {
        SmallString path_storage = new SmallString(128);
        StringRef p = _path.toStringRef(path_storage);
        return !path.extension(p).empty();
    }

    public static boolean is_absolute(Twine path2) {
        if (path2.isSingleStringRef()) {
            return path.is_absolute(path2.getSingleStringRef());
        }
        SmallString path_storage = new SmallString(128);
        path2.toVector(path_storage);
        return path.is_absolute(path_storage.$StringRef());
    }

    public static boolean is_absolute(char.ptr path2) {
        return path.is_absolute(new StringRef(path2));
    }

    public static boolean is_absolute(std.string path2) {
        return path.is_absolute(new StringRef(path2));
    }

    public static boolean is_absolute(StringRef p) {
        int pathOffsetInURL = path.get_path_offset_in_url(p);
        assert (pathOffsetInURL <= p.size()) : "[" + p + "] has offset at " + pathOffsetInURL + " vs length=" + p.size();
        if (pathOffsetInURL > 0) {
            assert (path.is_empty(p) || path.is_separator(p.$at(pathOffsetInURL)));
            assert (p.size() == pathOffsetInURL == path.is_empty(p)) : "expected the same reply for " + p + "[" + path.is_empty(p) + "] vs. (" + p.size() + "==" + pathOffsetInURL + ")";
            return p.size() != pathOffsetInURL;
        }
        boolean rootDir = path.has_root_directory(p);
        boolean rootName = true;
        rootName = llvm.LLVM_ON_WIN32 ? path.has_root_name(p) : true;
        return rootDir && rootName;
    }

    public static boolean is_relative(Twine path2) {
        return !path.is_absolute(path2);
    }

    public static char.ptr getEnvTempDir() {
        for (char.ptr Env : EnvironmentVariables) {
            char.ptr Dir = Native.$tryClone((char.ptr)std.getenv((char.ptr)Env));
            if (Dir == null) continue;
            return Dir;
        }
        return null;
    }

    public static char.ptr getDefaultTempDir(boolean ErasedOnReboot) {
        if (std.P_tmpdir != null) {
            return std.P_tmpdir;
        }
        if (ErasedOnReboot) {
            return NativePointer.$SLASH_TMP;
        }
        return NativePointer.$SLASH_VAR_SLASH_TMP;
    }

    public static boolean is_empty(StringRef path2) {
        int pathOffsetInURL = path.get_path_offset_in_url(path2);
        assert (pathOffsetInURL <= path2.size()) : "[" + path2 + "] has offset at " + pathOffsetInURL + " vs length=" + path2.size();
        if (pathOffsetInURL > 0) {
            return path2.size() == pathOffsetInURL;
        }
        return path2.empty();
    }

    public static int get_path_offset_in_url(StringRef path2) {
        String prefix;
        if (path2 != null && path2.startswith(prefix = RFS_PREFIX)) {
            int colonPos = path2.find_first_of((byte)58, prefix.length());
            if (colonPos != StringRef.npos) {
                int pos;
                for (pos = colonPos + 1; pos < path2.size() && std.isdigit((byte)path2.$at(pos)) != 0; ++pos) {
                }
                return pos;
            }
            NativeTrace.printStackTraceOnce((Throwable)((Object)new AssertionError((Object)("The path " + path2 + " starts with " + prefix + " but does not contain a colon after it"))));
            return prefix.length();
        }
        return 0;
    }

    public static StringRef remove_leading_dotslash(StringRef Path2) {
        while (Unsigned.$greater_uint((int)Path2.size(), (int)2) && Path2.$at(0) == 46 && path.is_separator(Path2.$at(1))) {
            Path2.$assignMove(Path2.substr(2));
            while (Unsigned.$greater_uint((int)Path2.size(), (int)0) && path.is_separator(Path2.$at(0))) {
                Path2.$assignMove(Path2.substr(1));
            }
        }
        return new StringRef(JavaDifferentiators.JD.Move.INSTANCE, Path2);
    }

    public static boolean remove_dots(SmallString path2) {
        return path.remove_dots(path2, false);
    }

    public static boolean remove_dots(SmallString path2, boolean remove_dot_dot) {
        StringRef p = new StringRef(path2.data(), path2.size());
        SmallString result = PathStatics.remove_dots(new StringRef(p), remove_dot_dot);
        if (result.$eq(path2)) {
            return false;
        }
        path2.swap(result);
        return true;
    }

    public static class reverse_iterator
    implements std.iterator<std.input_iterator_tag, StringRef>,
    type.iterator<reverse_iterator, StringRef> {
        private final StringRef Path;
        private StringRef Component;
        private int Position;

        public StringRef $star() {
            return this.Component;
        }

        public StringRef $arrow() {
            return (StringRef)Native.$AddrOf((Object)this.Component);
        }

        public reverse_iterator $preInc() {
            int end_pos;
            int root_dir_pos = org.llvm.support.impl.PathStatics.root_dir_start(this.Path);
            if (this.Position == this.Path.size() && Unsigned.$greater_uint((int)this.Path.size(), (int)(root_dir_pos + 1)) && path.is_separator(this.Path.$at(this.Position - 1))) {
                --this.Position;
                this.Component = StringRef.R$DOT;
                return this;
            }
            for (end_pos = this.Position; end_pos > 0 && end_pos - 1 != root_dir_pos && path.is_separator(this.Path.$at(end_pos - 1)); --end_pos) {
            }
            int start_pos = org.llvm.support.impl.PathStatics.filename_pos(this.Path.substr(0, end_pos));
            this.Component = this.Path.slice(start_pos, end_pos);
            this.Position = start_pos;
            return this;
        }

        public reverse_iterator $postInc() {
            throw new UnsupportedOperationException("Not implemented yet.");
        }

        public boolean $eq(Object _RHS) {
            reverse_iterator RHS = (reverse_iterator)_RHS;
            return this.Path.begin() == RHS.Path.begin() && llvm.$eq_StringRef(this.Component, RHS.Component) && this.Position == RHS.Position;
        }

        public boolean $noteq(Object RHS) {
            return !this.$eq(RHS);
        }

        public reverse_iterator(StringRef Path2, StringRef Component, int Position) {
            this.Path = Path2;
            this.Component = Component;
            this.Position = Position;
        }

        public reverse_iterator(reverse_iterator $Prm0) {
            this.Path = $Prm0.Path;
            this.Component = $Prm0.Component;
            this.Position = $Prm0.Position;
        }

        public type.ref<StringRef> star$ref() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int $sub(reverse_iterator iter) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public reverse_iterator $preDec() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public reverse_iterator $postDec() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public reverse_iterator $inc(int amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public reverse_iterator $dec(int amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public reverse_iterator $add(int amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public reverse_iterator $sub(int amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public reverse_iterator clone() {
            return new reverse_iterator(this);
        }

        public reverse_iterator const_clone() {
            return this.clone();
        }

        public String toString() {
            return "Path=" + this.Path + ", Component=" + this.Component + ", Position=" + this.Position + super.toString();
        }
    }

    public static class const_iterator
    implements std.iterator<std.input_iterator_tag, StringRef>,
    type.iterator<const_iterator, StringRef> {
        private final StringRef Path;
        private StringRef Component;
        private int Position;

        public const_iterator(StringRef Path2, StringRef Component, int Position) {
            this.Path = Path2;
            this.Component = Component;
            this.Position = Position;
        }

        public StringRef $star() {
            return this.Component;
        }

        public StringRef $arrow() {
            return (StringRef)Native.$AddrOf((Object)this.Component);
        }

        public const_iterator $preInc() {
            boolean was_net;
            assert (this.Position < this.Path.size()) : "Tried to increment past end!";
            this.Position += this.Component.size();
            if (this.Position == this.Path.size()) {
                this.Component = StringRef.R$EMPTY;
                return this;
            }
            boolean bl = was_net = this.Component.size() > 2 && path.is_separator(this.Component.$at(0)) && this.Component.$at(1) == this.Component.$at(0) && !path.is_separator(this.Component.$at(2));
            if (path.is_separator(this.Path.$at(this.Position))) {
                if (was_net || (llvm.LLVM_ON_WIN32 || NativeTrace.UNIT_TEST_MODE) && this.Component.endswith(":")) {
                    this.Component = this.Path.substr(this.Position, 1);
                    return this;
                }
                while (this.Position != this.Path.size() && path.is_separator(this.Path.$at(this.Position))) {
                    ++this.Position;
                }
                if (this.Position == this.Path.size()) {
                    --this.Position;
                    this.Component = StringRef.R$DOT;
                    return this;
                }
            }
            int end_pos = this.Path.find_first_of(org.llvm.support.impl.PathStatics.separators, this.Position);
            this.Component = this.Path.slice(this.Position, end_pos);
            return this;
        }

        public const_iterator $postInc() {
            throw new UnsupportedOperationException("EmptyBody");
        }

        public boolean $eq(Object RHS) {
            return this.Position == ((const_iterator)RHS).Position && Native.$eq_ptr((void.ptr)this.Path.begin(), (void.ptr)((const_iterator)RHS).Path.begin());
        }

        public boolean $noteq(Object RHS) {
            return !this.$eq(RHS);
        }

        public int $sub(const_iterator RHS) {
            return this.Position - RHS.Position;
        }

        public const_iterator() {
            this.Path = StringRef.R$EMPTY;
            this.Component = StringRef.R$EMPTY;
        }

        public const_iterator(const_iterator $Prm0) {
            this.Path = $Prm0.Path;
            this.Component = $Prm0.Component;
            this.Position = $Prm0.Position;
        }

        public type.ref<StringRef> star$ref() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public const_iterator $preDec() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public const_iterator $postDec() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public const_iterator $inc(int amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public const_iterator $dec(int amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public const_iterator $add(int amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public const_iterator $sub(int amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public const_iterator clone() {
            return new const_iterator(this);
        }

        public const_iterator const_clone() {
            return this.clone();
        }

        public String toString() {
            return "Path=" + this.Path + ", Component=" + this.Component + ", Position=" + this.Position + super.toString();
        }
    }
}

