/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.sys.impl;

import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.uint;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.StringMapBool;
import org.llvm.support.impl.ProcessorSubtypes;
import org.llvm.support.impl.ProcessorTypes;
import org.llvm.support.unix.impl.HostStatics;

public final class HostSysGlobals {
    public static std.string getDefaultTargetTriple() {
        std.string TargetTripleString = new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"i386-pc-solaris2.11");
        int DarwinDashIdx = TargetTripleString.find_T$C$P_size_type$_CharT("-darwin");
        if (DarwinDashIdx != std.string.npos) {
            TargetTripleString.resize(DarwinDashIdx + std.strlen((CharSequence)"-darwin"));
            TargetTripleString.$addassign(HostStatics.getOSVersion());
        }
        return Triple.normalize(new StringRef(TargetTripleString));
    }

    public static std.string getProcessTriple() {
        Triple PT = new Triple(new Twine(Triple.normalize(new StringRef("i386-pc-solaris2.11"))));
        if (NativeType.$sizeof_ptr() == 8 && PT.isArch32Bit()) {
            PT.$assignMove(PT.get64BitArchVariant());
        }
        if (NativeType.$sizeof_ptr() == 4 && PT.isArch64Bit()) {
            PT.$assignMove(PT.get32BitArchVariant());
        }
        return new std.string(PT.str());
    }

    public static StringRef getHostCPUName() {
        uint.ptr EAX = NativePointer.create_uint$ptr((int)0);
        uint.ptr EBX = NativePointer.create_uint$ptr((int)0);
        uint.ptr ECX = NativePointer.create_uint$ptr((int)0);
        uint.ptr EDX = NativePointer.create_uint$ptr((int)0);
        uint.ptr MaxLeaf = NativePointer.create_uint$ptr();
        uint.ptr Vendor = NativePointer.create_uint$ptr();
        if (org.llvm.support.impl.HostStatics.getX86CpuIDAndInfo(0, (uint.ptr)Native.$AddrOf((Object)MaxLeaf), (uint.ptr)Native.$AddrOf((Object)Vendor), (uint.ptr)Native.$AddrOf((Object)ECX), (uint.ptr)Native.$AddrOf((Object)EDX))) {
            return new StringRef(NativePointer.$generic);
        }
        if (org.llvm.support.impl.HostStatics.getX86CpuIDAndInfo(1, (uint.ptr)Native.$AddrOf((Object)EAX), (uint.ptr)Native.$AddrOf((Object)EBX), (uint.ptr)Native.$AddrOf((Object)ECX), (uint.ptr)Native.$AddrOf((Object)EDX))) {
            return new StringRef(NativePointer.$generic);
        }
        int Brand_id = EBX.$star() & 0xFF;
        uint.ptr Family = NativePointer.create_uint$ptr((int)0);
        uint.ptr Model2 = NativePointer.create_uint$ptr((int)0);
        int Features = 0;
        org.llvm.support.impl.HostStatics.detectX86FamilyModel(EAX.$star(), (uint.ptr)Native.$AddrOf((Object)Family), (uint.ptr)Native.$AddrOf((Object)Model2));
        Features = org.llvm.support.impl.HostStatics.getAvailableFeatures(ECX.$star(), EDX.$star(), MaxLeaf.$star());
        uint.ptr Type2 = NativePointer.create_uint$ptr();
        uint.ptr Subtype = NativePointer.create_uint$ptr();
        if (Vendor.$star() == 1970169159) {
            org.llvm.support.impl.HostStatics.getIntelProcessorTypeAndSubtype(Family.$star(), Model2.$star(), Brand_id, Features, (uint.ptr)Native.$AddrOf((Object)Type2), (uint.ptr)Native.$AddrOf((Object)Subtype));
            switch (ProcessorTypes.valueOf(Type2.$star())) {
                case INTEL_i386: {
                    return new StringRef("i386");
                }
                case INTEL_i486: {
                    return new StringRef("i486");
                }
                case INTEL_PENTIUM: {
                    if (Subtype.$star() == ProcessorSubtypes.INTEL_PENTIUM_MMX.getValue()) {
                        return new StringRef("pentium-mmx");
                    }
                    return new StringRef("pentium");
                }
                case INTEL_PENTIUM_PRO: {
                    return new StringRef("pentiumpro");
                }
                case INTEL_PENTIUM_II: {
                    return new StringRef("pentium2");
                }
                case INTEL_PENTIUM_III: {
                    return new StringRef("pentium3");
                }
                case INTEL_PENTIUM_IV: {
                    return new StringRef("pentium4");
                }
                case INTEL_PENTIUM_M: {
                    return new StringRef("pentium-m");
                }
                case INTEL_CORE_DUO: {
                    return new StringRef("yonah");
                }
                case INTEL_CORE2: {
                    switch (ProcessorSubtypes.valueOf(Subtype.$star())) {
                        case INTEL_CORE2_65: {
                            return new StringRef("core2");
                        }
                        case INTEL_CORE2_45: {
                            return new StringRef("penryn");
                        }
                    }
                    return new StringRef("core2");
                }
                case INTEL_COREI7: {
                    switch (ProcessorSubtypes.valueOf(Subtype.$star())) {
                        case INTEL_COREI7_NEHALEM: {
                            return new StringRef("nehalem");
                        }
                        case INTEL_COREI7_WESTMERE: {
                            return new StringRef("westmere");
                        }
                        case INTEL_COREI7_SANDYBRIDGE: {
                            return new StringRef("sandybridge");
                        }
                        case INTEL_COREI7_IVYBRIDGE: {
                            return new StringRef("ivybridge");
                        }
                        case INTEL_COREI7_HASWELL: {
                            return new StringRef("haswell");
                        }
                        case INTEL_COREI7_BROADWELL: {
                            return new StringRef("broadwell");
                        }
                        case INTEL_COREI7_SKYLAKE: {
                            return new StringRef("skylake");
                        }
                        case INTEL_COREI7_SKYLAKE_AVX512: {
                            return new StringRef("skylake-avx512");
                        }
                    }
                    return new StringRef("corei7");
                }
                case INTEL_ATOM: {
                    switch (ProcessorSubtypes.valueOf(Subtype.$star())) {
                        case INTEL_ATOM_BONNELL: {
                            return new StringRef("bonnell");
                        }
                        case INTEL_ATOM_SILVERMONT: {
                            return new StringRef("silvermont");
                        }
                    }
                    return new StringRef("atom");
                }
                case INTEL_XEONPHI: {
                    return new StringRef("knl");
                }
                case INTEL_X86_64: {
                    return new StringRef("x86-64");
                }
                case INTEL_NOCONA: {
                    return new StringRef("nocona");
                }
                case INTEL_PRESCOTT: {
                    return new StringRef("prescott");
                }
            }
            return new StringRef(NativePointer.$generic);
        }
        if (Vendor.$star() == 1752462657) {
            org.llvm.support.impl.HostStatics.getAMDProcessorTypeAndSubtype(Family.$star(), Model2.$star(), Features, (uint.ptr)Native.$AddrOf((Object)Type2), (uint.ptr)Native.$AddrOf((Object)Subtype));
            switch (ProcessorTypes.valueOf(Type2.$star())) {
                case AMD_i486: {
                    return new StringRef("i486");
                }
                case AMDPENTIUM: {
                    switch (ProcessorSubtypes.valueOf(Subtype.$star())) {
                        case AMDPENTIUM_K6: {
                            return new StringRef("k6");
                        }
                        case AMDPENTIUM_K62: {
                            return new StringRef("k6-2");
                        }
                        case AMDPENTIUM_K63: {
                            return new StringRef("k6-3");
                        }
                        case AMDPENTIUM_GEODE: {
                            return new StringRef("geode");
                        }
                    }
                    return new StringRef("pentium");
                }
                case AMDATHLON: {
                    switch (ProcessorSubtypes.valueOf(Subtype.$star())) {
                        case AMDATHLON_TBIRD: {
                            return new StringRef("athlon-tbird");
                        }
                        case AMDATHLON_MP: {
                            return new StringRef("athlon-mp");
                        }
                        case AMDATHLON_XP: {
                            return new StringRef("athlon-xp");
                        }
                        case AMDATHLON_K8SSE3: {
                            return new StringRef("k8-sse3");
                        }
                        case AMDATHLON_OPTERON: {
                            return new StringRef("opteron");
                        }
                        case AMDATHLON_FX: {
                            return new StringRef("athlon-fx");
                        }
                        case AMDATHLON_64: {
                            return new StringRef("athlon64");
                        }
                    }
                    return new StringRef("athlon");
                }
                case AMDFAM10H: {
                    if (Subtype.$star() == ProcessorSubtypes.AMDFAM10H_BARCELONA.getValue()) {
                        return new StringRef("barcelona");
                    }
                    return new StringRef("amdfam10");
                }
                case AMDFAM14H: {
                    return new StringRef("btver1");
                }
                case AMDFAM15H: {
                    switch (ProcessorSubtypes.valueOf(Subtype.$star())) {
                        case AMDFAM15H_BDVER1: {
                            return new StringRef("bdver1");
                        }
                        case AMDFAM15H_BDVER2: {
                            return new StringRef("bdver2");
                        }
                        case AMDFAM15H_BDVER3: {
                            return new StringRef("bdver3");
                        }
                        case AMDFAM15H_BDVER4: {
                            return new StringRef("bdver4");
                        }
                        case AMD_BTVER1: {
                            return new StringRef("btver1");
                        }
                    }
                    return new StringRef("amdfam15");
                }
                case AMDFAM16H: {
                    switch (ProcessorSubtypes.valueOf(Subtype.$star())) {
                        case AMD_BTVER1: {
                            return new StringRef("btver1");
                        }
                        case AMD_BTVER2: {
                            return new StringRef("btver2");
                        }
                    }
                    return new StringRef("amdfam16");
                }
            }
            return new StringRef(NativePointer.$generic);
        }
        return new StringRef(NativePointer.$generic);
    }

    public static boolean getHostCPUFeatures(StringMapBool Features) {
        uint.ptr EAX = NativePointer.create_uint$ptr((int)0);
        uint.ptr EBX = NativePointer.create_uint$ptr((int)0);
        uint.ptr ECX = NativePointer.create_uint$ptr((int)0);
        uint.ptr EDX = NativePointer.create_uint$ptr((int)0);
        uint.ptr MaxLevel = NativePointer.create_uint$ptr();
        class Unnamed_union {
            public int[] u = new int[3];
            public byte[] c = NativePointer.new$char((int)12, (byte[])new byte[0]);

            public String toString() {
                return "u=" + this.u + ", c=" + this.c;
            }
        }
        Unnamed_union text = new Unnamed_union();
        if (org.llvm.support.impl.HostStatics.getX86CpuIDAndInfo(0, (uint.ptr)Native.$AddrOf((Object)MaxLevel), (uint.ptr)NativePointer.create_uint$ptr((int[])text.u).$add(0), (uint.ptr)NativePointer.create_uint$ptr((int[])text.u).$add(2), (uint.ptr)NativePointer.create_uint$ptr((int[])text.u).$add(1)) || Unsigned.$less_uint((int)MaxLevel.$star(), (int)1)) {
            return false;
        }
        org.llvm.support.impl.HostStatics.getX86CpuIDAndInfo(1, (uint.ptr)Native.$AddrOf((Object)EAX), (uint.ptr)Native.$AddrOf((Object)EBX), (uint.ptr)Native.$AddrOf((Object)ECX), (uint.ptr)Native.$AddrOf((Object)EDX));
        Features.$set("cmov", (EDX.$star() >>> 15 & 1) != 0);
        Features.$set("mmx", (EDX.$star() >>> 23 & 1) != 0);
        Features.$set("sse", (EDX.$star() >>> 25 & 1) != 0);
        Features.$set("sse2", (EDX.$star() >>> 26 & 1) != 0);
        Features.$set("sse3", (ECX.$star() >>> 0 & 1) != 0);
        Features.$set("ssse3", (ECX.$star() >>> 9 & 1) != 0);
        Features.$set("sse4.1", (ECX.$star() >>> 19 & 1) != 0);
        Features.$set("sse4.2", (ECX.$star() >>> 20 & 1) != 0);
        Features.$set("pclmul", (ECX.$star() >>> 1 & 1) != 0);
        Features.$set("cx16", (ECX.$star() >>> 13 & 1) != 0);
        Features.$set("movbe", (ECX.$star() >>> 22 & 1) != 0);
        Features.$set("popcnt", (ECX.$star() >>> 23 & 1) != 0);
        Features.$set("aes", (ECX.$star() >>> 25 & 1) != 0);
        Features.$set("rdrnd", (ECX.$star() >>> 30 & 1) != 0);
        boolean HasAVXSave = (ECX.$star() >>> 27 & 1) != 0 && (ECX.$star() >>> 28 & 1) != 0 && !org.llvm.support.impl.HostStatics.getX86XCR0((uint.ptr)Native.$AddrOf((Object)EAX), (uint.ptr)Native.$AddrOf((Object)EDX)) && (EAX.$star() & 6) == 6;
        Features.$set("avx", HasAVXSave);
        Features.$set("fma", HasAVXSave && (ECX.$star() >>> 12 & 1) != 0);
        Features.$set("f16c", HasAVXSave && (ECX.$star() >>> 29 & 1) != 0);
        Features.$set("xsave", HasAVXSave && (ECX.$star() >>> 26 & 1) != 0);
        boolean HasAVX512Save = HasAVXSave && (EAX.$star() & 0xE0) == 224;
        uint.ptr MaxExtLevel = NativePointer.create_uint$ptr();
        org.llvm.support.impl.HostStatics.getX86CpuIDAndInfo(Integer.MIN_VALUE, (uint.ptr)Native.$AddrOf((Object)MaxExtLevel), (uint.ptr)Native.$AddrOf((Object)EBX), (uint.ptr)Native.$AddrOf((Object)ECX), (uint.ptr)Native.$AddrOf((Object)EDX));
        boolean HasExtLeaf1 = Unsigned.$greatereq_uint((int)MaxExtLevel.$star(), (int)-2147483647) && !org.llvm.support.impl.HostStatics.getX86CpuIDAndInfo(-2147483647, (uint.ptr)Native.$AddrOf((Object)EAX), (uint.ptr)Native.$AddrOf((Object)EBX), (uint.ptr)Native.$AddrOf((Object)ECX), (uint.ptr)Native.$AddrOf((Object)EDX));
        Features.$set("lzcnt", HasExtLeaf1 && (ECX.$star() >>> 5 & 1) != 0);
        Features.$set("sse4a", HasExtLeaf1 && (ECX.$star() >>> 6 & 1) != 0);
        Features.$set("prfchw", HasExtLeaf1 && (ECX.$star() >>> 8 & 1) != 0);
        Features.$set("xop", HasExtLeaf1 && (ECX.$star() >>> 11 & 1) != 0 && HasAVXSave);
        Features.$set("fma4", HasExtLeaf1 && (ECX.$star() >>> 16 & 1) != 0 && HasAVXSave);
        Features.$set("tbm", HasExtLeaf1 && (ECX.$star() >>> 21 & 1) != 0);
        Features.$set("mwaitx", HasExtLeaf1 && (ECX.$star() >>> 29 & 1) != 0);
        boolean HasLeaf7 = Unsigned.$greatereq_uint((int)MaxLevel.$star(), (int)7) && !org.llvm.support.impl.HostStatics.getX86CpuIDAndInfoEx(7, 0, (uint.ptr)Native.$AddrOf((Object)EAX), (uint.ptr)Native.$AddrOf((Object)EBX), (uint.ptr)Native.$AddrOf((Object)ECX), (uint.ptr)Native.$AddrOf((Object)EDX));
        Features.$set("avx2", HasAVXSave && HasLeaf7 && (EBX.$star() >>> 5 & 1) != 0);
        Features.$set("fsgsbase", HasLeaf7 && (EBX.$star() >>> 0 & 1) != 0);
        Features.$set("sgx", HasLeaf7 && (EBX.$star() >>> 2 & 1) != 0);
        Features.$set("bmi", HasLeaf7 && (EBX.$star() >>> 3 & 1) != 0);
        Features.$set("hle", HasLeaf7 && (EBX.$star() >>> 4 & 1) != 0);
        Features.$set("bmi2", HasLeaf7 && (EBX.$star() >>> 8 & 1) != 0);
        Features.$set("invpcid", HasLeaf7 && (EBX.$star() >>> 10 & 1) != 0);
        Features.$set("rtm", HasLeaf7 && (EBX.$star() >>> 11 & 1) != 0);
        Features.$set("rdseed", HasLeaf7 && (EBX.$star() >>> 18 & 1) != 0);
        Features.$set("adx", HasLeaf7 && (EBX.$star() >>> 19 & 1) != 0);
        Features.$set("smap", HasLeaf7 && (EBX.$star() >>> 20 & 1) != 0);
        Features.$set("pcommit", HasLeaf7 && (EBX.$star() >>> 22 & 1) != 0);
        Features.$set("clflushopt", HasLeaf7 && (EBX.$star() >>> 23 & 1) != 0);
        Features.$set("clwb", HasLeaf7 && (EBX.$star() >>> 24 & 1) != 0);
        Features.$set("sha", HasLeaf7 && (EBX.$star() >>> 29 & 1) != 0);
        Features.$set("avx512f", HasLeaf7 && (EBX.$star() >>> 16 & 1) != 0 && HasAVX512Save);
        Features.$set("avx512dq", HasLeaf7 && (EBX.$star() >>> 17 & 1) != 0 && HasAVX512Save);
        Features.$set("avx512ifma", HasLeaf7 && (EBX.$star() >>> 21 & 1) != 0 && HasAVX512Save);
        Features.$set("avx512pf", HasLeaf7 && (EBX.$star() >>> 26 & 1) != 0 && HasAVX512Save);
        Features.$set("avx512er", HasLeaf7 && (EBX.$star() >>> 27 & 1) != 0 && HasAVX512Save);
        Features.$set("avx512cd", HasLeaf7 && (EBX.$star() >>> 28 & 1) != 0 && HasAVX512Save);
        Features.$set("avx512bw", HasLeaf7 && (EBX.$star() >>> 30 & 1) != 0 && HasAVX512Save);
        Features.$set("avx512vl", HasLeaf7 && (EBX.$star() >>> 31 & 1) != 0 && HasAVX512Save);
        Features.$set("prefetchwt1", HasLeaf7 && (ECX.$star() & 1) != 0);
        Features.$set("avx512vbmi", HasLeaf7 && (ECX.$star() >>> 1 & 1) != 0 && HasAVX512Save);
        Features.$set("pku", HasLeaf7 && (ECX.$star() >>> 4 & 1) != 0);
        boolean HasLeafD = Unsigned.$greatereq_uint((int)MaxLevel.$star(), (int)13) && !org.llvm.support.impl.HostStatics.getX86CpuIDAndInfoEx(13, 1, (uint.ptr)Native.$AddrOf((Object)EAX), (uint.ptr)Native.$AddrOf((Object)EBX), (uint.ptr)Native.$AddrOf((Object)ECX), (uint.ptr)Native.$AddrOf((Object)EDX));
        Features.$set("xsaveopt", HasAVXSave && HasLeafD && (EAX.$star() >>> 0 & 1) != 0);
        Features.$set("xsavec", HasAVXSave && HasLeafD && (EAX.$star() >>> 1 & 1) != 0);
        Features.$set("xsaves", HasAVXSave && HasLeafD && (EAX.$star() >>> 3 & 1) != 0);
        return true;
    }
}

