/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.sys;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.sys.MutexImpl;

public class SmartMutex
implements Destructors.ClassWithDestructor {
    private MutexImpl impl;
    private final boolean mt_only;
    private int acquired;
    private boolean recursive;

    public SmartMutex(boolean mt_only) {
        this(mt_only, true);
    }

    public SmartMutex(boolean mt_only, boolean rec) {
        this.impl = new MutexImpl(rec);
        this.acquired = 0;
        this.recursive = rec;
        this.mt_only = mt_only;
    }

    public boolean lock() {
        if (!this.mt_only || AdtsupportLlvmGlobals.llvm_is_multithreaded()) {
            return this.impl.acquire();
        }
        assert (this.recursive || this.acquired == 0) : "Lock already acquired!!";
        ++this.acquired;
        return true;
    }

    public boolean unlock() {
        if (!this.mt_only || AdtsupportLlvmGlobals.llvm_is_multithreaded()) {
            return this.impl.release();
        }
        assert (this.recursive && this.acquired != 0 || this.acquired == 1) : "Lock not acquired before release!";
        --this.acquired;
        return true;
    }

    public boolean try_lock() {
        if (!this.mt_only || AdtsupportLlvmGlobals.llvm_is_multithreaded()) {
            return this.impl.tryacquire();
        }
        return true;
    }

    public void $destroy() {
        Native.destroy((Destructors.ClassWithDestructor)this.impl);
    }

    public boolean mt_only() {
        return this.mt_only;
    }

    public String toString() {
        return "impl=" + this.impl + ", acquired=" + this.acquired + ", recursive=" + this.recursive;
    }
}

