/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.built_in;
import org.clank.java.io;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVectorChar;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.support.FormattedNumber;
import org.llvm.support.FormattedString;
import org.llvm.support.format_object_base;
import org.llvm.support.llvm;

public abstract class raw_ostream
implements io.basic_ostream,
Destructors.ClassWithDestructor {
    private byte[] OutBufStart$Array;
    private char.ptr OutBufStart$CharPtr;
    private int OutBufStart$Index;
    private int OutBufEnd$Index;
    private int OutBufCur$Index;
    private BufferKind BufferMode;
    private static final byte[] NULL_ARRAY = NativePointer.new$char((int)0, (byte[])new byte[0]);
    private static final char.ptr NULL_BUF = NativePointer.create_char$ptr((byte[])NULL_ARRAY);
    private final char.ptr single_char = NativePointer.create_char$ptr((byte[])NativePointer.new$char$elem((byte)0));
    private static final int NUMBER_BUFFER_LENGTH = 20;
    private final char.ptr number_buffer = NativePointer.create_char$ptr((byte[])NativePointer.new$char((int)20, (byte[])new byte[0]));
    private static final String SPACES = "                                                                                ";
    private static final byte[] Spaces = "                                                                                ".getBytes();
    private static long NonOptimizedWriteBytesCalls = 0L;
    private static long NonOptimizedWriteBytesSize = 0L;

    private void $assign(raw_ostream $Prm0) {
        throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
    }

    private raw_ostream(raw_ostream $Prm0) {
        throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
    }

    public raw_ostream() {
        this(false);
    }

    public raw_ostream(boolean unbuffered) {
        this.BufferMode = unbuffered ? BufferKind.Unbuffered : BufferKind.InternalBuffer;
        this.OutBufStart$CharPtr = NULL_BUF;
        this.OutBufStart$Array = this.OutBufStart$CharPtr.$array();
        this.OutBufCur$Index = this.OutBufStart$Index = this.OutBufStart$CharPtr.$index();
        this.OutBufEnd$Index = this.OutBufStart$Index;
    }

    public void $destroy() {
        assert (this.OutBufCur$Index == this.OutBufStart$Index) : "raw_ostream destructor called with non-empty buffer!";
        if (this.BufferMode == BufferKind.InternalBuffer) {
            Destructors.$destroyArray((Object)this.OutBufStart$Array);
            this.OutBufStart$CharPtr = NULL_BUF;
            this.OutBufStart$Array = this.OutBufStart$CharPtr.$array();
            this.OutBufCur$Index = this.OutBufStart$Index = this.OutBufStart$CharPtr.$index();
            this.OutBufEnd$Index = this.OutBufStart$Index;
        }
    }

    public long tell() {
        return this.current_pos() + Unsigned.$uint2ullong((int)this.GetNumBytesInBuffer());
    }

    public void SetBuffered() {
        int Size = this.preferred_buffer_size();
        if (Size != 0) {
            this.SetBufferSize(Size);
        } else {
            this.SetUnbuffered();
        }
    }

    public void SetBufferSize(int Size) {
        assert (Size >= 0) : "forgot about unsigned conversion?";
        this.flush();
        this.SetBufferAndMode(NativePointer.create_char$ptr((byte[])NativePointer.new$char((int)Size, (byte[])new byte[0])), Size, BufferKind.InternalBuffer);
    }

    public int GetBufferSize() {
        if (this.BufferMode != BufferKind.Unbuffered && this.OutBufStart$Array == NULL_ARRAY) {
            return this.preferred_buffer_size();
        }
        return this.OutBufEnd$Index - this.OutBufStart$Index;
    }

    public final void SetUnbuffered() {
        this.flush();
        this.SetBufferAndMode(null, 0, BufferKind.Unbuffered);
    }

    public int GetNumBytesInBuffer() {
        return this.OutBufCur$Index - this.OutBufStart$Index;
    }

    public void flush() {
        if (this.OutBufCur$Index != this.OutBufStart$Index) {
            this.flush_nonempty();
        }
    }

    public final raw_ostream $out(boolean b) {
        return this.$out_char(b ? (byte)49 : 48);
    }

    public final raw_ostream $out_char(byte C2) {
        if (this.OutBufCur$Index >= this.OutBufEnd$Index) {
            return this.write(C2);
        }
        this.OutBufStart$Array[this.OutBufCur$Index++] = C2;
        return this;
    }

    public final raw_ostream $out_uchar(byte C2) {
        if (this.OutBufCur$Index >= this.OutBufEnd$Index) {
            return this.write(C2);
        }
        this.OutBufStart$Array[this.OutBufCur$Index++] = C2;
        return this;
    }

    public final raw_ostream $out_schar(byte C2) {
        if (this.OutBufCur$Index >= this.OutBufEnd$Index) {
            return this.write(C2);
        }
        this.OutBufStart$Array[this.OutBufCur$Index++] = C2;
        return this;
    }

    public final raw_ostream $out(StringRef Str) {
        int Size = Str.size();
        if (Size > this.OutBufEnd$Index - this.OutBufCur$Index) {
            return this.write(Str.data(), Size);
        }
        std.memcpy((byte[])this.OutBufStart$Array, (int)this.OutBufCur$Index, (char.ptr)Str.data(), (int)0, (int)Size);
        this.OutBufCur$Index += Size;
        return this;
    }

    public final raw_ostream $out(char.ptr Str) {
        return this.$out(Str, std.strlen((char.ptr)Str));
    }

    public final raw_ostream $out(char.ptr Str, int Len) {
        return this.$out(new StringRef(Str, Len));
    }

    public final raw_ostream $out(String Str) {
        return this.$out(new StringRef(Str));
    }

    public final raw_ostream $out(std.string Str) {
        return this.write(Str.data(), Str.length());
    }

    public final raw_ostream $out(SmallString Str) {
        return this.write(Str.$array(), 0, Str.size());
    }

    public raw_ostream $out(NativeCallback.Void2String o) {
        return this.$out(o.$call());
    }

    public raw_ostream $out(byte o) {
        return this.$out_schar(o);
    }

    public raw_ostream $out(char o) {
        return this.$out_uint(o);
    }

    public raw_ostream $out(int o) {
        return this.$out_int(o);
    }

    public raw_ostream $out(long o) {
        return this.$out_long(o);
    }

    public raw_ostream $out(double o) {
        return this.$out_double(o);
    }

    public raw_ostream $out(String format, Object ... args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public raw_ostream $out_os_str(std.string str) {
        return this.$out(str);
    }

    public final raw_ostream $out_ulong(long N) {
        if (N == 0L) {
            return (raw_ostream)Native.$Deref((Object)this.$out_char((byte)48));
        }
        int CurPtr = 20;
        while (N != 0L) {
            this.number_buffer.$set(--CurPtr, (byte)(48 + (byte)Unsigned.$rem_ulong((long)N, (long)10L)));
            N = Unsigned.$div_ulong((long)N, (long)10L);
        }
        return this.write(this.number_buffer, CurPtr, 20 - CurPtr);
    }

    public final raw_ostream $out_ulong$formatted(long N) {
        return this.$out(NativeTrace.formatNumber((long)N));
    }

    public final raw_ostream $out_long(long N) {
        if (N < 0L) {
            Native.$Deref((Object)this.$out_char((byte)45));
            N = -N;
        }
        return this.$out_ulong(N);
    }

    public raw_ostream $out_ullong(long N) {
        if (N >= 0L) {
            return this.$out_ulong(N);
        }
        assert (false) : "JAVA: implement it using BigInteger (was fixing SA_LOCAL_SELF_COMPARISON)";
        int CurPtr = 20;
        while (N != 0L) {
            this.number_buffer.$set(--CurPtr, (byte)(48 + (byte)Unsigned.$rem_ullong((long)N, (long)10L)));
            N = Unsigned.$div_ullong((long)N, (long)10L);
        }
        return this.write(this.number_buffer, CurPtr, 20 - CurPtr);
    }

    public final raw_ostream $out_llong(long N) {
        if (N < 0L) {
            Native.$Deref((Object)this.$out_char((byte)45));
            N = -N;
        }
        return this.$out_ullong(N);
    }

    public final raw_ostream $out_hex(long P2) {
        Native.$Deref((Object)this.$out_char((byte)48).$out_char((byte)120));
        return this.write_hex_impl(P2, 0);
    }

    public final raw_ostream $out(Object P2) {
        Native.$Deref((Object)this.$out_char((byte)48).$out_char((byte)120));
        return this.write_hex_impl(System.identityHashCode(P2), 8);
    }

    public final raw_ostream $out_uint(int N) {
        return this.$out_ulong(Unsigned.$uint2long((int)N));
    }

    public final raw_ostream $out_uint(uint.ref N) {
        return this.$out_uint(N.$deref());
    }

    public final raw_ostream $out_uint$formatted(int N) {
        return this.$out_ulong$formatted(Unsigned.$uint2long((int)N));
    }

    public final raw_ostream $out_uint(boolean b) {
        return this.$out_ulong(b ? 1L : 0L);
    }

    public final raw_ostream $out_int(int N) {
        return this.$out_long(N);
    }

    public final raw_ostream $out_double(double N) {
        return this.$out(String.format("%e", N));
    }

    public final raw_ostream $out(format_object_base Fmt) {
        SmallVectorImplChar V = null;
        try {
            int BytesUsed;
            int NextBufferSize = 127;
            int BufferBytesLeft = this.OutBufEnd$Index - this.OutBufCur$Index;
            if (BufferBytesLeft > 3) {
                BytesUsed = Fmt.print((char.ptr)this.OutBufStart$CharPtr.$add(this.OutBufCur$Index), BufferBytesLeft);
                if (BytesUsed <= BufferBytesLeft) {
                    this.OutBufCur$Index += BytesUsed;
                    raw_ostream raw_ostream2 = this;
                    return raw_ostream2;
                }
                NextBufferSize = BytesUsed;
            }
            V = new SmallVectorChar(128);
            while (true) {
                V.resize(NextBufferSize);
                BytesUsed = Fmt.print(V.data(), NextBufferSize);
                if (BytesUsed <= NextBufferSize) {
                    raw_ostream raw_ostream3 = this.write(V.data(), BytesUsed);
                    return raw_ostream3;
                }
                assert (BytesUsed > NextBufferSize) : "Didn't grow buffer!?";
                NextBufferSize = BytesUsed;
            }
        }
        finally {
            if (V != null) {
                V.$destroy();
            }
        }
    }

    public final raw_ostream $out(FormattedString FS) {
        int Len = FS.Str.size();
        int PadAmount = FS.Width - Len;
        if (FS.RightJustify && PadAmount > 0) {
            this.indent(PadAmount);
        }
        this.$out(new StringRef(FS.Str));
        if (!FS.RightJustify && PadAmount > 0) {
            this.indent(PadAmount);
        }
        return this;
    }

    public final raw_ostream $out(FormattedNumber FN) {
        long N;
        if (FN.Hex) {
            int Width;
            int Nibbles = (64 - llvm.countLeadingZeros_uint64_t_ZeroBehavior(FN.HexValue) + 3) / 4;
            assert (Nibbles >= 0) : "Nibbles must not be negatove: " + Nibbles;
            int n = Width = FN.Width > Nibbles + 2 ? FN.Width : Nibbles + 2;
            assert (Width >= 0) : "Width must not be negatove: " + Width;
            byte[] NumberBuffer = NativePointer.new$char((int)20, (byte[])new byte[]{48, 120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48});
            char.ptr EndPtr = NativePointer.create_char$ptr((byte[])NumberBuffer, (int)Width);
            char.ptr CurPtr = Native.$tryClone((char.ptr)EndPtr);
            int A = FN.Upper ? 65 : 97;
            long N2 = FN.HexValue;
            while (N2 != 0L) {
                long x = Unsigned.$rem_ullong((long)N2, (long)16L);
                ((char.ptr)CurPtr.$preDec()).$set(x < 10L ? (byte)(48L + x) : (byte)((long)A + x - 10L));
                N2 = Unsigned.$div_ullong((long)N2, (long)16L);
            }
            return this.write(NumberBuffer, 0, Width);
        }
        if (FN.DecValue == 0L) {
            this.indent(FN.Width - 1);
            return (raw_ostream)Native.$Deref((Object)this.$out_char((byte)48));
        }
        byte[] NumberBuffer = NativePointer.new$char((int)32, (byte[])new byte[0]);
        char.ptr EndPtr = NativePointer.create_char$ptr((byte[])NumberBuffer, (int)32);
        char.ptr CurPtr = Native.$tryClone((char.ptr)EndPtr);
        boolean Neg2 = FN.DecValue < 0L;
        long l = N = Neg2 ? -FN.DecValue : FN.DecValue;
        while (N != 0L) {
            ((char.ptr)CurPtr.$preDec()).$set((byte)(48 + (byte)Unsigned.$rem_ulong((long)N, (long)10L)));
            N = Unsigned.$div_ulong((long)N, (long)10L);
        }
        int Len = EndPtr.$sub((abstract_iterator)CurPtr);
        int Pad = FN.Width - Len;
        if (Neg2) {
            --Pad;
        }
        if (Pad > 0) {
            this.indent(Pad);
        }
        if (Neg2) {
            Native.$Deref((Object)this.$out_char((byte)45));
        }
        return this.write(CurPtr, Len);
    }

    public final raw_ostream write_hex(long N) {
        return this.write_hex_impl(N, 0);
    }

    private final raw_ostream write_hex_impl(long N, int printAtLeastDigitsAmount) {
        if (N == 0L) {
            return (raw_ostream)Native.$Deref((Object)this.$out_char((byte)48));
        }
        int CurPtr = 20;
        while (N != 0L) {
            long x = Unsigned.$rem_ullong((long)N, (long)16L);
            this.number_buffer.$set(--CurPtr, (byte)(x < 10L ? 48L + x : 97L + x - 10L));
            N = Unsigned.$div_ullong((long)N, (long)16L);
            --printAtLeastDigitsAmount;
        }
        while (printAtLeastDigitsAmount-- > 0) {
            this.number_buffer.$set(--CurPtr, (byte)48);
        }
        return this.write(this.number_buffer, CurPtr, 20 - CurPtr);
    }

    public final raw_ostream write_escaped(StringRef Str) {
        return this.write_escaped(Str, false);
    }

    public final raw_ostream write_escaped(StringRef Str, boolean UseHexEscapes) {
        int e = Str.size();
        block6: for (int i = 0; i != e; ++i) {
            byte c = Str.$at(i);
            switch (c) {
                case 92: {
                    Native.$Deref((Object)this.$out_char((byte)92).$out_char((byte)92));
                    continue block6;
                }
                case 9: {
                    Native.$Deref((Object)this.$out_char((byte)92).$out_char((byte)116));
                    continue block6;
                }
                case 10: {
                    Native.$Deref((Object)this.$out_char((byte)92).$out_char((byte)110));
                    continue block6;
                }
                case 34: {
                    Native.$Deref((Object)this.$out_char((byte)92).$out_char((byte)34));
                    continue block6;
                }
                default: {
                    if (std.isprint((byte)c) != 0) {
                        Native.$Deref((Object)this.$out_uchar(c));
                        continue block6;
                    }
                    if (UseHexEscapes) {
                        Native.$Deref((Object)this.$out_char((byte)92).$out_char((byte)120));
                        Native.$Deref((Object)this.$out_char(llvm.hexdigit(c >>> 4 & 0xF)));
                        Native.$Deref((Object)this.$out_char(llvm.hexdigit(c >>> 0 & 0xF)));
                        continue block6;
                    }
                    Native.$Deref((Object)this.$out_char((byte)92));
                    Native.$Deref((Object)this.$out_char((byte)(48 + (c >>> 6 & 7))));
                    Native.$Deref((Object)this.$out_char((byte)(48 + (c >>> 3 & 7))));
                    Native.$Deref((Object)this.$out_char((byte)(48 + (c >>> 0 & 7))));
                }
            }
        }
        return this;
    }

    public final raw_ostream write(byte C2) {
        if (built_in.__builtin_expect((this.OutBufCur$Index >= this.OutBufEnd$Index ? 1 : 0) != 0, (boolean)false) != 0) {
            if (built_in.__builtin_expect((this.OutBufStart$Array == NULL_ARRAY ? 1 : 0) != 0, (boolean)false) != 0) {
                if (this.BufferMode == BufferKind.Unbuffered) {
                    this.single_char.$set(0, Native.$AddrOf((byte)C2));
                    this.write_impl(this.single_char, 0, 1);
                    return this;
                }
                this.SetBuffered();
                return this.write(C2);
            }
            this.flush_nonempty();
        }
        this.OutBufStart$Array[this.OutBufCur$Index++] = C2;
        return this;
    }

    public final raw_ostream write(String Str, int Size) {
        return this.write(NativePointer.create_char$ptr((CharSequence)Str), 0, Size);
    }

    public final raw_ostream write(byte[] Ptr2, int PtrIdx, int Size) {
        return this.writeBytes(Ptr2, PtrIdx, Size);
    }

    private raw_ostream writeBytes(byte[] Ptr2, int PtrIdx, int Size) {
        assert (Size >= 0) : "forgot about unsigned conversion?";
        if (built_in.__builtin_expect((this.OutBufEnd$Index - this.OutBufCur$Index < Size ? 1 : 0) != 0, (boolean)false) != 0) {
            if (built_in.__builtin_expect((this.OutBufStart$Array == NULL_ARRAY ? 1 : 0) != 0, (boolean)false) != 0) {
                if (this.BufferMode == BufferKind.Unbuffered) {
                    this.write_impl(Ptr2, PtrIdx, Size);
                    return this;
                }
                this.SetBuffered();
                return this.writeBytes(Ptr2, PtrIdx, Size);
            }
            int NumBytes = this.OutBufEnd$Index - this.OutBufCur$Index;
            if (built_in.__builtin_expect((this.OutBufCur$Index == this.OutBufStart$Index ? 1 : 0) != 0, (boolean)false) != 0) {
                assert (NumBytes != 0) : "undefined behavior";
                int BytesToWrite = Size - Size % NumBytes;
                this.write_impl(Ptr2, PtrIdx, BytesToWrite);
                int BytesRemaining = Size - BytesToWrite;
                if (BytesRemaining > this.OutBufEnd$Index - this.OutBufCur$Index) {
                    return this.writeBytes(Ptr2, PtrIdx + BytesToWrite, BytesRemaining);
                }
                this.copy_to_buffer(Ptr2, PtrIdx + BytesToWrite, BytesRemaining);
                return this;
            }
            this.copy_to_buffer(Ptr2, PtrIdx, NumBytes);
            this.flush_nonempty();
            return this.writeBytes(Ptr2, PtrIdx + NumBytes, Size - NumBytes);
        }
        this.copy_to_buffer(Ptr2, PtrIdx, Size);
        return this;
    }

    public final raw_ostream write(char.iterator Ptr2, int Size) {
        byte[] buf = new byte[Size];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = Ptr2.$star();
            Ptr2.$postInc();
        }
        return this.write(buf, 0, Size);
    }

    public final raw_ostream write(char.ptr Ptr2, int Size) {
        return this.write(Ptr2, 0, Size);
    }

    public final raw_ostream write(char.ptr Ptr2, int PtrIdx, int Size) {
        if (Native.$is_array_based((char.ptr)Ptr2)) {
            return this.writeBytes(Ptr2.$array(), Ptr2.$index() + PtrIdx, Size);
        }
        return this.writeCharPtr(Ptr2, PtrIdx, Size);
    }

    private raw_ostream writeCharPtr(char.ptr Ptr2, int PtrIdx, int Size) {
        assert (Size >= 0) : "forgot about unsigned conversion?";
        if (built_in.__builtin_expect((this.OutBufEnd$Index - this.OutBufCur$Index < Size ? 1 : 0) != 0, (boolean)false) != 0) {
            if (built_in.__builtin_expect((this.OutBufStart$Array == NULL_ARRAY ? 1 : 0) != 0, (boolean)false) != 0) {
                if (this.BufferMode == BufferKind.Unbuffered) {
                    this.write_impl(Ptr2, PtrIdx, Size);
                    return this;
                }
                this.SetBuffered();
                return this.write(Ptr2, PtrIdx, Size);
            }
            int NumBytes = this.OutBufEnd$Index - this.OutBufCur$Index;
            if (built_in.__builtin_expect((this.OutBufCur$Index == this.OutBufStart$Index ? 1 : 0) != 0, (boolean)false) != 0) {
                assert (NumBytes != 0) : "undefined behavior";
                int BytesToWrite = Size - Size % NumBytes;
                this.write_impl(Ptr2, PtrIdx, BytesToWrite);
                int BytesRemaining = Size - BytesToWrite;
                if (BytesRemaining > this.OutBufEnd$Index - this.OutBufCur$Index) {
                    return this.write(Ptr2, PtrIdx + BytesToWrite, BytesRemaining);
                }
                this.copy_to_buffer(Ptr2, PtrIdx + BytesToWrite, BytesRemaining);
                return this;
            }
            this.copy_to_buffer(Ptr2, PtrIdx, NumBytes);
            this.flush_nonempty();
            return this.write(Ptr2, PtrIdx + NumBytes, Size - NumBytes);
        }
        this.copy_to_buffer(Ptr2, PtrIdx, Size);
        return this;
    }

    public final raw_ostream indent(int NumSpaces) {
        assert (NumSpaces >= 0) : "forgot about unsigned conversion?";
        if (NumSpaces < llvm.array_lengthof(SPACES)) {
            return this.writeBytes(Spaces, 0, NumSpaces);
        }
        while (NumSpaces != 0) {
            int NumToWrite = std.min((int)NumSpaces, (int)(llvm.array_lengthof(SPACES) - 1));
            this.writeBytes(Spaces, 0, NumToWrite);
            NumSpaces -= NumToWrite;
        }
        return this;
    }

    public raw_ostream changeColor(Colors Color) {
        return this.changeColor(Color, false, false);
    }

    public raw_ostream changeColor(Colors Color, boolean Bold) {
        return this.changeColor(Color, Bold, false);
    }

    public raw_ostream changeColor(Colors Color, boolean Bold, boolean BG) {
        return this;
    }

    public raw_ostream resetColor() {
        return this;
    }

    public raw_ostream reverseColor() {
        return this;
    }

    public boolean is_displayed() {
        return false;
    }

    public boolean has_colors() {
        return this.is_displayed();
    }

    protected abstract void write_impl(char.ptr var1, int var2, int var3);

    protected void write_impl(byte[] Ptr2, int PtrIdx, int Size) {
        raw_ostream.trackNonOptimizedWriteBytes(Size);
        this.write_impl(NativePointer.create_char$ptr((byte[])Ptr2), PtrIdx, Size);
    }

    protected void handle() {
    }

    protected abstract long current_pos();

    protected void SetBuffer(char.ptr BufferStart, int Size) {
        this.SetBufferAndMode(BufferStart, Size, BufferKind.ExternalBuffer);
    }

    protected int preferred_buffer_size() {
        return 1024;
    }

    protected final char.ptr getBufferStart() {
        return this.OutBufStart$CharPtr == NULL_BUF ? null : this.OutBufStart$CharPtr;
    }

    private void SetBufferAndMode(char.ptr BufferStart, int Size, BufferKind Mode) {
        assert (Size >= 0) : "forgot about unsigned conversion?";
        assert (Mode == BufferKind.Unbuffered && BufferStart == null && Size == 0 || Mode != BufferKind.Unbuffered && BufferStart != null && Size != 0) : "stream must be unbuffered or have at least one byte";
        assert (this.GetNumBytesInBuffer() == 0) : "Current buffer is non-empty!";
        if (this.BufferMode == BufferKind.InternalBuffer) {
            Destructors.$destroyArray((Object)this.OutBufStart$Array);
            this.OutBufStart$CharPtr = NULL_BUF;
            this.OutBufStart$Array = NULL_ARRAY;
        }
        char.ptr ptr2 = this.OutBufStart$CharPtr = BufferStart == null ? NULL_BUF : BufferStart;
        assert (this.OutBufStart$CharPtr.$array() != null);
        this.OutBufStart$Array = this.OutBufStart$CharPtr.$array();
        this.OutBufCur$Index = this.OutBufStart$Index = this.OutBufStart$CharPtr.$index();
        this.OutBufEnd$Index = this.OutBufStart$Index + Size;
        this.BufferMode = Mode;
        assert (this.OutBufStart$Index <= this.OutBufEnd$Index) : "Invalid size!";
    }

    private void flush_nonempty() {
        assert (this.OutBufCur$Index > this.OutBufStart$Index) : "Invalid call to flush_nonempty.";
        int Length = this.OutBufCur$Index - this.OutBufStart$Index;
        this.OutBufCur$Index = this.OutBufStart$Index;
        this.write_impl(this.OutBufStart$Array, this.OutBufCur$Index, Length);
    }

    private void copy_to_buffer(char.ptr Ptr2, int PtrIdx, int Size) {
        assert (Size >= 0) : "forgot about unsigned conversion?";
        assert (Size <= this.OutBufEnd$Index - this.OutBufCur$Index) : "Buffer overrun!";
        std.memcpy((byte[])this.OutBufStart$Array, (int)this.OutBufCur$Index, (char.ptr)Ptr2, (int)PtrIdx, (int)Size);
        this.OutBufCur$Index += Size;
    }

    private void copy_to_buffer(byte[] Ptr2, int PtrIdx, int Size) {
        assert (Size >= 0) : "forgot about unsigned conversion?";
        assert (Size <= this.OutBufEnd$Index - this.OutBufCur$Index) : "Buffer overrun!";
        std.memcpy((byte[])this.OutBufStart$Array, (int)this.OutBufCur$Index, (byte[])Ptr2, (int)PtrIdx, (int)Size);
        this.OutBufCur$Index += Size;
    }

    public String toString() {
        return "raw_ostream{BufferMode=" + (Object)((Object)this.BufferMode) + "\nStart=" + NativePointer.create_char$ptr((byte[])this.OutBufStart$Array) + "\nCur=" + this.OutBufCur$Index + "End=" + this.OutBufEnd$Index + '}';
    }

    private static void trackNonOptimizedWriteBytes(int Size) {
        if (NativeTrace.STATISTICS) {
            ++NonOptimizedWriteBytesCalls;
            NonOptimizedWriteBytesSize += (long)Size;
        }
    }

    public static void clearStatistics() {
        NonOptimizedWriteBytesCalls = 0L;
        NonOptimizedWriteBytesSize = 0L;
    }

    public static long PrintStats(raw_ostream out) {
        out.$out(String.format("%22s called:\t", "slow write_impl(byte[])")).$out(NativeTrace.formatNumber((long)NonOptimizedWriteBytesCalls)).$out(".\n");
        out.$out(String.format("%22s  Bytes:\t", "slow write_impl(byte[])")).$out(NativeTrace.formatNumber((long)NonOptimizedWriteBytesSize)).$out(".\n");
        NativeTrace.dumpStatisticValue((String)"RawOStreamNonOptimalWrites", (long)NonOptimizedWriteBytesCalls);
        NativeTrace.dumpStatisticValue((String)"RawOStreamNonOptimalWrittenBytes", (long)NonOptimizedWriteBytesSize);
        return NonOptimizedWriteBytesCalls + NonOptimizedWriteBytesSize;
    }

    public static final class Colors
    extends Enum<Colors> {
        public static final /* enum */ Colors BLACK = new Colors(0);
        public static final /* enum */ Colors RED = new Colors(1);
        public static final /* enum */ Colors GREEN = new Colors(2);
        public static final /* enum */ Colors YELLOW = new Colors(3);
        public static final /* enum */ Colors BLUE = new Colors(4);
        public static final /* enum */ Colors MAGENTA = new Colors(5);
        public static final /* enum */ Colors CYAN = new Colors(6);
        public static final /* enum */ Colors WHITE = new Colors(7);
        public static final /* enum */ Colors SAVEDCOLOR = new Colors(8);
        private final int value;
        private static final /* synthetic */ Colors[] $VALUES;

        public static Colors[] values() {
            return (Colors[])$VALUES.clone();
        }

        public static Colors valueOf(String name) {
            return Enum.valueOf(Colors.class, name);
        }

        public static Colors valueOf(int val) {
            Colors out;
            Colors colors = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private Colors(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Colors[]{BLACK, RED, GREEN, YELLOW, BLUE, MAGENTA, CYAN, WHITE, SAVEDCOLOR};
        }

        private static final class Values {
            private static final Colors[] VALUES;
            private static final Colors[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Colors kind : Colors.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Colors[min < 0 ? 1 - min : 0];
                VALUES = new Colors[max >= 0 ? 1 + max : 0];
                for (Colors kind : Colors.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Colors)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Colors)kind).value] = kind;
                }
            }
        }
    }

    private static final class BufferKind
    extends Enum<BufferKind> {
        public static final /* enum */ BufferKind Unbuffered = new BufferKind(0);
        public static final /* enum */ BufferKind InternalBuffer = new BufferKind(1);
        public static final /* enum */ BufferKind ExternalBuffer = new BufferKind(2);
        private final int value;
        private static final /* synthetic */ BufferKind[] $VALUES;

        public static BufferKind[] values() {
            return (BufferKind[])$VALUES.clone();
        }

        public static BufferKind valueOf(String name) {
            return Enum.valueOf(BufferKind.class, name);
        }

        public static BufferKind valueOf(int val) {
            BufferKind out;
            BufferKind bufferKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private BufferKind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new BufferKind[]{Unbuffered, InternalBuffer, ExternalBuffer};
        }

        private static final class Values {
            private static final BufferKind[] VALUES;
            private static final BufferKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (BufferKind kind : BufferKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new BufferKind[min < 0 ? 1 - min : 0];
                VALUES = new BufferKind[max >= 0 ? 1 + max : 0];
                for (BufferKind kind : BufferKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((BufferKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((BufferKind)kind).value] = kind;
                }
            }
        }
    }
}

