/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.io;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.llvm.adt.StringRef;
import org.llvm.support.impl.raw_ostreamStatics;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.raw_pwrite_stream;
import org.llvm.support.sys.Process;

public class raw_fd_ostream
extends raw_pwrite_stream
implements Destructors.ClassWithDestructor {
    private int FD;
    private boolean ShouldClose;
    private boolean Error;
    private long pos;
    private boolean SupportsSeeking;

    @Override
    protected void write_impl(char.ptr Ptr2, int PtrIdx, int Size) {
        assert (this.FD >= 0) : "File already closed.";
        this.pos += Unsigned.$uint2ullong((int)Size);
        boolean ShouldWriteInChunks = false;
        int Ptr$Index = Ptr2.$index() + PtrIdx;
        do {
            long ret;
            int ChunkSize;
            if (Unsigned.$greater_uint((int)(ChunkSize = Size), (int)Short.MAX_VALUE) && ShouldWriteInChunks) {
                ChunkSize = Short.MAX_VALUE;
            }
            if ((ret = io.write((int)this.FD, (char.ptr)Ptr2, (int)Ptr$Index, (int)ChunkSize)) < 0L) {
                if (std.errno() == 4 || std.errno() == 11 || std.errno() == 11) continue;
                this.error_detected();
                break;
            }
            Ptr$Index += Unsigned.$ulong2uint((long)ret);
            Size = (int)((long)Size - ret);
        } while (Size > 0);
    }

    @Override
    protected void pwrite_impl(char.ptr Ptr2, int Size, long Offset) {
        long Pos2 = this.tell();
        this.seek(Offset);
        this.write(Ptr2, Size);
        this.seek(Pos2);
    }

    @Override
    protected void write_impl(byte[] Ptr2, int PtrIndex, int Size) {
        assert (this.FD >= 0) : "File already closed.";
        this.pos += (long)Size;
        boolean ShouldWriteInChunks = false;
        do {
            long ret;
            int ChunkSize;
            if (Unsigned.$greater_uint((int)(ChunkSize = Size), (int)Short.MAX_VALUE) && ShouldWriteInChunks) {
                ChunkSize = Short.MAX_VALUE;
            }
            if ((ret = io.write((int)this.FD, (byte[])Ptr2, (int)PtrIndex, (int)ChunkSize)) < 0L) {
                if (std.errno() == 4 || std.errno() == 11 || std.errno() == 11) continue;
                this.error_detected();
                break;
            }
            PtrIndex = (int)((long)PtrIndex + ret);
            Size = (int)((long)Size - ret);
        } while (Size > 0);
    }

    @Override
    protected long current_pos() {
        return this.pos;
    }

    @Override
    protected int preferred_buffer_size() {
        assert (this.FD >= 0) : "File not yet open!";
        io.stat statbuf = new io.stat();
        if (std.fstat((int)this.FD, (io.stat)((io.stat)Native.$AddrOf((Object)statbuf))) != 0) {
            return 0;
        }
        if (std.S_ISCHR((long)statbuf.st_mode) && std.isatty((int)this.FD) != 0) {
            return 0;
        }
        return statbuf.st_blksize;
    }

    private void error_detected() {
        this.Error = true;
    }

    public raw_fd_ostream(std.string Filename, std_errors.error_code EC, int Flags) {
        this(new StringRef(Filename), EC, Flags);
    }

    public raw_fd_ostream(char.ptr Filename, std_errors.error_code EC, int Flags) {
        this(new StringRef(Filename), EC, Flags);
    }

    public raw_fd_ostream(StringRef Filename, std_errors.error_code EC, int Flags) {
        this(raw_ostreamStatics.getFD(Filename, EC, Flags), true);
    }

    public raw_fd_ostream(int.ref fd, boolean shouldClose) {
        this(fd.$deref(), shouldClose);
    }

    public raw_fd_ostream(int fd, boolean shouldClose) {
        this(fd, shouldClose, false);
    }

    public raw_fd_ostream(int.ref fd, boolean shouldClose, boolean unbuffered) {
        this(fd.$deref(), shouldClose, unbuffered);
    }

    public raw_fd_ostream(int fd, boolean shouldClose, boolean unbuffered) {
        super(unbuffered);
        this.FD = fd;
        this.ShouldClose = shouldClose;
        this.Error = false;
        if (this.FD < 0) {
            this.ShouldClose = false;
            return;
        }
        long loc = std.lseek((int)this.FD, (long)0L, (int)1);
        this.SupportsSeeking = loc != -1L;
        this.pos = !this.SupportsSeeking ? 0L : Unsigned.$long2ulong((long)loc);
    }

    @Override
    public void $destroy() {
        if (this.FD >= 0) {
            this.flush();
            if (this.ShouldClose && Process.SafelyCloseFileDescriptor(this.FD).$bool()) {
                this.error_detected();
            }
        }
        if (this.has_error()) {
            llvm.report_fatal_error(NativePointer.$((String)"IO failure on output stream."), false);
        }
        super.$destroy();
    }

    public void close() {
        assert (this.ShouldClose);
        this.ShouldClose = false;
        this.flush();
        if (Process.SafelyCloseFileDescriptor(this.FD).$bool()) {
            this.error_detected();
        }
        this.FD = -1;
    }

    public boolean supportsSeeking() {
        return this.SupportsSeeking;
    }

    public long seek(long off) {
        assert (this.SupportsSeeking) : "Stream does not support seeking!";
        this.flush();
        this.pos = Unsigned.$long2ulong((long)std.lseek((int)this.FD, (long)Unsigned.$ulong2long((long)off), (int)0));
        if (this.pos == Unsigned.$int2ulong((int)-1)) {
            this.error_detected();
        }
        return this.pos;
    }

    @Override
    public raw_ostream changeColor(raw_ostream.Colors colors) {
        return this.changeColor(colors, false, false);
    }

    @Override
    public raw_ostream changeColor(raw_ostream.Colors colors, boolean bold) {
        return this.changeColor(colors, bold, false);
    }

    @Override
    public raw_ostream changeColor(raw_ostream.Colors colors, boolean bold, boolean bg) {
        char.ptr colorcode;
        if (Process.ColorNeedsFlush()) {
            this.flush();
        }
        char.ptr ptr2 = colorcode = colors == raw_ostream.Colors.SAVEDCOLOR ? Process.OutputBold(bg) : Process.OutputColor(colors.getValue(), bold, bg);
        if (colorcode != null) {
            int len = std.strlen((char.ptr)colorcode);
            this.write(colorcode, 0, len);
            this.pos -= Unsigned.$uint2ullong((int)len);
        }
        return this;
    }

    @Override
    public raw_ostream resetColor() {
        char.ptr colorcode;
        if (Process.ColorNeedsFlush()) {
            this.flush();
        }
        if ((colorcode = Process.ResetColor()) != null) {
            int len = std.strlen((char.ptr)colorcode);
            this.write(colorcode, 0, len);
            this.pos -= Unsigned.$uint2ullong((int)len);
        }
        return this;
    }

    @Override
    public raw_ostream reverseColor() {
        char.ptr colorcode;
        if (Process.ColorNeedsFlush()) {
            this.flush();
        }
        if ((colorcode = Process.OutputReverse()) != null) {
            int len = std.strlen((char.ptr)colorcode);
            this.write(colorcode, 0, len);
            this.pos -= Unsigned.$uint2ullong((int)len);
        }
        return this;
    }

    @Override
    public boolean is_displayed() {
        return Process.FileDescriptorIsDisplayed(this.FD);
    }

    @Override
    public boolean has_colors() {
        return Process.FileDescriptorHasColors(this.FD);
    }

    public boolean has_error() {
        return this.Error;
    }

    public void clear_error() {
        this.Error = false;
    }

    @Override
    public String toString() {
        return "FD=" + this.FD + ", ShouldClose=" + this.ShouldClose + ", Error=" + this.Error + ", pos=" + this.pos + ", SupportsSeeking=" + this.SupportsSeeking + super.toString();
    }
}

