/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.impl;

import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.support.raw_ostream;

public final class LEB128LlvmGlobals {
    public static void encodeSLEB128(long Value, raw_ostream OS) {
        boolean More;
        do {
            byte Byte2 = Unsigned.$long2uchar((long)(Value & 0x7FL));
            boolean bl = More = !((Value >>= 7) == 0L && (Unsigned.$uchar2int((byte)Byte2) & 0x40) == 0 || Value == -1L && (Unsigned.$uchar2int((byte)Byte2) & 0x40) != 0);
            if (More) {
                Byte2 = (byte)(Byte2 | 0x80);
            }
            OS.$out_char(Byte2);
        } while (More);
    }

    public static void encodeULEB128(long Value, raw_ostream OS) {
        LEB128LlvmGlobals.encodeULEB128(Value, OS, 0);
    }

    public static void encodeULEB128(long Value, raw_ostream OS, int Padding) {
        do {
            byte Byte2 = Unsigned.$ullong2uchar((long)(Value & Unsigned.$int2ullong((int)127)));
            if ((Value >>>= 7) != Unsigned.$int2ullong((int)0) || Padding != 0) {
                Byte2 = (byte)(Byte2 | 0x80);
            }
            OS.$out_char(Byte2);
        } while (Value != Unsigned.$int2ullong((int)0));
        if (Padding != 0) {
            while (Padding != 1) {
                OS.$out_char((byte)-128);
                --Padding;
            }
            OS.$out_char((byte)0);
        }
    }

    public static int encodeULEB128(long Value, char.ptr p) {
        return LEB128LlvmGlobals.encodeULEB128(Value, p, 0);
    }

    public static int encodeULEB128(long Value, char.ptr p, int Padding) {
        char.ptr orig_p = Native.$tryClone((char.ptr)p);
        do {
            byte Byte2 = Unsigned.$ullong2uchar((long)(Value & Unsigned.$int2ullong((int)127)));
            if ((Value >>>= 7) != Unsigned.$int2ullong((int)0) || Padding != 0) {
                Byte2 = (byte)(Byte2 | 0x80);
            }
            ((char.ptr)p.$postInc()).$set(Byte2);
        } while (Value != Unsigned.$int2ullong((int)0));
        if (Padding != 0) {
            while (Padding != 1) {
                ((char.ptr)p.$postInc()).$set((byte)-128);
                --Padding;
            }
            ((char.ptr)p.$postInc()).$set((byte)0);
        }
        return p.$sub((abstract_iterator)orig_p);
    }

    public static long decodeULEB128(char.ptr p) {
        return LEB128LlvmGlobals.decodeULEB128(p, null);
    }

    public static long decodeULEB128(char.ptr p, uint.ptr n) {
        char.ptr orig_p = Native.$tryClone((char.ptr)p);
        long Value = Unsigned.$int2ulong((int)0);
        int Shift = 0;
        do {
            Value += Unsigned.$int2ulong((int)(Unsigned.$uchar2int((byte)p.$star()) & 0x7F)) << Shift;
            Shift += 7;
        } while (Unsigned.$uchar2int((byte)((char.ptr)p.$postInc()).$star()) >= 128);
        if (Native.$bool((Native.Native$Bool)n)) {
            n.$set(p.$sub((abstract_iterator)orig_p));
        }
        return Value;
    }

    public static long decodeSLEB128(char.ptr p) {
        return LEB128LlvmGlobals.decodeSLEB128(p, null);
    }

    public static long decodeSLEB128(char.ptr p, uint.ptr n) {
        byte Byte2;
        char.ptr orig_p = Native.$tryClone((char.ptr)p);
        long Value = 0L;
        int Shift = 0;
        do {
            Byte2 = ((char.ptr)p.$postInc()).$star();
            Value |= (long)((Unsigned.$uchar2int((byte)Byte2) & 0x7F) << Shift);
            Shift += 7;
        } while (Unsigned.$uchar2int((byte)Byte2) >= 128);
        if ((Unsigned.$uchar2int((byte)Byte2) & 0x40) != 0) {
            Value |= -1L << Shift;
        }
        if (Native.$bool((Native.Native$Bool)n)) {
            n.$set(p.$sub((abstract_iterator)orig_p));
        }
        return Value;
    }

    public static int getULEB128Size(long Value) {
        int Size = 0;
        do {
            ++Size;
        } while ((Value >>>= 7) != 0L);
        return Size;
    }

    public static int getSLEB128Size(long Value) {
        boolean IsMore;
        int Size = 0;
        int Sign = (int)(Value >> 63);
        do {
            int Byte2 = Unsigned.$llong2uint((long)(Value & 0x7FL));
            IsMore = (Value >>= 7) != (long)Sign || ((Byte2 ^ Sign) & 0x40) != 0;
            ++Size;
        } while (IsMore);
        return Size;
    }
}

