/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.impl;

import java.lang.invoke.LambdaMetafactory;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.SmallPtrSet;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.DenseMapInfo$LikePtr;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.adt.aliases.StringMapIterator;
import org.llvm.cl.ClGlobals;
import org.llvm.cl.FormattingFlags;
import org.llvm.cl.NumOccurrencesFlag;
import org.llvm.cl.Option;
import org.llvm.cl.OptionCategory;
import org.llvm.cl.SubCommand;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.BumpPtrAllocatorImpl;
import org.llvm.support.StringSaver;
import org.llvm.support.impl.CommandLineStatics;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.sys.path;

public class CommandLineParser
implements Destructors.ClassWithDestructor {
    public std.string ProgramName = new std.string();
    public char.ptr ProgramOverview = null;
    public std.vectorCharPtr MoreHelp = new std.vectorCharPtr();
    public SmallPtrSet<OptionCategory> RegisteredOptionCategories = new SmallPtrSet(DenseMapInfo$LikePtr.$Info(), 16);
    public SmallPtrSet<SubCommand> RegisteredSubCommands = new SmallPtrSet(DenseMapInfo$LikePtr.$Info(), 4);
    private SubCommand ActiveSubCommand = null;

    public CommandLineParser() {
        this.registerSubCommand((SubCommand)Native.$AddrOf((Object)ClGlobals.TopLevelSubCommand.$star()));
        this.registerSubCommand((SubCommand)Native.$AddrOf((Object)ClGlobals.AllSubCommands.$star()));
    }

    public void ResetAllOptionOccurrences() {
        for (SubCommand SC : this.RegisteredSubCommands) {
            for (StringMapEntry<Option> stringMapEntry : SC.OptionsMap) {
                ((Option)stringMapEntry.second).reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean ParseCommandLineOptions(int argc, type.ptr<char.ptr> argv, char.ptr Overview, boolean IgnoreErrors) {
        BumpPtrAllocatorImpl A = null;
        try {
            assert (this.hasOptions()) : "No options specified!";
            SmallVector<Object> newArgv = new SmallVector<Object>(JavaDifferentiators.JD.T.INSTANCE, 20, (type.iterator<?, Object>)argv, (type.iterator<?, Object>)((type.iterator)argv.$add(argc)), null);
            A = new BumpPtrAllocatorImpl();
            StringSaver Saver = new StringSaver(A);
            ClGlobals.ExpandResponseFiles(Saver, ClGlobals::TokenizeGNUCommandLine, newArgv);
            argv = (type.ptr)Native.$tryClone((NativeCloneable)((char.ptr)newArgv.$at(0)).$addr());
            argc = newArgv.size();
            this.ProgramName.$assignMove(path.filename(new StringRef((char.ptr)argv.$at(0))).$string());
            this.ProgramOverview = Native.$tryClone((char.ptr)Overview);
            bool.ref ErrorParsing = NativePointer.create_bool$ref((boolean)false);
            int NumPositionalRequired = 0;
            boolean HasUnlimitedPositionals = false;
            int FirstArg = 1;
            SubCommand ChosenSubCommand = (SubCommand)Native.$AddrOf((Object)ClGlobals.TopLevelSubCommand.$star());
            if (argc >= 2 && ((char.ptr)argv.$at(FirstArg)).$at(0) != 45 && (ChosenSubCommand = this.LookupSubCommand((char.ptr)argv.$at(FirstArg))) != Native.$AddrOf((Object)ClGlobals.TopLevelSubCommand.$star())) {
                FirstArg = 2;
            }
            CommandLineStatics.GlobalParser.$arrow().ActiveSubCommand = ChosenSubCommand;
            assert (Native.$bool((Native.Native$Bool)ChosenSubCommand));
            type.ref ConsumeAfterOpt = NativePointer.create_type$ref((Object)ChosenSubCommand.ConsumeAfterOpt);
            SmallVector<Option> PositionalOpts = ChosenSubCommand.PositionalOpts;
            SmallVector<Option> SinkOpts = ChosenSubCommand.SinkOpts;
            StringMap<Option> OptionsMap = ChosenSubCommand.OptionsMap;
            if (ConsumeAfterOpt.$deref() != null) assert (Unsigned.$greater_uint((int)PositionalOpts.size(), (int)0)) : "Cannot specify cl::ConsumeAfter without a positional argument!";
            if (!PositionalOpts.empty()) {
                boolean UnboundedFound = false;
                int e = PositionalOpts.size();
                for (int i = 0; i != e; ++i) {
                    Option Opt = (Option)PositionalOpts.$at(i);
                    if (CommandLineStatics.RequiresValue(Opt)) {
                        ++NumPositionalRequired;
                    } else if (ConsumeAfterOpt.$deref() != null) {
                        if (Unsigned.$greater_uint((int)PositionalOpts.size(), (int)1)) {
                            if (!IgnoreErrors) {
                                Opt.error(new Twine("error - this positional option will never be matched, because it does not Require a value, and a cl::ConsumeAfter option is active!"));
                            }
                            ErrorParsing.$set(true);
                        }
                    } else if (UnboundedFound && !Opt.hasArgStr()) {
                        if (!IgnoreErrors) {
                            Opt.error(new Twine("error - option can never match, because another positional argument will match an unbounded number of values, and this option does not require a value!"));
                            llvm.errs().$out(this.ProgramName).$out(": CommandLine Error: Option '").$out(Opt.ArgStr).$out("' is all messed up!\n");
                            llvm.errs().$out_uint(PositionalOpts.size());
                        }
                        ErrorParsing.$set(true);
                    }
                    UnboundedFound |= CommandLineStatics.EatsUnboundedNumberOfValues(Opt);
                }
                HasUnlimitedPositionals = UnboundedFound || ConsumeAfterOpt.$deref() != null;
            }
            SmallVector<std_pair.pairTypeUInt> PositionalVals = new SmallVector<std_pair.pairTypeUInt>(4, new std_pair.pairTypeUInt((Object)new StringRef(), 0));
            Option ActivePositionalArg = null;
            boolean DashDashFound = false;
            int.ref i = NativePointer.create_int$ref((int)FirstArg);
            while (i.$deref() < argc) {
                block63: {
                    void var21_28;
                    StringRef ArgName;
                    StringRef Value;
                    std.string NearestHandlerString;
                    Option NearestHandler;
                    block64: {
                        void var21_33;
                        block66: {
                            block65: {
                                block61: {
                                    block62: {
                                        Object var21_29 = null;
                                        NearestHandler = null;
                                        NearestHandlerString = new std.string();
                                        Value = new StringRef();
                                        ArgName = new StringRef(NativePointer.$EMPTY);
                                        if (((char.ptr)argv.$at(i.$deref())).$at(0) == 45 && ((char.ptr)argv.$at(i.$deref())).$at(1) != 0 && !DashDashFound) break block61;
                                        if (ActivePositionalArg == null) break block62;
                                        CommandLineStatics.ProvidePositionalOption(ActivePositionalArg, new StringRef((char.ptr)argv.$at(i.$deref())), i.$deref());
                                        break block63;
                                    }
                                    if (PositionalOpts.empty()) break block64;
                                    PositionalVals.push_back(new std_pair.pairTypeUInt((Object)new StringRef((char.ptr)argv.$at(i.$deref())), i.$deref()));
                                    if (Unsigned.$greatereq_uint((int)PositionalVals.size(), (int)NumPositionalRequired) && ConsumeAfterOpt.$deref() != null) {
                                        i.$set$preInc();
                                        while (i.$deref() < argc) {
                                            PositionalVals.push_back(new std_pair.pairTypeUInt((Object)new StringRef((char.ptr)argv.$at(i.$deref())), i.$deref()));
                                            i.$set$preInc();
                                        }
                                        break;
                                    }
                                    break block63;
                                }
                                if (((char.ptr)argv.$at(i.$deref())).$at(0) != 45 || ((char.ptr)argv.$at(i.$deref())).$at(1) != 45 || ((char.ptr)argv.$at(i.$deref())).$at(2) != 0 || DashDashFound) break block65;
                                DashDashFound = true;
                                break block63;
                            }
                            if (ActivePositionalArg == null || (ActivePositionalArg.getMiscFlags() & 2) == 0) break block66;
                            ArgName.$assignMove((char.ptr)((char.ptr)argv.$at(i.$deref())).$add(1));
                            while (!ArgName.empty() && ArgName.$at(0) == 45) {
                                ArgName.$assignMove(ArgName.substr(1));
                            }
                            Option option = this.LookupOption((SubCommand)Native.$Deref((Object)ChosenSubCommand), ArgName, Value);
                            if (option != null && option.getFormattingFlag() == FormattingFlags.Positional) break block64;
                            CommandLineStatics.ProvidePositionalOption(ActivePositionalArg, new StringRef((char.ptr)argv.$at(i.$deref())), i.$deref());
                            break block63;
                        }
                        ArgName.$assignMove((char.ptr)((char.ptr)argv.$at(i.$deref())).$add(1));
                        while (!ArgName.empty() && ArgName.$at(0) == 45) {
                            ArgName.$assignMove(ArgName.substr(1));
                        }
                        Option option = this.LookupOption((SubCommand)Native.$Deref((Object)ChosenSubCommand), ArgName, Value);
                        if (option == null) {
                            Option option2 = CommandLineStatics.HandlePrefixedOrGroupedOption(ArgName, Value, ErrorParsing, OptionsMap);
                        }
                        if (var21_33 == null && SinkOpts.empty()) {
                            NearestHandler = CommandLineStatics.LookupNearestOption(new StringRef(ArgName), OptionsMap, NearestHandlerString);
                        }
                    }
                    if (var21_28 == null) {
                        if (SinkOpts.empty()) {
                            if (!IgnoreErrors) {
                                llvm.errs().$out(this.ProgramName).$out(": Unknown command line argument '").$out((char.ptr)argv.$at(i.$deref())).$out("'.  Try: '").$out((char.ptr)argv.$at(0)).$out(" -help'\n");
                                if (NearestHandler != null) {
                                    llvm.errs().$out(this.ProgramName).$out(": Did you mean '-").$out(NearestHandlerString).$out("'?\n");
                                }
                            }
                            ErrorParsing.$set(true);
                        } else {
                            type.ptr I = (type.ptr)Native.$tryClone(SinkOpts.begin());
                            type.ptr E = (type.ptr)Native.$tryClone(SinkOpts.end());
                            while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
                                ((Option)I.$star()).addOccurrence(i.$deref(), new StringRef(NativePointer.$EMPTY), new StringRef((char.ptr)argv.$at(i.$deref())));
                                I.$preInc();
                            }
                        }
                    } else if (var21_28.getFormattingFlag() == FormattingFlags.Positional) {
                        ActivePositionalArg = var21_28;
                    } else {
                        ErrorParsing.$set$orassign(CommandLineStatics.ProvideOption((Option)var21_28, new StringRef(ArgName), new StringRef(Value), argc, (type.ptr<char.ptr>)argv, i));
                    }
                }
                i.$set$preInc();
            }
            if (Unsigned.$greater_uint((int)NumPositionalRequired, (int)PositionalVals.size())) {
                if (!IgnoreErrors) {
                    llvm.errs().$out(this.ProgramName).$out(": Not enough positional command line arguments specified!\n").$out("Must specify at least ").$out_uint(NumPositionalRequired).$out(" positional arguments: See: ").$out((char.ptr)argv.$at(0)).$out(" -help\n");
                }
                ErrorParsing.$set(true);
            } else if (!HasUnlimitedPositionals && Unsigned.$greater_uint((int)PositionalVals.size(), (int)PositionalOpts.size())) {
                if (!IgnoreErrors) {
                    llvm.errs().$out(this.ProgramName).$out(": Too many positional arguments specified!\n").$out("Can specify at most ").$out_uint(PositionalOpts.size()).$out(" positional arguments: See: ").$out((char.ptr)argv.$at(0)).$out(" -help\n");
                }
                ErrorParsing.$set(true);
            } else if (ConsumeAfterOpt.$deref() == null) {
                int ValNo = 0;
                int n = PositionalVals.size();
                int e = PositionalOpts.size();
                for (int i2 = 0; i2 != e; ++i2) {
                    boolean Done;
                    if (CommandLineStatics.RequiresValue((Option)PositionalOpts.$at(i2))) {
                        CommandLineStatics.ProvidePositionalOption((Option)PositionalOpts.$at(i2), new StringRef((StringRef)((std_pair.pairTypeUInt)PositionalVals.$at((int)ValNo)).first), ((std_pair.pairTypeUInt)PositionalVals.$at((int)ValNo)).second);
                        ++ValNo;
                        --NumPositionalRequired;
                    }
                    boolean bl = Done = ((Option)PositionalOpts.$at(i2)).getNumOccurrencesFlag() == NumOccurrencesFlag.Required;
                    block18: while (Unsigned.$greater_uint((int)(n - ValNo), (int)NumPositionalRequired) && !Done) {
                        switch (((Option)PositionalOpts.$at(i2)).getNumOccurrencesFlag()) {
                            case Optional: {
                                Done = true;
                            }
                            case ZeroOrMore: 
                            case OneOrMore: {
                                CommandLineStatics.ProvidePositionalOption((Option)PositionalOpts.$at(i2), new StringRef((StringRef)((std_pair.pairTypeUInt)PositionalVals.$at((int)ValNo)).first), ((std_pair.pairTypeUInt)PositionalVals.$at((int)ValNo)).second);
                                ++ValNo;
                                continue block18;
                            }
                        }
                        throw new llvm_unreachable("Internal error, unexpected NumOccurrences flag in positional argument processing!");
                    }
                }
            } else {
                void var21_36;
                assert (ConsumeAfterOpt.$deref() != null && Unsigned.$lesseq_uint((int)NumPositionalRequired, (int)PositionalVals.size()));
                int ValNo = 0;
                boolean bl = true;
                int e = PositionalOpts.size();
                while (var21_36 != e) {
                    if (CommandLineStatics.RequiresValue((Option)PositionalOpts.$at((int)var21_36))) {
                        ErrorParsing.$set$orassign(CommandLineStatics.ProvidePositionalOption((Option)PositionalOpts.$at((int)var21_36), new StringRef((StringRef)((std_pair.pairTypeUInt)PositionalVals.$at((int)ValNo)).first), ((std_pair.pairTypeUInt)PositionalVals.$at((int)ValNo)).second));
                        ++ValNo;
                    }
                    ++var21_36;
                }
                if (PositionalOpts.size() == 1 && ValNo == 0 && !PositionalVals.empty()) {
                    ErrorParsing.$set$orassign(CommandLineStatics.ProvidePositionalOption((Option)PositionalOpts.$at(0), new StringRef((StringRef)((std_pair.pairTypeUInt)PositionalVals.$at((int)ValNo)).first), ((std_pair.pairTypeUInt)PositionalVals.$at((int)ValNo)).second));
                    ++ValNo;
                }
                while (ValNo != PositionalVals.size()) {
                    ErrorParsing.$set$orassign(CommandLineStatics.ProvidePositionalOption((Option)ConsumeAfterOpt.$deref(), new StringRef((StringRef)((std_pair.pairTypeUInt)PositionalVals.$at((int)ValNo)).first), ((std_pair.pairTypeUInt)PositionalVals.$at((int)ValNo)).second));
                    ++ValNo;
                }
            }
            for (StringMapEntry<Option> stringMapEntry : OptionsMap) {
                switch (((Option)stringMapEntry.second).getNumOccurrencesFlag()) {
                    case OneOrMore: 
                    case Required: {
                        if (((Option)stringMapEntry.second).getNumOccurrences() != 0) break;
                        ((Option)stringMapEntry.second).error(new Twine("must be specified at least once!"));
                        ErrorParsing.$set(true);
                    }
                }
            }
            this.MoreHelp.clear();
            if (ErrorParsing.$deref()) {
                if (!IgnoreErrors) {
                    std.exit((int)1);
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (A != null) {
                A.$destroy();
            }
        }
    }

    public void addLiteralOption(Option Opt, SubCommand SC, char.ptr Name2) {
        if (Opt.hasArgStr()) {
            return;
        }
        if (!SC.OptionsMap.insert((std_pair.pair<StringRef, Option>)new std_pair.pairTypePtr((JavaDifferentiators.JD$Pair$_U1$_U2)JavaDifferentiators.JD$Pair$_U1$_U2.INSTANCE, (NativeCallback.Obj2T)(NativeCallback.Obj2T)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$addLiteralOption$0(java.lang.Object ), (Ljava/lang/Object;)Lorg/llvm/adt/StringRef;)(), (NativeCallback.Obj2T)(NativeCallback.Obj2T)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$addLiteralOption$1(java.lang.Object ), (Ljava/lang/Object;)Lorg/llvm/cl/Option;)(), (std_pair.pair)std.make_pair_T_Ptr((Object)Name2, (Object)((Option)Native.$AddrOf((Object)Opt))))).second) {
            llvm.errs().$out(this.ProgramName).$out(": CommandLine Error: Option '").$out(Name2).$out("' registered more than once!\n");
            llvm.report_fatal_error(NativePointer.$((String)"inconsistency in registered CommandLine options"));
        }
        if (SC == Native.$AddrOf((Object)ClGlobals.AllSubCommands.$star())) {
            for (SubCommand Sub : this.RegisteredSubCommands) {
                if (SC == Sub) continue;
                this.addLiteralOption(Opt, Sub, Name2);
            }
        }
    }

    public void addLiteralOption(Option Opt, char.ptr Name2) {
        if (Opt.Subs.empty()) {
            this.addLiteralOption(Opt, (SubCommand)Native.$AddrOf((Object)ClGlobals.TopLevelSubCommand.$star()), Name2);
        } else {
            for (SubCommand SC : Opt.Subs) {
                this.addLiteralOption(Opt, SC, Name2);
            }
        }
    }

    public void addOption(Option O, SubCommand SC) {
        boolean HadErrors = false;
        if (O.hasArgStr() && !SC.OptionsMap.insert((std_pair.pair<StringRef, Option>)std.make_pair_T_Ptr((Object)new StringRef((StringRef)O.ArgStr), (Object)O)).second) {
            llvm.errs().$out(this.ProgramName).$out(": CommandLine Error: Option '").$out(O.ArgStr).$out("' registered more than once!\n");
            HadErrors = true;
        }
        if (O.getFormattingFlag() == FormattingFlags.Positional) {
            SC.PositionalOpts.push_back(O);
        } else if ((O.getMiscFlags() & 4) != 0) {
            SC.SinkOpts.push_back(O);
        } else if (O.getNumOccurrencesFlag() == NumOccurrencesFlag.ConsumeAfter) {
            if (SC.ConsumeAfterOpt != null) {
                O.error(new Twine("Cannot specify more than one option with cl::ConsumeAfter!"));
                HadErrors = true;
            }
            SC.ConsumeAfterOpt = O;
        }
        if (HadErrors) {
            llvm.report_fatal_error(NativePointer.$((String)"inconsistency in registered CommandLine options"));
        }
        if (SC == Native.$AddrOf((Object)ClGlobals.AllSubCommands.$star())) {
            for (SubCommand Sub : this.RegisteredSubCommands) {
                if (SC == Sub) continue;
                this.addOption(O, Sub);
            }
        }
    }

    public void addOption(Option O) {
        if (O.Subs.empty()) {
            this.addOption(O, (SubCommand)Native.$AddrOf((Object)ClGlobals.TopLevelSubCommand.$star()));
        } else {
            for (SubCommand SC : O.Subs) {
                this.addOption(O, SC);
            }
        }
    }

    public void removeOption(Option O, SubCommand SC) {
        type.ptr Opt;
        SmallVector<StringRef> OptionNames = new SmallVector<StringRef>(16, new StringRef());
        O.getExtraOptionNames(OptionNames);
        if (O.hasArgStr()) {
            OptionNames.push_back(O.ArgStr);
        }
        SubCommand Sub = (SubCommand)Native.$Deref((Object)SC);
        for (StringRef Name2 : OptionNames) {
            Sub.OptionsMap.erase(Name2);
        }
        if (O.getFormattingFlag() == FormattingFlags.Positional) {
            Opt = (type.ptr)Native.$tryClone(Sub.PositionalOpts.begin());
            while (Native.$noteq_ptr((void.ptr)Opt, Sub.PositionalOpts.end())) {
                if (Opt.$star() == O) {
                    Sub.PositionalOpts.erase((type.ptr<Option>)Opt);
                    break;
                }
                Opt.$preInc();
            }
        } else if ((O.getMiscFlags() & 4) != 0) {
            Opt = (type.ptr)Native.$tryClone(Sub.SinkOpts.begin());
            while (Native.$noteq_ptr((void.ptr)Opt, Sub.SinkOpts.end())) {
                if (Opt.$star() == O) {
                    Sub.SinkOpts.erase((type.ptr<Option>)Opt);
                    break;
                }
                Opt.$preInc();
            }
        } else if (O == Sub.ConsumeAfterOpt) {
            Sub.ConsumeAfterOpt = null;
        }
    }

    public void removeOption(Option O) {
        if (O.Subs.empty()) {
            this.removeOption(O, (SubCommand)Native.$AddrOf((Object)ClGlobals.TopLevelSubCommand.$star()));
        } else if (O.isInAllSubCommands()) {
            for (SubCommand SC : this.RegisteredSubCommands) {
                this.removeOption(O, SC);
            }
        } else {
            for (SubCommand SC : O.Subs) {
                this.removeOption(O, SC);
            }
        }
    }

    public boolean hasOptions(SubCommand Sub) {
        return !Sub.OptionsMap.empty() || !Sub.PositionalOpts.empty() || null != Sub.ConsumeAfterOpt;
    }

    public boolean hasOptions() {
        for (SubCommand S2 : this.RegisteredSubCommands) {
            if (!this.hasOptions((SubCommand)Native.$Deref((Object)S2))) continue;
            return true;
        }
        return false;
    }

    public SubCommand getActiveSubCommand() {
        return this.ActiveSubCommand;
    }

    public void updateArgStr(Option O, StringRef NewName, SubCommand SC) {
        SubCommand Sub = (SubCommand)Native.$Deref((Object)SC);
        if (!Sub.OptionsMap.insert((std_pair.pair<StringRef, Option>)std.make_pair_T_Ptr((Object)NewName, (Object)O)).second) {
            llvm.errs().$out(this.ProgramName).$out(": CommandLine Error: Option '").$out(O.ArgStr).$out("' registered more than once!\n");
            llvm.report_fatal_error(NativePointer.$((String)"inconsistency in registered CommandLine options"));
        }
        Sub.OptionsMap.erase(new StringRef(O.ArgStr));
    }

    public void updateArgStr(Option O, StringRef NewName) {
        if (O.Subs.empty()) {
            this.updateArgStr(O, new StringRef(NewName), (SubCommand)Native.$AddrOf((Object)ClGlobals.TopLevelSubCommand.$star()));
        } else {
            for (SubCommand SC : O.Subs) {
                this.updateArgStr(O, new StringRef(NewName), SC);
            }
        }
    }

    public void printOptionValues() {
        int i;
        if (!CommandLineStatics.PrintOptions.$T().booleanValue() && !CommandLineStatics.PrintAllOptions.$T().booleanValue()) {
            return;
        }
        SmallVector<std_pair.pairTypePtr<char.ptr, Option>> Opts = new SmallVector<std_pair.pairTypePtr<char.ptr, Option>>(128, new std_pair.pairTypePtr());
        CommandLineStatics.sortOpts(this.ActiveSubCommand.OptionsMap, Opts, true);
        int MaxArgLen = 0;
        int e = Opts.size();
        for (i = 0; i != e; ++i) {
            MaxArgLen = std.max((int)MaxArgLen, (int)((Option)((std_pair.pairTypePtr)Opts.$at((int)i)).second).getOptionWidth());
        }
        e = Opts.size();
        for (i = 0; i != e; ++i) {
            ((Option)((std_pair.pairTypePtr)Opts.$at((int)i)).second).printOptionValue(MaxArgLen, CommandLineStatics.PrintAllOptions.$T());
        }
    }

    public void registerCategory(OptionCategory cat2) {
        OptionCategory L$cat = cat2;
        assert (AdtsupportLlvmGlobals.count_if(this.RegisteredOptionCategories, Category2 -> Native.$eq_ptr((void.ptr)L$cat.getName(), (void.ptr)Category2.getName())) == 0) : "Duplicate option categories";
        this.RegisteredOptionCategories.insert(cat2);
    }

    public void registerSubCommand(SubCommand sub2) {
        SubCommand L$sub = sub2;
        assert (AdtsupportLlvmGlobals.count_if(this.RegisteredSubCommands, Sub -> Native.$noteq_ptr((void.ptr)L$sub.getName(), (void.ptr)((char.ptr)null)) && Native.$eq_ptr((void.ptr)Sub.getName(), (void.ptr)L$sub.getName())) == 0) : "Duplicate subcommands";
        this.RegisteredSubCommands.insert(sub2);
        if (sub2 != Native.$AddrOf((Object)ClGlobals.AllSubCommands.$star())) {
            for (StringMapEntry<Option> stringMapEntry : ClGlobals.AllSubCommands.$arrow().OptionsMap) {
                Option O = (Option)stringMapEntry.second;
                if (O.isPositional() || O.isSink() || O.isConsumeAfter() || O.hasArgStr()) {
                    this.addOption(O, sub2);
                    continue;
                }
                this.addLiteralOption((Option)Native.$Deref((Object)O), sub2, stringMapEntry.first().str().c_str());
            }
        }
    }

    public void unregisterSubCommand(SubCommand sub2) {
        this.RegisteredSubCommands.erase(sub2);
    }

    public void reset() {
        this.ActiveSubCommand = null;
        this.ProgramName.clear();
        this.ProgramOverview = null;
        this.MoreHelp.clear();
        this.RegisteredOptionCategories.clear();
        this.ResetAllOptionOccurrences();
        this.RegisteredSubCommands.clear();
        ClGlobals.TopLevelSubCommand.$arrow().reset();
        ClGlobals.AllSubCommands.$arrow().reset();
        this.registerSubCommand((SubCommand)Native.$AddrOf((Object)ClGlobals.TopLevelSubCommand.$star()));
        this.registerSubCommand((SubCommand)Native.$AddrOf((Object)ClGlobals.AllSubCommands.$star()));
    }

    private Option LookupOption(SubCommand Sub, StringRef Arg, StringRef Value) {
        if (Arg.empty()) {
            return null;
        }
        assert (Native.$AddrOf((Object)Sub) != Native.$AddrOf((Object)ClGlobals.AllSubCommands.$star()));
        int EqualPos = Arg.find((byte)61);
        if (EqualPos == StringRef.npos) {
            StringMapIterator<Option> I = Sub.OptionsMap.find(Arg);
            if (I.$eq(Sub.OptionsMap.end())) {
                return null;
            }
            return I.$noteq(Sub.OptionsMap.end()) ? (Option)((StringMapEntry)I.$arrow()).second : null;
        }
        StringMapIterator<Option> I = Sub.OptionsMap.find(Arg.substr(0, EqualPos));
        if (I.$eq(Sub.OptionsMap.end())) {
            return null;
        }
        Value.$assignMove(Arg.substr(EqualPos + 1));
        Arg.$assignMove(Arg.substr(0, EqualPos));
        return (Option)((StringMapEntry)I.$arrow()).second;
    }

    private SubCommand LookupSubCommand(char.ptr Name2) {
        if (Native.$eq_ptr((void.ptr)Name2, null)) {
            return (SubCommand)Native.$AddrOf((Object)ClGlobals.TopLevelSubCommand.$star());
        }
        for (SubCommand S2 : this.RegisteredSubCommands) {
            if (S2 == Native.$AddrOf((Object)ClGlobals.AllSubCommands.$star()) || Native.$eq_ptr((void.ptr)S2.getName(), null) || !llvm.$eq_StringRef(S2.getName(), Name2)) continue;
            return S2;
        }
        return (SubCommand)Native.$AddrOf((Object)ClGlobals.TopLevelSubCommand.$star());
    }

    public void $destroy() {
        this.RegisteredSubCommands.$destroy();
        this.RegisteredOptionCategories.$destroy();
        this.MoreHelp.$destroy();
        this.ProgramName.$destroy();
    }

    public String toString() {
        return "ProgramName=" + this.ProgramName + ", ProgramOverview=" + this.ProgramOverview + ", MoreHelp=" + this.MoreHelp + ", RegisteredOptionCategories=" + this.RegisteredOptionCategories + ", RegisteredSubCommands=" + this.RegisteredSubCommands + ", ActiveSubCommand=" + this.ActiveSubCommand;
    }

    private static /* synthetic */ Option lambda$addLiteralOption$1(Object p) {
        return (Option)((std_pair.pairTypePtr)p).second;
    }

    private static /* synthetic */ StringRef lambda$addLiteralOption$0(Object p) {
        return new StringRef((char.ptr)((std_pair.pairTypePtr)p).first);
    }
}

