/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.impl;

import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.ulong;
import org.clank.support.void;
import org.llvm.adt.APInt;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.lostFraction;
import org.llvm.support.impl.APFloatStatics$powerOf5$$;
import org.llvm.support.impl.decimalInfo;
import org.llvm.support.llvm;

public final class APFloatStatics {
    public static char.ptr hexDigitsLower = NativePointer.$((String)"0123456789abcdef0");
    public static char.ptr hexDigitsUpper = NativePointer.$((String)"0123456789ABCDEF0");
    public static char.ptr infinityL = NativePointer.$((String)"infinity");
    public static char.ptr infinityU = NativePointer.$((String)"INFINITY");
    public static char.ptr NaNL = NativePointer.$((String)"nan");
    public static char.ptr NaNU = NativePointer.$((String)"NAN");

    public static int partCountForBits(int bits) {
        return Unsigned.$div_uint((int)(bits + llvm.integerPartWidth - 1), (int)llvm.integerPartWidth);
    }

    public static int decDigitValue(int c) {
        return c - Unsigned.$char2uint((byte)48);
    }

    public static int readExponent(char.ptr begin, char.ptr end) {
        boolean isNegative;
        int overlargeExponent = 24000;
        char.ptr p = Native.$tryClone((char.ptr)begin);
        assert (Native.$noteq_ptr((void.ptr)p, (void.ptr)end)) : "Exponent has no digits";
        boolean bl = isNegative = p.$star() == 45;
        if (p.$star() == 45 || p.$star() == 43) {
            p.$postInc();
            assert (Native.$noteq_ptr((void.ptr)p, (void.ptr)end)) : "Exponent has no digits";
        }
        int absExponent = APFloatStatics.decDigitValue(Unsigned.$char2uint((byte)((char.ptr)p.$postInc()).$star()));
        assert (Unsigned.$less_uint((int)absExponent, (int)10)) : "Invalid character in exponent";
        while (Native.$noteq_ptr((void.ptr)p, (void.ptr)end)) {
            int value = APFloatStatics.decDigitValue(Unsigned.$char2uint((byte)p.$star()));
            assert (Unsigned.$less_uint((int)value, (int)10)) : "Invalid character in exponent";
            value += absExponent * 10;
            if (Unsigned.$greatereq_uint((int)absExponent, (int)overlargeExponent)) {
                absExponent = overlargeExponent;
                p = Native.$tryClone((char.ptr)end);
                break;
            }
            absExponent = value;
            p.$preInc();
        }
        assert (Native.$eq_ptr((void.ptr)p, (void.ptr)end)) : "Invalid exponent in exponent";
        if (isNegative) {
            return -absExponent;
        }
        return absExponent;
    }

    public static int totalExponent(char.ptr p, char.ptr end, int exponentAdjustment) {
        boolean negative;
        int exponent = 0;
        assert (Native.$noteq_ptr((void.ptr)p, (void.ptr)end)) : "Exponent has no digits";
        boolean bl = negative = p.$star() == 45;
        if (p.$star() == 45 || p.$star() == 43) {
            p.$postInc();
            assert (Native.$noteq_ptr((void.ptr)p, (void.ptr)end)) : "Exponent has no digits";
        }
        int unsignedExponent = 0;
        boolean overflow = false;
        while (Native.$noteq_ptr((void.ptr)p, (void.ptr)end)) {
            int value = APFloatStatics.decDigitValue(Unsigned.$char2uint((byte)p.$star()));
            assert (Unsigned.$less_uint((int)value, (int)10)) : "Invalid character in exponent";
            if ((unsignedExponent = unsignedExponent * 10 + value) > Short.MAX_VALUE) {
                overflow = true;
                break;
            }
            p.$preInc();
        }
        if (exponentAdjustment > Short.MAX_VALUE || exponentAdjustment < Short.MIN_VALUE) {
            overflow = true;
        }
        if (!overflow) {
            exponent = unsignedExponent;
            if (negative) {
                exponent = -exponent;
            }
            if ((exponent += exponentAdjustment) > Short.MAX_VALUE || exponent < Short.MIN_VALUE) {
                overflow = true;
            }
        }
        if (overflow) {
            exponent = negative ? Short.MIN_VALUE : Short.MAX_VALUE;
        }
        return exponent;
    }

    public static char.ptr skipLeadingZeroesAndAnyDot(char.ptr begin, char.ptr end, char.ptr dot) {
        char.ptr p = Native.$tryClone((char.ptr)begin);
        dot.$assign((Object)end);
        while (Native.$noteq_ptr((void.ptr)p, (void.ptr)end) && p.$star() == 48) {
            p.$postInc();
        }
        if (Native.$noteq_ptr((void.ptr)p, (void.ptr)end) && p.$star() == 46) {
            dot.$assign((Object)((char.ptr)p.$postInc()));
            assert (end.$sub((abstract_iterator)begin) != 1) : "Significand has no digits";
            while (Native.$noteq_ptr((void.ptr)p, (void.ptr)end) && p.$star() == 48) {
                p.$postInc();
            }
        }
        return p;
    }

    public static void interpretDecimal(char.ptr begin, char.ptr end, decimalInfo D) {
        char.ptr dot = Native.$tryClone((char.ptr)end);
        char.ptr p = Native.$tryClone((char.ptr)APFloatStatics.skipLeadingZeroesAndAnyDot(begin, end, dot));
        D.firstSigDigit = Native.$tryClone((char.ptr)p);
        D.exponent = 0;
        D.normalizedExponent = 0;
        while (Native.$noteq_ptr((void.ptr)p, (void.ptr)end)) {
            if (p.$star() == 46) {
                assert (Native.$eq_ptr((void.ptr)dot, (void.ptr)end)) : "String contains multiple dots";
                dot = Native.$tryClone((char.ptr)((char.ptr)p.$postInc()));
                if (Native.$eq_ptr((void.ptr)p, (void.ptr)end)) break;
            }
            if (Unsigned.$greatereq_uint((int)APFloatStatics.decDigitValue(Unsigned.$char2uint((byte)p.$star())), (int)10)) break;
            p.$preInc();
        }
        if (Native.$noteq_ptr((void.ptr)p, (void.ptr)end)) {
            assert (p.$star() == 101 || p.$star() == 69) : "Invalid character in significand";
            assert (Native.$noteq_ptr((void.ptr)p, (void.ptr)begin)) : "Significand has no digits";
            assert (Native.$eq_ptr((void.ptr)dot, (void.ptr)end) || p.$sub((abstract_iterator)begin) != 1) : "Significand has no digits";
            D.exponent = APFloatStatics.readExponent((char.ptr)p.$add(1), end);
            if (Native.$eq_ptr((void.ptr)dot, (void.ptr)end)) {
                dot = Native.$tryClone((char.ptr)p);
            }
        }
        if (Native.$noteq_ptr((void.ptr)p, (void.ptr)D.firstSigDigit)) {
            if (Native.$noteq_ptr((void.ptr)p, (void.ptr)begin)) {
                do {
                    p.$postDec();
                } while (Native.$noteq_ptr((void.ptr)p, (void.ptr)begin) && p.$star() == 48 || Native.$noteq_ptr((void.ptr)p, (void.ptr)begin) && p.$star() == 46);
            }
            D.normalizedExponent = (D.exponent = D.exponent + (short)(dot.$sub((abstract_iterator)p) - (dot.$greater((Object)p) ? 1 : 0))) + (short)(p.$sub((abstract_iterator)D.firstSigDigit) - (dot.$greater((Object)D.firstSigDigit) && dot.$less((Object)p) ? 1 : 0));
        }
        D.lastSigDigit = Native.$tryClone((char.ptr)p);
    }

    public static lostFraction trailingHexadecimalFraction(char.ptr p, char.ptr end, int digitValue) {
        if (Unsigned.$greater_uint((int)digitValue, (int)8)) {
            return lostFraction.lfMoreThanHalf;
        }
        if (Unsigned.$less_uint((int)digitValue, (int)8) && Unsigned.$greater_uint((int)digitValue, (int)0)) {
            return lostFraction.lfLessThanHalf;
        }
        while (Native.$noteq_ptr((void.ptr)p, (void.ptr)end) && (p.$star() == 48 || p.$star() == 46)) {
            p.$postInc();
        }
        assert (Native.$noteq_ptr((void.ptr)p, (void.ptr)end)) : "Invalid trailing hexadecimal fraction!";
        int hexDigit = llvm.hexDigitValue(p.$star());
        if (hexDigit == -1) {
            return digitValue == 0 ? lostFraction.lfExactlyZero : lostFraction.lfExactlyHalf;
        }
        return digitValue == 0 ? lostFraction.lfLessThanHalf : lostFraction.lfMoreThanHalf;
    }

    public static lostFraction lostFractionThroughTruncation(ulong.ptr parts, int partCount, int bits) {
        int lsb = APInt.tcLSB(parts, partCount);
        if (Unsigned.$lesseq_uint((int)bits, (int)lsb)) {
            return lostFraction.lfExactlyZero;
        }
        if (bits == lsb + 1) {
            return lostFraction.lfExactlyHalf;
        }
        if (Unsigned.$lesseq_uint((int)bits, (int)(partCount * llvm.integerPartWidth)) && APInt.tcExtractBit(parts, bits - 1) != 0) {
            return lostFraction.lfMoreThanHalf;
        }
        return lostFraction.lfLessThanHalf;
    }

    public static lostFraction shiftRight(ulong.ptr dst, int parts, int bits) {
        lostFraction lost_fraction = APFloatStatics.lostFractionThroughTruncation(dst, parts, bits);
        APInt.tcShiftRight(dst, parts, bits);
        return lost_fraction;
    }

    public static lostFraction combineLostFractions(lostFraction moreSignificant, lostFraction lessSignificant) {
        if (lessSignificant != lostFraction.lfExactlyZero) {
            if (moreSignificant == lostFraction.lfExactlyZero) {
                moreSignificant = lostFraction.lfLessThanHalf;
            } else if (moreSignificant == lostFraction.lfExactlyHalf) {
                moreSignificant = lostFraction.lfMoreThanHalf;
            }
        }
        return moreSignificant;
    }

    public static int HUerrBound(boolean inexactMultiply, int HUerr1, int HUerr2) {
        assert (Unsigned.$less_uint((int)HUerr1, (int)2) || Unsigned.$less_uint((int)HUerr2, (int)2) || Unsigned.$less_uint((int)(HUerr1 + HUerr2), (int)8));
        if (HUerr1 + HUerr2 == 0) {
            return Unsigned.$bool2uint((boolean)inexactMultiply) * 2;
        }
        return Unsigned.$bool2uint((boolean)inexactMultiply) + 2 * (HUerr1 + HUerr2);
    }

    public static long ulpsFromBoundary(ulong.ptr parts, int bits, boolean isNearest) {
        assert (bits != 0);
        int count = Unsigned.$div_uint((int)(--bits), (int)llvm.integerPartWidth);
        int partBits = Unsigned.$rem_uint((int)bits, (int)llvm.integerPartWidth) + 1;
        long part = parts.$at(count) & (Unsigned.$int2ulong((int)0) ^ 0xFFFFFFFFFFFFFFFFL) >>> llvm.integerPartWidth - partBits;
        long boundary = isNearest ? Unsigned.$int2ulong((int)1) << partBits - 1 : Unsigned.$int2ulong((int)0);
        if (count == 0) {
            if (Unsigned.$lesseq_ullong((long)(part - boundary), (long)(boundary - part))) {
                return part - boundary;
            }
            return boundary - part;
        }
        if (part == boundary) {
            while (--count != 0) {
                if (parts.$at(count) == 0L) continue;
                return Unsigned.$int2ulong((int)0) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            return parts.$at(0);
        }
        if (part == boundary - Unsigned.$int2ullong((int)1)) {
            while (--count != 0) {
                if ((parts.$at(count) ^ 0xFFFFFFFFFFFFFFFFL) == 0L) continue;
                return Unsigned.$int2ulong((int)0) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            return -parts.$at(0);
        }
        return Unsigned.$int2ulong((int)0) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static int powerOf5(ulong.ptr dst, int power) {
        long[] firstEightPowers = APFloatStatics$powerOf5$$.firstEightPowers;
        long[] pow5s = NativePointer.new$ulong((int)1205);
        pow5s[0] = Unsigned.$int2ulong((int)390625);
        int[] partsCount = NativePointer.new$uint((int)16, (int[])new int[]{1});
        long[] scratch = NativePointer.new$ulong((int)600);
        ulong.ptr p1 = NativePointer.create_ulong$ptr();
        ulong.ptr p2 = NativePointer.create_ulong$ptr();
        ulong.ptr pow5 = NativePointer.create_ulong$ptr();
        assert (Unsigned.$lesseq_uint((int)power, (int)2047));
        p1 = (ulong.ptr)Native.$tryClone((NativeCloneable)dst);
        p2 = (ulong.ptr)Native.$tryClone((NativeCloneable)NativePointer.create_ulong$ptr((long[])scratch));
        p1.$set(firstEightPowers[power & 7]);
        power >>>= 3;
        int result = 1;
        pow5 = (ulong.ptr)Native.$tryClone((NativeCloneable)NativePointer.create_ulong$ptr((long[])pow5s));
        int n = 0;
        while (power != 0) {
            int pc = partsCount[n];
            if (pc == 0) {
                pc = partsCount[n - 1];
                APInt.tcFullMultiply(pow5, (ulong.ptr)pow5.$sub(pc), (ulong.ptr)pow5.$sub(pc), pc, pc);
                if (pow5.$at((pc *= 2) - 1) == Unsigned.$int2ullong((int)0)) {
                    // empty if block
                }
                partsCount[n] = --pc;
            }
            if ((power & 1) != 0) {
                ulong.ptr tmp = NativePointer.create_ulong$ptr();
                APInt.tcFullMultiply(p2, p1, pow5, result, pc);
                if (p2.$at((result += pc) - 1) == Unsigned.$int2ullong((int)0)) {
                    --result;
                }
                tmp = (ulong.ptr)Native.$tryClone((NativeCloneable)p1);
                p1 = (ulong.ptr)Native.$tryClone((NativeCloneable)p2);
                p2 = (ulong.ptr)Native.$tryClone((NativeCloneable)tmp);
            }
            pow5.$inc(pc);
            power >>>= 1;
            ++n;
        }
        if (Native.$noteq_ptr((void.ptr)p1, (void.ptr)dst)) {
            APInt.tcAssign(dst, p1, result);
        }
        return result;
    }

    public static int partAsHex(char.ptr dst, long part, int count, char.ptr hexDigitChars) {
        int result = count;
        assert (count != 0 && Unsigned.$lesseq_uint((int)count, (int)Unsigned.$div_uint((int)llvm.integerPartWidth, (int)4)));
        part >>>= llvm.integerPartWidth - 4 * count;
        while (count-- != 0) {
            dst.$set(count, hexDigitChars.$at(Unsigned.$ulong2uint((long)(part & Unsigned.$int2ullong((int)15)))));
            part >>>= 4;
        }
        return result;
    }

    public static char.ptr writeUnsignedDecimal(char.ptr dst, int n) {
        byte[] buff = NativePointer.new$char((int)40, (byte[])new byte[0]);
        char.ptr p = NativePointer.create_char$ptr();
        p = NativePointer.create_char$ptr((byte[])buff);
        do {
            ((char.ptr)p.$postInc()).$set(Unsigned.$uint2char((int)(Unsigned.$char2uint((byte)48) + Unsigned.$rem_uint((int)n, (int)10))));
        } while ((n = Unsigned.$div_uint((int)n, (int)10)) != 0);
        do {
            ((char.ptr)dst.$postInc()).$set(((char.ptr)p.$preDec()).$star());
        } while (Native.$noteq_ptr((Object)p, (Object)buff));
        return dst;
    }

    public static char.ptr writeSignedDecimal(char.ptr dst, int value) {
        if (value < 0) {
            ((char.ptr)dst.$postInc()).$set((byte)45);
            dst = Native.$tryClone((char.ptr)APFloatStatics.writeUnsignedDecimal(dst, -value));
        } else {
            dst = Native.$tryClone((char.ptr)APFloatStatics.writeUnsignedDecimal(dst, value));
        }
        return dst;
    }

    public static void append(SmallString Buffer, StringRef Str) {
        Buffer.append_T((char.iterator<?>)Str.begin(), (char.iterator<?>)Str.end());
    }

    public static void AdjustToPrecision(APInt significand, int.ref exp, int FormatPrecision) {
        int bitsRequired;
        int bits = significand.getActiveBits();
        if (Unsigned.$lesseq_uint((int)bits, (int)(bitsRequired = Unsigned.$div_uint((int)(FormatPrecision * 196 + 58), (int)59)))) {
            return;
        }
        int tensRemovable = Unsigned.$div_uint((int)((bits - bitsRequired) * 59), (int)196);
        if (tensRemovable == 0) {
            return;
        }
        exp.$set$addassign(tensRemovable);
        APInt divisor = new APInt(significand.getBitWidth(), Unsigned.$int2ulong((int)1));
        APInt powten = new APInt(significand.getBitWidth(), Unsigned.$int2ulong((int)10));
        while (true) {
            if ((tensRemovable & 1) != 0) {
                divisor.$starassign(powten);
            }
            if ((tensRemovable >>>= 1) == 0) break;
            powten.$starassign(powten);
        }
        significand.$assignMove(significand.udiv(divisor));
        significand.$assignMove(significand.trunc(significand.getActiveBits()));
    }

    public static void AdjustToPrecision(SmallString buffer, int.ref exp, int FormatPrecision) {
        int N = buffer.size();
        if (Unsigned.$lesseq_uint((int)N, (int)FormatPrecision)) {
            return;
        }
        int FirstSignificant = N - FormatPrecision;
        if (buffer.$at(FirstSignificant - 1) < 53) {
            while (Unsigned.$less_uint((int)FirstSignificant, (int)N) && buffer.$at(FirstSignificant) == 48) {
                ++FirstSignificant;
            }
            exp.$set$addassign(FirstSignificant);
            buffer.erase((char.ptr)Native.$AddrOf((Object)buffer.ptr$at(0)), (char.ptr)Native.$AddrOf((Object)buffer.ptr$at(FirstSignificant)));
            return;
        }
        for (int I = FirstSignificant; I != N; ++I) {
            if (buffer.$at(I) == 57) {
                ++FirstSignificant;
                continue;
            }
            buffer.ref$at(I).$set$postInc();
            break;
        }
        if (FirstSignificant == N) {
            exp.$set$addassign(FirstSignificant);
            buffer.clear();
            buffer.push_back((byte)49);
            return;
        }
        exp.$set$addassign(FirstSignificant);
        buffer.erase((char.ptr)Native.$AddrOf((Object)buffer.ptr$at(0)), (char.ptr)Native.$AddrOf((Object)buffer.ptr$at(FirstSignificant)));
    }
}

