/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.StringRef;
import org.llvm.support.TimeRecord;
import org.llvm.support.Timer;
import org.llvm.support.impl.LlvmStatics;
import org.llvm.support.impl.TimerStatics;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.SmartScopedLock;

public class TimerGroup
implements Destructors.ClassWithDestructor {
    private std.string Name;
    private Timer FirstTimer;
    private std.vector<std_pair.pairTypeType<TimeRecord, std.string>> TimersToPrint;
    private TimerGroup Prev;
    private TimerGroup Next;

    protected TimerGroup(TimerGroup TG) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected void $assign(TimerGroup TG) {
        throw new UnsupportedOperationException("Deleted");
    }

    public TimerGroup(StringRef name) {
        this.Name = new std.string((char.iterator)name.begin(), (char.iterator)name.end());
        this.FirstTimer = null;
        this.TimersToPrint = new std.vector((Object)new std_pair.pairTypeType((Object)new TimeRecord(), (Object)new std.string()));
        SmartScopedLock L = null;
        try {
            L = new SmartScopedLock(true, TimerStatics.TimerLock.$star());
            if (TimerStatics.TimerGroupList != null) {
                assert (TimerStatics.TimerGroupList.Prev == null);
                TimerStatics.TimerGroupList.Prev = this;
            }
            this.Next = TimerStatics.TimerGroupList;
            this.Prev = null;
            TimerStatics.TimerGroupList = this;
        }
        finally {
            if (L != null) {
                L.$destroy();
            }
        }
    }

    public void $destroy() {
        SmartScopedLock L = null;
        try {
            while (this.FirstTimer != null) {
                this.removeTimer((Timer)Native.$Deref((Object)this.FirstTimer));
            }
            L = new SmartScopedLock(true, TimerStatics.TimerLock.$star());
            if (this.Next != null) {
                assert (this.Next.Prev == this);
                this.Next.Prev = this.Prev;
            }
            if (this.Prev != null) {
                assert (this.Prev.Next == this);
                this.Prev.Next = this.Next;
            }
            if (TimerStatics.TimerGroupList == this) {
                assert (this.Prev == null);
                TimerStatics.TimerGroupList = this.Next;
            }
            this.Next = null;
            this.Prev = null;
        }
        finally {
            if (L != null) {
                L.$destroy();
            }
        }
        this.TimersToPrint.$destroy();
        this.Name.$destroy();
    }

    public void setName(StringRef name) {
        this.Name.assign$T((char.iterator)name.begin(), (char.iterator)name.end());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(raw_ostream OS) {
        SmartScopedLock L = null;
        try {
            L = new SmartScopedLock(true, TimerStatics.TimerLock.$star());
            Timer T4 = this.FirstTimer;
            while (T4 != null) {
                if (T4.hasTriggered()) {
                    this.TimersToPrint.emplace_back((Object)new std_pair.pairTypeType((Object)((TimeRecord)Native.$Clone((NativeCloneable)T4.Time)), (Object)((std.string)Native.$Clone((NativeCloneable)T4.Name))));
                    T4.clear();
                }
                T4 = T4.Next;
            }
            if (!this.TimersToPrint.empty()) {
                this.PrintQueuedTimers(OS);
            }
        }
        finally {
            if (L != null) {
                L.$destroy();
            }
        }
    }

    public static void printAll(raw_ostream OS) {
        SmartScopedLock L = null;
        try {
            L = new SmartScopedLock(true, TimerStatics.TimerLock.$star());
            TimerGroup TG = TimerStatics.TimerGroupList;
            while (TG != null) {
                TG.print(OS);
                TG = TG.Next;
            }
        }
        finally {
            if (L != null) {
                L.$destroy();
            }
        }
    }

    void addTimer(Timer T4) {
        SmartScopedLock L = null;
        try {
            L = new SmartScopedLock(true, TimerStatics.TimerLock.$star());
            assert (T4.TG == this) : T4.TG + " vs. " + this;
            if (this.FirstTimer != null) {
                assert (this.FirstTimer.Prev == null);
                this.FirstTimer.Prev = T4;
            }
            T4.Next = this.FirstTimer;
            assert (T4.Prev == null);
            this.FirstTimer = T4;
        }
        finally {
            if (L != null) {
                L.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTimer(Timer T4) {
        SmartScopedLock L = null;
        std_ptr.unique_ptr OutStream = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            L = new SmartScopedLock(true, TimerStatics.TimerLock.$star());
            if (T4.hasTriggered()) {
                this.TimersToPrint.emplace_back((Object)new std_pair.pairTypeType((Object)((TimeRecord)Native.$Clone((NativeCloneable)T4.Time)), (Object)((std.string)Native.$Clone((NativeCloneable)T4.Name))));
            }
            assert (T4.TG == this) : T4.TG + " vs. " + this;
            T4.TG = null;
            if (T4.Next != null) {
                assert (T4.Next.Prev == T4);
                T4.Next.Prev = T4.Prev;
            }
            if (T4.Prev != null) {
                assert (T4.Prev.Next == T4);
                T4.Prev.Next = T4.Next;
            }
            if (this.FirstTimer == T4) {
                assert (T4.Prev == null);
                this.FirstTimer = T4.Next;
            }
            T4.Next = null;
            T4.Prev = null;
            if (this.FirstTimer != null || this.TimersToPrint.empty()) {
                return;
            }
            OutStream = (std_ptr.unique_ptr)$c$.clean((Object)new std_ptr.unique_ptr(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, $c$.track(LlvmStatics.CreateInfoOutputFile())));
            this.PrintQueuedTimers((raw_ostream)OutStream.$star());
        }
        finally {
            if (OutStream != null) {
                OutStream.$destroy();
            }
            if (L != null) {
                L.$destroy();
            }
            $c$.$destroy();
        }
    }

    private void PrintQueuedTimers(raw_ostream OS) {
        std.sort((type.iterator)this.TimersToPrint.begin(), (type.iterator)this.TimersToPrint.end(), (std.Compare)new std.Compare<std_pair.pairTypeType<TimeRecord, std.string>>(){

            public boolean compare(std_pair.pairTypeType<TimeRecord, std.string> a, std_pair.pairTypeType<TimeRecord, std.string> b) {
                if (((TimeRecord)a.first).$less((TimeRecord)b.first)) {
                    return true;
                }
                if (((TimeRecord)b.first).$less((TimeRecord)a.first)) {
                    return false;
                }
                return ((std.string)a.second).$less(b.second);
            }
        });
        TimeRecord Total = new TimeRecord();
        for (std_pair.pairTypeType RecordNamePair : this.TimersToPrint) {
            Total.$addassign((TimeRecord)RecordNamePair.first);
        }
        OS.$out("===").$out(new std.string(73, 45)).$out("===\n");
        int Padding = Unsigned.$div_uint((int)(80 - this.Name.length()), (int)2);
        if (Unsigned.$greater_uint((int)Padding, (int)80)) {
            Padding = 0;
        }
        OS.indent(Padding).$out(this.Name).$out_char((byte)10);
        OS.$out("===").$out(new std.string(73, 45)).$out("===\n");
        if (this != TimerStatics.DefaultTimerGroup) {
            OS.$out(llvm.format("  Total Execution Time: %5.4f seconds (%5.4f wall clock)\n", Total.getProcessTime(), Total.getWallTime()));
        }
        OS.$out_char((byte)10);
        if (Total.getUserTime() != 0.0) {
            OS.$out("   ---User Time---");
        }
        if (Total.getSystemTime() != 0.0) {
            OS.$out("   --System Time--");
        }
        if (Total.getProcessTime() != 0.0) {
            OS.$out("   --User+System--");
        }
        OS.$out("   ---Wall Time---");
        if (Total.getMemUsed() != 0) {
            OS.$out("  ---Mem---");
        }
        OS.$out("  --- Name ---\n");
        int e = this.TimersToPrint.size();
        for (int i = 0; i != e; ++i) {
            std_pair.pairTypeType Entry2 = (std_pair.pairTypeType)this.TimersToPrint.$at(e - i - 1);
            ((TimeRecord)Entry2.first).print(Total, OS);
            OS.$out((std.string)Entry2.second).$out_char((byte)10);
        }
        Total.print(Total, OS);
        OS.$out("Total\n\n");
        OS.flush();
        this.TimersToPrint.clear();
    }

    public String toString() {
        return "Name=" + this.Name.toJavaString() + ", FirstTimer=" + (this.FirstTimer != null ? this.FirstTimer.Name.toJavaString() : "<null>") + ", TimersToPrint=" + this.TimersToPrint.size() + ", Prev=" + (this.Prev == null ? "<null>" : this.Prev.Name.toJavaString()) + ", Next=" + (this.Next == null ? "<null>" : this.Next.Name.toJavaString());
    }
}

