/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.support.DataStreamer;
import org.llvm.support.MemoryObject;

public class StreamingMemoryObject
extends MemoryObject
implements Destructors.ClassWithDestructor {
    public static int kChunkSize = 16384;
    private std.vectorChar Bytes;
    private std_ptr.unique_ptr<DataStreamer> Streamer;
    private int BytesRead;
    private int BytesSkipped;
    private int ObjectSize;
    private boolean EOFReached;

    public StreamingMemoryObject(std_ptr.unique_ptr<DataStreamer> Streamer) {
        this.Bytes = new std.vectorChar(kChunkSize);
        this.Streamer = new std_ptr.unique_ptr(JavaDifferentiators.JD.Move.INSTANCE, (std_ptr.unique_ptr)std.move(Streamer));
        this.BytesRead = 0;
        this.BytesSkipped = 0;
        this.ObjectSize = 0;
        this.EOFReached = false;
        this.BytesRead = ((DataStreamer)this.Streamer.$arrow()).GetBytes((char.ptr)Native.$AddrOf((Object)this.Bytes.ptr$at(0)), kChunkSize);
    }

    @Override
    public long getExtent() {
        if (this.ObjectSize != 0) {
            return Unsigned.$uint2ulong((int)this.ObjectSize);
        }
        int pos = this.BytesRead + kChunkSize;
        while (this.fetchToPos(pos)) {
            pos += kChunkSize;
        }
        return Unsigned.$uint2ulong((int)this.ObjectSize);
    }

    @Override
    public long readBytes(char.ptr Buf, long Size, long Address) {
        int MaxAddress;
        this.fetchToPos(Unsigned.$ullong2uint((long)(Address + Size - Unsigned.$int2ullong((int)1))));
        int n = MaxAddress = this.ObjectSize != 0 && Unsigned.$less_uint((int)this.ObjectSize, (int)this.BytesRead) ? this.ObjectSize : this.BytesRead;
        if (Unsigned.$greatereq_ulong_uint((long)Address, (int)MaxAddress)) {
            return Unsigned.$int2ulong((int)0);
        }
        long End2 = Address + Size;
        if (Unsigned.$greater_ulong_uint((long)End2, (int)MaxAddress)) {
            End2 = Unsigned.$uint2ulong((int)MaxAddress);
        }
        assert (Unsigned.$greatereq_ulong((long)End2, (long)Address));
        Size = End2 - Address;
        std.memcpy((char.ptr)Buf, (char.ptr)((char.ptr)Native.$AddrOf((Object)this.Bytes.ptr$at(Unsigned.$ullong2uint((long)(Address + Unsigned.$uint2ullong((int)this.BytesSkipped)))))), (int)Unsigned.$ulong2uint((long)Size));
        return Size;
    }

    @Override
    public char.ptr getPointer(long Address, long Size) {
        this.fetchToPos(Unsigned.$ullong2uint((long)(Address + Size - Unsigned.$int2ullong((int)1))));
        return (char.ptr)Native.$AddrOf((Object)this.Bytes.ptr$at(Unsigned.$ullong2uint((long)(Address + Unsigned.$uint2ullong((int)this.BytesSkipped)))));
    }

    @Override
    public boolean isValidAddress(long address) {
        if (this.ObjectSize != 0 && Unsigned.$less_ulong_uint((long)address, (int)this.ObjectSize)) {
            return true;
        }
        return this.fetchToPos(Unsigned.$ulong2uint((long)address));
    }

    public boolean dropLeadingBytes(int s) {
        if (Unsigned.$less_uint((int)this.BytesRead, (int)s)) {
            return true;
        }
        this.BytesSkipped = s;
        this.BytesRead -= s;
        return false;
    }

    public void setKnownObjectSize(int size) {
        this.ObjectSize = size;
        this.Bytes.reserve(size);
        if (Unsigned.$lesseq_uint((int)this.ObjectSize, (int)this.BytesRead)) {
            this.EOFReached = true;
        }
    }

    private boolean fetchToPos(int Pos2) {
        while (Unsigned.$greatereq_uint((int)Pos2, (int)this.BytesRead)) {
            if (this.EOFReached) {
                return false;
            }
            this.Bytes.resize(this.BytesRead + this.BytesSkipped + kChunkSize);
            int bytes = ((DataStreamer)this.Streamer.$arrow()).GetBytes((char.ptr)Native.$AddrOf((Object)this.Bytes.ptr$at(this.BytesRead + this.BytesSkipped)), kChunkSize);
            this.BytesRead += bytes;
            if (bytes != 0) continue;
            if (this.ObjectSize == 0) {
                this.ObjectSize = this.BytesRead;
            }
            this.EOFReached = true;
        }
        return this.ObjectSize == 0 || Unsigned.$less_uint((int)Pos2, (int)this.ObjectSize);
    }

    protected StreamingMemoryObject(StreamingMemoryObject $Prm0) {
        super($Prm0);
        throw new UnsupportedOperationException("Deleted");
    }

    protected void $assign(StreamingMemoryObject $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    @Override
    public void $destroy() {
        this.Streamer.$destroy();
        this.Bytes.$destroy();
        super.$destroy();
    }

    @Override
    public String toString() {
        return "Bytes=" + this.Bytes.size() + ", Streamer=" + NativeTrace.getIdentityStr((Object)this.Streamer.get()) + ", BytesRead=" + this.BytesRead + ", BytesSkipped=" + this.BytesSkipped + ", ObjectSize=" + this.ObjectSize + ", EOFReached=" + this.EOFReached + super.toString();
    }
}

