/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSet;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapConstIterator;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.adt.aliases.StringMapIterator;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.Regex;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class SpecialCaseList
implements Destructors.ClassWithDestructor {
    private StringMap<StringMap<Entry>> Entries;
    private StringMap<StringMap<std.string>> Regexps;
    private boolean IsCompiled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std_ptr.unique_ptr<SpecialCaseList> create(std.vectorString Paths, std.string Error2) {
        std_ptr.unique_ptr SCL = null;
        try {
            SCL = new std_ptr.unique_ptr((Object)new SpecialCaseList());
            for (std.string Path2 : Paths) {
                ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> FileOrErr = null;
                FileOrErr = MemoryBuffer.getFile(new Twine(Path2));
                std_errors.error_code EC = FileOrErr.getError();
                if (EC.$bool()) {
                    Error2.$assignMove(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(new Twine("can't open file '"), new Twine(Path2)), new Twine("': ")), new Twine(EC.message())).str());
                    std_ptr.unique_ptr unique_ptr2 = new std_ptr.unique_ptr(JavaDifferentiators.JD$NullPtr.INSTANCE, null);
                    return unique_ptr2;
                }
                std.string ParseError = new std.string();
                if (((SpecialCaseList)SCL.$arrow()).parse((MemoryBuffer)FileOrErr.get().get(), ParseError)) continue;
                Error2.$assignMove(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(new Twine("error parsing file '"), new Twine(Path2)), new Twine("': ")), new Twine(ParseError)).str());
                std_ptr.unique_ptr unique_ptr3 = new std_ptr.unique_ptr(JavaDifferentiators.JD$NullPtr.INSTANCE, null);
                return unique_ptr3;
                finally {
                    if (FileOrErr == null) continue;
                    FileOrErr.$destroy();
                }
            }
            ((SpecialCaseList)SCL.$arrow()).compile();
            Iterator iterator2 = new std_ptr.unique_ptr(JavaDifferentiators.JD.Move.INSTANCE, SCL);
            return iterator2;
        }
        finally {
            if (SCL != null) {
                SCL.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std_ptr.unique_ptr<SpecialCaseList> create(MemoryBuffer MB, std.string Error2) {
        std_ptr.unique_ptr SCL = null;
        try {
            SCL = new std_ptr.unique_ptr((Object)new SpecialCaseList());
            if (!((SpecialCaseList)SCL.$arrow()).parse(MB, Error2)) {
                std_ptr.unique_ptr unique_ptr2 = new std_ptr.unique_ptr(JavaDifferentiators.JD$NullPtr.INSTANCE, null);
                return unique_ptr2;
            }
            ((SpecialCaseList)SCL.$arrow()).compile();
            std_ptr.unique_ptr unique_ptr3 = new std_ptr.unique_ptr(JavaDifferentiators.JD.Move.INSTANCE, SCL);
            return unique_ptr3;
        }
        finally {
            if (SCL != null) {
                SCL.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std_ptr.unique_ptr<SpecialCaseList> createOrDie(std.vectorString Paths) {
        std.string Error2 = new std.string();
        std_ptr.unique_ptr<SpecialCaseList> SCL = null;
        try {
            SCL = SpecialCaseList.create(Paths, Error2);
            if (SCL.$bool()) {
                std_ptr.unique_ptr unique_ptr2 = new std_ptr.unique_ptr(JavaDifferentiators.JD.Move.INSTANCE, SCL);
                return unique_ptr2;
            }
        }
        finally {
            if (SCL != null) {
                SCL.$destroy();
            }
        }
        llvm.report_fatal_error(Error2);
        throw new llvm_unreachable(SpecialCaseList.class.getSimpleName() + ".createOrDie has died");
    }

    public void $destroy() {
        this.Regexps.$destroy();
        this.Entries.$destroy();
    }

    public boolean inSection(StringRef Section, StringRef Query) {
        return this.inSection(Section, Query, new StringRef());
    }

    public boolean inSection(String Section, StringRef Query) {
        return this.inSection(Section, Query, new StringRef());
    }

    public boolean inSection(String Section, StringRef Query, StringRef Category2) {
        return this.inSection(new StringRef(Section), Query, Category2);
    }

    public boolean inSection(StringRef Section, StringRef Query, StringRef Category2) {
        assert (this.IsCompiled) : "SpecialCaseList::compile() was not called!";
        StringMapIterator<StringMap<Entry>> I = this.Entries.find(Section);
        if (I.$eq(this.Entries.end())) {
            return false;
        }
        StringMapIterator II = ((StringMap)((StringMapEntry)((StringMapConstIterator)I).$arrow()).second).find(Category2);
        if (II.$eq(((StringMap)((StringMapEntry)((StringMapConstIterator)I).$arrow()).second).end())) {
            return false;
        }
        return ((Entry)((StringMapEntry)((StringMapConstIterator)II).$arrow()).getValue()).match(Query);
    }

    private SpecialCaseList(SpecialCaseList $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private SpecialCaseList $assign(SpecialCaseList $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private SpecialCaseList() {
        this.Entries = new StringMap<StringMap<Entry>>(new StringMap<Entry>(new Entry()));
        this.Regexps = new StringMap<StringMap<std.string>>(new StringMap<std.string>(new std.string()));
        this.IsCompiled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parse(MemoryBuffer MB, std.string Error2) {
        SmallVector<StringRef> Lines = new SmallVector<StringRef>(16, new StringRef());
        llvm.SplitString(MB.getBuffer(), Lines, new StringRef("\n\r"));
        int LineNo = 1;
        type.ptr I = Lines.begin();
        type.ptr E = Lines.end();
        while (I.$noteq(E)) {
            Regex CheckRE = null;
            try {
                if (!((StringRef)I.$star()).empty() && !((StringRef)I.$star()).startswith("#")) {
                    std_pair.pairTypeType<StringRef, StringRef> SplitLine = ((StringRef)I.$star()).split(":");
                    StringRef Prefix = new StringRef((StringRef)SplitLine.first);
                    if (((StringRef)SplitLine.second).empty()) {
                        Error2.$assignMove(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(new Twine("malformed line "), new Twine(JavaDifferentiators.JD.Int.INSTANCE, LineNo)), new Twine(": '")), new Twine((StringRef)SplitLine.first)), new Twine(NativePointer.$SGL_QUOTE)).str());
                        boolean bl = false;
                        return bl;
                    }
                    std_pair.pairTypeType<StringRef, StringRef> SplitRegexp = ((StringRef)SplitLine.second).split("=");
                    std.string Regexp = ((StringRef)SplitRegexp.first).$string();
                    StringRef Category2 = new StringRef((StringRef)SplitRegexp.second);
                    if (Regex.isLiteralERE(new StringRef(Regexp))) {
                        this.Entries.$at((StringRef)Prefix).$at((StringRef)Category2).Strings.insert(new StringRef(Regexp));
                    } else {
                        int pos = 0;
                        while ((pos = Regexp.find((CharSequence)"*", pos)) != std.string.npos) {
                            Regexp.replace(pos, std.strlen((char.ptr)NativePointer.$STAR), NativePointer.$DOT_STAR);
                            pos += std.strlen((char.ptr)NativePointer.$DOT_STAR);
                        }
                        CheckRE = new Regex(new StringRef(Regexp));
                        std.string REError = new std.string();
                        if (!CheckRE.isValid(REError)) {
                            Error2.$assignMove(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(new Twine("malformed regex in line "), new Twine(JavaDifferentiators.JD.Int.INSTANCE, LineNo)), new Twine(": '")), new Twine((StringRef)SplitLine.second)), new Twine("': ")), new Twine(REError)).str());
                            boolean bl = false;
                            return bl;
                        }
                        if (!this.Regexps.$at(Prefix).$at(Category2).empty()) {
                            this.Regexps.$at(Prefix).$at(Category2).$addassign((CharSequence)"|");
                        }
                        this.Regexps.$at(Prefix).$at(Category2).$addassign(std.$add_str_T((std.string)std.$add_T_str$C((String)"^", (std.string)Regexp), (String)"$"));
                    }
                }
            }
            finally {
                if (CheckRE != null) {
                    CheckRE.$destroy();
                }
            }
            I.$preInc();
            ++LineNo;
        }
        return true;
    }

    private void compile() {
        assert (!this.IsCompiled) : "compile() should only be called once";
        StringMapIterator<StringMap<std.string>> I = new StringMapIterator<StringMap<std.string>>(JavaDifferentiators.JD.Move.INSTANCE, this.Regexps.begin());
        StringMapIterator<StringMap<std.string>> E = new StringMapIterator<StringMap<std.string>>(JavaDifferentiators.JD.Move.INSTANCE, this.Regexps.end());
        while (I.$noteq(E)) {
            StringMapIterator II = ((StringMap)((StringMapEntry)I.$arrow()).second).begin();
            StringMapIterator IE = ((StringMap)((StringMapEntry)I.$arrow()).second).end();
            while (II.$noteq(IE)) {
                this.Entries.$at((StringRef)((StringMapEntry)I.$arrow()).getKey()).$at((StringRef)((StringMapEntry)II.$arrow()).getKey()).RegEx.reset((Object)new Regex(new StringRef((std.string)((StringMapEntry)II.$arrow()).getValue())));
                II.$preInc();
            }
            I.$preInc();
        }
        this.Regexps.clear();
        this.IsCompiled = true;
    }

    public String toString() {
        return "Entries=" + this.Entries + ", Regexps=" + this.Regexps + ", IsCompiled=" + this.IsCompiled;
    }

    private static class Entry
    implements Destructors.ClassWithDestructor,
    NativeCloneable<Entry> {
        public StringSet Strings;
        public std_ptr.unique_ptr<Regex> RegEx;

        public Entry() {
            this.Strings = new StringSet();
            this.RegEx = new std_ptr.unique_ptr();
        }

        public Entry(JavaDifferentiators.JD.Move _dparam, Entry Other) {
            throw new UnsupportedOperationException("EmptyBody");
        }

        public boolean match(StringRef Query) {
            return this.Strings.count(new StringRef(Query)) != 0 || this.RegEx.$bool() && ((Regex)this.RegEx.$arrow()).match(Query);
        }

        public void $destroy() {
            this.RegEx.$destroy();
            this.Strings.$destroy();
        }

        public Entry clone() {
            assert (this.Strings.empty()) : "must clone only as empty default value";
            assert (!this.RegEx.$bool()) : "must clone only as empty default value";
            return new Entry();
        }

        public String toString() {
            return "Strings=" + this.Strings + ", RegEx=" + this.RegEx;
        }
    }
}

