/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.NoneType;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.SMFixIt;
import org.llvm.support.SMLoc;
import org.llvm.support.SourceMgr;
import org.llvm.support.impl.SourceMgrStatics;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class SMDiagnostic
implements Destructors.ClassWithDestructor {
    private SourceMgr SM;
    private SMLoc Loc;
    private std.string Filename;
    private int LineNo;
    private int ColumnNo;
    private SourceMgr.DiagKind Kind;
    private std.string Message;
    private std.string LineContents;
    private std.vector<std_pair.pairUIntUInt> Ranges;
    private SmallVector<SMFixIt> FixIts;

    public SMDiagnostic() {
        this.SM = null;
        this.Loc = new SMLoc();
        this.Filename = new std.string();
        this.LineNo = 0;
        this.ColumnNo = 0;
        this.Kind = SourceMgr.DiagKind.DK_Error;
        this.Message = new std.string();
        this.LineContents = new std.string();
        this.Ranges = new std.vector((Object)new std_pair.pairUIntUInt());
        this.FixIts = new SmallVector<SMFixIt>(4, new SMFixIt());
    }

    public SMDiagnostic(StringRef filename, SourceMgr.DiagKind Knd, StringRef Msg) {
        this.SM = null;
        this.Loc = new SMLoc();
        this.Filename = filename.$string();
        this.LineNo = -1;
        this.ColumnNo = -1;
        this.Kind = Knd;
        this.Message = Msg.$string();
        this.LineContents = new std.string();
        this.Ranges = new std.vector((Object)new std_pair.pairUIntUInt());
        this.FixIts = new SmallVector<SMFixIt>(4, new SMFixIt());
    }

    public SMDiagnostic(SourceMgr sm, SMLoc L, StringRef FN, int Line, int Col, SourceMgr.DiagKind Kind2, StringRef Msg, StringRef LineStr, ArrayRef<std_pair.pairUIntUInt> Ranges) {
        this(sm, L, FN, Line, Col, Kind2, Msg, LineStr, Ranges, new ArrayRef<NoneType>(llvm.None, false));
    }

    public SMDiagnostic(SourceMgr sm, SMLoc L, StringRef FN, int Line, int Col, SourceMgr.DiagKind Kind2, StringRef Msg, StringRef LineStr, ArrayRef<std_pair.pairUIntUInt> Ranges, ArrayRef<SMFixIt> Hints) {
        this.SM = (SourceMgr)Native.$AddrOf((Object)sm);
        this.Loc = new SMLoc(L);
        this.Filename = FN.$string();
        this.LineNo = Line;
        this.ColumnNo = Col;
        this.Kind = Kind2;
        this.Message = Msg.$string();
        this.LineContents = LineStr.$string();
        this.Ranges = Ranges.vec();
        this.FixIts = new SmallVector<SMFixIt>(JavaDifferentiators.JD.T.INSTANCE, 4, (type.iterator<?, SMFixIt>)Hints.begin(), (type.iterator<?, SMFixIt>)Hints.end(), new SMFixIt());
        std.sort(this.FixIts.begin(), this.FixIts.end());
    }

    public SourceMgr getSourceMgr() {
        return this.SM;
    }

    public SMLoc getLoc() {
        return new SMLoc(this.Loc);
    }

    public StringRef getFilename() {
        return new StringRef(this.Filename);
    }

    public int getLineNo() {
        return this.LineNo;
    }

    public int getColumnNo() {
        return this.ColumnNo;
    }

    public SourceMgr.DiagKind getKind() {
        return this.Kind;
    }

    public StringRef getMessage() {
        return new StringRef(this.Message);
    }

    public StringRef getLineContents() {
        return new StringRef(this.LineContents);
    }

    public ArrayRef<std_pair.pairUIntUInt> getRanges() {
        return new ArrayRef<std_pair.pairUIntUInt>(this.Ranges, false);
    }

    public void addFixIt(SMFixIt Hint) {
        this.FixIts.push_back_T$C$R(Hint);
    }

    public ArrayRef<SMFixIt> getFixIts() {
        return new ArrayRef<SMFixIt>(this.FixIts, false);
    }

    public void print(char.ptr ProgName, raw_ostream S2) {
        this.print(ProgName, S2, true, true);
    }

    public void print(char.ptr ProgName, raw_ostream S2, boolean ShowColors) {
        this.print(ProgName, S2, ShowColors, true);
    }

    public void print(char.ptr ProgName, raw_ostream S2, boolean ShowColors, boolean ShowKindLabel) {
        int i;
        if (ShowColors &= S2.has_colors()) {
            S2.changeColor(raw_ostream.Colors.SAVEDCOLOR, true);
        }
        if (Native.$bool((Native.Native$Bool)ProgName) && ProgName.$at(0) != 0) {
            S2.$out(ProgName).$out(": ");
        }
        if (!this.Filename.empty()) {
            if (std.$eq_string$C_T$C$P((std.string)this.Filename, (String)"-")) {
                S2.$out("<stdin>");
            } else {
                S2.$out(this.Filename);
            }
            if (this.LineNo != -1) {
                S2.$out_char((byte)58).$out_int(this.LineNo);
                if (this.ColumnNo != -1) {
                    S2.$out_char((byte)58).$out_int(this.ColumnNo + 1);
                }
            }
            S2.$out(": ");
        }
        if (ShowKindLabel) {
            switch (this.Kind) {
                case DK_Error: {
                    if (ShowColors) {
                        S2.changeColor(raw_ostream.Colors.RED, true);
                    }
                    S2.$out("error: ");
                    break;
                }
                case DK_Warning: {
                    if (ShowColors) {
                        S2.changeColor(raw_ostream.Colors.MAGENTA, true);
                    }
                    S2.$out("warning: ");
                    break;
                }
                case DK_Note: {
                    if (ShowColors) {
                        S2.changeColor(raw_ostream.Colors.BLACK, true);
                    }
                    S2.$out("note: ");
                }
            }
            if (ShowColors) {
                S2.resetColor();
                S2.changeColor(raw_ostream.Colors.SAVEDCOLOR, true);
            }
        }
        S2.$out(this.Message).$out_char((byte)10);
        if (ShowColors) {
            S2.resetColor();
        }
        if (this.LineNo == -1 || this.ColumnNo == -1) {
            return;
        }
        if (std.$noteq___normal_iterator$C((abstract_iterator)std.find_if((char.iterator)this.LineContents.begin$Const(), (char.iterator)this.LineContents.end$Const(), SourceMgrStatics::isNonASCII), (abstract_iterator)this.LineContents.end$Const())) {
            SourceMgrStatics.printSourceLine(S2, new StringRef(this.LineContents));
            return;
        }
        int NumColumns = this.LineContents.size();
        std.string CaretLine = new std.string(NumColumns + 1, 32);
        int e = this.Ranges.size();
        for (int r = 0; r != e; ++r) {
            std_pair.pairUIntUInt R2 = new std_pair.pairUIntUInt((std_pair.pairUIntUInt)this.Ranges.$at$Const(r));
            std.fill((char.iterator)((char.iterator)Native.$AddrOf((Object)CaretLine.ptr$at(R2.first))), (char.iterator)((char.iterator)Native.$AddrOf((Object)CaretLine.ptr$at(std.min_uint((int)R2.second, (int)CaretLine.size())))), (byte)126);
        }
        std.string FixItInsertionLine = new std.string();
        SourceMgrStatics.buildFixItLine(CaretLine, FixItInsertionLine, new ArrayRef<SMFixIt>(this.FixIts, false), llvm.makeArrayRef((char.ptr)this.Loc.getPointer().$sub(this.ColumnNo), this.LineContents.size()));
        if (Unsigned.$lesseq_uint((int)this.ColumnNo, (int)NumColumns)) {
            CaretLine.$set(this.ColumnNo, (byte)94);
        } else {
            CaretLine.$set(NumColumns, (byte)94);
        }
        CaretLine.erase(CaretLine.find_last_not_of_T_size_type$_CharT((byte)32) + 1);
        SourceMgrStatics.printSourceLine(S2, new StringRef(this.LineContents));
        if (ShowColors) {
            S2.changeColor(raw_ostream.Colors.GREEN, true);
        }
        int e2 = CaretLine.size();
        int OutCol = 0;
        for (i = 0; i != e2; ++i) {
            if (Unsigned.$greatereq_uint((int)i, (int)this.LineContents.size()) || this.LineContents.$at$Const(i) != 9) {
                S2.$out_char(CaretLine.$at(i));
                ++OutCol;
                continue;
            }
            do {
                S2.$out_char(CaretLine.$at(i));
            } while (Unsigned.$rem_uint((int)(++OutCol), (int)SourceMgrStatics.TabStop) != 0);
        }
        S2.$out_char((byte)10);
        if (ShowColors) {
            S2.resetColor();
        }
        if (FixItInsertionLine.empty()) {
            return;
        }
        i = 0;
        e2 = FixItInsertionLine.size();
        OutCol = 0;
        while (Unsigned.$less_uint((int)i, (int)e2)) {
            if (Unsigned.$greatereq_uint((int)i, (int)this.LineContents.size()) || this.LineContents.$at$Const(i) != 9) {
                S2.$out_char(FixItInsertionLine.$at(i));
                ++OutCol;
            } else {
                do {
                    S2.$out_char(FixItInsertionLine.$at(i));
                    if (FixItInsertionLine.$at(i) == 32) continue;
                    ++i;
                } while (Unsigned.$rem_uint((int)(++OutCol), (int)SourceMgrStatics.TabStop) != 0 && i != e2);
            }
            ++i;
        }
        S2.$out_char((byte)10);
    }

    public SMDiagnostic $assignMove(SMDiagnostic $Prm0) {
        this.SM = $Prm0.SM;
        this.Loc.$assignMove($Prm0.Loc);
        this.Filename.$assignMove($Prm0.Filename);
        this.LineNo = $Prm0.LineNo;
        this.ColumnNo = $Prm0.ColumnNo;
        this.Kind = $Prm0.Kind;
        this.Message.$assignMove($Prm0.Message);
        this.LineContents.$assignMove($Prm0.LineContents);
        this.Ranges.$assignMove($Prm0.Ranges);
        this.FixIts.$assignMove($Prm0.FixIts);
        return this;
    }

    public void $destroy() {
        this.FixIts.$destroy();
        this.Ranges.$destroy();
        this.LineContents.$destroy();
        this.Message.$destroy();
        this.Filename.$destroy();
    }

    public SMDiagnostic(JavaDifferentiators.JD.Move _dparam, SMDiagnostic $Prm0) {
        this.SM = $Prm0.SM;
        this.Loc = new SMLoc(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Loc);
        this.Filename = new std.string(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Filename);
        this.LineNo = $Prm0.LineNo;
        this.ColumnNo = $Prm0.ColumnNo;
        this.Kind = $Prm0.Kind;
        this.Message = new std.string(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Message);
        this.LineContents = new std.string(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.LineContents);
        this.Ranges = new std.vector(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Ranges);
        this.FixIts = new SmallVector<SMFixIt>(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.FixIts);
    }

    public String toString() {
        return "SM=" + this.SM + ", Loc=" + this.Loc + ", Filename=" + this.Filename + ", LineNo=" + this.LineNo + ", ColumnNo=" + this.ColumnNo + ", Kind=" + (Object)((Object)this.Kind) + ", Message=" + this.Message + ", LineContents=" + this.LineContents + ", Ranges=" + this.Ranges + ", FixIts=" + this.FixIts;
    }
}

