/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.signal;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeTrace;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.CrashRecoveryContextCleanup;
import org.llvm.support.impl.CrashRecoveryContextImpl;
import org.llvm.support.impl.CrashRecoveryContextStatics;
import org.llvm.support.impl.RunSafelyOnThreadInfo;
import org.llvm.support.sys.SmartScopedLock;

public class CrashRecoveryContext
implements Destructors.ClassWithDestructor {
    private Object Impl = null;
    private CrashRecoveryContextCleanup head = null;

    public void $destroy() {
        CrashRecoveryContextCleanup i = this.head;
        CrashRecoveryContext PC = CrashRecoveryContextStatics.tlIsRecoveringFromCrash.$arrow().get();
        CrashRecoveryContextStatics.tlIsRecoveringFromCrash.$arrow().set(this);
        while (i != null) {
            CrashRecoveryContextCleanup tmp = i;
            i = tmp.next;
            tmp.cleanupFired = true;
            tmp.recoverResources();
            if (tmp == null) continue;
            tmp.$destroy();
        }
        CrashRecoveryContextStatics.tlIsRecoveringFromCrash.$arrow().set(PC);
        CrashRecoveryContextImpl CRCI = (CrashRecoveryContextImpl)this.Impl;
        if (CRCI != null) {
            CRCI.$destroy();
        }
    }

    public void registerCleanup(CrashRecoveryContextCleanup cleanup) {
        if (cleanup == null) {
            return;
        }
        if (this.head != null) {
            this.head.prev = cleanup;
        }
        cleanup.next = this.head;
        this.head = cleanup;
    }

    public void unregisterCleanup(CrashRecoveryContextCleanup cleanup) {
        if (cleanup == null) {
            return;
        }
        if (cleanup == this.head) {
            this.head = cleanup.next;
            if (this.head != null) {
                this.head.prev = null;
            }
        } else {
            cleanup.prev.next = cleanup.next;
            if (cleanup.next != null) {
                cleanup.next.prev = cleanup.prev;
            }
        }
        if (cleanup != null) {
            cleanup.$destroy();
        }
    }

    public static void Enable() {
        SmartScopedLock L = null;
        try {
            L = new SmartScopedLock(false, CrashRecoveryContextStatics.gCrashRecoveryContextMutex.$star());
            if (CrashRecoveryContextStatics.gCrashRecoveryEnabled) {
                return;
            }
            CrashRecoveryContextStatics.gCrashRecoveryEnabled = true;
            signal.sigaction Handler = new signal.sigaction();
            Handler._funcptr._handler = CrashRecoveryContextStatics::CrashRecoverySignalHandler;
            Handler.sa_flags = 0;
            signal.sigemptyset((signal.sigset_t)((signal.sigset_t)Native.$AddrOf((Object)Handler.sa_mask)));
            for (int i = 0; i != CrashRecoveryContextStatics.NumSignals; ++i) {
                signal.sigaction((int)CrashRecoveryContextStatics.Signals[i], (signal.sigaction)((signal.sigaction)Native.$AddrOf((Object)Handler)), (signal.sigaction)((signal.sigaction)Native.$AddrOf((Object)CrashRecoveryContextStatics.PrevActions[i])));
            }
        }
        finally {
            if (L != null) {
                L.$destroy();
            }
        }
    }

    public static void Disable() {
        SmartScopedLock L = null;
        try {
            L = new SmartScopedLock(false, CrashRecoveryContextStatics.gCrashRecoveryContextMutex.$star());
            if (!CrashRecoveryContextStatics.gCrashRecoveryEnabled) {
                return;
            }
            CrashRecoveryContextStatics.gCrashRecoveryEnabled = false;
            for (int i = 0; i != CrashRecoveryContextStatics.NumSignals; ++i) {
                signal.sigaction((int)CrashRecoveryContextStatics.Signals[i], (signal.sigaction)((signal.sigaction)Native.$AddrOf((Object)CrashRecoveryContextStatics.PrevActions[i])), (signal.sigaction)null);
            }
        }
        finally {
            if (L != null) {
                L.$destroy();
            }
        }
    }

    public static CrashRecoveryContext GetCurrent() {
        if (!CrashRecoveryContextStatics.gCrashRecoveryEnabled) {
            return null;
        }
        CrashRecoveryContextImpl CRCI = CrashRecoveryContextStatics.CurrentContext.$arrow().get();
        if (CRCI == null) {
            return null;
        }
        return CRCI.CRC;
    }

    public static boolean isRecoveringFromCrash() {
        return CrashRecoveryContextStatics.tlIsRecoveringFromCrash.$arrow().get() != null;
    }

    public boolean RunSafely(NativeCallback.Void2Void Fn) {
        if (CrashRecoveryContextStatics.gCrashRecoveryEnabled) {
            assert (this.Impl == null) : "Crash recovery context already initialized!";
            CrashRecoveryContextImpl CRCI = new CrashRecoveryContextImpl(this);
            this.Impl = CRCI;
        }
        try {
            Fn.$call();
        }
        catch (Throwable e) {
            NativeTrace.registerReason((Throwable)e);
        }
        return true;
    }

    public boolean RunSafely(NativeCallback.VoidPtr2Void Fn, Object UserData) {
        return this.RunSafely(() -> Fn.$call(UserData));
    }

    public boolean RunSafelyOnThread(NativeCallback.Void2Void Fn) {
        return this.RunSafelyOnThread(Fn, 0);
    }

    public boolean RunSafelyOnThread(NativeCallback.Void2Void Fn, int RequestedStackSize) {
        boolean UseBackgroundPriority = CrashRecoveryContextStatics.hasThreadBackgroundPriority();
        RunSafelyOnThreadInfo Info2 = new RunSafelyOnThreadInfo(Fn, this, UseBackgroundPriority, false);
        AdtsupportLlvmGlobals.llvm_execute_on_thread(CrashRecoveryContextStatics::RunSafelyOnThread_Dispatch, Native.$AddrOf((Object)Info2), RequestedStackSize);
        CrashRecoveryContextImpl CRC = (CrashRecoveryContextImpl)this.Impl;
        if (CRC != null) {
            CRC.setSwitchedThread();
        }
        return Info2.Result;
    }

    public boolean RunSafelyOnThread(NativeCallback.VoidPtr2Void Fn, Object UserData) {
        return this.RunSafelyOnThread(Fn, UserData, 0);
    }

    public boolean RunSafelyOnThread(NativeCallback.VoidPtr2Void Fn, Object UserData, int RequestedStackSize) {
        return this.RunSafelyOnThread(() -> Fn.$call(UserData), RequestedStackSize);
    }

    public void HandleCrash() {
        CrashRecoveryContextImpl CRCI = (CrashRecoveryContextImpl)this.Impl;
        assert (CRCI != null) : "Crash recovery context never initialized!";
        CRCI.HandleCrash();
    }

    public String toString() {
        return "Impl=" + NativeTrace.getIdentityStr((Object)this.Impl) + ", head=" + this.head;
    }
}

