/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import java.util.ArrayList;
import org.clank.support.Destructors;
import org.clank.support.NativeMemory;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.llvm.support.raw_ostream;

public abstract class AllocatorBase<DerivedT extends AllocatorBase>
implements Destructors.ClassWithDestructor,
NativeMemory.Allocator {
    private static final boolean TRACE_ALLOCATOR = NativeTrace.CHECK_ALLOCATOR;
    private final int AllocatorIndex;
    private final Exception stack;
    private Exception unregisterStack;
    private static final ArrayList<AllocatorBase> AllocatorStacks = new ArrayList(0);

    protected AllocatorBase() {
        if (TRACE_ALLOCATOR) {
            this.stack = new Exception("Not Freed Allocator (creation stack)");
            this.AllocatorIndex = AllocatorBase.register(this);
        } else {
            this.stack = null;
            this.AllocatorIndex = 0;
        }
    }

    public String toString() {
        return "";
    }

    public void $destroy() {
        if (TRACE_ALLOCATOR) {
            AllocatorBase.unregister(this);
        }
    }

    public abstract long getTotalMemory();

    private static synchronized int register(AllocatorBase alloc) {
        assert (alloc.AllocatorIndex == 0) : "must be not initialized";
        int index = AllocatorStacks.size();
        AllocatorStacks.add(alloc);
        return index;
    }

    private static synchronized void unregister(AllocatorBase alloc) {
        AllocatorBase removed = AllocatorStacks.set(alloc.AllocatorIndex, null);
        if (TRACE_ALLOCATOR) {
            if (removed != alloc) {
                assert (alloc.stack != null) : "must have allocation stack";
                assert (alloc.unregisterStack != null) : "must have unregister stack";
                new Exception("can not unregister twice").printStackTrace(System.err);
                alloc.unregisterStack.printStackTrace(System.err);
                alloc.stack.printStackTrace(System.err);
            } else {
                alloc.unregisterStack = new Exception("Unregistered at:");
            }
        }
        assert (removed == alloc) : "can not unregister twice. See err file for more details";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void DumpDebugTrace(raw_ostream out) {
        if (!TRACE_ALLOCATOR) return;
        Class<AllocatorBase> clazz = AllocatorBase.class;
        synchronized (AllocatorBase.class) {
            int count = 0;
            long knownSize = 0L;
            StringBuilder knownSizes = new StringBuilder();
            for (AllocatorBase alloc : AllocatorStacks) {
                if (alloc == null) continue;
                StackTraceElement knownStaticHelper = AllocatorBase.knownStaticHelpers(alloc.stack);
                if (knownStaticHelper != null) {
                    long totalMemory = alloc.getTotalMemory();
                    knownSize += totalMemory;
                    if (knownSizes.length() != 0) {
                        knownSizes.append("\n\t+");
                    } else {
                        knownSizes.append(" ");
                    }
                    knownSizes.append("[").append(NativeTrace.formatNumber((long)totalMemory)).append("]");
                    knownSizes.append(" at ").append(knownStaticHelper.toString());
                    continue;
                }
                alloc.stack.printStackTrace(System.err);
                ++count;
            }
            if (knownSizes.length() > 0) {
                knownSizes.insert(0, " = Allocations:\n\t").insert(0, NativeTrace.formatNumber((long)knownSize));
            } else {
                knownSizes.append("<Empty>");
            }
            out.$out(String.format("%30s:\t", "Known Allocators Consume")).$out(knownSizes.toString()).$out(NativePointer.$LF);
            out.$out(String.format("%30s:\t", "NOT Destroyed Allocators")).$out(NativeTrace.formatNumber((long)count)).$out(NativePointer.$LF);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static StackTraceElement knownStaticHelpers(Exception stack2) {
        assert (stack2 != null);
        for (StackTraceElement stackElem : stack2.getStackTrace()) {
            String className = stackElem.getClassName();
            String methodName = stackElem.getMethodName();
            if (!"<clinit>".equals(methodName)) continue;
            if ("org.clang.tools.services.support.FileInfo".equals(className)) {
                return stackElem;
            }
            if (!"org.clang.tools.services.impl.PreprocessorInitializer".equals(className)) continue;
            return stackElem;
        }
        return null;
    }
}

