/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.CachedHashStringRef;
import org.llvm.adt.DenseMapInfoCachedHashStringRef;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.DenseMapIteratorTypeUInt;
import org.llvm.adt.aliases.DenseMapTypeUInt;
import org.llvm.mc.impl.StringTableBuilderStatics;
import org.llvm.support.endian.EndianGlobals;
import org.llvm.support.llvm;

public class StringTableBuilder
implements Destructors.ClassWithDestructor {
    private SmallString StringTable = new SmallString(256);
    private DenseMapTypeUInt<CachedHashStringRef> StringIndexMap = new DenseMapTypeUInt<CachedHashStringRef>(DenseMapInfoCachedHashStringRef.$Info(), 0);
    private int Size = 0;
    private Kind K;
    private int Alignment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeStringTable(boolean Optimize) {
        std.vector Strings = null;
        try {
            Strings = new std.vector((Object)null);
            Strings.reserve(this.StringIndexMap.size());
            for (std_pair.pairTypeUInt<CachedHashStringRef> pairTypeUInt2 : this.StringIndexMap) {
                Strings.push_back_T$RR((Object)((std_pair.pairTypeUInt)Native.$AddrOf(pairTypeUInt2)));
            }
            if (!Strings.empty()) {
                if (Optimize) {
                    StringTableBuilderStatics.multikey_qsort((type.ptr<std_pair.pairTypeUInt<CachedHashStringRef>>)((type.ptr)Native.$AddrOf((Object)Strings.ptr$at(0))), (type.ptr<std_pair.pairTypeUInt<CachedHashStringRef>>)((type.ptr)Native.$AddrOf((Object)Strings.ptr$at(Strings.size()))), 0);
                } else {
                    std.sort((type.iterator)Strings.begin(), (type.iterator)Strings.end(), (LHS, RHS) -> Unsigned.$less_uint((int)LHS.second, (int)RHS.second));
                }
            }
            switch (this.K) {
                case RAW: {
                    break;
                }
                case ELF: 
                case MachO: {
                    this.StringTable.$addassign((byte)0);
                    break;
                }
                case WinCOFF: {
                    this.StringTable.append(4, (byte)0);
                }
            }
            StringRef Previous = new StringRef();
            for (std_pair.pairTypeUInt P3 : Strings) {
                int Pos;
                StringRef S2 = new StringRef(((CachedHashStringRef)P3.first).Val);
                if (this.K == Kind.WinCOFF) assert (Unsigned.$greater_uint((int)S2.size(), (int)8)) : "Short string in COFF string table!";
                if (Optimize && Previous.endswith(S2) && ((Pos = this.StringTable.size() - S2.size() - (this.K != Kind.RAW ? 1 : 0)) & this.Alignment - 1) == 0) {
                    P3.second = Pos;
                    continue;
                }
                if (Optimize) {
                    int Start;
                    P3.second = Start = Unsigned.$ulong2uint((long)llvm.alignTo(Unsigned.$uint2ulong((int)this.StringTable.size()), Unsigned.$uint2ulong((int)this.Alignment)));
                    this.StringTable.append(Start - this.StringTable.size(), (byte)0);
                } else assert (P3.second == this.StringTable.size()) : "different strtab offset after finalization";
                this.StringTable.$addassign(S2);
                if (this.K != Kind.RAW) {
                    this.StringTable.$addassign((byte)0);
                }
                Previous.$assign(S2);
            }
            switch (this.K) {
                case RAW: 
                case ELF: {
                    break;
                }
                case MachO: {
                    while (Unsigned.$rem_uint((int)this.StringTable.size(), (int)4) != 0) {
                        this.StringTable.$addassign((byte)0);
                    }
                    break;
                }
                case WinCOFF: {
                    assert (Unsigned.$lesseq_uint((int)this.StringTable.size(), (int)std.numeric_limitsUInt.max()));
                    int n = this.StringTable.size();
                    EndianGlobals.write(this.StringTable.data(), n, Integer.class, llvm.support.endianness.little, 1);
                }
            }
            this.Size = this.StringTable.size();
        }
        finally {
            if (Strings != null) {
                Strings.$destroy();
            }
        }
    }

    public StringTableBuilder(Kind K) {
        this(K, 1);
    }

    public StringTableBuilder(Kind K, int Alignment) {
        this.K = K;
        this.Alignment = Alignment;
        switch (K) {
            case RAW: {
                this.Size = 0;
                break;
            }
            case ELF: 
            case MachO: {
                this.Size = 1;
                break;
            }
            case WinCOFF: {
                this.Size = 4;
            }
        }
    }

    public int add(StringRef S2) {
        assert (!this.isFinalized());
        int Start = Unsigned.$ulong2uint((long)llvm.alignTo(Unsigned.$uint2ulong((int)this.Size), Unsigned.$uint2ulong((int)this.Alignment)));
        std_pair.pairTypeBool P2 = this.StringIndexMap.insert_pair$KeyT$ValueT(new std_pair.pairTypeUInt(JavaDifferentiators.JD$Pair$_U1$_U2.INSTANCE, (Object)new CachedHashStringRef(new StringRef(JavaDifferentiators.JD.Move.INSTANCE, new StringRef(S2))), Start));
        if (P2.second) {
            this.Size = Start + S2.size() + (this.K != Kind.RAW ? 1 : 0);
        }
        return ((DenseMapIteratorTypeUInt)P2.first).$arrow().second;
    }

    public void finalize() {
        this.finalizeStringTable(true);
    }

    public void finalizeInOrder() {
        this.finalizeStringTable(false);
    }

    public StringRef data() {
        assert (this.isFinalized());
        return this.StringTable.$StringRef();
    }

    public int getOffset(StringRef S2) {
        assert (this.isFinalized());
        DenseMapIteratorTypeUInt<CachedHashStringRef> I = this.StringIndexMap.find$Const(new CachedHashStringRef(new StringRef(S2)));
        assert (I.$noteq(this.StringIndexMap.end$Const())) : "String is not in table!";
        return I.$arrow().second;
    }

    public DenseMapTypeUInt<CachedHashStringRef> getMap() {
        return this.StringIndexMap;
    }

    public int getSize() {
        return this.Size;
    }

    public void clear() {
        this.StringTable.clear();
        this.StringIndexMap.clear();
    }

    private boolean isFinalized() {
        return !this.StringTable.empty();
    }

    public void $destroy() {
        this.StringIndexMap.$destroy();
        this.StringTable.$destroy();
    }

    public String toString() {
        return "StringTable=" + this.StringTable + ", StringIndexMap=" + this.StringIndexMap + ", Size=" + this.Size + ", K=" + (Object)((Object)this.K) + ", Alignment=" + this.Alignment;
    }

    public static final class Kind
    extends Enum<Kind>
    implements Native.NativeUIntEnum {
        public static final /* enum */ Kind ELF = new Kind(0);
        public static final /* enum */ Kind WinCOFF = new Kind(ELF.getValue() + 1);
        public static final /* enum */ Kind MachO = new Kind(WinCOFF.getValue() + 1);
        public static final /* enum */ Kind RAW = new Kind(MachO.getValue() + 1);
        private final int value;
        private static final /* synthetic */ Kind[] $VALUES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String name) {
            return Enum.valueOf(Kind.class, name);
        }

        public static Kind valueOf(int val) {
            Kind out;
            Kind kind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private Kind(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Kind[]{ELF, WinCOFF, MachO, RAW};
        }

        private static final class Values {
            private static final Kind[] VALUES;
            private static final Kind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Kind kind : Kind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Kind[min < 0 ? 1 - min : 0];
                VALUES = new Kind[max >= 0 ? 1 + max : 0];
                for (Kind kind : Kind.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((Kind)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((Kind)kind).value] = kind;
                }
            }
        }
    }
}

