/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.type;
import org.clank.support.aliases.ulong;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapInfo$LikePtr;
import org.llvm.adt.aliases.DenseMapTypeUChar;
import org.llvm.adt.aliases.DenseMapTypeUInt;
import org.llvm.adt.aliases.DenseMapTypeULong;
import org.llvm.adt.java.ADTRTTI;
import org.llvm.adt.pointee_iterator;
import org.llvm.mc.DataRegionData;
import org.llvm.mc.IndirectSymbolData;
import org.llvm.mc.MCAsmLayout;
import org.llvm.mc.MCAssembler;
import org.llvm.mc.MCConstantExpr;
import org.llvm.mc.MCExpr;
import org.llvm.mc.MCFixup;
import org.llvm.mc.MCFixupKindInfo;
import org.llvm.mc.MCFragment;
import org.llvm.mc.MCMachObjectTargetWriter;
import org.llvm.mc.MCObjectWriter;
import org.llvm.mc.MCSection;
import org.llvm.mc.MCSectionMachO;
import org.llvm.mc.MCSymbol;
import org.llvm.mc.MCSymbolRefExpr;
import org.llvm.mc.MCValue;
import org.llvm.mc.StringTableBuilder;
import org.llvm.mc.impl.MachObjectWriterStatics;
import org.llvm.support.MachO;
import org.llvm.support.llvm;
import org.llvm.support.raw_pwrite_stream;

public class MachObjectWriter
extends MCObjectWriter
implements Destructors.ClassWithDestructor {
    private std_ptr.unique_ptr<MCMachObjectTargetWriter> TargetObjectWriter;
    private DenseMap<MCSection, std.vector<RelAndSymbol>> Relocations;
    private DenseMapTypeUInt<MCSection> IndirectSymBase;
    private DenseMapTypeULong<MCSection> SectionAddress;
    private StringTableBuilder StringTable;
    private std.vector<MachSymbolData> LocalSymbolData;
    private std.vector<MachSymbolData> ExternalSymbolData;
    private std.vector<MachSymbolData> UndefinedSymbolData;

    private MachSymbolData findSymbolData(MCSymbol Sym) {
        for (std.vector SymbolData : new std.vector[]{(std.vector)Native.$AddrOf(this.LocalSymbolData), (std.vector)Native.$AddrOf(this.ExternalSymbolData), (std.vector)Native.$AddrOf(this.UndefinedSymbolData)}) {
            for (MachSymbolData Entry2 : (std.vector)Native.$Deref((Object)SymbolData)) {
                if (Entry2.Symbol != Native.$AddrOf((Object)Sym)) continue;
                return (MachSymbolData)Native.$AddrOf((Object)Entry2);
            }
        }
        return null;
    }

    public MachObjectWriter(MCMachObjectTargetWriter MOTW, raw_pwrite_stream OS, boolean IsLittleEndian) {
        super(OS, IsLittleEndian);
        this.TargetObjectWriter = new std_ptr.unique_ptr((Object)MOTW);
        this.Relocations = new DenseMap(DenseMapInfo$LikePtr.$Info(), new std.vector((Object)new RelAndSymbol()));
        this.IndirectSymBase = new DenseMapTypeUInt(DenseMapInfo$LikePtr.$Info(), 0);
        this.SectionAddress = new DenseMapTypeULong(DenseMapInfo$LikePtr.$Info(), 0L);
        this.StringTable = new StringTableBuilder(StringTableBuilder.Kind.MachO);
        this.LocalSymbolData = new std.vector((Object)new MachSymbolData());
        this.ExternalSymbolData = new std.vector((Object)new MachSymbolData());
        this.UndefinedSymbolData = new std.vector((Object)new MachSymbolData());
    }

    public MCSymbol findAliasedSymbol(MCSymbol Sym) {
        MCSymbol S2 = (MCSymbol)Native.$AddrOf((Object)Sym);
        while (S2.isVariable()) {
            MCExpr Value = S2.getVariableValue();
            MCSymbolRefExpr Ref = ADTRTTI.dyn_cast_MCSymbolRefExpr(Value);
            if (Ref == null) {
                return (MCSymbol)Native.$Deref((Object)S2);
            }
            S2 = (MCSymbol)Native.$AddrOf((Object)Ref.getSymbol());
        }
        return (MCSymbol)Native.$Deref((Object)S2);
    }

    @Override
    public void reset() {
        this.Relocations.clear();
        this.IndirectSymBase.clear();
        this.StringTable.clear();
        this.LocalSymbolData.clear();
        this.ExternalSymbolData.clear();
        this.UndefinedSymbolData.clear();
        super.reset();
    }

    public boolean isFixupKindPCRel(MCAssembler Asm, int Kind2) {
        MCFixupKindInfo FKI = Asm.getBackend().getFixupKindInfo(Kind2);
        return (FKI.Flags & 1) != 0;
    }

    public DenseMapTypeULong<MCSection> getSectionAddressMap() {
        return this.SectionAddress;
    }

    public long getSectionAddress(MCSection Sec) {
        return this.SectionAddress.lookup(Sec);
    }

    public long getSymbolAddress(MCSymbol S2, MCAsmLayout Layout) {
        if (S2.isVariable()) {
            MCConstantExpr C2 = ADTRTTI.dyn_cast_MCConstantExpr(S2.getVariableValue());
            if (C2 != null) {
                return C2.getValue();
            }
            MCValue Target2 = new MCValue();
            if (!S2.getVariableValue().evaluateAsRelocatable(Target2, (MCAsmLayout)Native.$AddrOf((Object)Layout), null)) {
                llvm.report_fatal_error(llvm.$add_Twine$C(llvm.$add_char$ptr$C_StringRef$C("unable to evaluate offset for variable '", S2.getName()), new Twine(NativePointer.$SGL_QUOTE)));
            }
            if (Target2.getSymA() != null && Target2.getSymA().getSymbol().isUndefined()) {
                llvm.report_fatal_error(llvm.$add_Twine$C(llvm.$add_char$ptr$C_StringRef$C("unable to evaluate offset to undefined symbol '", Target2.getSymA().getSymbol().getName()), new Twine(NativePointer.$SGL_QUOTE)));
            }
            if (Target2.getSymB() != null && Target2.getSymB().getSymbol().isUndefined()) {
                llvm.report_fatal_error(llvm.$add_Twine$C(llvm.$add_char$ptr$C_StringRef$C("unable to evaluate offset to undefined symbol '", Target2.getSymB().getSymbol().getName()), new Twine(NativePointer.$SGL_QUOTE)));
            }
            long Address = Target2.getConstant();
            if (Target2.getSymA() != null) {
                Address += this.getSymbolAddress(Target2.getSymA().getSymbol(), Layout);
            }
            if (Target2.getSymB() != null) {
                Address += this.getSymbolAddress(Target2.getSymB().getSymbol(), Layout);
            }
            return Address;
        }
        return this.getSectionAddress(S2.getFragment().getParent()) + Layout.getSymbolOffset(S2);
    }

    public long getFragmentAddress(MCFragment Fragment, MCAsmLayout Layout) {
        return this.getSectionAddress(Fragment.getParent()) + Layout.getFragmentOffset(Fragment);
    }

    public long getPaddingSize(MCSection Sec, MCAsmLayout Layout) {
        long EndAddr = this.getSectionAddress(Sec) + Layout.getSectionAddressSize(Sec);
        int Next = Sec.getLayoutOrder() + 1;
        if (Unsigned.$greatereq_uint((int)Next, (int)Layout.getSectionOrder$Const().size())) {
            return Unsigned.$int2ulong((int)0);
        }
        MCSection NextSec = (MCSection)Native.$Deref((Object)Layout.getSectionOrder$Const().$at$Const(Next));
        if (NextSec.isVirtualSection()) {
            return Unsigned.$int2ulong((int)0);
        }
        return llvm.OffsetToAlignment(EndAddr, Unsigned.$uint2ulong((int)NextSec.getAlignment()));
    }

    public boolean doesSymbolRequireExternRelocation(MCSymbol S2) {
        if (S2.isUndefined()) {
            return true;
        }
        return ADTRTTI.cast_MCSymbolMachO(S2).isWeakDefinition();
    }

    public boolean is64Bit() {
        return ((MCMachObjectTargetWriter)this.TargetObjectWriter.$arrow()).is64Bit();
    }

    public boolean isX86_64() {
        int CPUType2 = ((MCMachObjectTargetWriter)this.TargetObjectWriter.$arrow()).getCPUType();
        return CPUType2 == MachO.CPUType.CPU_TYPE_X86_64.getValue();
    }

    public void writeHeader(int Type2, int NumLoadCommands, int LoadCommandsSize, boolean SubsectionsViaSymbols) {
        int Flags = 0;
        if (SubsectionsViaSymbols) {
            Flags |= 0x2000;
        }
        long Start = this.getStream().tell();
        this.write32(this.is64Bit() ? -17958193 : -17958194);
        this.write32(((MCMachObjectTargetWriter)this.TargetObjectWriter.$arrow()).getCPUType());
        this.write32(((MCMachObjectTargetWriter)this.TargetObjectWriter.$arrow()).getCPUSubtype());
        this.write32(Type2);
        this.write32(NumLoadCommands);
        this.write32(LoadCommandsSize);
        this.write32(Flags);
        if (this.is64Bit()) {
            this.write32(0);
        }
        assert (this.getStream().tell() - Start == Unsigned.$uint2ullong((int)(this.is64Bit() ? MachO.mach_header_64.$sizeof_Mach_header_64() : MachO.mach_header.$sizeof_Mach_header())));
    }

    public void writeSegmentLoadCommand(StringRef Name2, int NumSections, long VMAddr, long VMSize, long SectionDataStartOffset, long SectionDataSize, int MaxProt, int InitProt) {
        long Start = this.getStream().tell();
        int SegmentLoadCommandSize = this.is64Bit() ? MachO.segment_command_64.$sizeof_Segment_command_64() : MachO.segment_command.$sizeof_Segment_command();
        this.write32(this.is64Bit() ? 25 : 1);
        this.write32(SegmentLoadCommandSize + NumSections * (this.is64Bit() ? MachO.section_64.$sizeof_Section_64() : MachO.section.$sizeof_Section()));
        assert (Unsigned.$lesseq_uint((int)Name2.size(), (int)16));
        this.writeBytes(new StringRef(Name2), 16);
        if (this.is64Bit()) {
            this.write64(VMAddr);
            this.write64(VMSize);
            this.write64(SectionDataStartOffset);
            this.write64(SectionDataSize);
        } else {
            this.write32(Unsigned.$ulong2uint((long)VMAddr));
            this.write32(Unsigned.$ulong2uint((long)VMSize));
            this.write32(Unsigned.$ulong2uint((long)SectionDataStartOffset));
            this.write32(Unsigned.$ulong2uint((long)SectionDataSize));
        }
        this.write32(MaxProt);
        this.write32(InitProt);
        this.write32(NumSections);
        this.write32(0);
        assert (this.getStream().tell() - Start == Unsigned.$uint2ullong((int)SegmentLoadCommandSize));
    }

    public void writeSection(MCAsmLayout Layout, MCSection Sec, long VMAddr, long FileOffset, int Flags, long RelocationsStart, int NumRelocations) {
        long SectionSize = Layout.getSectionAddressSize((MCSection)Native.$AddrOf((Object)Sec));
        MCSectionMachO Section = ADTRTTI.cast_MCSectionMachO(Sec);
        if (Section.isVirtualSection()) {
            assert (Layout.getSectionFileSize((MCSection)Native.$AddrOf((Object)Sec)) == Unsigned.$int2ullong((int)0)) : "Invalid file size!";
            FileOffset = Unsigned.$int2ulong((int)0);
        }
        long Start = this.getStream().tell();
        this.writeBytes(Section.getSectionName(), 16);
        this.writeBytes(Section.getSegmentName(), 16);
        if (this.is64Bit()) {
            this.write64(VMAddr);
            this.write64(SectionSize);
        } else {
            this.write32(Unsigned.$ulong2uint((long)VMAddr));
            this.write32(Unsigned.$ulong2uint((long)SectionSize));
        }
        this.write32(Unsigned.$ulong2uint((long)FileOffset));
        assert (llvm.isPowerOf2_32(Section.getAlignment())) : "Invalid alignment!";
        this.write32(llvm.Log2_32(Section.getAlignment()));
        this.write32(Unsigned.$ullong2uint((long)(NumRelocations != 0 ? RelocationsStart : Unsigned.$int2ullong((int)0))));
        this.write32(NumRelocations);
        this.write32(Flags);
        this.write32(this.IndirectSymBase.lookup((MCSection)Native.$AddrOf((Object)Sec)));
        this.write32(Section.getStubSize());
        if (this.is64Bit()) {
            this.write32(0);
        }
        assert (this.getStream().tell() - Start == Unsigned.$uint2ullong((int)(this.is64Bit() ? MachO.section_64.$sizeof_Section_64() : MachO.section.$sizeof_Section())));
    }

    public void writeSymtabLoadCommand(int SymbolOffset, int NumSymbols, int StringTableOffset, int StringTableSize) {
        long Start = this.getStream().tell();
        this.write32(2);
        this.write32(MachO.symtab_command.$sizeof_Symtab_command());
        this.write32(SymbolOffset);
        this.write32(NumSymbols);
        this.write32(StringTableOffset);
        this.write32(StringTableSize);
        assert (this.getStream().tell() - Start == Unsigned.$uint2ullong((int)MachO.symtab_command.$sizeof_Symtab_command()));
    }

    public void writeDysymtabLoadCommand(int FirstLocalSymbol, int NumLocalSymbols, int FirstExternalSymbol, int NumExternalSymbols, int FirstUndefinedSymbol, int NumUndefinedSymbols, int IndirectSymbolOffset, int NumIndirectSymbols) {
        long Start = this.getStream().tell();
        this.write32(11);
        this.write32(MachO.dysymtab_command.$sizeof_Dysymtab_command());
        this.write32(FirstLocalSymbol);
        this.write32(NumLocalSymbols);
        this.write32(FirstExternalSymbol);
        this.write32(NumExternalSymbols);
        this.write32(FirstUndefinedSymbol);
        this.write32(NumUndefinedSymbols);
        this.write32(0);
        this.write32(0);
        this.write32(0);
        this.write32(0);
        this.write32(0);
        this.write32(0);
        this.write32(IndirectSymbolOffset);
        this.write32(NumIndirectSymbols);
        this.write32(0);
        this.write32(0);
        this.write32(0);
        this.write32(0);
        assert (this.getStream().tell() - Start == Unsigned.$uint2ullong((int)MachO.dysymtab_command.$sizeof_Dysymtab_command()));
    }

    public void writeNlist(MachSymbolData MSD, MCAsmLayout Layout) {
        MCSymbol Symbol = MSD.Symbol;
        MCSymbol Data = (MCSymbol)Native.$Deref((Object)Symbol);
        MCSymbol AliasedSymbol = (MCSymbol)Native.$AddrOf((Object)this.findAliasedSymbol((MCSymbol)Native.$Deref((Object)Symbol)));
        byte SectionIndex = MSD.SectionIndex;
        byte Type2 = Unsigned.$int2uchar((int)0);
        long Address = Unsigned.$int2ulong((int)0);
        boolean IsAlias = Symbol != AliasedSymbol;
        MCSymbol OrigSymbol = (MCSymbol)Native.$Deref((Object)Symbol);
        MachSymbolData AliaseeInfo = new MachSymbolData();
        if (IsAlias) {
            AliaseeInfo = this.findSymbolData((MCSymbol)Native.$Deref((Object)AliasedSymbol));
            if (AliaseeInfo != null) {
                SectionIndex = AliaseeInfo.SectionIndex;
            }
            Symbol = AliasedSymbol;
        }
        Type2 = IsAlias && Symbol.isUndefined() ? Unsigned.$uint2uchar((int)10) : (Symbol.isUndefined() ? Unsigned.$uint2uchar((int)0) : (Symbol.isAbsolute() ? Unsigned.$uint2uchar((int)2) : Unsigned.$uint2uchar((int)14)));
        if (Data.isPrivateExtern()) {
            Type2 = (byte)(Type2 | 0x10);
        }
        if (Data.isExternal() || !IsAlias && Symbol.isUndefined()) {
            Type2 = (byte)(Type2 | 1);
        }
        if (IsAlias && Symbol.isUndefined()) {
            Address = AliaseeInfo.StringIndex;
        } else if (Symbol.isDefined()) {
            Address = this.getSymbolAddress(OrigSymbol, Layout);
        } else if (Symbol.isCommon()) {
            Address = Symbol.getCommonSize();
        }
        this.write32(Unsigned.$ulong2uint((long)MSD.StringIndex));
        this.write8(Type2);
        this.write8(SectionIndex);
        boolean EncodeAsAltEntry = IsAlias && ADTRTTI.cast_MCSymbolMachO(OrigSymbol).isAltEntry();
        this.write16(ADTRTTI.cast_MCSymbolMachO(Symbol).getEncodedFlags(EncodeAsAltEntry));
        if (this.is64Bit()) {
            this.write64(Address);
        } else {
            this.write32(Unsigned.$ulong2uint((long)Address));
        }
    }

    public void writeLinkeditLoadCommand(int Type2, int DataOffset, int DataSize) {
        long Start = this.getStream().tell();
        this.write32(Type2);
        this.write32(MachO.linkedit_data_command.$sizeof_Linkedit_data_command());
        this.write32(DataOffset);
        this.write32(DataSize);
        assert (this.getStream().tell() - Start == Unsigned.$uint2ullong((int)MachO.linkedit_data_command.$sizeof_Linkedit_data_command()));
    }

    public void writeLinkerOptionsLoadCommand(std.vectorString Options2) {
        int Size = MachObjectWriterStatics.ComputeLinkerOptionsLoadCommandSize(Options2, this.is64Bit());
        long Start = this.getStream().tell();
        this.write32(45);
        this.write32(Size);
        this.write32(Options2.size());
        long BytesWritten = Unsigned.$uint2ulong((int)MachO.linker_option_command.$sizeof_Linker_option_command());
        for (std.string Option2 : Options2) {
            this.writeBytes(new StringRef(Option2.c_str()), Option2.size() + 1);
            BytesWritten += Unsigned.$uint2ullong((int)(Option2.size() + 1));
        }
        this.writeBytes(new StringRef(NativePointer.$EMPTY), Unsigned.$ulong2uint((long)llvm.OffsetToAlignment(BytesWritten, Unsigned.$int2ulong((int)(this.is64Bit() ? 8 : 4)))));
        assert (this.getStream().tell() - Start == Unsigned.$uint2ullong((int)Size));
    }

    public void addRelocation(MCSymbol RelSymbol, MCSection Sec, MachO.any_relocation_info MRE) {
        RelAndSymbol P2 = new RelAndSymbol(RelSymbol, MRE);
        ((std.vector)this.Relocations.$at_T1$C$R(Sec)).push_back_T$C$R((Object)P2);
    }

    public void recordScatteredRelocation(MCAssembler Asm, MCAsmLayout Layout, MCFragment Fragment, MCFixup Fixup, MCValue Target2, int Log2Size, ulong.ref FixedValue) {
        throw new UnsupportedOperationException("<<<DeclJavaPrinter::VisitFunctionDecl NULL BODY IN USED Translation Unit>>>");
    }

    public void recordTLVPRelocation(MCAssembler Asm, MCAsmLayout Layout, MCFragment Fragment, MCFixup Fixup, MCValue Target2, ulong.ref FixedValue) {
        throw new UnsupportedOperationException("<<<DeclJavaPrinter::VisitFunctionDecl NULL BODY IN USED Translation Unit>>>");
    }

    @Override
    public void recordRelocation(MCAssembler Asm, MCAsmLayout Layout, MCFragment Fragment, MCFixup Fixup, MCValue Target2, bool.ref IsPCRel, ulong.ref FixedValue) {
        ((MCMachObjectTargetWriter)this.TargetObjectWriter.$arrow()).recordRelocation(this, Asm, Layout, Fragment, Fixup, new MCValue(Target2), FixedValue);
    }

    public void bindIndirectSymbols(MCAssembler Asm) {
        MCSectionMachO Section;
        StdVector.iterator<IndirectSymbolData> it = Asm.indirect_symbol_begin();
        StdVector.iterator<IndirectSymbolData> ie = Asm.indirect_symbol_end();
        while (std.$noteq___normal_iterator$C(it, ie)) {
            MCSectionMachO Section2 = ADTRTTI.cast_MCSectionMachO((MCSection)Native.$Deref((Object)((IndirectSymbolData)it.$arrow()).Section));
            if (Section2.getType() != 6 && Section2.getType() != 7 && Section2.getType() != 20 && Section2.getType() != 8) {
                MCSymbol Symbol = (MCSymbol)Native.$Deref((Object)((IndirectSymbolData)it.$arrow()).Symbol);
                llvm.report_fatal_error(llvm.$add_Twine$C(llvm.$add_char$ptr$C_StringRef$C("indirect symbol '", Symbol.getName()), new Twine("' not in a symbol pointer or stub section")));
            }
            it.$preInc();
        }
        int IndirectIndex = 0;
        StdVector.iterator<IndirectSymbolData> it2 = Asm.indirect_symbol_begin();
        StdVector.iterator<IndirectSymbolData> ie2 = Asm.indirect_symbol_end();
        while (std.$noteq___normal_iterator$C(it2, ie2)) {
            Section = ADTRTTI.cast_MCSectionMachO((MCSection)Native.$Deref((Object)((IndirectSymbolData)it2.$arrow()).Section));
            if (Section.getType() == 6 || Section.getType() == 20) {
                this.IndirectSymBase.insert_pair$KeyT$ValueT((std_pair.pairTypeUInt<MCSection>)new std_pair.pairPtrUInt(JavaDifferentiators.JD$Pair$_U1$_U2.INSTANCE, (Object)((IndirectSymbolData)it2.$arrow()).Section, IndirectIndex));
                Asm.registerSymbol((MCSymbol)Native.$Deref((Object)((IndirectSymbolData)it2.$arrow()).Symbol));
            }
            it2.$preInc();
            ++IndirectIndex;
        }
        IndirectIndex = 0;
        it2 = Asm.indirect_symbol_begin();
        ie2 = Asm.indirect_symbol_end();
        while (std.$noteq___normal_iterator$C(it2, ie2)) {
            Section = ADTRTTI.cast_MCSectionMachO((MCSection)Native.$Deref((Object)((IndirectSymbolData)it2.$arrow()).Section));
            if (Section.getType() == 7 || Section.getType() == 8) {
                this.IndirectSymBase.insert_pair$KeyT$ValueT((std_pair.pairTypeUInt<MCSection>)new std_pair.pairPtrUInt(JavaDifferentiators.JD$Pair$_U1$_U2.INSTANCE, (Object)((IndirectSymbolData)it2.$arrow()).Section, IndirectIndex));
                bool.ptr Created = NativePointer.create_bool$ptr();
                Asm.registerSymbol((MCSymbol)Native.$Deref((Object)((IndirectSymbolData)it2.$arrow()).Symbol), (bool.ptr)Native.$AddrOf((Object)Created));
                if (Created.$star()) {
                    ADTRTTI.cast_MCSymbolMachO(((IndirectSymbolData)it2.$arrow()).Symbol).setReferenceTypeUndefinedLazy(true);
                }
            }
            it2.$preInc();
            ++IndirectIndex;
        }
    }

    public void computeSymbolTable(MCAssembler Asm, std.vector<MachSymbolData> LocalSymbolData, std.vector<MachSymbolData> ExternalSymbolData, std.vector<MachSymbolData> UndefinedSymbolData) {
        MachSymbolData MSD;
        DenseMapTypeUChar SectionIndexMap = new DenseMapTypeUChar(DenseMapInfo$LikePtr.$Info(), 0);
        int Index = 1;
        pointee_iterator<MCSection> it = Asm.begin();
        pointee_iterator<MCSection> ie = Asm.end();
        while (it.$noteq(ie)) {
            SectionIndexMap.$set((MCSection)Native.$AddrOf((Object)it.$star()), Unsigned.$uint2uchar((int)Index));
            it.$preInc();
            ++Index;
        }
        assert (Unsigned.$lesseq_uint((int)Index, (int)256)) : "Too many sections!";
        for (MCSymbol Symbol : Asm.symbols()) {
            if (!Asm.isSymbolLinkerVisible(Symbol)) continue;
            this.StringTable.add(Symbol.getName());
        }
        this.StringTable.finalize();
        for (MCSymbol Symbol : Asm.symbols()) {
            if (!Asm.isSymbolLinkerVisible(Symbol) || !Symbol.isExternal() && !Symbol.isUndefined()) continue;
            MSD = new MachSymbolData();
            MSD.Symbol = (MCSymbol)Native.$AddrOf((Object)Symbol);
            MSD.StringIndex = Unsigned.$uint2ulong((int)this.StringTable.getOffset(Symbol.getName()));
            if (Symbol.isUndefined()) {
                MSD.SectionIndex = Unsigned.$int2uchar((int)0);
                UndefinedSymbolData.push_back_T$C$R((Object)MSD);
                continue;
            }
            if (Symbol.isAbsolute()) {
                MSD.SectionIndex = Unsigned.$int2uchar((int)0);
                ExternalSymbolData.push_back_T$C$R((Object)MSD);
                continue;
            }
            MSD.SectionIndex = SectionIndexMap.lookup((MCSection)Native.$AddrOf((Object)Symbol.getSection()));
            assert (MSD.SectionIndex != 0) : "Invalid section index!";
            ExternalSymbolData.push_back_T$C$R((Object)MSD);
        }
        for (MCSymbol Symbol : Asm.symbols()) {
            if (!Asm.isSymbolLinkerVisible(Symbol) || Symbol.isExternal() || Symbol.isUndefined()) continue;
            MSD = new MachSymbolData();
            MSD.Symbol = (MCSymbol)Native.$AddrOf((Object)Symbol);
            MSD.StringIndex = Unsigned.$uint2ulong((int)this.StringTable.getOffset(Symbol.getName()));
            if (Symbol.isAbsolute()) {
                MSD.SectionIndex = Unsigned.$int2uchar((int)0);
                LocalSymbolData.push_back_T$C$R((Object)MSD);
                continue;
            }
            MSD.SectionIndex = SectionIndexMap.lookup((MCSection)Native.$AddrOf((Object)Symbol.getSection()));
            assert (MSD.SectionIndex != 0) : "Invalid section index!";
            LocalSymbolData.push_back_T$C$R((Object)MSD);
        }
        std.sort((type.iterator)ExternalSymbolData.begin(), (type.iterator)ExternalSymbolData.end());
        std.sort((type.iterator)UndefinedSymbolData.begin(), (type.iterator)UndefinedSymbolData.end());
        Index = 0;
        for (std.vector SymbolData : new std.vector[]{(std.vector)Native.$AddrOf(LocalSymbolData), (std.vector)Native.$AddrOf(ExternalSymbolData), (std.vector)Native.$AddrOf(UndefinedSymbolData)}) {
            for (MachSymbolData Entry2 : (std.vector)Native.$Deref((Object)SymbolData)) {
                Entry2.Symbol.setIndex(Index++);
            }
        }
        for (MCSection Section : Asm) {
            for (RelAndSymbol Rel : (std.vector)this.Relocations.$at_T1$RR((MCSection)Native.$AddrOf((Object)Section))) {
                if (Rel.Sym == null) continue;
                int Index$1 = Rel.Sym.getIndex();
                assert (llvm.isInt(Unsigned.$uint2long((int)Index$1), 24));
                if (this.IsLittleEndian) {
                    Rel.MRE.r_word1 = Rel.MRE.r_word1 & 0xFF000000 | Index$1 | 0x8000000;
                    continue;
                }
                Rel.MRE.r_word1 = Rel.MRE.r_word1 & 0xFF | Index$1 << 8 | 0x10;
            }
        }
    }

    public void computeSectionAddresses(MCAssembler Asm, MCAsmLayout Layout) {
        long StartAddress = Unsigned.$int2ulong((int)0);
        for (MCSection Sec : Layout.getSectionOrder$Const()) {
            StartAddress = llvm.alignTo(StartAddress, Unsigned.$uint2ulong((int)Sec.getAlignment()));
            this.SectionAddress.$set(Sec, StartAddress);
            StartAddress += Layout.getSectionAddressSize(Sec);
            StartAddress += this.getPaddingSize(Sec, Layout);
        }
    }

    @Override
    public void executePostLayoutBinding(MCAssembler Asm, MCAsmLayout Layout) {
        this.computeSectionAddresses(Asm, Layout);
        this.bindIndirectSymbols(Asm);
    }

    @Override
    public boolean isSymbolRefDifferenceFullyResolvedImpl(MCAssembler Asm, MCSymbol A, MCSymbol B, boolean InSet) {
        if (A.isVariable() || B.isVariable()) {
            return false;
        }
        return super.isSymbolRefDifferenceFullyResolvedImpl(Asm, A, B, InSet);
    }

    @Override
    public boolean isSymbolRefDifferenceFullyResolvedImpl(MCAssembler Asm, MCSymbol SymA, MCFragment FB, boolean InSet, boolean IsPCRel) {
        if (InSet) {
            return true;
        }
        MCSymbol SA = this.findAliasedSymbol(SymA);
        MCSection SecA = SA.getSection();
        MCSection SecB = (MCSection)Native.$Deref((Object)FB.getParent());
        if (IsPCRel) {
            boolean hasReliableSymbolDifference = this.isX86_64();
            if (!hasReliableSymbolDifference) {
                return SA.isInSection() && Native.$AddrOf((Object)SecA) == Native.$AddrOf((Object)SecB) && (SA.isTemporary() || FB.getAtom() == SA.getFragment().getAtom() || !Asm.getSubsectionsViaSymbols());
            }
            if (FB.getAtom() == null && SA.isTemporary() && SA.isInSection() && Native.$AddrOf((Object)SecA) == Native.$AddrOf((Object)SecB)) {
                return true;
            }
        }
        if (Native.$AddrOf((Object)SecA) != Native.$AddrOf((Object)SecB)) {
            return false;
        }
        MCFragment FA = SA.getFragment();
        if (FA == null) {
            return false;
        }
        return FA.getAtom() == FB.getAtom();
    }

    @Override
    public void writeObject(MCAssembler Asm, MCAsmLayout Layout) {
        int NumSymbols;
        long LOHRawSize;
        long LOHSize;
        int NumDataRegions;
        this.computeSymbolTable(Asm, this.LocalSymbolData, this.ExternalSymbolData, this.UndefinedSymbolData);
        int NumSections = Asm.size();
        MCAssembler.VersionMinInfoType VersionInfo = Layout.getAssembler().getVersionMinInfo();
        int NumLoadCommands = 1;
        long LoadCommandsSize = Unsigned.$uint2ulong((int)(this.is64Bit() ? MachO.segment_command_64.$sizeof_Segment_command_64() + NumSections * MachO.section_64.$sizeof_Section_64() : MachO.segment_command.$sizeof_Segment_command() + NumSections * MachO.section.$sizeof_Section()));
        if (VersionInfo.Major != 0) {
            ++NumLoadCommands;
            LoadCommandsSize += Unsigned.$uint2ullong((int)MachO.version_min_command.$sizeof_Version_min_command());
        }
        if ((NumDataRegions = Asm.getDataRegions().size()) != 0) {
            ++NumLoadCommands;
            LoadCommandsSize += Unsigned.$uint2ullong((int)MachO.linkedit_data_command.$sizeof_Linkedit_data_command());
        }
        if ((LOHSize = llvm.alignTo(LOHRawSize = Asm.getLOHContainer().getEmitSize(this, Layout), Unsigned.$int2ulong((int)(this.is64Bit() ? 8 : 4)))) != 0L) {
            ++NumLoadCommands;
            LoadCommandsSize += Unsigned.$uint2ullong((int)MachO.linkedit_data_command.$sizeof_Linkedit_data_command());
        }
        if ((NumSymbols = this.LocalSymbolData.size() + this.ExternalSymbolData.size() + this.UndefinedSymbolData.size()) != 0) {
            NumLoadCommands += 2;
            LoadCommandsSize += Unsigned.$uint2ullong((int)(MachO.symtab_command.$sizeof_Symtab_command() + MachO.dysymtab_command.$sizeof_Dysymtab_command()));
        }
        for (std.vectorString Option2 : Asm.getLinkerOptions()) {
            ++NumLoadCommands;
            LoadCommandsSize += Unsigned.$uint2ullong((int)MachObjectWriterStatics.ComputeLinkerOptionsLoadCommandSize(Option2, this.is64Bit()));
        }
        long SectionDataStart = Unsigned.$uint2ullong((int)(this.is64Bit() ? MachO.mach_header_64.$sizeof_Mach_header_64() : MachO.mach_header.$sizeof_Mach_header())) + LoadCommandsSize;
        long SectionDataSize = Unsigned.$int2ulong((int)0);
        long SectionDataFileSize = Unsigned.$int2ulong((int)0);
        long VMSize = Unsigned.$int2ulong((int)0);
        for (MCSection Sec : Asm) {
            long Address = this.getSectionAddress((MCSection)Native.$AddrOf((Object)Sec));
            long Size = Layout.getSectionAddressSize((MCSection)Native.$AddrOf((Object)Sec));
            long FileSize = Layout.getSectionFileSize((MCSection)Native.$AddrOf((Object)Sec));
            FileSize += this.getPaddingSize((MCSection)Native.$AddrOf((Object)Sec), Layout);
            VMSize = std.max((long)VMSize, (long)(Address + Size));
            if (Sec.isVirtualSection()) continue;
            SectionDataSize = std.max((long)SectionDataSize, (long)(Address + Size));
            SectionDataFileSize = std.max((long)SectionDataFileSize, (long)(Address + FileSize));
        }
        int SectionDataPadding = Unsigned.$ulong2uint((long)llvm.OffsetToAlignment(SectionDataFileSize, Unsigned.$int2ulong((int)4)));
        this.writeHeader(1, NumLoadCommands, Unsigned.$ulong2uint((long)LoadCommandsSize), Asm.getSubsectionsViaSymbols());
        int Prot = 7;
        this.writeSegmentLoadCommand(new StringRef(NativePointer.$EMPTY), NumSections, Unsigned.$int2ulong((int)0), VMSize, SectionDataStart, SectionDataSize, Prot, Prot);
        long RelocTableEnd = SectionDataStart + (SectionDataFileSize += Unsigned.$uint2ullong((int)SectionDataPadding));
        for (MCSection Section : Asm) {
            MCSectionMachO Sec = ADTRTTI.cast_MCSectionMachO(Section);
            std.vector Relocs = (std.vector)this.Relocations.$at_T1$RR((MCSection)Native.$AddrOf((Object)Sec));
            int NumRelocs = Relocs.size();
            long SectionStart = SectionDataStart + this.getSectionAddress((MCSection)Native.$AddrOf((Object)Sec));
            int Flags = Sec.getTypeAndAttributes();
            if (Sec.hasInstructions()) {
                Flags |= 0x400;
            }
            this.writeSection(Layout, Sec, this.getSectionAddress((MCSection)Native.$AddrOf((Object)Sec)), SectionStart, Flags, RelocTableEnd, NumRelocs);
            RelocTableEnd += Unsigned.$uint2ullong((int)(NumRelocs * MachO.any_relocation_info.$sizeof_Any_relocation_info()));
        }
        if (VersionInfo.Major != 0) {
            assert (Unsigned.$less_uint((int)VersionInfo.Update, (int)256)) : "unencodable update target version";
            assert (Unsigned.$less_uint((int)VersionInfo.Minor, (int)256)) : "unencodable minor target version";
            assert (Unsigned.$less_uint((int)VersionInfo.Major, (int)65536)) : "unencodable major target version";
            int EncodedVersion = VersionInfo.Update | VersionInfo.Minor << 8 | VersionInfo.Major << 16;
            int LCType = 0;
            switch (VersionInfo.Kind) {
                case MCVM_OSXVersionMin: {
                    LCType = 36;
                    break;
                }
                case MCVM_IOSVersionMin: {
                    LCType = 37;
                    break;
                }
                case MCVM_TvOSVersionMin: {
                    LCType = 47;
                    break;
                }
                case MCVM_WatchOSVersionMin: {
                    LCType = 48;
                }
            }
            this.write32(LCType);
            this.write32(MachO.version_min_command.$sizeof_Version_min_command());
            this.write32(EncodedVersion);
            this.write32(0);
        }
        long DataInCodeTableEnd = RelocTableEnd + Unsigned.$uint2ullong((int)(NumDataRegions * 8));
        if (NumDataRegions != 0) {
            long DataRegionsOffset = RelocTableEnd;
            long DataRegionsSize = Unsigned.$uint2ulong((int)(NumDataRegions * 8));
            this.writeLinkeditLoadCommand(41, Unsigned.$ulong2uint((long)DataRegionsOffset), Unsigned.$ulong2uint((long)DataRegionsSize));
        }
        long LOHTableEnd = DataInCodeTableEnd + LOHSize;
        if (LOHSize != 0L) {
            this.writeLinkeditLoadCommand(46, Unsigned.$ulong2uint((long)DataInCodeTableEnd), Unsigned.$ulong2uint((long)LOHSize));
        }
        if (NumSymbols != 0) {
            int FirstLocalSymbol = 0;
            int NumLocalSymbols = this.LocalSymbolData.size();
            int FirstExternalSymbol = FirstLocalSymbol + NumLocalSymbols;
            int NumExternalSymbols = this.ExternalSymbolData.size();
            int FirstUndefinedSymbol = FirstExternalSymbol + NumExternalSymbols;
            int NumUndefinedSymbols = this.UndefinedSymbolData.size();
            int NumIndirectSymbols = Asm.indirect_symbol_size();
            int NumSymTabSymbols = NumLocalSymbols + NumExternalSymbols + NumUndefinedSymbols;
            long IndirectSymbolSize = Unsigned.$uint2ulong((int)(NumIndirectSymbols * 4));
            long IndirectSymbolOffset = Unsigned.$int2ulong((int)0);
            if (NumIndirectSymbols != 0) {
                IndirectSymbolOffset = LOHTableEnd;
            }
            long SymbolTableOffset = LOHTableEnd + IndirectSymbolSize;
            long StringTableOffset = SymbolTableOffset + Unsigned.$uint2ullong((int)(NumSymTabSymbols * (this.is64Bit() ? MachO.nlist_64.$sizeof_Nlist_64() : MachO.nlist.$sizeof_Nlist())));
            this.writeSymtabLoadCommand(Unsigned.$ulong2uint((long)SymbolTableOffset), NumSymTabSymbols, Unsigned.$ulong2uint((long)StringTableOffset), this.StringTable.data().size());
            this.writeDysymtabLoadCommand(FirstLocalSymbol, NumLocalSymbols, FirstExternalSymbol, NumExternalSymbols, FirstUndefinedSymbol, NumUndefinedSymbols, Unsigned.$ulong2uint((long)IndirectSymbolOffset), NumIndirectSymbols);
        }
        for (std.vectorString Option3 : Asm.getLinkerOptions()) {
            this.writeLinkerOptionsLoadCommand(Option3);
        }
        for (MCSection Sec : Asm) {
            Asm.writeSectionData((MCSection)Native.$AddrOf((Object)Sec), Layout);
            long Pad = this.getPaddingSize((MCSection)Native.$AddrOf((Object)Sec), Layout);
            this.WriteZeros(Unsigned.$ulong2uint((long)Pad));
        }
        this.WriteZeros(SectionDataPadding);
        for (MCSection Sec : Asm) {
            std.vector Relocs = (std.vector)this.Relocations.$at_T1$RR((MCSection)Native.$AddrOf((Object)Sec));
            for (RelAndSymbol Rel : llvm.make_range(Relocs.rbegin(), Relocs.rend())) {
                this.write32(Rel.MRE.r_word0);
                this.write32(Rel.MRE.r_word1);
            }
        }
        StdVector.iterator it = new StdVector.iterator(Asm.data_region_begin());
        StdVector.iterator ie = new StdVector.iterator(Asm.data_region_end());
        while (std.$noteq___normal_iterator$C((abstract_iterator)it, (abstract_iterator)ie)) {
            DataRegionData Data = (DataRegionData)Native.$AddrOf((Object)((DataRegionData)it.$star()));
            long Start = this.getSymbolAddress((MCSymbol)Native.$Deref((Object)Data.Start), Layout);
            long End = this.getSymbolAddress((MCSymbol)Native.$Deref((Object)Data.End), Layout);
            this.write32(Unsigned.$ulong2uint((long)Start));
            this.write16(Unsigned.$ullong2ushort((long)(End - Start)));
            this.write16((char)Data.Kind.getValue());
            it.$preInc();
        }
        if (LOHSize != 0L) {
            int Start = Unsigned.$ulong2uint((long)this.getStream().tell());
            Asm.getLOHContainer().emit(this, Layout);
            this.writeBytes(new StringRef(NativePointer.$EMPTY), Unsigned.$ulong2uint((long)llvm.OffsetToAlignment(LOHRawSize, Unsigned.$int2ulong((int)(this.is64Bit() ? 8 : 4)))));
            assert (this.getStream().tell() - Unsigned.$uint2ullong((int)Start) == LOHSize);
        }
        if (NumSymbols != 0) {
            it = new StdVector.iterator(Asm.indirect_symbol_begin());
            ie = new StdVector.iterator(Asm.indirect_symbol_end());
            while (std.$noteq___normal_iterator$C((abstract_iterator)it, (abstract_iterator)ie)) {
                MCSectionMachO Section = (MCSectionMachO)Native.$Deref((Object)((IndirectSymbolData)it.$arrow()).Section);
                if (Section.getType() == 6 && ((IndirectSymbolData)it.$arrow()).Symbol.isDefined() && !((IndirectSymbolData)it.$arrow()).Symbol.isExternal()) {
                    int Flags = Integer.MIN_VALUE;
                    if (((IndirectSymbolData)it.$arrow()).Symbol.isAbsolute()) {
                        Flags |= 0x40000000;
                    }
                    this.write32(Flags);
                } else {
                    this.write32(((IndirectSymbolData)it.$arrow()).Symbol.getIndex());
                }
                it.$preInc();
            }
            for (std.vector SymbolData : new std.vector[]{(std.vector)Native.$AddrOf(this.LocalSymbolData), (std.vector)Native.$AddrOf(this.ExternalSymbolData), (std.vector)Native.$AddrOf(this.UndefinedSymbolData)}) {
                for (MachSymbolData Entry2 : (std.vector)Native.$Deref((Object)SymbolData)) {
                    this.writeNlist(Entry2, Layout);
                }
            }
            this.getStream().$out(this.StringTable.data());
        }
    }

    @Override
    public void $destroy() {
        this.UndefinedSymbolData.$destroy();
        this.ExternalSymbolData.$destroy();
        this.LocalSymbolData.$destroy();
        this.StringTable.$destroy();
        this.SectionAddress.$destroy();
        this.IndirectSymBase.$destroy();
        this.Relocations.$destroy();
        this.TargetObjectWriter.$destroy();
        super.$destroy();
    }

    @Override
    public String toString() {
        return "TargetObjectWriter=" + this.TargetObjectWriter + ", Relocations=" + this.Relocations + ", IndirectSymBase=" + this.IndirectSymBase + ", SectionAddress=" + this.SectionAddress + ", StringTable=[StringTableBuilder], LocalSymbolData=" + this.LocalSymbolData + ", ExternalSymbolData=" + this.ExternalSymbolData + ", UndefinedSymbolData=" + this.UndefinedSymbolData + super.toString();
    }

    private static class RelAndSymbol {
        public MCSymbol Sym;
        public MachO.any_relocation_info MRE;

        public RelAndSymbol(MCSymbol Sym, MachO.any_relocation_info MRE) {
            this.Sym = Sym;
            this.MRE = new MachO.any_relocation_info(MRE);
        }

        public RelAndSymbol(RelAndSymbol $Prm0) {
            this.Sym = $Prm0.Sym;
            this.MRE = new MachO.any_relocation_info($Prm0.MRE);
        }

        public RelAndSymbol(JavaDifferentiators.JD.Move _dparam, RelAndSymbol $Prm0) {
            this.Sym = $Prm0.Sym;
            this.MRE = new MachO.any_relocation_info(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.MRE);
        }

        public RelAndSymbol() {
        }

        public String toString() {
            return "Sym=" + this.Sym + ", MRE=" + this.MRE;
        }
    }

    private static class MachSymbolData
    implements Native.ComparableLower {
        public MCSymbol Symbol;
        public long StringIndex;
        public byte SectionIndex;

        public boolean $less(MachSymbolData RHS) {
            return llvm.$less_StringRef(this.Symbol.getName(), RHS.Symbol.getName());
        }

        public MachSymbolData() {
        }

        public MachSymbolData(MachSymbolData $Prm0) {
            this.Symbol = $Prm0.Symbol;
            this.StringIndex = $Prm0.StringIndex;
            this.SectionIndex = $Prm0.SectionIndex;
        }

        public MachSymbolData(JavaDifferentiators.JD.Move _dparam, MachSymbolData $Prm0) {
            this.Symbol = $Prm0.Symbol;
            this.StringIndex = $Prm0.StringIndex;
            this.SectionIndex = $Prm0.SectionIndex;
        }

        public MachSymbolData $assignMove(MachSymbolData $Prm0) {
            this.Symbol = $Prm0.Symbol;
            this.StringIndex = $Prm0.StringIndex;
            this.SectionIndex = $Prm0.SectionIndex;
            return this;
        }

        public String toString() {
            return "Symbol=" + this.Symbol + ", StringIndex=" + this.StringIndex + ", SectionIndex=" + Unsigned.$uchar2uint((byte)this.SectionIndex);
        }

        public boolean $less(Object RHS) {
            return this.$less((MachSymbolData)RHS);
        }
    }
}

