/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.llvm.mc.MCExpr;
import org.llvm.mc.MCSymbolRefExpr;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;

public class MCValue {
    private MCSymbolRefExpr SymA;
    private MCSymbolRefExpr SymB;
    private long Cst;
    private int RefKind;

    public long getConstant() {
        return this.Cst;
    }

    public MCSymbolRefExpr getSymA() {
        return this.SymA;
    }

    public MCSymbolRefExpr getSymB() {
        return this.SymB;
    }

    public int getRefKind() {
        return this.RefKind;
    }

    public boolean isAbsolute() {
        return this.SymA == null && this.SymB == null;
    }

    public void print(raw_ostream OS) {
        if (this.isAbsolute()) {
            OS.$out_llong(this.getConstant());
            return;
        }
        if (this.getRefKind() != 0) {
            OS.$out_char((byte)58).$out_uint(this.getRefKind()).$out_char((byte)58);
        }
        AdtsupportLlvmGlobals.$out_raw_ostream_MCExpr$C(OS, (MCExpr)Native.$Deref((Object)this.getSymA()));
        if (this.getSymB() != null) {
            OS.$out(" - ");
            AdtsupportLlvmGlobals.$out_raw_ostream_MCExpr$C(OS, (MCExpr)Native.$Deref((Object)this.getSymB()));
        }
        if (this.getConstant() != 0L) {
            OS.$out(" + ").$out_llong(this.getConstant());
        }
    }

    public void dump() {
        this.print(llvm.dbgs());
    }

    public MCSymbolRefExpr.VariantKind getAccessVariant() {
        MCSymbolRefExpr B = this.getSymB();
        if (B != null && B.getKind() != MCSymbolRefExpr.VariantKind.VK_None) {
            throw new llvm_unreachable("unsupported");
        }
        MCSymbolRefExpr A = this.getSymA();
        if (A == null) {
            return MCSymbolRefExpr.VariantKind.VK_None;
        }
        MCSymbolRefExpr.VariantKind Kind2 = (MCSymbolRefExpr.VariantKind)A.getKind();
        if (Kind2 == MCSymbolRefExpr.VariantKind.VK_WEAKREF) {
            return MCSymbolRefExpr.VariantKind.VK_None;
        }
        return Kind2;
    }

    public static MCValue get(MCSymbolRefExpr SymA) {
        return MCValue.get(SymA, null, 0L, 0);
    }

    public static MCValue get(MCSymbolRefExpr SymA, MCSymbolRefExpr SymB) {
        return MCValue.get(SymA, SymB, 0L, 0);
    }

    public static MCValue get(MCSymbolRefExpr SymA, MCSymbolRefExpr SymB, long Val) {
        return MCValue.get(SymA, SymB, Val, 0);
    }

    public static MCValue get(MCSymbolRefExpr SymA, MCSymbolRefExpr SymB, long Val, int RefKind) {
        MCValue R2 = new MCValue();
        R2.Cst = Val;
        R2.SymA = SymA;
        R2.SymB = SymB;
        R2.RefKind = RefKind;
        return R2;
    }

    public static MCValue get(long Val) {
        MCValue R2 = new MCValue();
        R2.Cst = Val;
        R2.SymA = null;
        R2.SymB = null;
        R2.RefKind = 0;
        return R2;
    }

    public MCValue() {
    }

    public MCValue(MCValue $Prm0) {
        this.SymA = $Prm0.SymA;
        this.SymB = $Prm0.SymB;
        this.Cst = $Prm0.Cst;
        this.RefKind = $Prm0.RefKind;
    }

    public MCValue(JavaDifferentiators.JD.Move _dparam, MCValue $Prm0) {
        this.SymA = $Prm0.SymA;
        this.SymB = $Prm0.SymB;
        this.Cst = $Prm0.Cst;
        this.RefKind = $Prm0.RefKind;
    }

    public MCValue $assign(MCValue $Prm0) {
        this.SymA = $Prm0.SymA;
        this.SymB = $Prm0.SymB;
        this.Cst = $Prm0.Cst;
        this.RefKind = $Prm0.RefKind;
        return this;
    }

    public MCValue $assignMove(MCValue $Prm0) {
        this.SymA = $Prm0.SymA;
        this.SymB = $Prm0.SymB;
        this.Cst = $Prm0.Cst;
        this.RefKind = $Prm0.RefKind;
        return this;
    }

    public String toString() {
        return "SymA=[MCSymbolRefExpr], SymB=[MCSymbolRefExpr], Cst=" + this.Cst + ", RefKind=" + this.RefKind;
    }
}

