/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.support.Unsigned;
import org.llvm.adt.aliases.StringMapEntryBool;
import org.llvm.mc.MCExpr;
import org.llvm.mc.MCSymbol;
import org.llvm.support.llvm_unreachable;

public class MCSymbolELF
extends MCSymbol {
    private MCExpr SymbolSize = null;

    public MCSymbolELF(StringMapEntryBool Name2, boolean isTemporary) {
        super(MCSymbol.SymbolKind.SymbolKindELF, Name2, isTemporary);
    }

    public void setSize(MCExpr SS) {
        this.SymbolSize = SS;
    }

    public MCExpr getSize() {
        return this.SymbolSize;
    }

    public void setVisibility(int Visibility) {
        assert (Visibility == 0 || Visibility == 1 || Visibility == 2 || Visibility == 3);
        int OtherFlags = this.getFlags() & 0xFFFFFF9F;
        this.setFlags(OtherFlags | Visibility << 5);
    }

    public int getVisibility() {
        int Visibility = (this.getFlags() & 0x60) >>> 5;
        assert (Visibility == 0 || Visibility == 1 || Visibility == 2 || Visibility == 3);
        return Visibility;
    }

    public void setOther(int Other) {
        assert ((Other & 0x1F) == 0);
        assert (Unsigned.$lesseq_uint((int)(Other >>>= 5), (int)7));
        int OtherFlags = this.getFlags() & 0xFFFFFC7F;
        this.setFlags(OtherFlags | Other << 7);
    }

    public int getOther() {
        int Other = (this.getFlags() & 0x380) >>> 7;
        return Other << 5;
    }

    public void setType(int Type2) {
        int Val;
        switch (Type2) {
            default: {
                throw new llvm_unreachable("Unsupported Binding");
            }
            case 0: {
                Val = 0;
                break;
            }
            case 1: {
                Val = 1;
                break;
            }
            case 2: {
                Val = 2;
                break;
            }
            case 3: {
                Val = 3;
                break;
            }
            case 5: {
                Val = 4;
                break;
            }
            case 6: {
                Val = 5;
                break;
            }
            case 10: {
                Val = 6;
            }
        }
        int OtherFlags = this.getFlags() & 0xFFFFFFF8;
        this.setFlags(OtherFlags | Val << 0);
    }

    public int getType() {
        int Val = (this.getFlags() & 7) >>> 0;
        switch (Val) {
            default: {
                throw new llvm_unreachable("Invalid value");
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: 
        }
        return 10;
    }

    public void setBinding(int Binding) {
        int Val;
        this.setIsBindingSet();
        switch (Binding) {
            default: {
                throw new llvm_unreachable("Unsupported Binding");
            }
            case 0: {
                Val = 0;
                break;
            }
            case 1: {
                Val = 1;
                break;
            }
            case 2: {
                Val = 2;
                break;
            }
            case 10: {
                Val = 3;
            }
        }
        int OtherFlags = this.getFlags() & 0xFFFFFFE7;
        this.setFlags(OtherFlags | Val << 3);
    }

    public int getBinding() {
        if (this.isBindingSet()) {
            int Val = (this.getFlags() & 0x18) >>> 3;
            switch (Val) {
                default: {
                    throw new llvm_unreachable("Invalid value");
                }
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: 
            }
            return 10;
        }
        if (this.isDefined()) {
            return 0;
        }
        if (this.isUsedInReloc()) {
            return 1;
        }
        if (this.isWeakrefUsedInReloc()) {
            return 2;
        }
        if (this.isSignature()) {
            return 0;
        }
        return 1;
    }

    public boolean isBindingSet() {
        return (this.getFlags() & 0x1000) != 0;
    }

    public void setIsWeakrefUsedInReloc() {
        int OtherFlags = this.getFlags() & 0xFFFFF7FF;
        this.setFlags(OtherFlags | 0x800);
    }

    public boolean isWeakrefUsedInReloc() {
        return (this.getFlags() & 0x800) != 0;
    }

    public void setIsSignature() {
        int OtherFlags = this.getFlags() & 0xFFFFFBFF;
        this.setFlags(OtherFlags | 0x400);
    }

    public boolean isSignature() {
        return (this.getFlags() & 0x400) != 0;
    }

    public static boolean classof(MCSymbol S2) {
        return S2.isELF();
    }

    private void setIsBindingSet() {
        int OtherFlags = this.getFlags() & 0xFFFFEFFF;
        this.setFlags(OtherFlags | 0x1000);
    }

    @Override
    public String toString() {
        return "SymbolSize=[MCExpr]" + super.toString();
    }
}

