/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.ArrayRefUInt;
import org.llvm.adt.aliases.DenseMapInfo$LikePtr;
import org.llvm.adt.aliases.DenseMapTypeUInt;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.java.ADTRTTI;
import org.llvm.mc.MCAsmBackend;
import org.llvm.mc.MCAsmInfo;
import org.llvm.mc.MCAssemblerFlag;
import org.llvm.mc.MCBinaryExpr;
import org.llvm.mc.MCCFIInstruction;
import org.llvm.mc.MCContext;
import org.llvm.mc.MCDataRegionType;
import org.llvm.mc.MCDwarfFrameInfo;
import org.llvm.mc.MCDwarfLineTable;
import org.llvm.mc.MCExpr;
import org.llvm.mc.MCFragment;
import org.llvm.mc.MCInst;
import org.llvm.mc.MCSection;
import org.llvm.mc.MCSubtargetInfo;
import org.llvm.mc.MCSymbol;
import org.llvm.mc.MCSymbolAttr;
import org.llvm.mc.MCSymbolELF;
import org.llvm.mc.MCSymbolRefExpr;
import org.llvm.mc.MCTargetStreamer;
import org.llvm.mc.MCVersionMinType;
import org.llvm.mc.WinEH;
import org.llvm.mc.impl.MCStreamerStatics;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.SMLoc;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.raw_svector_ostream;
import org.llvm.support.target.Win64EH;

public abstract class MCStreamer
implements Destructors.ClassWithDestructor {
    private final MCContext Context;
    private std_ptr.unique_ptr<MCTargetStreamer> TargetStreamer;
    private std.vector<MCDwarfFrameInfo> DwarfFrameInfos;
    private std.vector<WinEH.FrameInfo> WinFrameInfos;
    private WinEH.FrameInfo CurrentWinFrameInfo;
    private DenseMapTypeUInt<MCSymbol> SymbolOrdering;
    private SmallVector<std_pair.pairTypeType<std_pair.pair<MCSection, MCExpr>, std_pair.pair<MCSection, MCExpr>>> SectionStack;
    private int NextWinCFIID;

    protected MCStreamer(MCStreamer $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected MCStreamer $assign(MCStreamer $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private MCDwarfFrameInfo getCurrentDwarfFrameInfo() {
        if (this.DwarfFrameInfos.empty()) {
            return null;
        }
        return (MCDwarfFrameInfo)Native.$AddrOf((Object)((MCDwarfFrameInfo)this.DwarfFrameInfos.back()));
    }

    private void EnsureValidDwarfFrame() {
        MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
        if (CurFrame == null || CurFrame.End != null) {
            llvm.report_fatal_error(NativePointer.$((String)"No open frame"));
        }
    }

    private MCSymbol EmitCFICommon() {
        this.EnsureValidDwarfFrame();
        MCSymbol Label = this.getContext().createTempSymbol();
        this.EmitLabel(Label);
        return Label;
    }

    private void EnsureValidWinFrameInfo() {
        MCAsmInfo MAI = this.Context.getAsmInfo();
        if (!MAI.usesWindowsCFI()) {
            llvm.report_fatal_error(NativePointer.$((String)".seh_* directives are not supported on this target"));
        }
        if (this.CurrentWinFrameInfo == null || this.CurrentWinFrameInfo.End != null) {
            llvm.report_fatal_error(NativePointer.$((String)"No open Win64 EH frame function!"));
        }
    }

    protected MCStreamer(MCContext Ctx) {
        this.Context = Ctx;
        this.TargetStreamer = new std_ptr.unique_ptr();
        this.DwarfFrameInfos = new std.vector((Object)new MCDwarfFrameInfo());
        this.WinFrameInfos = new std.vector((Object)null);
        this.CurrentWinFrameInfo = null;
        this.SymbolOrdering = new DenseMapTypeUInt(DenseMapInfo$LikePtr.$Info(), 0);
        this.SectionStack = new SmallVector<std_pair.pairTypeType>(4, new std_pair.pairTypeType());
        this.NextWinCFIID = 0;
        this.SectionStack.push_back((std_pair.pairTypeType<std_pair.pair<MCSection, MCExpr>, std_pair.pair<MCSection, MCExpr>>)new std_pair.pairTypeType());
    }

    protected void EmitCFIStartProcImpl(MCDwarfFrameInfo Frame) {
    }

    protected void EmitCFIEndProcImpl(MCDwarfFrameInfo Frame) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    protected WinEH.FrameInfo getCurrentWinFrameInfo() {
        return this.CurrentWinFrameInfo;
    }

    protected void EmitWindowsUnwindTables() {
    }

    protected void EmitRawTextImpl(StringRef String2) {
        llvm.errs().$out("EmitRawText called on an MCStreamer that doesn't support it,  something must not be fully mc'ized\n");
        std.abort();
    }

    public void $destroy() {
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)this.getNumWinFrameInfos())) {
            if (this.WinFrameInfos.$at(i) != null) {
                ((WinEH.FrameInfo)this.WinFrameInfos.$at(i)).$destroy();
            }
            ++i;
        }
        this.SectionStack.$destroy();
        this.SymbolOrdering.$destroy();
        this.WinFrameInfos.$destroy();
        this.DwarfFrameInfos.$destroy();
        this.TargetStreamer.$destroy();
    }

    public void visitUsedExpr(MCExpr Expr) {
        switch ((MCExpr.ExprKind)Expr.getKind()) {
            case Target: {
                ADTRTTI.cast_MCTargetExpr(Expr).visitUsedExpr(this);
                break;
            }
            case Constant: {
                break;
            }
            case Binary: {
                MCBinaryExpr BE = ADTRTTI.cast_MCBinaryExpr(Expr);
                this.visitUsedExpr((MCExpr)Native.$Deref((Object)BE.getLHS()));
                this.visitUsedExpr((MCExpr)Native.$Deref((Object)BE.getRHS()));
                break;
            }
            case SymbolRef: {
                this.visitUsedSymbol(ADTRTTI.cast_MCSymbolRefExpr(Expr).getSymbol());
                break;
            }
            case Unary: {
                this.visitUsedExpr((MCExpr)Native.$Deref((Object)ADTRTTI.cast_MCUnaryExpr(Expr).getSubExpr()));
            }
        }
    }

    public void visitUsedSymbol(MCSymbol Sym) {
    }

    public void setTargetStreamer(MCTargetStreamer TS) {
        this.TargetStreamer.reset((Object)TS);
    }

    public void reset() {
        this.DwarfFrameInfos.clear();
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)this.getNumWinFrameInfos())) {
            if (this.WinFrameInfos.$at(i) != null) {
                ((WinEH.FrameInfo)this.WinFrameInfos.$at(i)).$destroy();
            }
            ++i;
        }
        this.WinFrameInfos.clear();
        this.CurrentWinFrameInfo = null;
        this.SymbolOrdering.clear();
        this.SectionStack.clear();
        this.SectionStack.push_back((std_pair.pairTypeType<std_pair.pair<MCSection, MCExpr>, std_pair.pair<MCSection, MCExpr>>)new std_pair.pairTypeType());
    }

    public MCContext getContext() {
        return this.Context;
    }

    public MCTargetStreamer getTargetStreamer() {
        return (MCTargetStreamer)this.TargetStreamer.get();
    }

    public int getNumFrameInfos() {
        return this.DwarfFrameInfos.size();
    }

    public ArrayRef<MCDwarfFrameInfo> getDwarfFrameInfos() {
        return new ArrayRef<MCDwarfFrameInfo>(this.DwarfFrameInfos, false);
    }

    public boolean hasUnfinishedDwarfFrameInfo() {
        MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
        return CurFrame != null && CurFrame.End == null;
    }

    public int getNumWinFrameInfos() {
        return this.WinFrameInfos.size();
    }

    public ArrayRef<WinEH.FrameInfo> getWinFrameInfos() {
        return new ArrayRef<WinEH.FrameInfo>(this.WinFrameInfos, true);
    }

    public void generateCompactUnwindEncodings(MCAsmBackend MAB) {
        for (MCDwarfFrameInfo FI : this.DwarfFrameInfos) {
            FI.CompactUnwindEncoding = MAB != null ? MAB.generateCompactUnwindEncoding(new ArrayRef<MCCFIInstruction>(FI.Instructions, false)) : 0;
        }
    }

    public boolean isVerboseAsm() {
        return false;
    }

    public boolean hasRawTextSupport() {
        return false;
    }

    public boolean isIntegratedAssemblerRequired() {
        return false;
    }

    public void AddComment(Twine T4) {
    }

    public raw_ostream GetCommentOS() {
        return llvm.nulls();
    }

    public void emitRawComment(Twine T4) {
        this.emitRawComment(T4, true);
    }

    public void emitRawComment(Twine T4, boolean TabPrefix) {
    }

    public void addExplicitComment(Twine T4) {
    }

    public void emitExplicitComments() {
    }

    public void AddBlankLine() {
    }

    public std_pair.pair<MCSection, MCExpr> getCurrentSection() {
        if (!this.SectionStack.empty()) {
            return new std_pair.pair((std_pair.pair)((std_pair.pairTypeType)this.SectionStack.back$Const()).first);
        }
        return new std_pair.pair();
    }

    public MCSection getCurrentSectionOnly() {
        return (MCSection)this.getCurrentSection().first;
    }

    public std_pair.pair<MCSection, MCExpr> getPreviousSection() {
        if (!this.SectionStack.empty()) {
            return new std_pair.pair((std_pair.pair)((std_pair.pairTypeType)this.SectionStack.back$Const()).second);
        }
        return new std_pair.pair();
    }

    public int GetSymbolOrder(MCSymbol Sym) {
        return this.SymbolOrdering.lookup(Sym);
    }

    public void ChangeSection(MCSection $Prm0, MCExpr $Prm1) {
    }

    public void PushSection() {
        this.SectionStack.push_back((std_pair.pairTypeType<std_pair.pair<MCSection, MCExpr>, std_pair.pair<MCSection, MCExpr>>)std.make_pair((Object)((std_pair.pair)Native.$Move(this.getCurrentSection())), (Object)((std_pair.pair)Native.$Move(this.getPreviousSection()))));
    }

    public boolean PopSection() {
        if (Unsigned.$lesseq_uint((int)this.SectionStack.size(), (int)1)) {
            return false;
        }
        type.ptr I = (type.ptr)Native.$tryClone(this.SectionStack.end());
        I.$preDec();
        std_pair.pair OldSection = new std_pair.pair((std_pair.pair)((std_pair.pairTypeType)I.$star()).first);
        I.$preDec();
        std_pair.pair NewSection = new std_pair.pair((std_pair.pair)((std_pair.pairTypeType)I.$star()).first);
        if (std.$noteq_pair$_T1$_T2$C((Object)OldSection, (Object)NewSection)) {
            this.ChangeSection((MCSection)NewSection.first, (MCExpr)NewSection.second);
        }
        this.SectionStack.pop_back();
        return true;
    }

    public boolean SubSection(MCExpr Subsection) {
        if (this.SectionStack.empty()) {
            return false;
        }
        this.SwitchSection((MCSection)((std_pair.pair)((std_pair.pairTypeType)this.SectionStack.back()).first).first, Subsection);
        return true;
    }

    public void SwitchSection(MCSection Section) {
        this.SwitchSection(Section, null);
    }

    public void SwitchSection(MCSection Section, MCExpr Subsection) {
        assert (Section != null) : "Cannot switch to a null section!";
        std_pair.pair curSection = new std_pair.pair((std_pair.pair)((std_pair.pairTypeType)this.SectionStack.back()).first);
        ((std_pair.pair)((std_pair.pairTypeType)this.SectionStack.back()).second).$assign(curSection);
        if (std.$noteq_pair$_T1$_T2$C((Object)new std_pair.pair(JavaDifferentiators.JD$T$RR_T1$RR.INSTANCE, (Object)Section, (Object)Subsection), (Object)curSection)) {
            this.ChangeSection(Section, Subsection);
            ((std_pair.pair)((std_pair.pairTypeType)this.SectionStack.back()).first).$assignMove(new std_pair.pair(JavaDifferentiators.JD$T$RR_T1$RR.INSTANCE, (Object)Section, (Object)Subsection));
            assert (!Section.hasEnded()) : "Section already ended";
            MCSymbol Sym = Section.getBeginSymbol();
            if (Sym != null && !Sym.isInSection()) {
                this.EmitLabel(Sym);
            }
        }
    }

    public void SwitchSectionNoChange(MCSection Section) {
        this.SwitchSectionNoChange(Section, null);
    }

    public void SwitchSectionNoChange(MCSection Section, MCExpr Subsection) {
        assert (Section != null) : "Cannot switch to a null section!";
        std_pair.pair curSection = new std_pair.pair((std_pair.pair)((std_pair.pairTypeType)this.SectionStack.back()).first);
        ((std_pair.pair)((std_pair.pairTypeType)this.SectionStack.back()).second).$assign(curSection);
        if (std.$noteq_pair$_T1$_T2$C((Object)new std_pair.pair(JavaDifferentiators.JD$T$RR_T1$RR.INSTANCE, (Object)Section, (Object)Subsection), (Object)curSection)) {
            ((std_pair.pair)((std_pair.pairTypeType)this.SectionStack.back()).first).$assignMove(new std_pair.pair(JavaDifferentiators.JD$T$RR_T1$RR.INSTANCE, (Object)Section, (Object)Subsection));
        }
    }

    public void InitSections(boolean NoExecStack) {
        this.SwitchSection(this.getContext().getObjectFileInfo().getTextSection());
    }

    public MCSymbol endSection(MCSection Section) {
        MCSymbol Sym = Section.getEndSymbol(this.Context);
        if (Sym.isInSection()) {
            return Sym;
        }
        this.SwitchSection(Section);
        this.EmitLabel(Sym);
        return Sym;
    }

    public void AssignFragment(MCSymbol Symbol, MCFragment Fragment) {
        assert (Native.$bool((Object)Fragment));
        Symbol.setFragment(Fragment);
        this.SymbolOrdering.$set(Symbol, 1 + this.SymbolOrdering.size());
    }

    public void EmitLabel(MCSymbol Symbol) {
        assert (!Symbol.isVariable()) : "Cannot emit a variable symbol!";
        assert (this.getCurrentSection().first != null) : "Cannot emit before setting section!";
        assert (Symbol.getFragment() == null) : "Unexpected fragment on symbol data!";
        Symbol.setFragment((MCFragment)Native.$AddrOf((Object)this.getCurrentSectionOnly().getDummyFragment()));
        MCTargetStreamer TS = this.getTargetStreamer();
        if (TS != null) {
            TS.emitLabel(Symbol);
        }
    }

    public void EmitEHSymAttributes(MCSymbol Symbol, MCSymbol EHSymbol) {
    }

    public void EmitAssemblerFlag(MCAssemblerFlag Flag) {
    }

    public void EmitLinkerOptions(ArrayRef<std.string> Kind2) {
    }

    public void EmitDataRegion(MCDataRegionType Kind2) {
    }

    public void EmitVersionMin(MCVersionMinType $Prm0, int Major, int Minor, int Update) {
    }

    public void EmitThumbFunc(MCSymbol Func) {
    }

    public void EmitAssignment(MCSymbol Symbol, MCExpr Value) {
        this.visitUsedExpr((MCExpr)Native.$Deref((Object)Value));
        Symbol.setVariableValue(Value);
        MCTargetStreamer TS = this.getTargetStreamer();
        if (TS != null) {
            TS.emitAssignment(Symbol, Value);
        }
    }

    public void EmitWeakReference(MCSymbol Alias, MCSymbol Symbol) {
    }

    public abstract boolean EmitSymbolAttribute(MCSymbol var1, MCSymbolAttr var2);

    public void EmitSymbolDesc(MCSymbol Symbol, int DescValue) {
    }

    public void BeginCOFFSymbolDef(MCSymbol Symbol) {
    }

    public void EmitCOFFSymbolStorageClass(int StorageClass) {
    }

    public void EmitCOFFSymbolType(int Type2) {
    }

    public void EndCOFFSymbolDef() {
    }

    public void EmitCOFFSafeSEH(MCSymbol Symbol) {
    }

    public void EmitCOFFSectionIndex(MCSymbol Symbol) {
    }

    public void EmitCOFFSecRel32(MCSymbol Symbol) {
    }

    public void emitELFSize(MCSymbolELF Symbol, MCExpr Value) {
    }

    public void EmitLOHDirective(int Kind2, SmallVectorImpl<MCSymbol> Args) {
    }

    public abstract void EmitCommonSymbol(MCSymbol var1, long var2, int var4);

    public void EmitLocalCommonSymbol(MCSymbol Symbol, long Size, int ByteAlignment) {
    }

    public abstract void EmitZerofill(MCSection var1, MCSymbol var2, long var3, int var5);

    public void EmitTBSSSymbol(MCSection Section, MCSymbol Symbol, long Size) {
        this.EmitTBSSSymbol(Section, Symbol, Size, 0);
    }

    public void EmitTBSSSymbol(MCSection Section, MCSymbol Symbol, long Size, int ByteAlignment) {
    }

    public void EmitBytes(StringRef Data) {
    }

    public void EmitBinaryData(StringRef Data) {
        this.EmitBytes(new StringRef(Data));
    }

    public void EmitValueImpl(MCExpr Value, int Size) {
        this.EmitValueImpl(Value, Size, new SMLoc());
    }

    public void EmitValueImpl(MCExpr Value, int Size, SMLoc Loc) {
        this.visitUsedExpr((MCExpr)Native.$Deref((Object)Value));
    }

    public void EmitValue(MCExpr Value, int Size) {
        this.EmitValue(Value, Size, new SMLoc());
    }

    public void EmitValue(MCExpr Value, int Size, SMLoc Loc) {
        this.EmitValueImpl(Value, Size, new SMLoc(Loc));
    }

    public void EmitIntValue(long Value, int Size) {
        assert (Unsigned.$lesseq_uint((int)1, (int)Size) && Unsigned.$lesseq_uint((int)Size, (int)8)) : "Invalid size";
        assert (llvm.isUIntN(8 * Size, Value) || llvm.isIntN(8 * Size, Value)) : "Invalid size";
        byte[] buf = NativePointer.new$char((int)8, (byte[])new byte[0]);
        boolean isLittleEndian = this.Context.getAsmInfo().isLittleEndian();
        for (int i = 0; i != Size; ++i) {
            int index = isLittleEndian ? i : Size - i - 1;
            buf[i] = Unsigned.$ulong2uchar((long)(Value >>> index * 8));
        }
        this.EmitBytes(new StringRef(buf, Size));
    }

    public void EmitULEB128Value(MCExpr Value) {
    }

    public void EmitSLEB128Value(MCExpr Value) {
    }

    public void EmitULEB128IntValue(long Value) {
        this.EmitULEB128IntValue(Value, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitULEB128IntValue(long Value, int Padding) {
        raw_svector_ostream OSE = null;
        try {
            SmallString Tmp = new SmallString(128);
            OSE = new raw_svector_ostream(Tmp);
            AdtsupportLlvmGlobals.encodeULEB128(Value, OSE, Padding);
            this.EmitBytes(OSE.str());
        }
        finally {
            if (OSE != null) {
                OSE.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitSLEB128IntValue(long Value) {
        raw_svector_ostream OSE = null;
        try {
            SmallString Tmp = new SmallString(128);
            OSE = new raw_svector_ostream(Tmp);
            AdtsupportLlvmGlobals.encodeSLEB128(Value, OSE);
            this.EmitBytes(OSE.str());
        }
        finally {
            if (OSE != null) {
                OSE.$destroy();
            }
        }
    }

    public void EmitSymbolValue(MCSymbol Sym, int Size) {
        this.EmitSymbolValue(Sym, Size, false);
    }

    public void EmitSymbolValue(MCSymbol Sym, int Size, boolean IsSectionRelative) {
        assert (!IsSectionRelative || Size == 4) : "SectionRelative value requires 4-bytes";
        if (!IsSectionRelative) {
            this.EmitValueImpl(MCSymbolRefExpr.create(Sym, this.getContext()), Size);
        } else {
            this.EmitCOFFSecRel32(Sym);
        }
    }

    public void EmitGPRel64Value(MCExpr Value) {
        llvm.report_fatal_error(NativePointer.$((String)"unsupported directive in streamer"));
    }

    public void EmitGPRel32Value(MCExpr Value) {
        llvm.report_fatal_error(NativePointer.$((String)"unsupported directive in streamer"));
    }

    public void emitFill(long NumBytes, byte FillValue) {
        long e = NumBytes;
        for (long i = Unsigned.$int2ulong((int)0); i != e; ++i) {
            this.EmitIntValue(Unsigned.$uchar2ulong((byte)FillValue), 1);
        }
    }

    public void emitFill(MCExpr NumBytes, long Value) {
        this.emitFill(NumBytes, Value, new SMLoc());
    }

    public void emitFill(MCExpr NumBytes, long Value, SMLoc Loc) {
    }

    public void emitFill(long NumValues, long Size, long Expr) {
        long NonZeroSize = Size > 4L ? 4L : Size;
        Expr &= -1L >>> (int)(64L - NonZeroSize * 8L);
        long e = NumValues;
        for (long i = Unsigned.$int2ulong((int)0); i != e; ++i) {
            this.EmitIntValue(Expr, Unsigned.$long2uint((long)NonZeroSize));
            if (NonZeroSize >= Size) continue;
            this.EmitIntValue(Unsigned.$int2ulong((int)0), Unsigned.$llong2uint((long)(Size - NonZeroSize)));
        }
    }

    public void emitFill(MCExpr NumValues, long Size, long Expr) {
        this.emitFill(NumValues, Size, Expr, new SMLoc());
    }

    public void emitFill(MCExpr NumValues, long Size, long Expr, SMLoc Loc) {
    }

    public void EmitZeros(long NumBytes) {
        this.emitFill(NumBytes, Unsigned.$int2uchar((int)0));
    }

    public void EmitValueToAlignment(int ByteAlignment) {
        this.EmitValueToAlignment(ByteAlignment, 0L, 1, 0);
    }

    public void EmitValueToAlignment(int ByteAlignment, long Value) {
        this.EmitValueToAlignment(ByteAlignment, Value, 1, 0);
    }

    public void EmitValueToAlignment(int ByteAlignment, long Value, int ValueSize) {
        this.EmitValueToAlignment(ByteAlignment, Value, ValueSize, 0);
    }

    public void EmitValueToAlignment(int ByteAlignment, long Value, int ValueSize, int MaxBytesToEmit) {
    }

    public void EmitCodeAlignment(int ByteAlignment) {
        this.EmitCodeAlignment(ByteAlignment, 0);
    }

    public void EmitCodeAlignment(int ByteAlignment, int MaxBytesToEmit) {
    }

    public void emitValueToOffset(MCExpr Offset) {
        this.emitValueToOffset(Offset, Unsigned.$int2uchar((int)0));
    }

    public void emitValueToOffset(MCExpr Offset, byte Value) {
    }

    public void EmitFileDirective(StringRef Filename) {
    }

    public void EmitIdent(StringRef IdentString) {
    }

    public int EmitDwarfFileDirective(int FileNo, StringRef Directory, StringRef Filename) {
        return this.EmitDwarfFileDirective(FileNo, Directory, Filename, 0);
    }

    public int EmitDwarfFileDirective(int FileNo, StringRef Directory, StringRef Filename, int CUID) {
        return this.getContext().getDwarfFile(new StringRef(Directory), new StringRef(Filename), FileNo, CUID);
    }

    public void EmitDwarfLocDirective(int FileNo, int Line, int Column, int Flags, int Isa, int Discriminator, StringRef FileName) {
        this.getContext().setCurrentDwarfLoc(FileNo, Line, Column, Flags, Isa, Discriminator);
    }

    public int EmitCVFileDirective(int FileNo, StringRef Filename) {
        return this.getContext().getCVFile(new StringRef(Filename), FileNo);
    }

    public void EmitCVLocDirective(int FunctionId, int FileNo, int Line, int Column, boolean PrologueEnd, boolean IsStmt, StringRef FileName) {
        this.getContext().setCurrentCVLoc(FunctionId, FileNo, Line, Column, PrologueEnd, IsStmt);
    }

    public void EmitCVLinetableDirective(int FunctionId, MCSymbol Begin, MCSymbol End) {
    }

    public void EmitCVInlineLinetableDirective(int PrimaryFunctionId, int SourceFileId, int SourceLineNum, MCSymbol FnStartSym, MCSymbol FnEndSym, ArrayRefUInt SecondaryFunctionIds) {
    }

    public void EmitCVDefRangeDirective(ArrayRef<std_pair.pairPtrPtr<MCSymbol, MCSymbol>> Ranges, StringRef FixedSizePortion) {
    }

    public void EmitCVStringTableDirective() {
    }

    public void EmitCVFileChecksumsDirective() {
    }

    public void emitAbsoluteSymbolDiff(MCSymbol Hi, MCSymbol Lo, int Size) {
        MCBinaryExpr Diff = MCBinaryExpr.createSub(MCSymbolRefExpr.create(Hi, this.Context), MCSymbolRefExpr.create(Lo, this.Context), this.Context);
        MCAsmInfo MAI = this.Context.getAsmInfo();
        if (!MAI.doesSetDirectiveSuppressReloc()) {
            this.EmitValue(Diff, Size);
            return;
        }
        MCSymbol SetLabel = this.Context.createTempSymbol(new Twine("set"), true);
        this.EmitAssignment(SetLabel, Diff);
        this.EmitSymbolValue(SetLabel, Size);
    }

    public MCSymbol getDwarfLineTableSymbol(int CUID) {
        MCDwarfLineTable Table = this.getContext().getMCDwarfLineTable(CUID);
        if (Table.getLabel() == null) {
            StringRef Prefix = new StringRef(this.Context.getAsmInfo().getPrivateGlobalPrefix());
            Table.setLabel(this.Context.getOrCreateSymbol(llvm.$add_Twine$C(llvm.$add_StringRef$C_char$ptr$C(Prefix, "line_table_start"), new Twine(JavaDifferentiators.JD.UInt.INSTANCE, CUID))));
        }
        return Table.getLabel();
    }

    public void EmitCFISections(boolean EH, boolean Debug) {
        assert (EH || Debug);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitCFIStartProc(boolean IsSimple) {
        MCDwarfFrameInfo Frame = null;
        try {
            if (this.hasUnfinishedDwarfFrameInfo()) {
                llvm.report_fatal_error(NativePointer.$((String)"Starting a frame before finishing the previous one!"));
            }
            Frame = new MCDwarfFrameInfo();
            Frame.IsSimple = IsSimple;
            this.EmitCFIStartProcImpl(Frame);
            MCAsmInfo MAI = this.Context.getAsmInfo();
            if (MAI != null) {
                for (MCCFIInstruction Inst : MAI.getInitialFrameState()) {
                    if (Inst.getOperation() != MCCFIInstruction.OpType.OpDefCfa && Inst.getOperation() != MCCFIInstruction.OpType.OpDefCfaRegister) continue;
                    Frame.CurrentCfaRegister = Inst.getRegister();
                }
            }
            this.DwarfFrameInfos.push_back_T$C$R((Object)Frame);
        }
        finally {
            if (Frame != null) {
                Frame.$destroy();
            }
        }
    }

    public void EmitCFIEndProc() {
        this.EnsureValidDwarfFrame();
        MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
        this.EmitCFIEndProcImpl((MCDwarfFrameInfo)Native.$Deref((Object)CurFrame));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitCFIDefCfa(long Register, long Offset) {
        MCCFIInstruction Instruction2 = null;
        try {
            MCSymbol Label = this.EmitCFICommon();
            Instruction2 = MCCFIInstruction.createDefCfa(Label, Unsigned.$long2uint((long)Register), (int)Offset);
            MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
            CurFrame.Instructions.push_back_T$C$R((Object)Instruction2);
            CurFrame.CurrentCfaRegister = Unsigned.$long2uint((long)Register);
        }
        finally {
            if (Instruction2 != null) {
                Instruction2.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitCFIDefCfaOffset(long Offset) {
        MCCFIInstruction Instruction2 = null;
        try {
            MCSymbol Label = this.EmitCFICommon();
            Instruction2 = MCCFIInstruction.createDefCfaOffset(Label, (int)Offset);
            MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
            CurFrame.Instructions.push_back_T$C$R((Object)Instruction2);
        }
        finally {
            if (Instruction2 != null) {
                Instruction2.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitCFIDefCfaRegister(long Register) {
        MCCFIInstruction Instruction2 = null;
        try {
            MCSymbol Label = this.EmitCFICommon();
            Instruction2 = MCCFIInstruction.createDefCfaRegister(Label, Unsigned.$long2uint((long)Register));
            MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
            CurFrame.Instructions.push_back_T$C$R((Object)Instruction2);
            CurFrame.CurrentCfaRegister = Unsigned.$long2uint((long)Register);
        }
        finally {
            if (Instruction2 != null) {
                Instruction2.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitCFIOffset(long Register, long Offset) {
        MCCFIInstruction Instruction2 = null;
        try {
            MCSymbol Label = this.EmitCFICommon();
            Instruction2 = MCCFIInstruction.createOffset(Label, Unsigned.$long2uint((long)Register), (int)Offset);
            MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
            CurFrame.Instructions.push_back_T$C$R((Object)Instruction2);
        }
        finally {
            if (Instruction2 != null) {
                Instruction2.$destroy();
            }
        }
    }

    public void EmitCFIPersonality(MCSymbol Sym, int Encoding) {
        this.EnsureValidDwarfFrame();
        MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
        CurFrame.Personality = Sym;
        CurFrame.PersonalityEncoding = Encoding;
    }

    public void EmitCFILsda(MCSymbol Sym, int Encoding) {
        this.EnsureValidDwarfFrame();
        MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
        CurFrame.Lsda = Sym;
        CurFrame.LsdaEncoding = Encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitCFIRememberState() {
        MCCFIInstruction Instruction2 = null;
        try {
            MCSymbol Label = this.EmitCFICommon();
            Instruction2 = MCCFIInstruction.createRememberState(Label);
            MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
            CurFrame.Instructions.push_back_T$C$R((Object)Instruction2);
        }
        finally {
            if (Instruction2 != null) {
                Instruction2.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitCFIRestoreState() {
        MCCFIInstruction Instruction2 = null;
        try {
            MCSymbol Label = this.EmitCFICommon();
            Instruction2 = MCCFIInstruction.createRestoreState(Label);
            MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
            CurFrame.Instructions.push_back_T$C$R((Object)Instruction2);
        }
        finally {
            if (Instruction2 != null) {
                Instruction2.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitCFISameValue(long Register) {
        MCCFIInstruction Instruction2 = null;
        try {
            MCSymbol Label = this.EmitCFICommon();
            Instruction2 = MCCFIInstruction.createSameValue(Label, Unsigned.$long2uint((long)Register));
            MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
            CurFrame.Instructions.push_back_T$C$R((Object)Instruction2);
        }
        finally {
            if (Instruction2 != null) {
                Instruction2.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitCFIRestore(long Register) {
        MCCFIInstruction Instruction2 = null;
        try {
            MCSymbol Label = this.EmitCFICommon();
            Instruction2 = MCCFIInstruction.createRestore(Label, Unsigned.$long2uint((long)Register));
            MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
            CurFrame.Instructions.push_back_T$C$R((Object)Instruction2);
        }
        finally {
            if (Instruction2 != null) {
                Instruction2.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitCFIRelOffset(long Register, long Offset) {
        MCCFIInstruction Instruction2 = null;
        try {
            MCSymbol Label = this.EmitCFICommon();
            Instruction2 = MCCFIInstruction.createRelOffset(Label, Unsigned.$long2uint((long)Register), (int)Offset);
            MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
            CurFrame.Instructions.push_back_T$C$R((Object)Instruction2);
        }
        finally {
            if (Instruction2 != null) {
                Instruction2.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitCFIAdjustCfaOffset(long Adjustment) {
        MCCFIInstruction Instruction2 = null;
        try {
            MCSymbol Label = this.EmitCFICommon();
            Instruction2 = MCCFIInstruction.createAdjustCfaOffset(Label, (int)Adjustment);
            MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
            CurFrame.Instructions.push_back_T$C$R((Object)Instruction2);
        }
        finally {
            if (Instruction2 != null) {
                Instruction2.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitCFIEscape(StringRef Values2) {
        MCCFIInstruction Instruction2 = null;
        try {
            MCSymbol Label = this.EmitCFICommon();
            Instruction2 = MCCFIInstruction.createEscape(Label, new StringRef(Values2));
            MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
            CurFrame.Instructions.push_back_T$C$R((Object)Instruction2);
        }
        finally {
            if (Instruction2 != null) {
                Instruction2.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitCFIGnuArgsSize(long Size) {
        MCCFIInstruction Instruction2 = null;
        try {
            MCSymbol Label = this.EmitCFICommon();
            Instruction2 = MCCFIInstruction.createGnuArgsSize(Label, (int)Size);
            MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
            CurFrame.Instructions.push_back_T$C$R((Object)Instruction2);
        }
        finally {
            if (Instruction2 != null) {
                Instruction2.$destroy();
            }
        }
    }

    public void EmitCFISignalFrame() {
        this.EnsureValidDwarfFrame();
        MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
        CurFrame.IsSignalFrame = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitCFIUndefined(long Register) {
        MCCFIInstruction Instruction2 = null;
        try {
            MCSymbol Label = this.EmitCFICommon();
            Instruction2 = MCCFIInstruction.createUndefined(Label, Unsigned.$long2uint((long)Register));
            MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
            CurFrame.Instructions.push_back_T$C$R((Object)Instruction2);
        }
        finally {
            if (Instruction2 != null) {
                Instruction2.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitCFIRegister(long Register1, long Register2) {
        MCCFIInstruction Instruction2 = null;
        try {
            MCSymbol Label = this.EmitCFICommon();
            Instruction2 = MCCFIInstruction.createRegister(Label, Unsigned.$long2uint((long)Register1), Unsigned.$long2uint((long)Register2));
            MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
            CurFrame.Instructions.push_back_T$C$R((Object)Instruction2);
        }
        finally {
            if (Instruction2 != null) {
                Instruction2.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitCFIWindowSave() {
        MCCFIInstruction Instruction2 = null;
        try {
            MCSymbol Label = this.EmitCFICommon();
            Instruction2 = MCCFIInstruction.createWindowSave(Label);
            MCDwarfFrameInfo CurFrame = this.getCurrentDwarfFrameInfo();
            CurFrame.Instructions.push_back_T$C$R((Object)Instruction2);
        }
        finally {
            if (Instruction2 != null) {
                Instruction2.$destroy();
            }
        }
    }

    public void EmitWinCFIStartProc(MCSymbol Symbol) {
        MCAsmInfo MAI = this.Context.getAsmInfo();
        if (!MAI.usesWindowsCFI()) {
            llvm.report_fatal_error(NativePointer.$((String)".seh_* directives are not supported on this target"));
        }
        if (this.CurrentWinFrameInfo != null && this.CurrentWinFrameInfo.End == null) {
            llvm.report_fatal_error(NativePointer.$((String)"Starting a function before ending the previous one!"));
        }
        MCSymbol StartProc = this.getContext().createTempSymbol();
        this.EmitLabel(StartProc);
        this.WinFrameInfos.push_back_T$RR((Object)new WinEH.FrameInfo(Symbol, StartProc));
        this.CurrentWinFrameInfo = (WinEH.FrameInfo)this.WinFrameInfos.back();
        this.CurrentWinFrameInfo.TextSection = this.getCurrentSectionOnly();
    }

    public void EmitWinCFIEndProc() {
        this.EnsureValidWinFrameInfo();
        if (this.CurrentWinFrameInfo.ChainedParent != null) {
            llvm.report_fatal_error(NativePointer.$((String)"Not all chained regions terminated!"));
        }
        MCSymbol Label = this.getContext().createTempSymbol();
        this.EmitLabel(Label);
        this.CurrentWinFrameInfo.End = Label;
    }

    public void EmitWinCFIStartChained() {
        this.EnsureValidWinFrameInfo();
        MCSymbol StartProc = this.getContext().createTempSymbol();
        this.EmitLabel(StartProc);
        this.WinFrameInfos.push_back_T$RR((Object)new WinEH.FrameInfo(this.CurrentWinFrameInfo.Function, StartProc, this.CurrentWinFrameInfo));
        this.CurrentWinFrameInfo = (WinEH.FrameInfo)this.WinFrameInfos.back();
        this.CurrentWinFrameInfo.TextSection = this.getCurrentSectionOnly();
    }

    public void EmitWinCFIEndChained() {
        this.EnsureValidWinFrameInfo();
        if (this.CurrentWinFrameInfo.ChainedParent == null) {
            llvm.report_fatal_error(NativePointer.$((String)"End of a chained region outside a chained region!"));
        }
        MCSymbol Label = this.getContext().createTempSymbol();
        this.EmitLabel(Label);
        this.CurrentWinFrameInfo.End = Label;
        this.CurrentWinFrameInfo = this.CurrentWinFrameInfo.ChainedParent;
    }

    public void EmitWinCFIPushReg(int Register) {
        this.EnsureValidWinFrameInfo();
        MCSymbol Label = this.getContext().createTempSymbol();
        this.EmitLabel(Label);
        WinEH.Instruction Inst = Win64EH.Instruction.PushNonVol(Label, Register);
        this.CurrentWinFrameInfo.Instructions.push_back_T$C$R((Object)Inst);
    }

    public void EmitWinCFISetFrame(int Register, int Offset) {
        this.EnsureValidWinFrameInfo();
        if (this.CurrentWinFrameInfo.LastFrameInst >= 0) {
            llvm.report_fatal_error(NativePointer.$((String)"Frame register and offset already specified!"));
        }
        if ((Offset & 0xF) != 0) {
            llvm.report_fatal_error(NativePointer.$((String)"Misaligned frame pointer offset!"));
        }
        if (Unsigned.$greater_uint((int)Offset, (int)240)) {
            llvm.report_fatal_error(NativePointer.$((String)"Frame offset must be less than or equal to 240!"));
        }
        MCSymbol Label = this.getContext().createTempSymbol();
        this.EmitLabel(Label);
        WinEH.Instruction Inst = Win64EH.Instruction.SetFPReg(Label, Register, Offset);
        this.CurrentWinFrameInfo.LastFrameInst = this.CurrentWinFrameInfo.Instructions.size();
        this.CurrentWinFrameInfo.Instructions.push_back_T$C$R((Object)Inst);
    }

    public void EmitWinCFIAllocStack(int Size) {
        this.EnsureValidWinFrameInfo();
        if (Size == 0) {
            llvm.report_fatal_error(NativePointer.$((String)"Allocation size must be non-zero!"));
        }
        if ((Size & 7) != 0) {
            llvm.report_fatal_error(NativePointer.$((String)"Misaligned stack allocation!"));
        }
        MCSymbol Label = this.getContext().createTempSymbol();
        this.EmitLabel(Label);
        WinEH.Instruction Inst = Win64EH.Instruction.Alloc(Label, Size);
        this.CurrentWinFrameInfo.Instructions.push_back_T$C$R((Object)Inst);
    }

    public void EmitWinCFISaveReg(int Register, int Offset) {
        this.EnsureValidWinFrameInfo();
        if ((Offset & 7) != 0) {
            llvm.report_fatal_error(NativePointer.$((String)"Misaligned saved register offset!"));
        }
        MCSymbol Label = this.getContext().createTempSymbol();
        this.EmitLabel(Label);
        WinEH.Instruction Inst = Win64EH.Instruction.SaveNonVol(Label, Register, Offset);
        this.CurrentWinFrameInfo.Instructions.push_back_T$C$R((Object)Inst);
    }

    public void EmitWinCFISaveXMM(int Register, int Offset) {
        this.EnsureValidWinFrameInfo();
        if ((Offset & 0xF) != 0) {
            llvm.report_fatal_error(NativePointer.$((String)"Misaligned saved vector register offset!"));
        }
        MCSymbol Label = this.getContext().createTempSymbol();
        this.EmitLabel(Label);
        WinEH.Instruction Inst = Win64EH.Instruction.SaveXMM(Label, Register, Offset);
        this.CurrentWinFrameInfo.Instructions.push_back_T$C$R((Object)Inst);
    }

    public void EmitWinCFIPushFrame(boolean Code) {
        this.EnsureValidWinFrameInfo();
        if (Unsigned.$greater_uint((int)this.CurrentWinFrameInfo.Instructions.size(), (int)0)) {
            llvm.report_fatal_error(NativePointer.$((String)"If present, PushMachFrame must be the first UOP"));
        }
        MCSymbol Label = this.getContext().createTempSymbol();
        this.EmitLabel(Label);
        WinEH.Instruction Inst = Win64EH.Instruction.PushMachFrame(Label, Code);
        this.CurrentWinFrameInfo.Instructions.push_back_T$C$R((Object)Inst);
    }

    public void EmitWinCFIEndProlog() {
        this.EnsureValidWinFrameInfo();
        MCSymbol Label = this.getContext().createTempSymbol();
        this.EmitLabel(Label);
        this.CurrentWinFrameInfo.PrologEnd = Label;
    }

    public void EmitWinEHHandler(MCSymbol Sym, boolean Unwind, boolean Except) {
        this.EnsureValidWinFrameInfo();
        if (this.CurrentWinFrameInfo.ChainedParent != null) {
            llvm.report_fatal_error(NativePointer.$((String)"Chained unwind areas can't have handlers!"));
        }
        this.CurrentWinFrameInfo.ExceptionHandler = Sym;
        if (!Except && !Unwind) {
            llvm.report_fatal_error(NativePointer.$((String)"Don't know what kind of handler this is!"));
        }
        if (Unwind) {
            this.CurrentWinFrameInfo.HandlesUnwind = true;
        }
        if (Except) {
            this.CurrentWinFrameInfo.HandlesExceptions = true;
        }
    }

    public void EmitWinEHHandlerData() {
        this.EnsureValidWinFrameInfo();
        if (this.CurrentWinFrameInfo.ChainedParent != null) {
            llvm.report_fatal_error(NativePointer.$((String)"Chained unwind areas can't have handlers!"));
        }
    }

    public MCSection getAssociatedPDataSection(MCSection TextSec) {
        return MCStreamerStatics.getWinCFISection(this.getContext(), (uint.ptr)Native.$AddrOf((Object)NativePointer.create_uint$ptr2ConstT((int)this.NextWinCFIID)), this.getContext().getObjectFileInfo().getPDataSection(), TextSec);
    }

    public MCSection getAssociatedXDataSection(MCSection TextSec) {
        return MCStreamerStatics.getWinCFISection(this.getContext(), (uint.ptr)Native.$AddrOf((Object)NativePointer.create_uint$ptr2ConstT((int)this.NextWinCFIID)), this.getContext().getObjectFileInfo().getXDataSection(), TextSec);
    }

    public void EmitSyntaxDirective() {
    }

    public boolean EmitRelocDirective(MCExpr Offset, StringRef Name2, MCExpr Expr, SMLoc Loc) {
        return true;
    }

    public void EmitInstruction(MCInst Inst, MCSubtargetInfo STI) {
        int i = Inst.getNumOperands();
        while (i-- != 0) {
            if (!Inst.getOperand$Const(i).isExpr()) continue;
            this.visitUsedExpr((MCExpr)Native.$Deref((Object)Inst.getOperand$Const(i).getExpr()));
        }
    }

    public void EmitBundleAlignMode(int AlignPow2) {
    }

    public void EmitBundleLock(boolean AlignToEnd) {
    }

    public void EmitBundleUnlock() {
    }

    public void EmitRawText(Twine T4) {
        SmallString Str = new SmallString(128);
        this.EmitRawTextImpl(T4.toStringRef(Str));
    }

    public void FinishImpl() {
    }

    public void Finish() {
        MCTargetStreamer TS;
        if (!this.DwarfFrameInfos.empty() && ((MCDwarfFrameInfo)this.DwarfFrameInfos.back()).End == null) {
            llvm.report_fatal_error(NativePointer.$((String)"Unfinished frame!"));
        }
        if ((TS = this.getTargetStreamer()) != null) {
            TS.finish();
        }
        this.FinishImpl();
    }

    public boolean mayHaveInstructions(MCSection Sec) {
        return true;
    }

    public String toString() {
        return "Context=[MCContext], TargetStreamer=" + this.TargetStreamer + ", DwarfFrameInfos=" + this.DwarfFrameInfos + ", WinFrameInfos=" + this.WinFrameInfos + ", CurrentWinFrameInfo=" + this.CurrentWinFrameInfo + ", SymbolOrdering=" + this.SymbolOrdering + ", SectionStack=" + this.SectionStack + ", NextWinCFIID=" + this.NextWinCFIID;
    }
}

