/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.llvm.adt.StringRef;
import org.llvm.mc.MCAsmInfo;
import org.llvm.mc.MCExpr;
import org.llvm.mc.MCSection;
import org.llvm.mc.MCSymbol;
import org.llvm.mc.MCSymbolELF;
import org.llvm.mc.SectionKind;
import org.llvm.mc.impl.MCSectionELFStatics;
import org.llvm.support.raw_ostream;

public final class MCSectionELF
extends MCSection
implements Destructors.ClassWithDestructor {
    private StringRef SectionName;
    private int Type;
    private int Flags;
    private int UniqueID;
    private int EntrySize;
    private MCSymbolELF Group;
    private MCSectionELF Associated;

    public MCSectionELF(StringRef Section, int type2, int flags, SectionKind K, int entrySize, MCSymbolELF group, int UniqueID2, MCSymbol Begin, MCSectionELF Associated) {
        super(MCSection.SectionVariant.SV_ELF, new SectionKind(K), Begin);
        this.SectionName = new StringRef(Section);
        this.Type = type2;
        this.Flags = flags;
        this.UniqueID = UniqueID2;
        this.EntrySize = entrySize;
        this.Group = group;
        this.Associated = Associated;
        if (this.Group != null) {
            this.Group.setIsSignature();
        }
    }

    public void setSectionName(StringRef Name2) {
        this.SectionName.$assign(Name2);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    public boolean ShouldOmitSectionDirective(StringRef Name2, MCAsmInfo MAI) {
        if (this.isUnique()) {
            return false;
        }
        return MAI.shouldOmitSectionDirective(new StringRef(Name2));
    }

    public StringRef getSectionName() {
        return new StringRef(this.SectionName);
    }

    public int getType() {
        return this.Type;
    }

    public int getFlags() {
        return this.Flags;
    }

    public int getEntrySize() {
        return this.EntrySize;
    }

    public void setFlags(int F) {
        this.Flags = F;
    }

    public MCSymbolELF getGroup() {
        return this.Group;
    }

    @Override
    public void PrintSwitchToSection(MCAsmInfo MAI, raw_ostream OS, MCExpr Subsection) {
        if (this.ShouldOmitSectionDirective(new StringRef(this.SectionName), MAI)) {
            OS.$out_char((byte)9).$out(this.getSectionName());
            if (Subsection != null) {
                OS.$out_char((byte)9);
                Subsection.print(OS, (MCAsmInfo)Native.$AddrOf((Object)MAI));
            }
            OS.$out_char((byte)10);
            return;
        }
        OS.$out("\t.section\t");
        MCSectionELFStatics.printName(OS, this.getSectionName());
        if (MAI.usesSunStyleELFSectionSwitchSyntax() && (this.Flags & 0x10) == 0) {
            if ((this.Flags & 2) != 0) {
                OS.$out(",#alloc");
            }
            if ((this.Flags & 4) != 0) {
                OS.$out(",#execinstr");
            }
            if ((this.Flags & 1) != 0) {
                OS.$out(",#write");
            }
            if ((this.Flags & Integer.MIN_VALUE) != 0) {
                OS.$out(",#exclude");
            }
            if ((this.Flags & 0x400) != 0) {
                OS.$out(",#tls");
            }
            OS.$out_char((byte)10);
            return;
        }
        OS.$out(",\"");
        if ((this.Flags & 2) != 0) {
            OS.$out_char((byte)97);
        }
        if ((this.Flags & Integer.MIN_VALUE) != 0) {
            OS.$out_char((byte)101);
        }
        if ((this.Flags & 4) != 0) {
            OS.$out_char((byte)120);
        }
        if ((this.Flags & 0x200) != 0) {
            OS.$out_char((byte)71);
        }
        if ((this.Flags & 1) != 0) {
            OS.$out_char((byte)119);
        }
        if ((this.Flags & 0x10) != 0) {
            OS.$out_char((byte)77);
        }
        if ((this.Flags & 0x20) != 0) {
            OS.$out_char((byte)83);
        }
        if ((this.Flags & 0x400) != 0) {
            OS.$out_char((byte)84);
        }
        if ((this.Flags & 0x800) != 0) {
            OS.$out_char((byte)99);
        }
        if ((this.Flags & 0x1000) != 0) {
            OS.$out_char((byte)100);
        }
        OS.$out_char((byte)34);
        OS.$out_char((byte)44);
        if (MAI.getCommentString().$at(0) == 64) {
            OS.$out_char((byte)37);
        } else {
            OS.$out_char((byte)64);
        }
        if (this.Type == 14) {
            OS.$out("init_array");
        } else if (this.Type == 15) {
            OS.$out("fini_array");
        } else if (this.Type == 16) {
            OS.$out("preinit_array");
        } else if (this.Type == 8) {
            OS.$out("nobits");
        } else if (this.Type == 7) {
            OS.$out("note");
        } else if (this.Type == 1) {
            OS.$out("progbits");
        } else if (this.Type == 0x70000001) {
            OS.$out("unwind");
        }
        if (this.EntrySize != 0) {
            assert (Native.$bool((int)(this.Flags & 0x10)));
            OS.$out(NativePointer.$COMMA).$out_uint(this.EntrySize);
        }
        if ((this.Flags & 0x200) != 0) {
            OS.$out(NativePointer.$COMMA);
            MCSectionELFStatics.printName(OS, this.Group.getName());
            OS.$out(",comdat");
        }
        if (this.isUnique()) {
            OS.$out(",unique,").$out_uint(this.UniqueID);
        }
        OS.$out_char((byte)10);
        if (Subsection != null) {
            OS.$out("\t.subsection\t");
            Subsection.print(OS, (MCAsmInfo)Native.$AddrOf((Object)MAI));
            OS.$out_char((byte)10);
        }
    }

    @Override
    public boolean UseCodeAlign() {
        return (this.getFlags() & 4) != 0;
    }

    @Override
    public boolean isVirtualSection() {
        return this.getType() == 8;
    }

    public boolean isUnique() {
        return this.UniqueID != -1;
    }

    public int getUniqueID() {
        return this.UniqueID;
    }

    public MCSectionELF getAssociatedSection() {
        return this.Associated;
    }

    public static boolean classof(MCSection S2) {
        return S2.getVariant() == MCSection.SectionVariant.SV_ELF;
    }

    @Override
    public String toString() {
        return "SectionName=" + this.SectionName + ", Type=" + this.Type + ", Flags=" + this.Flags + ", UniqueID=" + this.UniqueID + ", EntrySize=" + this.EntrySize + ", Group=" + this.Group + ", Associated=" + this.Associated + super.toString();
    }
}

