/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.ilist_iterator;
import org.llvm.adt.iplist;
import org.llvm.mc.MCAsmInfo;
import org.llvm.mc.MCContext;
import org.llvm.mc.MCDataFragment;
import org.llvm.mc.MCDummyFragment;
import org.llvm.mc.MCExpr;
import org.llvm.mc.MCFragment;
import org.llvm.mc.MCSymbol;
import org.llvm.mc.SectionKind;
import org.llvm.mc.ilistMCFragment;
import org.llvm.mc.ilist_traitsMCFragment;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public abstract class MCSection
implements Iterable<MCFragment>,
Destructors.ClassWithDestructor {
    private MCSymbol Begin;
    private MCSymbol End;
    private int Alignment;
    private int Ordinal;
    private int LayoutOrder;
    private BundleLockStateType BundleLockState;
    private int BundleLockNestingDepth;
    private boolean BundleGroupBeforeFirstInst;
    private boolean HasInstructions;
    private boolean IsRegistered;
    private MCDummyFragment DummyFragment;
    private iplist<MCFragment> Fragments;
    private SmallVector<std_pair.pairUIntPtr<MCFragment>> SubsectionFragmentMap;
    protected SectionVariant Variant;
    protected SectionKind Kind;

    protected MCSection(MCSection $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected void $assign(MCSection $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected MCSection(SectionVariant V, SectionKind K, MCSymbol Begin) {
        this.Begin = Begin;
        this.End = null;
        this.Alignment = 1;
        this.Ordinal = 0;
        this.BundleLockState = BundleLockStateType.NotBundleLocked;
        this.BundleLockNestingDepth = 0;
        this.BundleGroupBeforeFirstInst = false;
        this.HasInstructions = false;
        this.IsRegistered = false;
        this.DummyFragment = new MCDummyFragment(this);
        this.Fragments = new ilistMCFragment();
        this.SubsectionFragmentMap = new SmallVector<std_pair.pairUIntPtr>(1, new std_pair.pairUIntPtr());
        this.Variant = V;
        this.Kind = new SectionKind(K);
    }

    public void $destroy() {
        this.SubsectionFragmentMap.$destroy();
        this.Fragments.$destroy();
        this.DummyFragment.$destroy();
    }

    public SectionKind getKind() {
        return new SectionKind(this.Kind);
    }

    public SectionVariant getVariant() {
        return this.Variant;
    }

    public MCSymbol getBeginSymbol() {
        return this.Begin;
    }

    public MCSymbol getBeginSymbol$Const() {
        return this.getBeginSymbol();
    }

    public void setBeginSymbol(MCSymbol Sym) {
        assert (this.Begin == null);
        this.Begin = Sym;
    }

    public MCSymbol getEndSymbol(MCContext Ctx) {
        if (this.End == null) {
            this.End = Ctx.createTempSymbol(new Twine("sec_end"), true);
        }
        return this.End;
    }

    public boolean hasEnded() {
        return this.End != null && this.End.isInSection();
    }

    public int getAlignment() {
        return this.Alignment;
    }

    public void setAlignment(int Value) {
        this.Alignment = Value;
    }

    public int getOrdinal() {
        return this.Ordinal;
    }

    public void setOrdinal(int Value) {
        this.Ordinal = Value;
    }

    public int getLayoutOrder() {
        return this.LayoutOrder;
    }

    public void setLayoutOrder(int Value) {
        this.LayoutOrder = Value;
    }

    public BundleLockStateType getBundleLockState() {
        return this.BundleLockState;
    }

    public void setBundleLockState(BundleLockStateType NewState) {
        if (NewState == BundleLockStateType.NotBundleLocked) {
            if (this.BundleLockNestingDepth == 0) {
                llvm.report_fatal_error(NativePointer.$((String)"Mismatched bundle_lock/unlock directives"));
            }
            if (--this.BundleLockNestingDepth == 0) {
                this.BundleLockState = BundleLockStateType.NotBundleLocked;
            }
            return;
        }
        if (this.BundleLockState != BundleLockStateType.BundleLockedAlignToEnd) {
            this.BundleLockState = NewState;
        }
        ++this.BundleLockNestingDepth;
    }

    public boolean isBundleLocked() {
        return this.BundleLockState != BundleLockStateType.NotBundleLocked;
    }

    public boolean isBundleGroupBeforeFirstInst() {
        return this.BundleGroupBeforeFirstInst;
    }

    public void setBundleGroupBeforeFirstInst(boolean IsFirst) {
        this.BundleGroupBeforeFirstInst = IsFirst;
    }

    public boolean hasInstructions() {
        return this.HasInstructions;
    }

    public void setHasInstructions(boolean Value) {
        this.HasInstructions = Value;
    }

    public boolean isRegistered() {
        return this.IsRegistered;
    }

    public void setIsRegistered(boolean Value) {
        this.IsRegistered = Value;
    }

    public iplist<MCFragment> getFragmentList() {
        return this.Fragments;
    }

    public iplist<MCFragment> getFragmentList$Const() {
        return this.getFragmentList();
    }

    public static iplist<MCFragment> getSublistAccess(MCSection $this, MCFragment $Prm0) {
        return (iplist)Native.$AddrOf($this.Fragments);
    }

    public MCDummyFragment getDummyFragment$Const() {
        return this.DummyFragment;
    }

    public MCDummyFragment getDummyFragment() {
        return this.DummyFragment;
    }

    public ilist_iterator<MCFragment> begin() {
        return this.Fragments.begin();
    }

    public ilist_iterator<MCFragment> begin$Const() {
        return new ilist_iterator<MCFragment>(this.begin());
    }

    public ilist_iterator<MCFragment> end() {
        return this.Fragments.end();
    }

    public ilist_iterator<MCFragment> end$Const() {
        return new ilist_iterator<MCFragment>(this.end());
    }

    public std.reverse_iterator<MCFragment> rbegin() {
        return this.Fragments.rbegin();
    }

    public std.reverse_iterator<MCFragment> rbegin$Const() {
        return new std.reverse_iterator(JavaDifferentiators.JD$Reverse_iterator$_Iter$C.INSTANCE, this.rbegin());
    }

    public std.reverse_iterator<MCFragment> rend() {
        return this.Fragments.rend();
    }

    public std.reverse_iterator<MCFragment> rend$Const() {
        return new std.reverse_iterator(JavaDifferentiators.JD$Reverse_iterator$_Iter$C.INSTANCE, this.rend());
    }

    public ilist_iterator<MCFragment> getSubsectionInsertionPoint(int Subsection) {
        if (Subsection == 0 && this.SubsectionFragmentMap.empty()) {
            return this.end();
        }
        type.ptr MI = (type.ptr)std.lower_bound(this.SubsectionFragmentMap.begin(), this.SubsectionFragmentMap.end(), (Object)std.make_pair_uint_Ptr((int)Subsection, (Object)null));
        boolean ExactMatch = false;
        if (Native.$noteq_ptr((void.ptr)MI, this.SubsectionFragmentMap.end())) {
            boolean bl = ExactMatch = ((std_pair.pairUIntPtr)MI.$star()).first == Subsection;
            if (ExactMatch) {
                MI.$preInc();
            }
        }
        ilist_iterator<MCFragment> IP = new ilist_iterator<MCFragment>(ilist_traitsMCFragment.$instance());
        if (Native.$eq_ptr((void.ptr)MI, this.SubsectionFragmentMap.end())) {
            IP.$assignMove(this.end());
        } else {
            IP.$assignMove(((MCFragment)((std_pair.pairUIntPtr)MI.$star()).second).getIterator());
        }
        if (!ExactMatch && Subsection != 0) {
            MCDataFragment F = new MCDataFragment();
            this.SubsectionFragmentMap.insert_iterator$T$value_T$RR((type.ptr<std_pair.pairUIntPtr<MCFragment>>)MI, (std_pair.pairUIntPtr<MCFragment>)std.make_pair_uint_Ptr((int)Subsection, (Object)F));
            this.getFragmentList().insert_ilist_iterator$NodeTy_T$P(new ilist_iterator<MCFragment>(IP), F);
            F.setParent(this);
        }
        return IP;
    }

    public void dump() {
        raw_ostream OS = llvm.errs();
        OS.$out("<MCSection");
        OS.$out(" Fragments:[\n      ");
        ilist_iterator<MCFragment> it = this.begin();
        ilist_iterator<MCFragment> ie = this.end();
        while (it.$noteq(ie)) {
            if (it.$noteq(this.begin())) {
                OS.$out(",\n      ");
            }
            ((MCFragment)it.$arrow()).dump();
            it.$preInc();
        }
        OS.$out("]>");
    }

    public abstract void PrintSwitchToSection(MCAsmInfo var1, raw_ostream var2, MCExpr var3);

    public abstract boolean UseCodeAlign();

    public abstract boolean isVirtualSection();

    @Override
    public Iterator<MCFragment> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    public String toString() {
        return "Begin=" + this.Begin + ", End=" + this.End + ", Alignment=" + this.Alignment + ", Ordinal=" + this.Ordinal + ", LayoutOrder=" + this.LayoutOrder + ", BundleLockState=" + (Object)((Object)this.BundleLockState) + ", BundleLockNestingDepth=" + this.BundleLockNestingDepth + ", BundleGroupBeforeFirstInst=" + this.BundleGroupBeforeFirstInst + ", HasInstructions=" + this.HasInstructions + ", IsRegistered=" + this.IsRegistered + ", DummyFragment=" + this.DummyFragment + ", Fragments=" + this.Fragments + ", SubsectionFragmentMap=" + this.SubsectionFragmentMap + ", Variant=" + (Object)((Object)this.Variant) + ", Kind=" + this.Kind;
    }

    public static final class BundleLockStateType
    extends Enum<BundleLockStateType>
    implements Native.NativeUIntEnum {
        public static final /* enum */ BundleLockStateType NotBundleLocked = new BundleLockStateType(0);
        public static final /* enum */ BundleLockStateType BundleLocked = new BundleLockStateType(NotBundleLocked.getValue() + 1);
        public static final /* enum */ BundleLockStateType BundleLockedAlignToEnd = new BundleLockStateType(BundleLocked.getValue() + 1);
        private final int value;
        private static final /* synthetic */ BundleLockStateType[] $VALUES;

        public static BundleLockStateType[] values() {
            return (BundleLockStateType[])$VALUES.clone();
        }

        public static BundleLockStateType valueOf(String name) {
            return Enum.valueOf(BundleLockStateType.class, name);
        }

        public static BundleLockStateType valueOf(int val) {
            BundleLockStateType out;
            BundleLockStateType bundleLockStateType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private BundleLockStateType(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new BundleLockStateType[]{NotBundleLocked, BundleLocked, BundleLockedAlignToEnd};
        }

        private static final class Values {
            private static final BundleLockStateType[] VALUES;
            private static final BundleLockStateType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (BundleLockStateType kind : BundleLockStateType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new BundleLockStateType[min < 0 ? 1 - min : 0];
                VALUES = new BundleLockStateType[max >= 0 ? 1 + max : 0];
                for (BundleLockStateType kind : BundleLockStateType.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((BundleLockStateType)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((BundleLockStateType)kind).value] = kind;
                }
            }
        }
    }

    public static final class SectionVariant
    extends Enum<SectionVariant>
    implements Native.NativeUIntEnum {
        public static final /* enum */ SectionVariant SV_COFF = new SectionVariant(0);
        public static final /* enum */ SectionVariant SV_ELF = new SectionVariant(SV_COFF.getValue() + 1);
        public static final /* enum */ SectionVariant SV_MachO = new SectionVariant(SV_ELF.getValue() + 1);
        private final int value;
        private static final /* synthetic */ SectionVariant[] $VALUES;

        public static SectionVariant[] values() {
            return (SectionVariant[])$VALUES.clone();
        }

        public static SectionVariant valueOf(String name) {
            return Enum.valueOf(SectionVariant.class, name);
        }

        public static SectionVariant valueOf(int val) {
            SectionVariant out;
            SectionVariant sectionVariant = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private SectionVariant(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new SectionVariant[]{SV_COFF, SV_ELF, SV_MachO};
        }

        private static final class Values {
            private static final SectionVariant[] VALUES;
            private static final SectionVariant[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (SectionVariant kind : SectionVariant.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new SectionVariant[min < 0 ? 1 - min : 0];
                VALUES = new SectionVariant[max >= 0 ? 1 + max : 0];
                for (SectionVariant kind : SectionVariant.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((SectionVariant)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((SectionVariant)kind).value] = kind;
                }
            }
        }
    }
}

