/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.aliases.ushort;
import org.llvm.adt.aliases.DenseMapIntInt;
import org.llvm.adt.aliases.DenseMapIteratorIntInt;
import org.llvm.mc.MCRegisterClass;
import org.llvm.mc.MCRegisterDesc;
import org.llvm.mc.MCSubRegIterator;
import org.llvm.mc.MCSuperRegIterator;
import org.llvm.support.llvm;

public class MCRegisterInfo
implements Destructors.ClassWithDestructor {
    private type.ptr<MCRegisterDesc> Desc;
    private int NumRegs;
    private int RAReg;
    private int PCReg;
    private type.ptr<MCRegisterClass> Classes;
    private int NumClasses;
    private int NumRegUnits;
    public char[] RegUnitRoots = new char[2];
    public ushort.ptr DiffLists;
    private uint.ptr RegUnitMaskSequences;
    private char.ptr RegStrings;
    private char.ptr RegClassStrings;
    private ushort.ptr SubRegIndices;
    private type.ptr<SubRegCoveredBits> SubRegIdxRanges;
    private int NumSubRegIndices;
    private ushort.ptr RegEncodingTable;
    private int L2DwarfRegsSize;
    private int EHL2DwarfRegsSize;
    private int Dwarf2LRegsSize;
    private int EHDwarf2LRegsSize;
    private type.ptr<DwarfLLVMRegPair> L2DwarfRegs;
    private type.ptr<DwarfLLVMRegPair> EHL2DwarfRegs;
    private type.ptr<DwarfLLVMRegPair> Dwarf2LRegs;
    private type.ptr<DwarfLLVMRegPair> EHDwarf2LRegs;
    private DenseMapIntInt L2SEHRegs;
    private DenseMapIntInt L2CVRegs;

    public void InitMCRegisterInfo(type.ptr<MCRegisterDesc> D, int NR, int RA, int PC, type.ptr<MCRegisterClass> C2, int NC, char[] RURoots, int NRU, ushort.ptr DL, uint.ptr RUMS, char.ptr Strings, char.ptr ClassStrings, ushort.ptr SubIndices, int NumIndices, type.ptr<SubRegCoveredBits> SubIdxRanges, ushort.ptr RET) {
        this.Desc = D;
        this.NumRegs = NR;
        this.RAReg = RA;
        this.PCReg = PC;
        this.Classes = C2;
        this.DiffLists = (ushort.ptr)Native.$tryClone((NativeCloneable)DL);
        this.RegUnitMaskSequences = (uint.ptr)Native.$tryClone((NativeCloneable)RUMS);
        this.RegStrings = Native.$tryClone((char.ptr)Strings);
        this.RegClassStrings = Native.$tryClone((char.ptr)ClassStrings);
        this.NumClasses = NC;
        this.RegUnitRoots = RURoots;
        this.NumRegUnits = NRU;
        this.SubRegIndices = (ushort.ptr)Native.$tryClone((NativeCloneable)SubIndices);
        this.NumSubRegIndices = NumIndices;
        this.SubRegIdxRanges = SubIdxRanges;
        this.RegEncodingTable = (ushort.ptr)Native.$tryClone((NativeCloneable)RET);
    }

    public void mapLLVMRegsToDwarfRegs(type.ptr<DwarfLLVMRegPair> Map2, int Size, boolean isEH) {
        if (isEH) {
            this.EHL2DwarfRegs = Map2;
            this.EHL2DwarfRegsSize = Size;
        } else {
            this.L2DwarfRegs = Map2;
            this.L2DwarfRegsSize = Size;
        }
    }

    public void mapDwarfRegsToLLVMRegs(type.ptr<DwarfLLVMRegPair> Map2, int Size, boolean isEH) {
        if (isEH) {
            this.EHDwarf2LRegs = Map2;
            this.EHDwarf2LRegsSize = Size;
        } else {
            this.Dwarf2LRegs = Map2;
            this.Dwarf2LRegsSize = Size;
        }
    }

    public void mapLLVMRegToSEHReg(int LLVMReg, int SEHReg) {
        this.L2SEHRegs.$set(LLVMReg, SEHReg);
    }

    public void mapLLVMRegToCVReg(int LLVMReg, int CVReg) {
        this.L2CVRegs.$set(LLVMReg, CVReg);
    }

    public int getRARegister() {
        return this.RAReg;
    }

    public int getProgramCounter() {
        return this.PCReg;
    }

    public MCRegisterDesc $at(int RegNo) {
        assert (Unsigned.$less_uint((int)RegNo, (int)this.NumRegs)) : "Attempting to access record for invalid register number!";
        return (MCRegisterDesc)this.Desc.$at(RegNo);
    }

    public MCRegisterDesc get(int RegNo) {
        return this.$at(RegNo);
    }

    public int getSubReg(int Reg, int Idx) {
        assert (Idx != 0 && Unsigned.$less_uint((int)Idx, (int)this.getNumSubRegIndices())) : "This is not a subregister index";
        ushort.ptr SRI = (ushort.ptr)Native.$tryClone((NativeCloneable)((ushort.ptr)this.SubRegIndices.$add(this.get((int)Reg).SubRegIndices)));
        MCSubRegIterator Subs = new MCSubRegIterator(Reg, this);
        while (Subs.isValid()) {
            if (Unsigned.$ushort2uint((char)SRI.$star()) == Idx) {
                return Subs.$star();
            }
            Subs.$preInc();
            SRI.$preInc();
        }
        return 0;
    }

    public int getMatchingSuperReg(int Reg, int SubIdx, MCRegisterClass RC) {
        MCSuperRegIterator Supers = new MCSuperRegIterator(Reg, this);
        while (Supers.isValid()) {
            if (RC.contains(Supers.$star()) && Reg == this.getSubReg(Supers.$star(), SubIdx)) {
                return Supers.$star();
            }
            Supers.$preInc();
        }
        return 0;
    }

    public int getSubRegIndex(int Reg, int SubReg) {
        assert (SubReg != 0 && Unsigned.$less_uint((int)SubReg, (int)this.getNumRegs())) : "This is not a register";
        ushort.ptr SRI = (ushort.ptr)Native.$tryClone((NativeCloneable)((ushort.ptr)this.SubRegIndices.$add(this.get((int)Reg).SubRegIndices)));
        MCSubRegIterator Subs = new MCSubRegIterator(Reg, this);
        while (Subs.isValid()) {
            if (Subs.$star() == SubReg) {
                return Unsigned.$ushort2uint((char)SRI.$star());
            }
            Subs.$preInc();
            SRI.$preInc();
        }
        return 0;
    }

    public int getSubRegIdxSize(int Idx) {
        assert (Idx != 0 && Unsigned.$less_uint((int)Idx, (int)this.getNumSubRegIndices())) : "This is not a subregister index";
        return Unsigned.$ushort2uint((char)((SubRegCoveredBits)this.SubRegIdxRanges.$at((int)Idx)).Size);
    }

    public int getSubRegIdxOffset(int Idx) {
        assert (Idx != 0 && Unsigned.$less_uint((int)Idx, (int)this.getNumSubRegIndices())) : "This is not a subregister index";
        return Unsigned.$ushort2uint((char)((SubRegCoveredBits)this.SubRegIdxRanges.$at((int)Idx)).Offset);
    }

    public char.ptr getName(int RegNo) {
        return (char.ptr)this.RegStrings.$add(this.get((int)RegNo).Name);
    }

    public int getNumRegs() {
        return this.NumRegs;
    }

    public int getNumSubRegIndices() {
        return this.NumSubRegIndices;
    }

    public int getNumRegUnits() {
        return this.NumRegUnits;
    }

    public int getDwarfRegNum(int RegNum, boolean isEH) {
        type.ptr<DwarfLLVMRegPair> M = isEH ? this.EHL2DwarfRegs : this.L2DwarfRegs;
        int Size = isEH ? this.EHL2DwarfRegsSize : this.L2DwarfRegsSize;
        DwarfLLVMRegPair Key = new DwarfLLVMRegPair(RegNum, 0);
        type.ptr I = (type.ptr)std.lower_bound(M, (type.iterator)((type.ptr)M.$add(Size)), (Object)Key);
        if (I.$eq((Object)M.$add(Size)) || ((DwarfLLVMRegPair)I.$star()).FromReg != RegNum) {
            return -1;
        }
        return ((DwarfLLVMRegPair)I.$star()).ToReg;
    }

    public int getLLVMRegNum(int RegNum, boolean isEH) {
        type.ptr<DwarfLLVMRegPair> M = isEH ? this.EHDwarf2LRegs : this.Dwarf2LRegs;
        int Size = isEH ? this.EHDwarf2LRegsSize : this.Dwarf2LRegsSize;
        DwarfLLVMRegPair Key = new DwarfLLVMRegPair(RegNum, 0);
        type.ptr I = (type.ptr)std.lower_bound(M, (type.iterator)((type.ptr)M.$add(Size)), (Object)Key);
        assert (!I.$eq((Object)M.$add(Size)) && ((DwarfLLVMRegPair)I.$star()).FromReg == RegNum) : "Invalid RegNum";
        return ((DwarfLLVMRegPair)I.$star()).ToReg;
    }

    public int getSEHRegNum(int RegNum) {
        DenseMapIteratorIntInt I = this.L2SEHRegs.find$Const(RegNum);
        if (I.$eq(this.L2SEHRegs.end$Const())) {
            return RegNum;
        }
        return I.$arrow().second;
    }

    public int getCodeViewRegNum(int RegNum) {
        DenseMapIteratorIntInt I;
        if (this.L2CVRegs.empty()) {
            llvm.report_fatal_error(NativePointer.$((String)"target does not implement codeview register mapping"));
        }
        if ((I = this.L2CVRegs.find$Const(RegNum)).$eq(this.L2CVRegs.end$Const())) {
            llvm.report_fatal_error(NativePointer.$((String)"unknown codeview register"));
        }
        return I.$arrow().second;
    }

    public type.ptr<MCRegisterClass> regclass_begin() {
        return this.Classes;
    }

    public type.ptr<MCRegisterClass> regclass_end() {
        return (type.ptr)this.Classes.$add(this.NumClasses);
    }

    public int getNumRegClasses() {
        return this.regclass_end().$sub(this.regclass_begin());
    }

    public MCRegisterClass getRegClass(int i) {
        assert (Unsigned.$less_uint((int)i, (int)this.getNumRegClasses())) : "Register Class ID out of range";
        return (MCRegisterClass)this.Classes.$at(i);
    }

    public char.ptr getRegClassName(MCRegisterClass Class2) {
        return (char.ptr)this.RegClassStrings.$add(Class2.NameIdx);
    }

    public char getEncodingValue(int RegNo) {
        assert (Unsigned.$less_uint((int)RegNo, (int)this.NumRegs)) : "Attempting to get encoding for invalid register number!";
        return this.RegEncodingTable.$at(RegNo);
    }

    public boolean isSubRegister(int RegA, int RegB) {
        return this.isSuperRegister(RegB, RegA);
    }

    public boolean isSuperRegister(int RegA, int RegB) {
        MCSuperRegIterator I = new MCSuperRegIterator(RegA, this);
        while (I.isValid()) {
            if (I.$star() == RegB) {
                return true;
            }
            I.$preInc();
        }
        return false;
    }

    public boolean isSubRegisterEq(int RegA, int RegB) {
        return this.isSuperRegisterEq(RegB, RegA);
    }

    public boolean isSuperRegisterEq(int RegA, int RegB) {
        return RegA == RegB || this.isSuperRegister(RegA, RegB);
    }

    public boolean isSuperOrSubRegisterEq(int RegA, int RegB) {
        return this.isSubRegisterEq(RegA, RegB) || this.isSuperRegister(RegA, RegB);
    }

    public void $destroy() {
        this.L2CVRegs.$destroy();
        this.L2SEHRegs.$destroy();
    }

    public String toString() {
        return "Desc=" + this.Desc + ", NumRegs=" + this.NumRegs + ", RAReg=" + this.RAReg + ", PCReg=" + this.PCReg + ", Classes=" + this.Classes + ", NumClasses=" + this.NumClasses + ", NumRegUnits=" + this.NumRegUnits + ", RegUnitRoots=" + this.RegUnitRoots + ", DiffLists=" + this.DiffLists + ", RegUnitMaskSequences=" + this.RegUnitMaskSequences + ", RegStrings=" + this.RegStrings + ", RegClassStrings=" + this.RegClassStrings + ", SubRegIndices=" + this.SubRegIndices + ", SubRegIdxRanges=" + this.SubRegIdxRanges + ", NumSubRegIndices=" + this.NumSubRegIndices + ", RegEncodingTable=" + this.RegEncodingTable + ", L2DwarfRegsSize=" + this.L2DwarfRegsSize + ", EHL2DwarfRegsSize=" + this.EHL2DwarfRegsSize + ", Dwarf2LRegsSize=" + this.Dwarf2LRegsSize + ", EHDwarf2LRegsSize=" + this.EHDwarf2LRegsSize + ", L2DwarfRegs=" + this.L2DwarfRegs + ", EHL2DwarfRegs=" + this.EHL2DwarfRegs + ", Dwarf2LRegs=" + this.Dwarf2LRegs + ", EHDwarf2LRegs=" + this.EHDwarf2LRegs + ", L2SEHRegs=" + this.L2SEHRegs + ", L2CVRegs=" + this.L2CVRegs;
    }

    public static class DiffListIterator {
        private char Val = Unsigned.$int2ushort((int)0);
        private ushort.ptr List = null;

        protected DiffListIterator() {
        }

        protected void init(char InitVal, ushort.ptr DiffList) {
            this.Val = InitVal;
            this.List = (ushort.ptr)Native.$tryClone((NativeCloneable)DiffList);
        }

        protected int advance() {
            assert (this.isValid()) : "Cannot move off the end of the list.";
            char D = ((ushort.ptr)this.List.$postInc()).$star();
            this.Val = (char)(this.Val + Unsigned.$ushort2int((char)D));
            return Unsigned.$ushort2uint((char)D);
        }

        public boolean isValid() {
            return Native.$bool((Native.Native$Bool)this.List);
        }

        public int $star() {
            return Unsigned.$ushort2uint((char)this.Val);
        }

        public void $preInc() {
            if (this.advance() == 0) {
                this.List = null;
            }
        }

        public DiffListIterator $assignMove(DiffListIterator $Prm0) {
            this.Val = $Prm0.Val;
            this.List = (ushort.ptr)Native.$tryClone((NativeCloneable)$Prm0.List);
            return this;
        }

        public String toString() {
            return "Val=" + Unsigned.$ushort2uint((char)this.Val) + ", List=" + this.List;
        }
    }

    public static class SubRegCoveredBits {
        public char Offset;
        public char Size;

        public String toString() {
            return "Offset=" + Unsigned.$ushort2uint((char)this.Offset) + ", Size=" + Unsigned.$ushort2uint((char)this.Size);
        }
    }

    public static class DwarfLLVMRegPair {
        public int FromReg;
        public int ToReg;

        public boolean $less(DwarfLLVMRegPair RHS) {
            return Unsigned.$less_uint((int)this.FromReg, (int)RHS.FromReg);
        }

        public DwarfLLVMRegPair(DwarfLLVMRegPair $Prm0) {
            this.FromReg = $Prm0.FromReg;
            this.ToReg = $Prm0.ToReg;
        }

        public DwarfLLVMRegPair(int FromReg, int ToReg) {
            this.FromReg = FromReg;
            this.ToReg = ToReg;
        }

        public String toString() {
            return "FromReg=" + this.FromReg + ", ToReg=" + this.ToReg;
        }
    }
}

