/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.llvm.mc.MCExpr;
import org.llvm.mc.MCInst;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class MCOperand {
    private MachineOperandType Kind;
    private Unnamed_union1 Unnamed_field1 = new Unnamed_union1();

    public MCOperand() {
        this.Kind = MachineOperandType.kInvalid;
        this.Unnamed_field1.FPImmVal = 0.0;
    }

    public boolean isValid() {
        return this.Kind != MachineOperandType.kInvalid;
    }

    public boolean isReg() {
        return this.Kind == MachineOperandType.kRegister;
    }

    public boolean isImm() {
        return this.Kind == MachineOperandType.kImmediate;
    }

    public boolean isFPImm() {
        return this.Kind == MachineOperandType.kFPImmediate;
    }

    public boolean isExpr() {
        return this.Kind == MachineOperandType.kExpr;
    }

    public boolean isInst() {
        return this.Kind == MachineOperandType.kInst;
    }

    public int getReg() {
        assert (this.isReg()) : "This is not a register operand!";
        return this.Unnamed_field1.RegVal;
    }

    public void setReg(int Reg) {
        assert (this.isReg()) : "This is not a register operand!";
        this.Unnamed_field1.RegVal = Reg;
    }

    public long getImm() {
        assert (this.isImm()) : "This is not an immediate";
        return this.Unnamed_field1.ImmVal;
    }

    public void setImm(long Val) {
        assert (this.isImm()) : "This is not an immediate";
        this.Unnamed_field1.ImmVal = Val;
    }

    public double getFPImm() {
        assert (this.isFPImm()) : "This is not an FP immediate";
        return this.Unnamed_field1.FPImmVal;
    }

    public void setFPImm(double Val) {
        assert (this.isFPImm()) : "This is not an FP immediate";
        this.Unnamed_field1.FPImmVal = Val;
    }

    public MCExpr getExpr() {
        assert (this.isExpr()) : "This is not an expression";
        return this.Unnamed_field1.ExprVal;
    }

    public void setExpr(MCExpr Val) {
        assert (this.isExpr()) : "This is not an expression";
        this.Unnamed_field1.ExprVal = Val;
    }

    public MCInst getInst() {
        assert (this.isInst()) : "This is not a sub-instruction";
        return this.Unnamed_field1.InstVal;
    }

    public void setInst(MCInst Val) {
        assert (this.isInst()) : "This is not a sub-instruction";
        this.Unnamed_field1.InstVal = Val;
    }

    public static MCOperand createReg(int Reg) {
        MCOperand Op2 = new MCOperand();
        Op2.Kind = MachineOperandType.kRegister;
        Op2.Unnamed_field1.RegVal = Reg;
        return Op2;
    }

    public static MCOperand createImm(long Val) {
        MCOperand Op2 = new MCOperand();
        Op2.Kind = MachineOperandType.kImmediate;
        Op2.Unnamed_field1.ImmVal = Val;
        return Op2;
    }

    public static MCOperand createFPImm(double Val) {
        MCOperand Op2 = new MCOperand();
        Op2.Kind = MachineOperandType.kFPImmediate;
        Op2.Unnamed_field1.FPImmVal = Val;
        return Op2;
    }

    public static MCOperand createExpr(MCExpr Val) {
        MCOperand Op2 = new MCOperand();
        Op2.Kind = MachineOperandType.kExpr;
        Op2.Unnamed_field1.ExprVal = Val;
        return Op2;
    }

    public static MCOperand createInst(MCInst Val) {
        MCOperand Op2 = new MCOperand();
        Op2.Kind = MachineOperandType.kInst;
        Op2.Unnamed_field1.InstVal = Val;
        return Op2;
    }

    public void print(raw_ostream OS) {
        OS.$out("<MCOperand ");
        if (!this.isValid()) {
            OS.$out("INVALID");
        } else if (this.isReg()) {
            OS.$out("Reg:").$out_uint(this.getReg());
        } else if (this.isImm()) {
            OS.$out("Imm:").$out_llong(this.getImm());
        } else if (this.isFPImm()) {
            OS.$out("FPImm:").$out_double(this.getFPImm());
        } else if (this.isExpr()) {
            AdtsupportLlvmGlobals.$out_raw_ostream_MCExpr$C(OS.$out("Expr:("), (MCExpr)Native.$Deref((Object)this.getExpr())).$out(NativePointer.$RPAREN);
        } else if (this.isInst()) {
            AdtsupportLlvmGlobals.$out_raw_ostream_MCInst$C(OS.$out("Inst:("), (MCInst)Native.$Deref((Object)this.getInst())).$out(NativePointer.$RPAREN);
        } else {
            OS.$out("UNDEFINED");
        }
        OS.$out(NativePointer.$GT);
    }

    public void dump() {
        this.print(llvm.dbgs());
        llvm.dbgs().$out(NativePointer.$LF);
    }

    public MCOperand(JavaDifferentiators.JD.Move _dparam, MCOperand $Prm0) {
        this.Kind = $Prm0.Kind;
        this.Unnamed_field1 = new Unnamed_union1(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Unnamed_field1);
    }

    public MCOperand $assign(MCOperand $Prm0) {
        this.Kind = $Prm0.Kind;
        this.Unnamed_field1.$assign($Prm0.Unnamed_field1);
        return this;
    }

    public MCOperand $assignMove(MCOperand $Prm0) {
        this.Kind = $Prm0.Kind;
        this.Unnamed_field1.$assignMove($Prm0.Unnamed_field1);
        return this;
    }

    public String toString() {
        return "Kind=" + (Object)((Object)this.Kind) + ", Unnamed_field1=" + this.Unnamed_field1;
    }

    private static class Unnamed_union1 {
        public int RegVal;
        public long ImmVal;
        public double FPImmVal;
        public MCExpr ExprVal;
        public MCInst InstVal;

        public Unnamed_union1(JavaDifferentiators.JD.Move _dparam, Unnamed_union1 $Prm0) {
        }

        public Unnamed_union1 $assign(Unnamed_union1 $Prm0) {
            return this;
        }

        public Unnamed_union1 $assignMove(Unnamed_union1 $Prm0) {
            return this;
        }

        public Unnamed_union1() {
        }

        public String toString() {
            return "RegVal=" + this.RegVal + ", ImmVal=" + this.ImmVal + ", FPImmVal=" + this.FPImmVal + ", ExprVal=[MCExpr], InstVal=" + this.InstVal;
        }
    }

    private static final class MachineOperandType
    extends Enum<MachineOperandType>
    implements Native.NativeUCharEnum {
        public static final /* enum */ MachineOperandType kInvalid = new MachineOperandType(0);
        public static final /* enum */ MachineOperandType kRegister = new MachineOperandType(kInvalid.getValue() + 1);
        public static final /* enum */ MachineOperandType kImmediate = new MachineOperandType(kRegister.getValue() + 1);
        public static final /* enum */ MachineOperandType kFPImmediate = new MachineOperandType(kImmediate.getValue() + 1);
        public static final /* enum */ MachineOperandType kExpr = new MachineOperandType(kFPImmediate.getValue() + 1);
        public static final /* enum */ MachineOperandType kInst = new MachineOperandType(kExpr.getValue() + 1);
        private final byte value;
        private static final /* synthetic */ MachineOperandType[] $VALUES;

        public static MachineOperandType[] values() {
            return (MachineOperandType[])$VALUES.clone();
        }

        public static MachineOperandType valueOf(String name) {
            return Enum.valueOf(MachineOperandType.class, name);
        }

        public static MachineOperandType valueOf(byte val) {
            MachineOperandType out = MachineOperandType.valueOf((int)val);
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]. Int not capable to keep values?";
            return out;
        }

        public static MachineOperandType valueOf(int val) {
            MachineOperandType out;
            MachineOperandType machineOperandType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private MachineOperandType(int val) {
            this.value = (byte)val;
        }

        public final byte getValue() {
            return this.value;
        }

        static {
            $VALUES = new MachineOperandType[]{kInvalid, kRegister, kImmediate, kFPImmediate, kExpr, kInst};
        }

        private static final class Values {
            private static final MachineOperandType[] VALUES;
            private static final MachineOperandType[] _VALUES;

            private Values() {
            }

            static {
                byte max = 0;
                byte min = 0;
                for (MachineOperandType kind : MachineOperandType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new MachineOperandType[min < 0 ? 1 - min : 0];
                VALUES = new MachineOperandType[max >= 0 ? 1 + max : 0];
                for (MachineOperandType kind : MachineOperandType.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((MachineOperandType)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((MachineOperandType)kind).value] = kind;
                }
            }
        }
    }
}

