/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.ulong;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.mc.MCAsmLayout;
import org.llvm.mc.MCAssembler;
import org.llvm.mc.MCFixup;
import org.llvm.mc.MCFragment;
import org.llvm.mc.MCSection;
import org.llvm.mc.MCSymbol;
import org.llvm.mc.MCSymbolRefExpr;
import org.llvm.mc.MCValue;
import org.llvm.support.endian.Writer;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.raw_pwrite_stream;

public abstract class MCObjectWriter
implements Destructors.ClassWithDestructor {
    private raw_pwrite_stream OS;
    protected boolean IsLittleEndian;

    protected MCObjectWriter(MCObjectWriter $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected void $assign(MCObjectWriter $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected MCObjectWriter(raw_pwrite_stream OS, boolean IsLittleEndian) {
        this.OS = (raw_pwrite_stream)Native.$AddrOf((Object)OS);
        this.IsLittleEndian = IsLittleEndian;
    }

    protected int getInitialOffset() {
        return Unsigned.$ulong2uint((long)this.OS.tell());
    }

    public void $destroy() {
    }

    public void reset() {
    }

    public boolean isLittleEndian() {
        return this.IsLittleEndian;
    }

    public raw_pwrite_stream getStream() {
        return (raw_pwrite_stream)Native.$Deref((Object)this.OS);
    }

    public void setStream(raw_pwrite_stream NewOS) {
        this.OS = (raw_pwrite_stream)Native.$AddrOf((Object)NewOS);
    }

    public abstract void executePostLayoutBinding(MCAssembler var1, MCAsmLayout var2);

    public abstract void recordRelocation(MCAssembler var1, MCAsmLayout var2, MCFragment var3, MCFixup var4, MCValue var5, bool.ref var6, ulong.ref var7);

    public boolean isSymbolRefDifferenceFullyResolved(MCAssembler Asm, MCSymbolRefExpr A, MCSymbolRefExpr B, boolean InSet) {
        if (A.getKind() != MCSymbolRefExpr.VariantKind.VK_None || B.getKind() != MCSymbolRefExpr.VariantKind.VK_None) {
            return false;
        }
        MCSymbol SA = A.getSymbol();
        MCSymbol SB = B.getSymbol();
        if (SA.isUndefined() || SB.isUndefined()) {
            return false;
        }
        if (SA.getFragment() == null || SB.getFragment() == null) {
            return false;
        }
        return this.isSymbolRefDifferenceFullyResolvedImpl(Asm, SA, SB, InSet);
    }

    public boolean isSymbolRefDifferenceFullyResolvedImpl(MCAssembler Asm, MCSymbol A, MCSymbol B, boolean InSet) {
        return this.isSymbolRefDifferenceFullyResolvedImpl(Asm, A, (MCFragment)Native.$Deref((Object)B.getFragment()), InSet, false);
    }

    public boolean isSymbolRefDifferenceFullyResolvedImpl(MCAssembler Asm, MCSymbol SymA, MCFragment FB, boolean InSet, boolean IsPCRel) {
        MCSection SecA = SymA.getSection();
        MCSection SecB = (MCSection)Native.$Deref((Object)FB.getParent());
        return Native.$AddrOf((Object)SecA) == Native.$AddrOf((Object)SecB);
    }

    public boolean isWeak(MCSymbol $Prm0) {
        return false;
    }

    public abstract void writeObject(MCAssembler var1, MCAsmLayout var2);

    public void write8(byte Value) {
        ((raw_pwrite_stream)Native.$Deref((Object)this.OS)).$out_char(Value);
    }

    public void writeLE16(char Value) {
        new Writer(llvm.support.endianness.little, (raw_ostream)Native.$Deref((Object)this.OS)).write_uint16(Value);
    }

    public void writeLE32(int Value) {
        new Writer(llvm.support.endianness.little, (raw_ostream)Native.$Deref((Object)this.OS)).write_uint32(Value);
    }

    public void writeLE64(long Value) {
        new Writer(llvm.support.endianness.little, (raw_ostream)Native.$Deref((Object)this.OS)).write_uint64(Value);
    }

    public void writeBE16(char Value) {
        new Writer(llvm.support.endianness.big, (raw_ostream)Native.$Deref((Object)this.OS)).write(Character.valueOf(Value));
    }

    public void writeBE32(int Value) {
        new Writer(llvm.support.endianness.big, (raw_ostream)Native.$Deref((Object)this.OS)).write(Value);
    }

    public void writeBE64(long Value) {
        new Writer(llvm.support.endianness.big, (raw_ostream)Native.$Deref((Object)this.OS)).write(Value);
    }

    public void write16(char Value) {
        if (this.IsLittleEndian) {
            this.writeLE16(Value);
        } else {
            this.writeBE16(Value);
        }
    }

    public void write32(int Value) {
        if (this.IsLittleEndian) {
            this.writeLE32(Value);
        } else {
            this.writeBE32(Value);
        }
    }

    public void write64(long Value) {
        if (this.IsLittleEndian) {
            this.writeLE64(Value);
        } else {
            this.writeBE64(Value);
        }
    }

    public void WriteZeros(int N) {
        byte[] Zeros = new byte[16];
        int e = Unsigned.$div_uint((int)N, (int)16);
        for (int i = 0; i != e; ++i) {
            ((raw_pwrite_stream)Native.$Deref((Object)this.OS)).$out(new StringRef(Zeros, 16));
        }
        ((raw_pwrite_stream)Native.$Deref((Object)this.OS)).$out(new StringRef(Zeros, Unsigned.$rem_uint((int)N, (int)16)));
    }

    public void writeBytes(SmallString ByteVec) {
        this.writeBytes(ByteVec, 0);
    }

    public void writeBytes(SmallString ByteVec, int ZeroFillSize) {
        this.writeBytes(new StringRef(ByteVec.data$Const(), ByteVec.size()), ZeroFillSize);
    }

    public void writeBytes(StringRef Str) {
        this.writeBytes(Str, 0);
    }

    public void writeBytes(StringRef Str, int ZeroFillSize) {
        assert (ZeroFillSize == 0 || Unsigned.$lesseq_uint((int)Str.size(), (int)ZeroFillSize)) : "data size greater than fill size, unexpected large write will occur";
        ((raw_pwrite_stream)Native.$Deref((Object)this.OS)).$out(Str);
        if (ZeroFillSize != 0) {
            this.WriteZeros(ZeroFillSize - Str.size());
        }
    }

    public String toString() {
        return "OS=" + this.OS + ", IsLittleEndian=" + this.IsLittleEndian;
    }
}

