/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.mc.ExceptionHandling;
import org.llvm.mc.MCContext;
import org.llvm.mc.MCSection;
import org.llvm.mc.SectionKind;
import org.llvm.mc.impl.MCObjectFileInfoStatics;
import org.llvm.support.CodeModel;
import org.llvm.support.llvm;

public class MCObjectFileInfo
implements Destructors.ClassWithDestructor {
    protected boolean CommDirectiveSupportsAlignment;
    protected boolean SupportsWeakOmittedEHFrame;
    protected boolean SupportsCompactUnwindWithoutEHFrame;
    protected boolean OmitDwarfIfHaveCompactUnwind;
    protected int PersonalityEncoding;
    protected int LSDAEncoding;
    protected int FDECFIEncoding;
    protected int TTypeEncoding;
    protected int CompactUnwindDwarfEHFrameOnly;
    protected MCSection TextSection;
    protected MCSection DataSection;
    protected MCSection BSSSection;
    protected MCSection ReadOnlySection;
    protected MCSection StaticCtorSection;
    protected MCSection StaticDtorSection;
    protected MCSection LSDASection;
    protected MCSection CompactUnwindSection;
    protected MCSection DwarfAbbrevSection;
    protected MCSection DwarfInfoSection;
    protected MCSection DwarfLineSection;
    protected MCSection DwarfFrameSection;
    protected MCSection DwarfPubTypesSection;
    protected MCSection DwarfDebugInlineSection;
    protected MCSection DwarfStrSection;
    protected MCSection DwarfLocSection;
    protected MCSection DwarfARangesSection;
    protected MCSection DwarfRangesSection;
    protected MCSection DwarfMacinfoSection;
    protected MCSection DwarfPubNamesSection;
    protected MCSection DwarfAccelNamesSection;
    protected MCSection DwarfAccelObjCSection;
    protected MCSection DwarfAccelNamespaceSection;
    protected MCSection DwarfAccelTypesSection;
    protected MCSection DwarfInfoDWOSection;
    protected MCSection DwarfTypesDWOSection;
    protected MCSection DwarfAbbrevDWOSection;
    protected MCSection DwarfStrDWOSection;
    protected MCSection DwarfLineDWOSection;
    protected MCSection DwarfLocDWOSection;
    protected MCSection DwarfStrOffDWOSection;
    protected MCSection DwarfAddrSection;
    protected MCSection DwarfCUIndexSection;
    protected MCSection DwarfTUIndexSection;
    protected MCSection DwarfGnuPubNamesSection;
    protected MCSection DwarfGnuPubTypesSection;
    protected MCSection COFFDebugSymbolsSection;
    protected MCSection COFFDebugTypesSection;
    protected MCSection TLSExtraDataSection;
    protected MCSection TLSDataSection;
    protected MCSection TLSBSSSection;
    protected MCSection StackMapSection;
    protected MCSection FaultMapSection;
    protected MCSection EHFrameSection;
    protected MCSection DataRelROSection;
    protected MCSection MergeableConst4Section;
    protected MCSection MergeableConst8Section;
    protected MCSection MergeableConst16Section;
    protected MCSection MergeableConst32Section;
    protected MCSection TLSTLVSection;
    protected MCSection TLSThreadInitSection;
    protected MCSection CStringSection;
    protected MCSection UStringSection;
    protected MCSection TextCoalSection;
    protected MCSection ConstTextCoalSection;
    protected MCSection ConstDataSection;
    protected MCSection DataCoalSection;
    protected MCSection DataCommonSection;
    protected MCSection DataBSSSection;
    protected MCSection FourByteConstantSection;
    protected MCSection EightByteConstantSection;
    protected MCSection SixteenByteConstantSection;
    protected MCSection LazySymbolPointerSection;
    protected MCSection NonLazySymbolPointerSection;
    protected MCSection ThreadLocalPointerSection;
    protected MCSection DrectveSection;
    protected MCSection PDataSection;
    protected MCSection XDataSection;
    protected MCSection SXDataSection;
    private Environment Env;
    private boolean PositionIndependent;
    private CodeModel.Model CMModel;
    private MCContext Ctx;
    private Triple TT = new Triple();

    public void InitMCObjectFileInfo(Triple TheTriple, boolean PIC, CodeModel.Model cm, MCContext ctx) {
        this.PositionIndependent = PIC;
        this.CMModel = cm;
        this.Ctx = (MCContext)Native.$AddrOf((Object)ctx);
        this.CommDirectiveSupportsAlignment = true;
        this.SupportsWeakOmittedEHFrame = true;
        this.SupportsCompactUnwindWithoutEHFrame = false;
        this.OmitDwarfIfHaveCompactUnwind = false;
        this.TTypeEncoding = 0;
        this.FDECFIEncoding = 0;
        this.LSDAEncoding = 0;
        this.PersonalityEncoding = 0;
        this.CompactUnwindDwarfEHFrameOnly = 0;
        this.EHFrameSection = null;
        this.CompactUnwindSection = null;
        this.DwarfAccelNamesSection = null;
        this.DwarfAccelObjCSection = null;
        this.DwarfAccelNamespaceSection = null;
        this.DwarfAccelTypesSection = null;
        this.TT.$assign(TheTriple);
        switch (this.TT.getObjectFormat()) {
            case MachO: {
                this.Env = Environment.IsMachO;
                this.initMachOMCObjectFileInfo(this.TT);
                break;
            }
            case COFF: {
                if (!this.TT.isOSWindows()) {
                    llvm.report_fatal_error(NativePointer.$((String)"Cannot initialize MC for non-Windows COFF object files."));
                }
                this.Env = Environment.IsCOFF;
                this.initCOFFMCObjectFileInfo(this.TT);
                break;
            }
            case ELF: {
                this.Env = Environment.IsELF;
                this.initELFMCObjectFileInfo(this.TT);
                break;
            }
            case UnknownObjectFormat: {
                llvm.report_fatal_error(NativePointer.$((String)"Cannot initialize MC for unknown object file format."));
            }
        }
    }

    public boolean getSupportsWeakOmittedEHFrame() {
        return this.SupportsWeakOmittedEHFrame;
    }

    public boolean getSupportsCompactUnwindWithoutEHFrame() {
        return this.SupportsCompactUnwindWithoutEHFrame;
    }

    public boolean getOmitDwarfIfHaveCompactUnwind() {
        return this.OmitDwarfIfHaveCompactUnwind;
    }

    public boolean getCommDirectiveSupportsAlignment() {
        return this.CommDirectiveSupportsAlignment;
    }

    public int getPersonalityEncoding() {
        return this.PersonalityEncoding;
    }

    public int getLSDAEncoding() {
        return this.LSDAEncoding;
    }

    public int getFDEEncoding() {
        return this.FDECFIEncoding;
    }

    public int getTTypeEncoding() {
        return this.TTypeEncoding;
    }

    public int getCompactUnwindDwarfEHFrameOnly() {
        return this.CompactUnwindDwarfEHFrameOnly;
    }

    public MCSection getTextSection() {
        return this.TextSection;
    }

    public MCSection getDataSection() {
        return this.DataSection;
    }

    public MCSection getBSSSection() {
        return this.BSSSection;
    }

    public MCSection getReadOnlySection() {
        return this.ReadOnlySection;
    }

    public MCSection getLSDASection() {
        return this.LSDASection;
    }

    public MCSection getCompactUnwindSection() {
        return this.CompactUnwindSection;
    }

    public MCSection getDwarfAbbrevSection() {
        return this.DwarfAbbrevSection;
    }

    public MCSection getDwarfInfoSection() {
        return this.DwarfInfoSection;
    }

    public MCSection getDwarfLineSection() {
        return this.DwarfLineSection;
    }

    public MCSection getDwarfFrameSection() {
        return this.DwarfFrameSection;
    }

    public MCSection getDwarfPubNamesSection() {
        return this.DwarfPubNamesSection;
    }

    public MCSection getDwarfPubTypesSection() {
        return this.DwarfPubTypesSection;
    }

    public MCSection getDwarfGnuPubNamesSection() {
        return this.DwarfGnuPubNamesSection;
    }

    public MCSection getDwarfGnuPubTypesSection() {
        return this.DwarfGnuPubTypesSection;
    }

    public MCSection getDwarfDebugInlineSection() {
        return this.DwarfDebugInlineSection;
    }

    public MCSection getDwarfStrSection() {
        return this.DwarfStrSection;
    }

    public MCSection getDwarfLocSection() {
        return this.DwarfLocSection;
    }

    public MCSection getDwarfARangesSection() {
        return this.DwarfARangesSection;
    }

    public MCSection getDwarfRangesSection() {
        return this.DwarfRangesSection;
    }

    public MCSection getDwarfMacinfoSection() {
        return this.DwarfMacinfoSection;
    }

    public MCSection getDwarfAccelNamesSection() {
        return this.DwarfAccelNamesSection;
    }

    public MCSection getDwarfAccelObjCSection() {
        return this.DwarfAccelObjCSection;
    }

    public MCSection getDwarfAccelNamespaceSection() {
        return this.DwarfAccelNamespaceSection;
    }

    public MCSection getDwarfAccelTypesSection() {
        return this.DwarfAccelTypesSection;
    }

    public MCSection getDwarfInfoDWOSection() {
        return this.DwarfInfoDWOSection;
    }

    public MCSection getDwarfTypesSection(long Hash) {
        return this.Ctx.getELFSection(new Twine(".debug_types"), 1, 512, 0, new Twine(llvm.utostr(Hash)));
    }

    public MCSection getDwarfTypesDWOSection() {
        return this.DwarfTypesDWOSection;
    }

    public MCSection getDwarfAbbrevDWOSection() {
        return this.DwarfAbbrevDWOSection;
    }

    public MCSection getDwarfStrDWOSection() {
        return this.DwarfStrDWOSection;
    }

    public MCSection getDwarfLineDWOSection() {
        return this.DwarfLineDWOSection;
    }

    public MCSection getDwarfLocDWOSection() {
        return this.DwarfLocDWOSection;
    }

    public MCSection getDwarfStrOffDWOSection() {
        return this.DwarfStrOffDWOSection;
    }

    public MCSection getDwarfAddrSection() {
        return this.DwarfAddrSection;
    }

    public MCSection getDwarfCUIndexSection() {
        return this.DwarfCUIndexSection;
    }

    public MCSection getDwarfTUIndexSection() {
        return this.DwarfTUIndexSection;
    }

    public MCSection getCOFFDebugSymbolsSection() {
        return this.COFFDebugSymbolsSection;
    }

    public MCSection getCOFFDebugTypesSection() {
        return this.COFFDebugTypesSection;
    }

    public MCSection getTLSExtraDataSection() {
        return this.TLSExtraDataSection;
    }

    public MCSection getTLSDataSection() {
        return this.TLSDataSection;
    }

    public MCSection getTLSBSSSection() {
        return this.TLSBSSSection;
    }

    public MCSection getStackMapSection() {
        return this.StackMapSection;
    }

    public MCSection getFaultMapSection() {
        return this.FaultMapSection;
    }

    public MCSection getDataRelROSection() {
        return this.DataRelROSection;
    }

    public MCSection getMergeableConst4Section() {
        return this.MergeableConst4Section;
    }

    public MCSection getMergeableConst8Section() {
        return this.MergeableConst8Section;
    }

    public MCSection getMergeableConst16Section() {
        return this.MergeableConst16Section;
    }

    public MCSection getMergeableConst32Section() {
        return this.MergeableConst32Section;
    }

    public MCSection getTLSTLVSection() {
        return this.TLSTLVSection;
    }

    public MCSection getTLSThreadInitSection() {
        return this.TLSThreadInitSection;
    }

    public MCSection getCStringSection() {
        return this.CStringSection;
    }

    public MCSection getUStringSection() {
        return this.UStringSection;
    }

    public MCSection getTextCoalSection() {
        return this.TextCoalSection;
    }

    public MCSection getConstTextCoalSection() {
        return this.ConstTextCoalSection;
    }

    public MCSection getConstDataSection() {
        return this.ConstDataSection;
    }

    public MCSection getDataCoalSection() {
        return this.DataCoalSection;
    }

    public MCSection getDataCommonSection() {
        return this.DataCommonSection;
    }

    public MCSection getDataBSSSection() {
        return this.DataBSSSection;
    }

    public MCSection getFourByteConstantSection() {
        return this.FourByteConstantSection;
    }

    public MCSection getEightByteConstantSection() {
        return this.EightByteConstantSection;
    }

    public MCSection getSixteenByteConstantSection() {
        return this.SixteenByteConstantSection;
    }

    public MCSection getLazySymbolPointerSection() {
        return this.LazySymbolPointerSection;
    }

    public MCSection getNonLazySymbolPointerSection() {
        return this.NonLazySymbolPointerSection;
    }

    public MCSection getThreadLocalPointerSection() {
        return this.ThreadLocalPointerSection;
    }

    public MCSection getDrectveSection() {
        return this.DrectveSection;
    }

    public MCSection getPDataSection() {
        return this.PDataSection;
    }

    public MCSection getXDataSection() {
        return this.XDataSection;
    }

    public MCSection getSXDataSection() {
        return this.SXDataSection;
    }

    public MCSection getEHFrameSection() {
        return this.EHFrameSection;
    }

    public Environment getObjectFileType() {
        return this.Env;
    }

    public boolean isPositionIndependent() {
        return this.PositionIndependent;
    }

    private void initMachOMCObjectFileInfo(Triple T4) {
        this.SupportsWeakOmittedEHFrame = false;
        this.EHFrameSection = this.Ctx.getMachOSection(new StringRef("__TEXT"), new StringRef("__eh_frame"), 1744830475, SectionKind.getReadOnly());
        if (T4.isOSDarwin() && T4.getArch() == Triple.ArchType.aarch64) {
            this.SupportsCompactUnwindWithoutEHFrame = true;
        }
        if (T4.isWatchABI()) {
            this.OmitDwarfIfHaveCompactUnwind = true;
        }
        this.PersonalityEncoding = 155;
        this.FDECFIEncoding = 16;
        this.LSDAEncoding = 16;
        this.TTypeEncoding = 155;
        if (T4.isMacOSX() && T4.isMacOSXVersionLT(10, 5)) {
            this.CommDirectiveSupportsAlignment = false;
        }
        this.TextSection = this.Ctx.getMachOSection(new StringRef("__TEXT"), new StringRef("__text"), Integer.MIN_VALUE, SectionKind.getText());
        this.DataSection = this.Ctx.getMachOSection(new StringRef("__DATA"), new StringRef("__data"), 0, SectionKind.getData());
        this.BSSSection = null;
        this.TLSDataSection = this.Ctx.getMachOSection(new StringRef("__DATA"), new StringRef("__thread_data"), 17, SectionKind.getData());
        this.TLSBSSSection = this.Ctx.getMachOSection(new StringRef("__DATA"), new StringRef("__thread_bss"), 18, SectionKind.getThreadBSS());
        this.TLSTLVSection = this.Ctx.getMachOSection(new StringRef("__DATA"), new StringRef("__thread_vars"), 19, SectionKind.getData());
        this.TLSThreadInitSection = this.Ctx.getMachOSection(new StringRef("__DATA"), new StringRef("__thread_init"), 21, SectionKind.getData());
        this.CStringSection = this.Ctx.getMachOSection(new StringRef("__TEXT"), new StringRef("__cstring"), 2, SectionKind.getMergeable1ByteCString());
        this.UStringSection = this.Ctx.getMachOSection(new StringRef("__TEXT"), new StringRef("__ustring"), 0, SectionKind.getMergeable2ByteCString());
        this.FourByteConstantSection = this.Ctx.getMachOSection(new StringRef("__TEXT"), new StringRef("__literal4"), 3, SectionKind.getMergeableConst4());
        this.EightByteConstantSection = this.Ctx.getMachOSection(new StringRef("__TEXT"), new StringRef("__literal8"), 4, SectionKind.getMergeableConst8());
        this.SixteenByteConstantSection = this.Ctx.getMachOSection(new StringRef("__TEXT"), new StringRef("__literal16"), 14, SectionKind.getMergeableConst16());
        this.ReadOnlySection = this.Ctx.getMachOSection(new StringRef("__TEXT"), new StringRef(NativePointer.$__const), 0, SectionKind.getReadOnly());
        Triple.ArchType ArchTy = T4.getArch();
        if (ArchTy == Triple.ArchType.ppc || ArchTy == Triple.ArchType.ppc64) {
            this.TextCoalSection = this.Ctx.getMachOSection(new StringRef("__TEXT"), new StringRef("__textcoal_nt"), -2147483637, SectionKind.getText());
            this.ConstTextCoalSection = this.Ctx.getMachOSection(new StringRef("__TEXT"), new StringRef("__const_coal"), 11, SectionKind.getReadOnly());
            this.DataCoalSection = this.Ctx.getMachOSection(new StringRef("__DATA"), new StringRef("__datacoal_nt"), 11, SectionKind.getData());
        } else {
            this.TextCoalSection = this.TextSection;
            this.ConstTextCoalSection = this.ReadOnlySection;
            this.DataCoalSection = this.DataSection;
        }
        this.ConstDataSection = this.Ctx.getMachOSection(new StringRef("__DATA"), new StringRef(NativePointer.$__const), 0, SectionKind.getReadOnlyWithRel());
        this.DataCommonSection = this.Ctx.getMachOSection(new StringRef("__DATA"), new StringRef("__common"), 1, SectionKind.getBSS());
        this.DataBSSSection = this.Ctx.getMachOSection(new StringRef("__DATA"), new StringRef("__bss"), 1, SectionKind.getBSS());
        this.LazySymbolPointerSection = this.Ctx.getMachOSection(new StringRef("__DATA"), new StringRef("__la_symbol_ptr"), 7, SectionKind.getMetadata());
        this.NonLazySymbolPointerSection = this.Ctx.getMachOSection(new StringRef("__DATA"), new StringRef("__nl_symbol_ptr"), 6, SectionKind.getMetadata());
        this.ThreadLocalPointerSection = this.Ctx.getMachOSection(new StringRef("__DATA"), new StringRef("__thread_ptr"), 20, SectionKind.getMetadata());
        if (!this.PositionIndependent) {
            this.StaticCtorSection = this.Ctx.getMachOSection(new StringRef("__TEXT"), new StringRef("__constructor"), 0, SectionKind.getData());
            this.StaticDtorSection = this.Ctx.getMachOSection(new StringRef("__TEXT"), new StringRef("__destructor"), 0, SectionKind.getData());
        } else {
            this.StaticCtorSection = this.Ctx.getMachOSection(new StringRef("__DATA"), new StringRef("__mod_init_func"), 9, SectionKind.getData());
            this.StaticDtorSection = this.Ctx.getMachOSection(new StringRef("__DATA"), new StringRef("__mod_term_func"), 10, SectionKind.getData());
        }
        this.LSDASection = this.Ctx.getMachOSection(new StringRef("__TEXT"), new StringRef("__gcc_except_tab"), 0, SectionKind.getReadOnlyWithRel());
        this.COFFDebugSymbolsSection = null;
        this.COFFDebugTypesSection = null;
        if (MCObjectFileInfoStatics.useCompactUnwind(T4)) {
            this.CompactUnwindSection = this.Ctx.getMachOSection(new StringRef("__LD"), new StringRef("__compact_unwind"), 0x2000000, SectionKind.getReadOnly());
            if (T4.getArch() == Triple.ArchType.x86_64 || T4.getArch() == Triple.ArchType.x86) {
                this.CompactUnwindDwarfEHFrameOnly = 0x4000000;
            } else if (T4.getArch() == Triple.ArchType.aarch64) {
                this.CompactUnwindDwarfEHFrameOnly = 0x3000000;
            } else if (T4.getArch() == Triple.ArchType.arm || T4.getArch() == Triple.ArchType.thumb) {
                this.CompactUnwindDwarfEHFrameOnly = 0x4000000;
            }
        }
        this.DwarfAccelNamesSection = this.Ctx.getMachOSection(new StringRef("__DWARF"), new StringRef("__apple_names"), 0x2000000, SectionKind.getMetadata(), NativePointer.$((String)"names_begin"));
        this.DwarfAccelObjCSection = this.Ctx.getMachOSection(new StringRef("__DWARF"), new StringRef("__apple_objc"), 0x2000000, SectionKind.getMetadata(), NativePointer.$((String)"objc_begin"));
        this.DwarfAccelNamespaceSection = this.Ctx.getMachOSection(new StringRef("__DWARF"), new StringRef("__apple_namespac"), 0x2000000, SectionKind.getMetadata(), NativePointer.$((String)"namespac_begin"));
        this.DwarfAccelTypesSection = this.Ctx.getMachOSection(new StringRef("__DWARF"), new StringRef("__apple_types"), 0x2000000, SectionKind.getMetadata(), NativePointer.$((String)"types_begin"));
        this.DwarfAbbrevSection = this.Ctx.getMachOSection(new StringRef("__DWARF"), new StringRef("__debug_abbrev"), 0x2000000, SectionKind.getMetadata(), NativePointer.$((String)"section_abbrev"));
        this.DwarfInfoSection = this.Ctx.getMachOSection(new StringRef("__DWARF"), new StringRef("__debug_info"), 0x2000000, SectionKind.getMetadata(), NativePointer.$((String)"section_info"));
        this.DwarfLineSection = this.Ctx.getMachOSection(new StringRef("__DWARF"), new StringRef("__debug_line"), 0x2000000, SectionKind.getMetadata(), NativePointer.$((String)"section_line"));
        this.DwarfFrameSection = this.Ctx.getMachOSection(new StringRef("__DWARF"), new StringRef("__debug_frame"), 0x2000000, SectionKind.getMetadata());
        this.DwarfPubNamesSection = this.Ctx.getMachOSection(new StringRef("__DWARF"), new StringRef("__debug_pubnames"), 0x2000000, SectionKind.getMetadata());
        this.DwarfPubTypesSection = this.Ctx.getMachOSection(new StringRef("__DWARF"), new StringRef("__debug_pubtypes"), 0x2000000, SectionKind.getMetadata());
        this.DwarfGnuPubNamesSection = this.Ctx.getMachOSection(new StringRef("__DWARF"), new StringRef("__debug_gnu_pubn"), 0x2000000, SectionKind.getMetadata());
        this.DwarfGnuPubTypesSection = this.Ctx.getMachOSection(new StringRef("__DWARF"), new StringRef("__debug_gnu_pubt"), 0x2000000, SectionKind.getMetadata());
        this.DwarfStrSection = this.Ctx.getMachOSection(new StringRef("__DWARF"), new StringRef("__debug_str"), 0x2000000, SectionKind.getMetadata(), NativePointer.$((String)"info_string"));
        this.DwarfLocSection = this.Ctx.getMachOSection(new StringRef("__DWARF"), new StringRef("__debug_loc"), 0x2000000, SectionKind.getMetadata(), NativePointer.$((String)"section_debug_loc"));
        this.DwarfARangesSection = this.Ctx.getMachOSection(new StringRef("__DWARF"), new StringRef("__debug_aranges"), 0x2000000, SectionKind.getMetadata());
        this.DwarfRangesSection = this.Ctx.getMachOSection(new StringRef("__DWARF"), new StringRef("__debug_ranges"), 0x2000000, SectionKind.getMetadata(), NativePointer.$((String)"debug_range"));
        this.DwarfMacinfoSection = this.Ctx.getMachOSection(new StringRef("__DWARF"), new StringRef("__debug_macinfo"), 0x2000000, SectionKind.getMetadata(), NativePointer.$((String)"debug_macinfo"));
        this.DwarfDebugInlineSection = this.Ctx.getMachOSection(new StringRef("__DWARF"), new StringRef("__debug_inlined"), 0x2000000, SectionKind.getMetadata());
        this.DwarfCUIndexSection = this.Ctx.getMachOSection(new StringRef("__DWARF"), new StringRef("__debug_cu_index"), 0x2000000, SectionKind.getMetadata());
        this.DwarfTUIndexSection = this.Ctx.getMachOSection(new StringRef("__DWARF"), new StringRef("__debug_tu_index"), 0x2000000, SectionKind.getMetadata());
        this.StackMapSection = this.Ctx.getMachOSection(new StringRef("__LLVM_STACKMAPS"), new StringRef("__llvm_stackmaps"), 0, SectionKind.getMetadata());
        this.FaultMapSection = this.Ctx.getMachOSection(new StringRef("__LLVM_FAULTMAPS"), new StringRef("__llvm_faultmaps"), 0, SectionKind.getMetadata());
        this.TLSExtraDataSection = this.TLSTLVSection;
    }

    private void initELFMCObjectFileInfo(Triple T4) {
        switch (T4.getArch()) {
            case mips: 
            case mipsel: {
                this.FDECFIEncoding = 11;
                break;
            }
            case mips64: 
            case mips64el: {
                this.FDECFIEncoding = 12;
                break;
            }
            case x86_64: {
                this.FDECFIEncoding = 0x10 | (this.CMModel == CodeModel.Model.Large ? 12 : 11);
                break;
            }
            default: {
                this.FDECFIEncoding = 27;
            }
        }
        switch (T4.getArch()) {
            case arm: 
            case armeb: 
            case thumb: 
            case thumbeb: {
                if (this.Ctx.getAsmInfo().getExceptionHandlingType() == ExceptionHandling.ARM) break;
            }
            case ppc: 
            case x86: {
                this.PersonalityEncoding = this.PositionIndependent ? 155 : 0;
                this.LSDAEncoding = this.PositionIndependent ? 27 : 0;
                this.TTypeEncoding = this.PositionIndependent ? 155 : 0;
                break;
            }
            case x86_64: {
                if (this.PositionIndependent) {
                    this.PersonalityEncoding = 0x90 | (this.CMModel == CodeModel.Model.Small || this.CMModel == CodeModel.Model.Medium ? 11 : 12);
                    this.LSDAEncoding = 0x10 | (this.CMModel == CodeModel.Model.Small ? 11 : 12);
                    this.TTypeEncoding = 0x90 | (this.CMModel == CodeModel.Model.Small || this.CMModel == CodeModel.Model.Medium ? 11 : 12);
                    break;
                }
                this.PersonalityEncoding = this.CMModel == CodeModel.Model.Small || this.CMModel == CodeModel.Model.Medium ? 3 : 0;
                this.LSDAEncoding = this.CMModel == CodeModel.Model.Small ? 3 : 0;
                this.TTypeEncoding = this.CMModel == CodeModel.Model.Small ? 3 : 0;
                break;
            }
            case hexagon: {
                this.PersonalityEncoding = 0;
                this.LSDAEncoding = 0;
                this.FDECFIEncoding = 0;
                this.TTypeEncoding = 0;
                if (!this.PositionIndependent) break;
                this.PersonalityEncoding |= 0x90;
                this.LSDAEncoding |= 0x10;
                this.FDECFIEncoding |= 0x10;
                this.TTypeEncoding |= 0x90;
                break;
            }
            case aarch64: 
            case aarch64_be: {
                if (this.PositionIndependent) {
                    this.PersonalityEncoding = 156;
                    this.LSDAEncoding = 28;
                    this.TTypeEncoding = 156;
                    break;
                }
                this.PersonalityEncoding = 0;
                this.LSDAEncoding = 0;
                this.TTypeEncoding = 0;
                break;
            }
            case lanai: {
                this.LSDAEncoding = 0;
                this.PersonalityEncoding = 0;
                this.TTypeEncoding = 0;
                break;
            }
            case mips: 
            case mipsel: 
            case mips64: 
            case mips64el: {
                this.PersonalityEncoding = 128;
                this.TTypeEncoding = 155;
                break;
            }
            case ppc64: 
            case ppc64le: {
                this.PersonalityEncoding = 148;
                this.LSDAEncoding = 20;
                this.TTypeEncoding = 148;
                break;
            }
            case sparcel: 
            case sparc: {
                if (this.PositionIndependent) {
                    this.LSDAEncoding = 27;
                    this.PersonalityEncoding = 155;
                    this.TTypeEncoding = 155;
                    break;
                }
                this.LSDAEncoding = 0;
                this.PersonalityEncoding = 0;
                this.TTypeEncoding = 0;
                break;
            }
            case sparcv9: {
                this.LSDAEncoding = 27;
                if (this.PositionIndependent) {
                    this.PersonalityEncoding = 155;
                    this.TTypeEncoding = 155;
                    break;
                }
                this.PersonalityEncoding = 0;
                this.TTypeEncoding = 0;
                break;
            }
            case systemz: {
                if (this.PositionIndependent) {
                    this.PersonalityEncoding = 155;
                    this.LSDAEncoding = 27;
                    this.TTypeEncoding = 155;
                    break;
                }
                this.PersonalityEncoding = 0;
                this.LSDAEncoding = 0;
                this.TTypeEncoding = 0;
                break;
            }
        }
        int EHSectionType = T4.getArch() == Triple.ArchType.x86_64 ? 0x70000001 : 1;
        int EHSectionFlags = 2;
        if (T4.isOSSolaris() && T4.getArch() != Triple.ArchType.x86_64) {
            EHSectionFlags |= 1;
        }
        this.BSSSection = this.Ctx.getELFSection(new Twine(".bss"), 8, 3);
        this.TextSection = this.Ctx.getELFSection(new Twine(".text"), 1, 6);
        this.DataSection = this.Ctx.getELFSection(new Twine(".data"), 1, 3);
        this.ReadOnlySection = this.Ctx.getELFSection(new Twine(".rodata"), 1, 2);
        this.TLSDataSection = this.Ctx.getELFSection(new Twine(".tdata"), 1, 1027);
        this.TLSBSSSection = this.Ctx.getELFSection(new Twine(".tbss"), 8, 1027);
        this.DataRelROSection = this.Ctx.getELFSection(new Twine(".data.rel.ro"), 1, 3);
        this.MergeableConst4Section = this.Ctx.getELFSection(new Twine(".rodata.cst4"), 1, 18, 4, new Twine(NativePointer.$EMPTY));
        this.MergeableConst8Section = this.Ctx.getELFSection(new Twine(".rodata.cst8"), 1, 18, 8, new Twine(NativePointer.$EMPTY));
        this.MergeableConst16Section = this.Ctx.getELFSection(new Twine(".rodata.cst16"), 1, 18, 16, new Twine(NativePointer.$EMPTY));
        this.MergeableConst32Section = this.Ctx.getELFSection(new Twine(".rodata.cst32"), 1, 18, 32, new Twine(NativePointer.$EMPTY));
        this.StaticCtorSection = this.Ctx.getELFSection(new Twine(".ctors"), 1, 3);
        this.StaticDtorSection = this.Ctx.getELFSection(new Twine(".dtors"), 1, 3);
        this.LSDASection = this.Ctx.getELFSection(new Twine(".gcc_except_table"), 1, 2);
        this.COFFDebugSymbolsSection = null;
        this.COFFDebugTypesSection = null;
        this.DwarfAbbrevSection = this.Ctx.getELFSection(new Twine(".debug_abbrev"), 1, 0, NativePointer.$((String)"section_abbrev"));
        this.DwarfInfoSection = this.Ctx.getELFSection(new Twine(".debug_info"), 1, 0, NativePointer.$((String)"section_info"));
        this.DwarfLineSection = this.Ctx.getELFSection(new Twine(".debug_line"), 1, 0);
        this.DwarfFrameSection = this.Ctx.getELFSection(new Twine(".debug_frame"), 1, 0);
        this.DwarfPubNamesSection = this.Ctx.getELFSection(new Twine(".debug_pubnames"), 1, 0);
        this.DwarfPubTypesSection = this.Ctx.getELFSection(new Twine(".debug_pubtypes"), 1, 0);
        this.DwarfGnuPubNamesSection = this.Ctx.getELFSection(new Twine(".debug_gnu_pubnames"), 1, 0);
        this.DwarfGnuPubTypesSection = this.Ctx.getELFSection(new Twine(".debug_gnu_pubtypes"), 1, 0);
        this.DwarfStrSection = this.Ctx.getELFSection(new Twine(".debug_str"), 1, 48, 1, new Twine(NativePointer.$EMPTY));
        this.DwarfLocSection = this.Ctx.getELFSection(new Twine(".debug_loc"), 1, 0);
        this.DwarfARangesSection = this.Ctx.getELFSection(new Twine(".debug_aranges"), 1, 0);
        this.DwarfRangesSection = this.Ctx.getELFSection(new Twine(".debug_ranges"), 1, 0, NativePointer.$((String)"debug_range"));
        this.DwarfMacinfoSection = this.Ctx.getELFSection(new Twine(".debug_macinfo"), 1, 0, NativePointer.$((String)"debug_macinfo"));
        this.DwarfAccelNamesSection = this.Ctx.getELFSection(new Twine(".apple_names"), 1, 0, NativePointer.$((String)"names_begin"));
        this.DwarfAccelObjCSection = this.Ctx.getELFSection(new Twine(".apple_objc"), 1, 0, NativePointer.$((String)"objc_begin"));
        this.DwarfAccelNamespaceSection = this.Ctx.getELFSection(new Twine(".apple_namespaces"), 1, 0, NativePointer.$((String)"namespac_begin"));
        this.DwarfAccelTypesSection = this.Ctx.getELFSection(new Twine(".apple_types"), 1, 0, NativePointer.$((String)"types_begin"));
        this.DwarfInfoDWOSection = this.Ctx.getELFSection(new Twine(".debug_info.dwo"), 1, 0);
        this.DwarfTypesDWOSection = this.Ctx.getELFSection(new Twine(".debug_types.dwo"), 1, 0);
        this.DwarfAbbrevDWOSection = this.Ctx.getELFSection(new Twine(".debug_abbrev.dwo"), 1, 0);
        this.DwarfStrDWOSection = this.Ctx.getELFSection(new Twine(".debug_str.dwo"), 1, 48, 1, new Twine(NativePointer.$EMPTY));
        this.DwarfLineDWOSection = this.Ctx.getELFSection(new Twine(".debug_line.dwo"), 1, 0);
        this.DwarfLocDWOSection = this.Ctx.getELFSection(new Twine(".debug_loc.dwo"), 1, 0, NativePointer.$((String)"skel_loc"));
        this.DwarfStrOffDWOSection = this.Ctx.getELFSection(new Twine(".debug_str_offsets.dwo"), 1, 0);
        this.DwarfAddrSection = this.Ctx.getELFSection(new Twine(".debug_addr"), 1, 0, NativePointer.$((String)"addr_sec"));
        this.DwarfCUIndexSection = this.Ctx.getELFSection(new Twine(".debug_cu_index"), 1, 0);
        this.DwarfTUIndexSection = this.Ctx.getELFSection(new Twine(".debug_tu_index"), 1, 0);
        this.StackMapSection = this.Ctx.getELFSection(new Twine(".llvm_stackmaps"), 1, 2);
        this.FaultMapSection = this.Ctx.getELFSection(new Twine(".llvm_faultmaps"), 1, 2);
        this.EHFrameSection = this.Ctx.getELFSection(new Twine(".eh_frame"), EHSectionType, EHSectionFlags);
    }

    private void initCOFFMCObjectFileInfo(Triple T4) {
        this.EHFrameSection = this.Ctx.getCOFFSection(new StringRef(".eh_frame"), -1073741760, SectionKind.getData());
        boolean IsThumb = T4.getArch() == Triple.ArchType.thumb;
        this.CommDirectiveSupportsAlignment = true;
        this.BSSSection = this.Ctx.getCOFFSection(new StringRef(".bss"), -1073741696, SectionKind.getBSS());
        this.TextSection = this.Ctx.getCOFFSection(new StringRef(".text"), (IsThumb ? 131072 : 0) | 0x20 | 0x20000000 | 0x40000000, SectionKind.getText());
        this.DataSection = this.Ctx.getCOFFSection(new StringRef(".data"), -1073741760, SectionKind.getData());
        this.ReadOnlySection = this.Ctx.getCOFFSection(new StringRef(".rdata"), 0x40000040, SectionKind.getReadOnly());
        if (T4.isKnownWindowsMSVCEnvironment() || T4.isWindowsItaniumEnvironment()) {
            this.StaticCtorSection = this.Ctx.getCOFFSection(new StringRef(".CRT$XCU"), 0x40000040, SectionKind.getReadOnly());
            this.StaticDtorSection = this.Ctx.getCOFFSection(new StringRef(".CRT$XTX"), 0x40000040, SectionKind.getReadOnly());
        } else {
            this.StaticCtorSection = this.Ctx.getCOFFSection(new StringRef(".ctors"), -1073741760, SectionKind.getData());
            this.StaticDtorSection = this.Ctx.getCOFFSection(new StringRef(".dtors"), -1073741760, SectionKind.getData());
        }
        this.LSDASection = T4.getArch() == Triple.ArchType.x86_64 ? null : this.Ctx.getCOFFSection(new StringRef(".gcc_except_table"), 0x40000040, SectionKind.getReadOnly());
        this.COFFDebugSymbolsSection = this.Ctx.getCOFFSection(new StringRef(".debug$S"), 0x42000040, SectionKind.getMetadata());
        this.COFFDebugTypesSection = this.Ctx.getCOFFSection(new StringRef(".debug$T"), 0x42000040, SectionKind.getMetadata());
        this.DwarfAbbrevSection = this.Ctx.getCOFFSection(new StringRef(".debug_abbrev"), 0x42000040, SectionKind.getMetadata(), NativePointer.$((String)"section_abbrev"));
        this.DwarfInfoSection = this.Ctx.getCOFFSection(new StringRef(".debug_info"), 0x42000040, SectionKind.getMetadata(), NativePointer.$((String)"section_info"));
        this.DwarfLineSection = this.Ctx.getCOFFSection(new StringRef(".debug_line"), 0x42000040, SectionKind.getMetadata(), NativePointer.$((String)"section_line"));
        this.DwarfFrameSection = this.Ctx.getCOFFSection(new StringRef(".debug_frame"), 0x42000040, SectionKind.getMetadata());
        this.DwarfPubNamesSection = this.Ctx.getCOFFSection(new StringRef(".debug_pubnames"), 0x42000040, SectionKind.getMetadata());
        this.DwarfPubTypesSection = this.Ctx.getCOFFSection(new StringRef(".debug_pubtypes"), 0x42000040, SectionKind.getMetadata());
        this.DwarfGnuPubNamesSection = this.Ctx.getCOFFSection(new StringRef(".debug_gnu_pubnames"), 0x42000040, SectionKind.getMetadata());
        this.DwarfGnuPubTypesSection = this.Ctx.getCOFFSection(new StringRef(".debug_gnu_pubtypes"), 0x42000040, SectionKind.getMetadata());
        this.DwarfStrSection = this.Ctx.getCOFFSection(new StringRef(".debug_str"), 0x42000040, SectionKind.getMetadata(), NativePointer.$((String)"info_string"));
        this.DwarfLocSection = this.Ctx.getCOFFSection(new StringRef(".debug_loc"), 0x42000040, SectionKind.getMetadata(), NativePointer.$((String)"section_debug_loc"));
        this.DwarfARangesSection = this.Ctx.getCOFFSection(new StringRef(".debug_aranges"), 0x42000040, SectionKind.getMetadata());
        this.DwarfRangesSection = this.Ctx.getCOFFSection(new StringRef(".debug_ranges"), 0x42000040, SectionKind.getMetadata(), NativePointer.$((String)"debug_range"));
        this.DwarfMacinfoSection = this.Ctx.getCOFFSection(new StringRef(".debug_macinfo"), 0x42000040, SectionKind.getMetadata(), NativePointer.$((String)"debug_macinfo"));
        this.DwarfInfoDWOSection = this.Ctx.getCOFFSection(new StringRef(".debug_info.dwo"), 0x42000040, SectionKind.getMetadata(), NativePointer.$((String)"section_info_dwo"));
        this.DwarfTypesDWOSection = this.Ctx.getCOFFSection(new StringRef(".debug_types.dwo"), 0x42000040, SectionKind.getMetadata(), NativePointer.$((String)"section_types_dwo"));
        this.DwarfAbbrevDWOSection = this.Ctx.getCOFFSection(new StringRef(".debug_abbrev.dwo"), 0x42000040, SectionKind.getMetadata(), NativePointer.$((String)"section_abbrev_dwo"));
        this.DwarfStrDWOSection = this.Ctx.getCOFFSection(new StringRef(".debug_str.dwo"), 0x42000040, SectionKind.getMetadata(), NativePointer.$((String)"skel_string"));
        this.DwarfLineDWOSection = this.Ctx.getCOFFSection(new StringRef(".debug_line.dwo"), 0x42000040, SectionKind.getMetadata());
        this.DwarfLocDWOSection = this.Ctx.getCOFFSection(new StringRef(".debug_loc.dwo"), 0x42000040, SectionKind.getMetadata(), NativePointer.$((String)"skel_loc"));
        this.DwarfStrOffDWOSection = this.Ctx.getCOFFSection(new StringRef(".debug_str_offsets.dwo"), 0x42000040, SectionKind.getMetadata());
        this.DwarfAddrSection = this.Ctx.getCOFFSection(new StringRef(".debug_addr"), 0x42000040, SectionKind.getMetadata(), NativePointer.$((String)"addr_sec"));
        this.DwarfCUIndexSection = this.Ctx.getCOFFSection(new StringRef(".debug_cu_index"), 0x42000040, SectionKind.getMetadata());
        this.DwarfTUIndexSection = this.Ctx.getCOFFSection(new StringRef(".debug_tu_index"), 0x42000040, SectionKind.getMetadata());
        this.DwarfAccelNamesSection = this.Ctx.getCOFFSection(new StringRef(".apple_names"), 0x42000040, SectionKind.getMetadata(), NativePointer.$((String)"names_begin"));
        this.DwarfAccelNamespaceSection = this.Ctx.getCOFFSection(new StringRef(".apple_namespaces"), 0x42000040, SectionKind.getMetadata(), NativePointer.$((String)"namespac_begin"));
        this.DwarfAccelTypesSection = this.Ctx.getCOFFSection(new StringRef(".apple_types"), 0x42000040, SectionKind.getMetadata(), NativePointer.$((String)"types_begin"));
        this.DwarfAccelObjCSection = this.Ctx.getCOFFSection(new StringRef(".apple_objc"), 0x42000040, SectionKind.getMetadata(), NativePointer.$((String)"objc_begin"));
        this.DrectveSection = this.Ctx.getCOFFSection(new StringRef(".drectve"), 2560, SectionKind.getMetadata());
        this.PDataSection = this.Ctx.getCOFFSection(new StringRef(".pdata"), 0x40000040, SectionKind.getData());
        this.XDataSection = this.Ctx.getCOFFSection(new StringRef(".xdata"), 0x40000040, SectionKind.getData());
        this.SXDataSection = this.Ctx.getCOFFSection(new StringRef(".sxdata"), 512, SectionKind.getMetadata());
        this.TLSDataSection = this.Ctx.getCOFFSection(new StringRef(".tls$"), -1073741760, SectionKind.getData());
        this.StackMapSection = this.Ctx.getCOFFSection(new StringRef(".llvm_stackmaps"), 0x40000040, SectionKind.getReadOnly());
    }

    public Triple getTargetTriple() {
        return this.TT;
    }

    public void $destroy() {
        this.TT.$destroy();
    }

    public String toString() {
        return "CommDirectiveSupportsAlignment=" + this.CommDirectiveSupportsAlignment + ", SupportsWeakOmittedEHFrame=" + this.SupportsWeakOmittedEHFrame + ", SupportsCompactUnwindWithoutEHFrame=" + this.SupportsCompactUnwindWithoutEHFrame + ", OmitDwarfIfHaveCompactUnwind=" + this.OmitDwarfIfHaveCompactUnwind + ", PersonalityEncoding=" + this.PersonalityEncoding + ", LSDAEncoding=" + this.LSDAEncoding + ", FDECFIEncoding=" + this.FDECFIEncoding + ", TTypeEncoding=" + this.TTypeEncoding + ", CompactUnwindDwarfEHFrameOnly=" + this.CompactUnwindDwarfEHFrameOnly + ", TextSection=" + this.TextSection + ", DataSection=" + this.DataSection + ", BSSSection=" + this.BSSSection + ", ReadOnlySection=" + this.ReadOnlySection + ", StaticCtorSection=" + this.StaticCtorSection + ", StaticDtorSection=" + this.StaticDtorSection + ", LSDASection=" + this.LSDASection + ", CompactUnwindSection=" + this.CompactUnwindSection + ", DwarfAbbrevSection=" + this.DwarfAbbrevSection + ", DwarfInfoSection=" + this.DwarfInfoSection + ", DwarfLineSection=" + this.DwarfLineSection + ", DwarfFrameSection=" + this.DwarfFrameSection + ", DwarfPubTypesSection=" + this.DwarfPubTypesSection + ", DwarfDebugInlineSection=" + this.DwarfDebugInlineSection + ", DwarfStrSection=" + this.DwarfStrSection + ", DwarfLocSection=" + this.DwarfLocSection + ", DwarfARangesSection=" + this.DwarfARangesSection + ", DwarfRangesSection=" + this.DwarfRangesSection + ", DwarfMacinfoSection=" + this.DwarfMacinfoSection + ", DwarfPubNamesSection=" + this.DwarfPubNamesSection + ", DwarfAccelNamesSection=" + this.DwarfAccelNamesSection + ", DwarfAccelObjCSection=" + this.DwarfAccelObjCSection + ", DwarfAccelNamespaceSection=" + this.DwarfAccelNamespaceSection + ", DwarfAccelTypesSection=" + this.DwarfAccelTypesSection + ", DwarfInfoDWOSection=" + this.DwarfInfoDWOSection + ", DwarfTypesDWOSection=" + this.DwarfTypesDWOSection + ", DwarfAbbrevDWOSection=" + this.DwarfAbbrevDWOSection + ", DwarfStrDWOSection=" + this.DwarfStrDWOSection + ", DwarfLineDWOSection=" + this.DwarfLineDWOSection + ", DwarfLocDWOSection=" + this.DwarfLocDWOSection + ", DwarfStrOffDWOSection=" + this.DwarfStrOffDWOSection + ", DwarfAddrSection=" + this.DwarfAddrSection + ", DwarfCUIndexSection=" + this.DwarfCUIndexSection + ", DwarfTUIndexSection=" + this.DwarfTUIndexSection + ", DwarfGnuPubNamesSection=" + this.DwarfGnuPubNamesSection + ", DwarfGnuPubTypesSection=" + this.DwarfGnuPubTypesSection + ", COFFDebugSymbolsSection=" + this.COFFDebugSymbolsSection + ", COFFDebugTypesSection=" + this.COFFDebugTypesSection + ", TLSExtraDataSection=" + this.TLSExtraDataSection + ", TLSDataSection=" + this.TLSDataSection + ", TLSBSSSection=" + this.TLSBSSSection + ", StackMapSection=" + this.StackMapSection + ", FaultMapSection=" + this.FaultMapSection + ", EHFrameSection=" + this.EHFrameSection + ", DataRelROSection=" + this.DataRelROSection + ", MergeableConst4Section=" + this.MergeableConst4Section + ", MergeableConst8Section=" + this.MergeableConst8Section + ", MergeableConst16Section=" + this.MergeableConst16Section + ", MergeableConst32Section=" + this.MergeableConst32Section + ", TLSTLVSection=" + this.TLSTLVSection + ", TLSThreadInitSection=" + this.TLSThreadInitSection + ", CStringSection=" + this.CStringSection + ", UStringSection=" + this.UStringSection + ", TextCoalSection=" + this.TextCoalSection + ", ConstTextCoalSection=" + this.ConstTextCoalSection + ", ConstDataSection=" + this.ConstDataSection + ", DataCoalSection=" + this.DataCoalSection + ", DataCommonSection=" + this.DataCommonSection + ", DataBSSSection=" + this.DataBSSSection + ", FourByteConstantSection=" + this.FourByteConstantSection + ", EightByteConstantSection=" + this.EightByteConstantSection + ", SixteenByteConstantSection=" + this.SixteenByteConstantSection + ", LazySymbolPointerSection=" + this.LazySymbolPointerSection + ", NonLazySymbolPointerSection=" + this.NonLazySymbolPointerSection + ", ThreadLocalPointerSection=" + this.ThreadLocalPointerSection + ", DrectveSection=" + this.DrectveSection + ", PDataSection=" + this.PDataSection + ", XDataSection=" + this.XDataSection + ", SXDataSection=" + this.SXDataSection + ", Env=" + (Object)((Object)this.Env) + ", PositionIndependent=" + this.PositionIndependent + ", CMModel=" + (Object)((Object)this.CMModel) + ", Ctx=[MCContext], TT=" + this.TT;
    }

    public static final class Environment
    extends Enum<Environment>
    implements Native.NativeUIntEnum {
        public static final /* enum */ Environment IsMachO = new Environment(0);
        public static final /* enum */ Environment IsELF = new Environment(IsMachO.getValue() + 1);
        public static final /* enum */ Environment IsCOFF = new Environment(IsELF.getValue() + 1);
        private final int value;
        private static final /* synthetic */ Environment[] $VALUES;

        public static Environment[] values() {
            return (Environment[])$VALUES.clone();
        }

        public static Environment valueOf(String name) {
            return Enum.valueOf(Environment.class, name);
        }

        public static Environment valueOf(int val) {
            Environment out;
            Environment environment = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private Environment(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Environment[]{IsMachO, IsELF, IsCOFF};
        }

        private static final class Values {
            private static final Environment[] VALUES;
            private static final Environment[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Environment kind : Environment.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Environment[min < 0 ? 1 - min : 0];
                VALUES = new Environment[max >= 0 ? 1 + max : 0];
                for (Environment kind : Environment.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((Environment)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((Environment)kind).value] = kind;
                }
            }
        }
    }
}

