/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.llvm.adt.StringRef;
import org.llvm.mc.HexStyle;
import org.llvm.mc.MCAsmInfo;
import org.llvm.mc.MCInst;
import org.llvm.mc.MCInstrInfo;
import org.llvm.mc.MCRegisterInfo;
import org.llvm.mc.MCSubtargetInfo;
import org.llvm.mc.impl.MCInstPrinterStatics;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.format_object;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;

public abstract class MCInstPrinter
implements Destructors.ClassWithDestructor {
    protected raw_ostream CommentStream = null;
    protected final MCAsmInfo MAI;
    protected final MCInstrInfo MII;
    protected final MCRegisterInfo MRI;
    protected boolean UseMarkup;
    protected boolean PrintImmHex;
    protected HexStyle.Style PrintHexStyle;

    protected void printAnnotation(raw_ostream OS, StringRef Annot) {
        if (!Annot.empty()) {
            if (this.CommentStream != null) {
                ((raw_ostream)Native.$Deref((Object)this.CommentStream)).$out(Annot);
                if (Annot.back() != 10) {
                    ((raw_ostream)Native.$Deref((Object)this.CommentStream)).$out_char((byte)10);
                }
            } else {
                OS.$out(NativePointer.$SPACE).$out(this.MAI.getCommentString()).$out(NativePointer.$SPACE).$out(Annot);
            }
        }
    }

    public MCInstPrinter(MCAsmInfo mai, MCInstrInfo mii, MCRegisterInfo mri) {
        this.MAI = mai;
        this.MII = mii;
        this.MRI = mri;
        this.UseMarkup = false;
        this.PrintImmHex = false;
        this.PrintHexStyle = HexStyle.Style.C;
    }

    public void $destroy() {
    }

    public void setCommentStream(raw_ostream OS) {
        this.CommentStream = (raw_ostream)Native.$AddrOf((Object)OS);
    }

    public abstract void printInst(MCInst var1, raw_ostream var2, StringRef var3, MCSubtargetInfo var4);

    public StringRef getOpcodeName(int Opcode2) {
        return new StringRef(this.MII.getName(Opcode2));
    }

    public void printRegName(raw_ostream OS, int RegNo) {
        throw new llvm_unreachable("Target should implement this");
    }

    public boolean getUseMarkup() {
        return this.UseMarkup;
    }

    public void setUseMarkup(boolean Value) {
        this.UseMarkup = Value;
    }

    public StringRef markup(StringRef s) {
        if (this.getUseMarkup()) {
            return new StringRef(JavaDifferentiators.JD.Move.INSTANCE, s);
        }
        return new StringRef(NativePointer.$EMPTY);
    }

    public StringRef markup(StringRef a, StringRef b) {
        if (this.getUseMarkup()) {
            return new StringRef(JavaDifferentiators.JD.Move.INSTANCE, a);
        }
        return new StringRef(JavaDifferentiators.JD.Move.INSTANCE, b);
    }

    public boolean getPrintImmHex() {
        return this.PrintImmHex;
    }

    public void setPrintImmHex(boolean Value) {
        this.PrintImmHex = Value;
    }

    public HexStyle.Style getPrintHexStyle() {
        return this.PrintHexStyle;
    }

    public void setPrintHexStyle(HexStyle.Style Value) {
        this.PrintHexStyle = Value;
    }

    public format_object formatImm(long Value) {
        return this.PrintImmHex ? this.formatHex_long(Value) : this.formatDec(Value);
    }

    public format_object formatDec(long Value) {
        return AdtsupportLlvmGlobals.format(NativePointer.$((String)"%lld"), Value);
    }

    public format_object formatHex_long(long Value) {
        switch (this.PrintHexStyle) {
            case C: {
                if (Value < 0L) {
                    return AdtsupportLlvmGlobals.format(NativePointer.$((String)"-0x%llx"), -Value);
                }
                return AdtsupportLlvmGlobals.format(NativePointer.$((String)"0x%llx"), Value);
            }
            case Asm: {
                if (Value < 0L) {
                    if (MCInstPrinterStatics.needsLeadingZero(-Value)) {
                        return AdtsupportLlvmGlobals.format(NativePointer.$((String)"-0%llxh"), -Value);
                    }
                    return AdtsupportLlvmGlobals.format(NativePointer.$((String)"-%llxh"), -Value);
                }
                if (MCInstPrinterStatics.needsLeadingZero(Value)) {
                    return AdtsupportLlvmGlobals.format(NativePointer.$((String)"0%llxh"), Value);
                }
                return AdtsupportLlvmGlobals.format(NativePointer.$((String)"%llxh"), Value);
            }
        }
        throw new llvm_unreachable("unsupported print style");
    }

    public format_object formatHex_ulong(long Value) {
        switch (this.PrintHexStyle) {
            case C: {
                return AdtsupportLlvmGlobals.format(NativePointer.$((String)"0x%llx"), Value);
            }
            case Asm: {
                if (MCInstPrinterStatics.needsLeadingZero(Value)) {
                    return AdtsupportLlvmGlobals.format(NativePointer.$((String)"0%llxh"), Value);
                }
                return AdtsupportLlvmGlobals.format(NativePointer.$((String)"%llxh"), Value);
            }
        }
        throw new llvm_unreachable("unsupported print style");
    }

    public String toString() {
        return "CommentStream=" + this.CommentStream + ", MAI=" + this.MAI + ", MII=" + this.MII + ", MRI=" + this.MRI + ", UseMarkup=" + this.UseMarkup + ", PrintImmHex=" + this.PrintImmHex + ", PrintHexStyle=" + (Object)((Object)this.PrintHexStyle);
    }
}

